<?php
/**
 * WP File Download
 *
 * @package WP File Download
 * @author  Joomunited
 * @version 1.0
 */

namespace Joomunited\WP_File_Download\Admin\Fields;

use Joomunited\WPFramework\v1_0_6\Field;
use Joomunited\WPFramework\v1_0_6\Application;
use Joomunited\WPFramework\v1_0_6\Model;

defined('ABSPATH') || die();

/**
 * Class Acf
 */
class FileCustomFieldselection extends Field
{
    /**
     * Render <input> tag
     *
     * @param array $field Fields
     * @param array $data  Data
     *
     * @return string
     */
    public function getfield($field, $data)
    {
        if (function_exists('wpfdCheckInstallACFPlugins') && wpfdCheckInstallACFPlugins()) {
            $attributes = $field['@attributes'];
            $className = '';

            if (isset($attributes['name'])) {
                $className = ' wpfd-field-'.$attributes['name'];
            }

            $fieldName = $attributes['name'];
            $prefix = str_replace('showcustomfields', '', $fieldName);
            $groupName = esc_attr($prefix . 'groupcustomfields');
            $value = (isset($data[$fieldName]) && intval($data[$fieldName]) === 1) ? '1' : '0';
            $checked = ($value === '1') ? ' checked' : '';
            $options = array('none' => esc_html__('-- Select ACF groups --', 'wpfd'));
            $optionVal = isset($data[$prefix . 'groupcustomfields']) ? $data[$prefix . 'groupcustomfields'] : 'none';
            $showSelect = intval($value) === 1 ? '' : 'display: none;';
            $fieldGroups = acf_get_field_groups(array( 'post_type' => 'wpfd_file' ));

            if (is_array($fieldGroups) && !empty($fieldGroups)) {
                $options['all_groups'] = esc_html__('All ACF groups', 'wpfd');
                foreach ($fieldGroups as $fieldGroup) {
                    $options[$fieldGroup['key']] = $fieldGroup['title'];
                }
            }

            $html = '<div class="ju-settings-option wpfd-form-field' . $className . '">';
            $html .= '<div class="wpfd_row_full">';
            $html .= '<div>';
            // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Possibility to translate by our deployment script
            $tooltip    = isset($attributes['tooltip']) ? __($attributes['tooltip'], 'wpfd') : '';
            if (empty($attributes['hidden']) || (!empty($attributes['hidden']) && $attributes['hidden'] !== 'true')) {
                if (!empty($attributes['label']) && $attributes['label'] !== '' &&
                    !empty($attributes['name']) && $attributes['name'] !== '') {
                    $html .= '<label title="' . $tooltip . '" class="ju-setting-label" for="' . $attributes['name'] . '">';
                    // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Dynamic translate
                    $html .= esc_html__($attributes['label'], 'wpfd') . '</label>';
                }
            }

            // Switch
            $inputValue = 0;
            $html .= '<div class="ju-switch-button"><label class="switch">';
            $html .= '<input';
            $html .= ' type="checkbox"';
            $html .= ' onChange="jQuery(this).parents(\'.ju-settings-option\').find(\'.show_custom_field_select_section\').slideToggle()"';

            if (!empty($attributes)) {
                $attribute_array = array('class', 'name', 'value');
                foreach ($attributes as $attribute => $value) {
                    if (in_array($attribute, $attribute_array) && isset($value)) {
                        if ($attribute === 'value') {
                            $inputValue = $value;
                            $html .= ' ' . $attribute . '="' . $value . '"';
                            if ((string) $value === '1') {
                                $html .= ' checked';
                            }
                        } elseif ($attribute === 'name') {
                            $html .= ' ' . $attribute . '="ref_' . $value . '"';
                        } else {
                            $html .= ' ' . $attribute . '="' . $value . '"';
                        }
                    }
                }
            }

            $html .= ' />';
            $html .= '<span class="slider"></span>';
            $html .= '</label>';
            $val = ($inputValue === '' || (string)$inputValue === '0') ? '0' : '1';
            $html .= '<input type="hidden" id="' . $attributes['name'] . '" name="' . $attributes['name'] . '" value="' . $val . '" />';
            $html .= '</div>';

            if (!empty($attributes['help']) && $attributes['help'] !== '') {
                // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Possibility to translate by our deployment script
                $html .= '<p class="help-block">' . __($attributes['help'], 'wpfd') . '</p>';
            }

            $html .= '</div>';

            // ACF Groups selection
            $html .= '<div class="show_custom_field_select_section" style="' . $showSelect . '; margin: 10px 0 0 0">';
            $html .= '<select name="'. $groupName .'_selection" id="' . $groupName . '_selection"';
            $html .= ' onChange="jQuery(this).parents(\'.wpfdparams\').find(\'input[name='. $prefix .'groupcustomfields]\').val(jQuery(this).val())"';
            $html .= ' class="ju-input" style="width: 100%; max-width: unset;">';

            foreach ($options as $key => $option) {
                $selected = (strval($key) === strval($optionVal)) ? 'selected' : '';
                $html .= '<option value="' . esc_attr($key) . '" ' . $selected . '>' . esc_attr($option) . '</option>';
            }

            $html .= '</select>';
            $html .= '</div>';
            $html .= '</div>';
            $html .= '</div>';

            return $html;
        } else {
            return '';
        }
    }
}
