<?php
/**
 * WP File Download
 *
 * @package WP File Download
 * @author  Joomunited
 * @version 1.0
 */

namespace Joomunited\WP_File_Download\Admin\Fields;

use Joomunited\WPFramework\v1_0_6\Field;
use Joomunited\WPFramework\v1_0_6\Factory;
use Joomunited\WPFramework\v1_0_6\Application;

defined('ABSPATH') || die();

/**
 * Class private categories
 */
class Privatecategories extends Field
{
    /**
     * Show private category settings
     *
     * @param array $field Fields
     * @param array $data  Data
     *
     * @return string
     */
    public function getfield($field, $data)
    {
        $attributes = $field['@attributes'];
        $fullWidthClass = (isset($attributes['value']) && intval($attributes['value']) === 1) ? 'full-width' : '';
        $html = '<div class="private-category-settings-container ' . $fullWidthClass . '">';
        $html .= '<div class="private-category-settings-contents">';
        $html .= '<div class="ju-settings-option ju-setting-private-category">';
        $html .= '<div class="wpfd_row_full">';
        // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Possibility to translate by our deployment script
        $tooltip = isset($attributes['tooltip']) ? __($attributes['tooltip'], 'wpfd') : '';
        if (empty($attributes['hidden']) || (!empty($attributes['hidden']) && $attributes['hidden'] !== 'true')) {
            if (!empty($attributes['label']) && $attributes['label'] !== '' &&
                !empty($attributes['name']) && $attributes['name'] !== '') {
                $html .= '<label title="' . $tooltip . '" class="ju-setting-label" for="' . $attributes['name'] . '">';
                // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Dynamic translate
                $html .= esc_html__($attributes['label'], 'wpfd') . '</label>';
            }
        }
        // Switch
        $inputValue = 0;
        $html .= '<div class="ju-switch-button"><label class="switch">';
        $html .= '<input';
        $html .= ' type="checkbox"';

        if (!empty($attributes)) {
            $attribute_array = array('class', 'name', 'value');
            foreach ($attributes as $attribute => $value) {
                if (in_array($attribute, $attribute_array) && isset($value)) {
                    if ($attribute === 'value') {
                        $inputValue = $value;
                        $html .= ' ' . $attribute . '="' . $value . '"';
                        if ((string)$value === '1') {
                            $html .= ' checked';
                        }
                    } elseif ($attribute === 'name') {
                        $html .= ' ' . $attribute . '="ref_' . $value . '"';
                    } else {
                        $html .= ' ' . $attribute . '="' . $value . '"';
                    }
                }
            }
        }
        $html .= ' />';
        $html .= '<span class="slider"></span>';
        $html .= '</label>';
        $val = ($inputValue === '' || (string)$inputValue === '0') ? '0' : '1';
        $html .= '<input type="hidden" id="' . $attributes['name'] . '" name="' . $attributes['name'] . '" value="' . $val . '" />';
        $html .= '</div>';

        if (!empty($attributes['help']) && $attributes['help'] !== '') {
            // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Possibility to translate by our deployment script
            $html .= '<p class="help-block">' . __($attributes['help'], 'wpfd') . '</p>';
        }

        $html .= '</div>';
        $html .= '</div>';
        $html .= $this->showPrivateCategorySettings($val);
        $html .= '</div>';
        $html .= '</div>';
        $html .= '<div class="ju-private-category-btn-section">';
        $html .= '<input type="submit" value="Save Changes" class="ju-button btn_wpfd_save" id="ju_private_category_save_btn">';
        $html .= '<button type="button" id="wpfd_btn_run_private_category" ';
        $html .= 'class="ju-button orange-outline-button ju-button-inline wpfd_private_category_btn wpfd_btn_run_private_category ju-setting-label" title="' . esc_html__('Create private categories for existing users', 'wpfd') . '">';
        $html .= esc_html__('Create categories', 'wpfd');
        $html .= '<span class="spinner" style="display:none; margin: 0; vertical-align: middle"></span>';
        $html .= '</button>';
        $html .= '</div>';

        return $html;
    }

    /**
     * Display settings
     *
     * @param string|integer $val Show settings or not
     *
     * @return string
     */
    public function showPrivateCategorySettings($val = '0')
    {
        $c_roles = wpfd_admin_ui_user_roles_get_roles();
        $roles = $c_roles->role_objects;
        $roles_name = $c_roles->role_names;
        $style = intval($val) !== 1 ? 'display: none;' : '';
        $insertedPrivateCategoryIds = get_option('wpfd_private_categories', array());
        $selectedId = 0;

        if (!isset($insertedPrivateCategoryIds) || is_null($insertedPrivateCategoryIds)
            || empty($insertedPrivateCategoryIds) || $insertedPrivateCategoryIds === false) {
            $insertedPrivateCategoryIds = array();
        }

        if (!empty($insertedPrivateCategoryIds) && is_countable($insertedPrivateCategoryIds)) {
            // phpcs:ignore PHPCompatibility.FunctionUse.NewFunctions.array_key_firstFound -- It works well
            $selectedId = array_key_first($insertedPrivateCategoryIds);
        }

        $checkCategoryExists = (!empty($selectedId) && term_exists($selectedId, 'wpfd-category')) ? true : false;
        $privateCategory = (!empty($selectedId) && isset($insertedPrivateCategoryIds[$selectedId])) ? $insertedPrivateCategoryIds[$selectedId] : array();
        $roleKeys = (isset($privateCategory['role_keys']) && is_array($privateCategory['role_keys'])) ? $privateCategory['role_keys'] : array();
        ob_start(); ?>
        <div class="ju-settings-option ju-private-category-settings full-width" style="<?php echo esc_attr($style); ?>">
            <div class="">
                <div id="wpfd_private_category_selection" class="wpfd-full-width">
                    <div id="wpfd_local_categories" class="wpfd-no-padding"></div>
                    <div id="wp_roles" class="wpfd-no-padding">
                        <p><?php esc_html_e('WP Roles', 'wpfd'); ?></p>
                        <?php if (is_countable($roles) && !empty($roles)) : ?>
                            <ul class="wp_role_list">
                                <li class="directory" data-role="all_wp_roles">
                                    <?php $roleChecked = ($checkCategoryExists && in_array('all_wp_roles', $roleKeys)) ? ' checked' : ''; ?>
                                    <input class="media_checkbox check-private-category-item"
                                           id="cb-select-all_wp_roles"
                                           data-role_name="All_WP_Roles"
                                           type="checkbox" name="post[]"
                                           value="all_wp_roles" <?php echo esc_html($roleChecked); ?>>
                                    <span
                                        class="wpfd-folder-toggle"><?php echo esc_html_e('All Roles', 'wpfd'); ?></span>
                                </li>
                                <?php foreach ($roles as $name => $role) : ?>
                                    <?php if (!isset($role->name) || $role->name === '') {
                                        continue;
                                    } ?>
                                    <?php $readableName = $roles_name[$role->name]; ?>
                                    <?php $roleChecked = ($checkCategoryExists && in_array($role->name, $roleKeys)) ? ' checked' : ''; ?>
                                    <li class="directory" data-role="<?php echo esc_attr($role->name) ?>">
                                        <input
                                            class="media_checkbox check-private-category-item check-private-category-role"
                                            id="cb-select-<?php echo esc_html($role->name); ?>"
                                            data-role_name="<?php echo esc_attr($readableName) ?>"
                                            type="checkbox" name="post[]"
                                            value="<?php echo esc_html($role->name); ?>" <?php echo esc_html($roleChecked); ?>>
                                        <span class="wpfd-folder-toggle"><?php echo esc_html($readableName); ?></span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="wpfd-full-width" id="wpfd_private_category_breadcrumb" style="display: none;">
                    <div class="input_dir">
                        <input class="ju-input inputbox input-block-level wpfd-input-inline input_private_category dir_name_private_category"
                               type="text" name="dir_name_private_category" readonly="" value="">
                        <input class="ju-input inputbox input-block-level wpfd-input-inline input_private_category dir_name_roles"
                               type="text" name="dir_name_roles" readonly="" data-id_category="0" value="">
                        <input type="hidden" id="wpfd_selected_category_id" name="wpfd_selected_category_id"
                               value="<?php echo esc_attr($selectedId); ?>">
                        <input type="hidden" id="wpfd_selected_roles" name="wpfd_selected_roles"
                               value="<?php echo ($checkCategoryExists && !empty($roleKeys)) ? implode(',', $roleKeys) : ''; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped above in functions directly
                                ?>">
                    </div>
                </div>
            </div>
        </div>
        <?php
        $contents = ob_get_contents();
        ob_end_clean();

        return $contents;
    }
}
