<?php
/**
 * WP File Download
 *
 * @package WP File Download
 * @author  Joomunited
 * @version 1.0
 */

// No direct access.
defined('ABSPATH') || die();
?>
<fieldset id="category-layout">
    <legend><?php esc_html_e('Category layout', 'wpfd'); ?></legend>
    <?php
    $this->renderText('marginleft', esc_html__('Margin left', 'wpfd'), esc_html__('File icon left margin', 'wpfd'));
    $this->renderText('marginright', esc_html__('Margin right', 'wpfd'), esc_html__('File icon right margin', 'wpfd'));
    $this->renderText('margintop', esc_html__('Margin top', 'wpfd'), esc_html__('File icon top margin', 'wpfd'));
    $this->renderText('marginbottom', esc_html__('Margin bottom', 'wpfd'), esc_html__('File icon bottom margin', 'wpfd'));
    $this->renderSwitcher('showcategorytitle', esc_html__('Show category title', 'wpfd'), esc_html__('Display the file category title', 'wpfd'));
    $this->renderSwitcher('showsubcategories', esc_html__('Show subcategories', 'wpfd'), esc_html__('Display not only the category selected but also all its subcategories', 'wpfd'));
    $this->renderSwitcher('showbreadcrumb', esc_html__('Show Breadcrumb', 'wpfd'), esc_html__('Display a clickable navigation breadcrumb, to navigate through file categories', 'wpfd'));
    $this->renderSelectOptions(
        'showfoldertree',
        esc_html__('Show folder tree', 'wpfd'),
        esc_html__('Display a folder tree with file categories on the selected position part of the file listing', 'wpfd'),
        array('0' => 'No', '1' => 'Left', '2' => 'Top', '3' => 'Right', '4' => 'Bottom')
    );
    $this->renderSwitcher('expanded_folder_tree', esc_html__('Expanded folder tree', 'wpfd'), esc_html__('Show folder tree', 'wpfd'));
    $this->renderSwitcher('showuploadform', esc_html__('Show upload form', 'wpfd'), esc_html__('Add the upload form below the file listing', 'wpfd'));
    $this->renderSwitcher('displayfilesearch', esc_html__('Display file search', 'wpfd'), esc_html__('Enable a search bar to quickly find files, making navigation through large volumes of content more efficient', 'wpfd'));
    $this->renderColor('bgcolor', esc_html__('Background color', 'wpfd'), esc_html__('The background color of the WP File Download Category files', 'wpfd'));
    ?>
</fieldset>
<fieldset id="file-layout">
    <legend><?php esc_html_e('File block layout', 'wpfd'); ?></legend>
    <?php
    $this->renderSwitcher('showtitle', esc_html__('Show title', 'wpfd'), esc_html__('Display the title of the file download', 'wpfd'));
    $this->renderSwitcher('showdescription', esc_html__('Show description', 'wpfd'), esc_html__('Display the description of the file download', 'wpfd'));
    $this->renderSwitcher('showsize', esc_html__('Show file size', 'wpfd'), esc_html__('Display the size of the file download', 'wpfd'));
    $this->renderSwitcher('showversion', esc_html__('Show version', 'wpfd'), esc_html__('Display the version (if any) of the file download', 'wpfd'));
    $this->renderSwitcher('showhits', esc_html__('Show hits', 'wpfd'), esc_html__('Display the download hits (if any) of the file', 'wpfd'));
    $this->renderSwitcher('showdownload', esc_html__('Show download link', 'wpfd'), esc_html__('Add the download button and file title link in the file listing', 'wpfd'));
    $this->renderSwitcher('showdateadd', esc_html__('Show date added', 'wpfd'), esc_html__('Display the date of the file upload', 'wpfd'));
    $this->renderSwitcher('showdatemodified', esc_html__('Show date modified', 'wpfd'), esc_html__('Display the date of the file\'s last modification (file replace, file information edition…)', 'wpfd'));
    $this->renderCustomFields('showcustomfields', esc_html__('Show custom fields', 'wpfd'), esc_html__('Display the custom fields of the file upload', 'wpfd'));
    $this->renderText('croptitle', esc_html__('Crop titles', 'wpfd'), esc_html__('Crop the file titles after a predefined number of characters', 'wpfd'));
    $this->renderColor('bgdownloadlink', esc_html__('Background download link', 'wpfd'), esc_html__('The background color of the download button', 'wpfd'));
    $this->renderColor('colordownloadlink', esc_html__('Color download link', 'wpfd'), esc_html__('The download link and text of the download button colors', 'wpfd'));
    ?>
</fieldset>
