<?php
/**
 * WP File Download
 *
 * @package WP File Download
 * @author  Joomunited
 * @version 4.4
 */

// No direct access.
defined('ABSPATH') || die();

use Joomunited\WPFramework\v1_0_6\Application;

?>
<div class="wpfd-settings-wrapper ju-main-wrapper">
    <div class="ju-left-panel-toggle">
        <i class="dashicons dashicons-leftright ju-left-panel-toggle-icon"></i>
    </div>
    <div class="ju-left-panel wpfd-settings-sidebar">
        <div class="wpfd-settings-sidebar-menu">
            <?php
            /**
             * Action print out configuration menu
             *
             * @hook wpfd_admin_ui_menu_logo - 10
             *
             * @internal
             */
            do_action('wpfd_admin_ui_configuration_menu');
            ?>
        </div>
        <div class="wpfd-settings-sidebar-toggle">
            <button class="wpfd-sidebar-collapse-btn">
                <span class="ju-icon-collapse"></span>
                <span>Collapse</span>
            </button>
            <button class="wpfd-sidebar-expand-btn">
                <span class="ju-icon-expand"></span>
            </button>
        </div>
    </div>
    <div class="ju-right-panel wpfd-settings-content">
        <?php
        /**
         * Action to write import notice
         *
         * @ignore
         */
        do_action('wpdf_admin_notices');

        /**
         * Action print out configuration content
         *
         * @internal
         */
        do_action('wpfd_admin_ui_configuration_content');
        ?>
    </div>
</div>
<script type="text/javascript">
    wpfdajaxurl = "<?php echo wpfd_sanitize_ajax_url(Application::getInstance('Wpfd')->getAjaxUrl());  // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- keep this, if not it error ?>";
</script>
