<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('WPFD_Acf_Location_File_Type')) :

    class WPFD_Acf_Location_File_Type extends ACF_Location
    {
        /**
         * Initializes props.
         *
         * @date   5/03/2014
         * @param  void
         * @return void
         * @since  5.0.0
         */
        public function initialize()
        {
            $this->name = 'wpfd_file_type';
            $this->label = __('File type', 'wpfd');
            $this->category = 'WP File Download';
            $this->object_type = 'post';
        }

        /**
         * Matches the provided rule against the screen args returning a bool result.
         *
         * @date   9/4/20
         * @param  array $rule        The location rule.
         * @param  array $screen      The screen args.
         * @param  array $field_group The field group settings.
         * @return boolean
         * @since  5.9.0
         */
        public function match($rule, $screen, $field_group)
        {
            // Check screen args.
            if (isset($screen['post_type'])) {
                $post_type = $screen['post_type'];
            } elseif (isset($screen['post_id'])) {
                $post_type = get_post_type($screen['post_id']);
            } else {
                return false;
            }

            // Compare rule against $post_type.
            return $this->compare_to_rule($post_type, $rule);
        }

        /**
         * Returns an array of possible values for this rule type.
         *
         * @date   9/4/20
         * @param  array $rule A location rule.
         * @return array
         * @since  5.9.0
         */
        public function get_values($rule)
        {
            // Get file types.
            $file_types = array(
                'wpfd_file' => esc_html__('WP File Download File', 'wpfd')
            );

            // Return array of [type => label].
            return $file_types;
        }

        /**
         * Returns the object_subtype connected to this location.
         *
         * @date   1/4/20
         * @param  array $rule A location rule.
         * @return string|array
         * @since  5.9.0
         */
        public function get_object_subtype($rule)
        {
            if ($rule['operator'] === '==') {
                return $rule['value'];
            }
            return '';
        }
    }

endif; // class_exists check
