/**
 * WP File Download
 *
 * @package WP File Download
 * @author Joomunited
 * @version 1.0
 */
jQuery(document).ready(function ($) {
    if (typeof (wpfdfrontend.translates.mail_notify_unsubscribe) === 'undefined') {
        wpfdfrontend.translates.mail_notify_unsubscribe = '';
    }

    $('.wpfd-content.wpfd-content-multi').each(function () {
        $(this).addClass('wpfd-content-mail-subscribe');
    });

    $('.wpfd-content.wpfd-content-mail-subscribe').each(function () {
        $(this).find('.cbox_file_download').addClass('cbox_file_mail');
        $(this).find('.wpfd-category-mail-subscribe-all').remove();
        $(this).find('.wpfd-upload-form').remove();
    });

    mailInputSelected();
    function mailInputSelected() {
        $(document).on('change', ".wpfd-content.wpfd-content-mail-subscribe input.cbox_file_mail", function () {
            var sc = $(this).closest('.wpfd-content-mail-subscribe').attr('data-category');
            var rootCat = ".wpfd-content-mail-subscribe.wpfd-content-multi[data-category=" + sc + "]";
            var selectedFiles = $(rootCat + " input.cbox_file_download:checked");
            var filesId = [];

            if (selectedFiles.length) {
                selectedFiles.each(function (index, file) {
                    filesId.push($(file).data('id'));
                });
            }

            if (filesId.length > 0) {
                $(rootCat + " .wpfdSelectedFiles").remove();
                $('<input type="hidden" class="wpfdSelectedFiles" value="' + filesId.join(',') + '" />')
                    .insertAfter($(rootCat).find(" #current_category_slug_" + sc));
                $(rootCat).find(".wpfd-category-mail-unsubscribe-all").hide();
                $(rootCat).find(".wpfd-category-mail-unsubscribe-selected").remove();
                var mailSelectedBtn = $('<a href="javascript:void(0);" class="wpfd-category-mail-unsubscribe-selected" style="display: block;">' + wpfdfrontend.translates.mail_notify_cancel + '</a>');
                $(rootCat).find("div.wpfd-header-btn-group").append(mailSelectedBtn);
            } else {
                $(rootCat + " .wpfdSelectedFiles").remove();
                $(rootCat).find(".wpfd-category-mail-unsubscribe-selected").remove();
                $(rootCat).find(".wpfd-category-mail-unsubscribe-all").show();
            }
        });
    }

    mailUnsubscribeFileChanges();
    function mailUnsubscribeFileChanges() {
        // Remove mail notify all files
        $(document).on('click', '.wpfd-category-mail-unsubscribe-all', function (e) {
            e.preventDefault();
            var sc = $(this).closest('.wpfd-content-mail-subscribe').attr('data-category');
            var rootCat = ".wpfd-content-mail-subscribe.wpfd-content-multi[data-category=" + sc + "]";
            var current_category = $(rootCat).find('#current_category_' + sc).val();
            var title = $(rootCat).find('.wpfd-category-mail-unsubscribe-all').text();

            $.ajax({
                url: wpfdfrontend.wpfdajaxurl + "?action=wpfd&task=files.mailUnsubscribeEntireCategoryFiles&wpfd_category_id=" + current_category,
                dataType: "json",
                beforeSend: function () {
                    $(rootCat).find('.wpfd-category-mail-unsubscribe-all').text('Subscribing...');
                },
            }).done(function (results) {
                if (results.success) {
                    var hash = results.data.hash;
                    $(rootCat).find('.wpfd-category-mail-unsubscribe-all').text('Done!');
                    setTimeout(function () {
                        $(rootCat).find('.wpfd-category-mail-unsubscribe-all').text(title);
                    }, 1500);
                    setTimeout(function () {
                        location.reload();
                    }, 2000);
                } else {
                    alert(results.data.message);
                }
            })
        });

        // Remove mail notify selected files
        $(document).on('click', '.wpfd-category-mail-unsubscribe-selected', function (e) {
            e.preventDefault();
            var sc = $(this).closest('.wpfd-content-mail-subscribe').attr('data-category');
            var rootCat = ".wpfd-content-mail-subscribe.wpfd-content-multi[data-category=" + sc + "]";
            if ($(rootCat).find('.wpfdSelectedFiles').length > 0) {
                var current_category = $(rootCat).find('#current_category_' + sc).val();
                var selectedFilesId = $(rootCat).find('.wpfdSelectedFiles').val();
                $.ajax({
                    url: wpfdfrontend.wpfdajaxurl + "?action=wpfd&task=files.mailUnsubscribeSelectedFiles&filesId=" + selectedFilesId + "&wpfd_category_id=" + current_category,
                    dataType: "json",
                    beforeSend: function () {
                        $(rootCat).find('.wpfd-category-mail-unsubscribe-selected').text('Subscribing...');
                    },
                }).done(function (results) {
                    if (results.success) {
                        var hash = results.data.hash;
                        $(rootCat).find('.wpfd-category-mail-unsubscribe-selected').text('Done!');
                        setTimeout(function () {
                            $(rootCat).find('.wpfd-category-mail-unsubscribe-selected').text(wpfdfrontend.translates.mail_notify_cancel);
                        }, 1500);
                        setTimeout(function () {
                            location.reload();
                        }, 2000);
                    } else {
                        alert(results.data.message);
                    }
                })
            }
        });
    }
});
