<?php
/**
 * WP File Download
 *
 * @package WP File Download
 * @author  Joomunited
 * @version 1.0
 */

use Joomunited\WPFramework\v1_0_6\Application;
use Joomunited\WPFramework\v1_0_6\Model;

defined('ABSPATH') || die();

/**
 * Class WpfdModelFilefront
 */
class WpfdModelFilefront extends Model
{
    /**
     * Get category by file id
     *
     * @param integer $id_file File id
     *
     * @return integer
     */
    public function getFileCategory($id_file)
    {
        $catid     = 0;
        $term_list = wp_get_post_terms($id_file, 'wpfd-category', array('fields' => 'ids'));
        if (!is_wp_error($term_list)) {
            $catid = (is_array($term_list) && isset($term_list[0])) ? $term_list[0] : 0;
        }

        return $catid;
    }

    /**
     * Check valid ref catid
     *
     * @param integer $id       File id
     * @param integer $refCatId Ref category id to check
     *
     * @return boolean
     */
    public function isValidRefCatId($id, $refCatId)
    {
        $metaData = get_post_meta($id, '_wpfd_file_metadata', true);

        if (!is_array($metaData)) {
            return false;
        }

        if (!isset($metaData['file_multi_category'])) {
            return false;
        }

        $refCatIds = $metaData['file_multi_category'];
        $refCatIds = array_map(function ($cId) {
            return intval($cId);
        }, $refCatIds);

        if (in_array(intval($refCatId), $refCatIds)) {
            return true;
        }

        return false;
    }

    /**
     * Get file info by ID
     *
     * @param integer $id_file File id
     * @param integer $rootcat Parent category
     *
     * @return mixed
     */
    public function getFile($id_file, $rootcat = 0)
    {
        $app            = Application::getInstance('Wpfd', __FILE__);
        $modelConfig    = $this->getInstance('configfront');
        $modelCategory  = $this->getInstance('categoryfront');
        $modelTokens    = $this->getInstance('tokens');
        $token          = '';
        $params         = $modelConfig->getGlobalConfig();
        $user           = wp_get_current_user();
        $WpfdBasePath   = $app->getPath() . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR;
        $WpfdBasePath  .= 'classes' . DIRECTORY_SEPARATOR . 'WpfdBase.php';
        require_once $WpfdBasePath;
        $rmdownloadext  = (int) WpfdBase::loadValue($params, 'rmdownloadext', 1) === 1;
        $roles          = array();
        if (!class_exists('WpfdHelperFile')) {
            require_once WPFD_PLUGIN_DIR_PATH . 'app/site/helpers/WpfdHelperFile.php';
        }
        foreach ($user->roles as $role) {
            $roles[] = strtolower($role);
        }

        // Fix conflict plugin Go7 Pricing Table
        remove_all_filters('posts_fields');
        $row            = get_post($id_file, OBJECT);
        $expiredFile    = false;
        $fileMetadata   = get_post_meta($id_file, '_wpfd_file_metadata', true);
        $productLinked  = get_post_meta($id_file, '_wpfd_products_linked', true);

        if ((WpfdHelperFile::wpfdIsExpired((int)$id_file) === true && $productLinked === '') ||
            (WpfdHelperFile::wpfdIsExpired((int)$id_file) === true && is_array($fileMetadata)
                && isset($fileMetadata['woo_permission']) && $fileMetadata['woo_permission'] === 'both_woo_and_wpfd_permission')) {
            $expiredFile = true;
        }

        if (is_wp_error($row) || $row === false || !isset($row->post_status) || $row->post_status === 'private' || $row->post_status === 'trash' || $row->post_date_gmt > current_time('mysql', 1)
            || $expiredFile === true) {
            return false;
        }

        /**
         * Filter to change file title
         *
         * @param string  File title
         * @param integer File id
         *
         * @return string
         */
        $row->title       = apply_filters('wpfd_file_title', $row->post_title, $row->ID);
        $row->description = trim($row->post_excerpt);
        $row->created_time = get_date_from_gmt($row->post_date_gmt);
        $row->modified_time = get_date_from_gmt($row->post_modified_gmt);
        $row->created = mysql2date(
            WpfdBase::loadValue($params, 'date_format', get_option('date_format')),
            $row->created_time
        );
        $row->modified = mysql2date(
            WpfdBase::loadValue($params, 'date_format', get_option('date_format')),
            $row->modified_time
        );
        $metadata = get_post_meta($id_file, '_wpfd_file_metadata', true);
        if (!is_wp_error($metadata) && !empty($metadata)) {
            foreach ($metadata as $key => $value) {
                $row->$key = $value;
            }
        }
        $term_list = wp_get_post_terms($id_file, 'wpfd-category', array('fields' => 'ids'));
        if (empty($term_list)) {
            return false;
        }
        $wpfd_term     = get_term($term_list[0], 'wpfd-category');
        $row->catname  = sanitize_title($wpfd_term->name);
        $row->cattitle = $wpfd_term->name;
        if (!is_wp_error($term_list)) {
            $row->catid = $term_list[0];
        } else {
            $row->catid = 0;
        }
        if (isset($row->version)) {
            $row->versionNumber = $row->version;
        }
        $remote_url                   = isset($metadata['remote_url']) ? $metadata['remote_url'] : false;
        $ftpFile                      = (isset($metadata['wpfd_sync_ftp_file']) && (bool) $metadata['wpfd_sync_ftp_file'] === true) ? true : false;
        $viewer_type                  = WpfdBase::loadValue($params, 'use_google_viewer', 'lightbox');
        $extension_viewer_list        = 'png,jpg,jpeg,gif,pdf,ppt,pptx,doc,docx,xls,xlsx,dxf,ps,eps,xps,psd,tif,tiff,bmp,svg,pages,ai,dxf,ttf,txt,mp3,mp4';
        $images_extension_viewer_list = array('png', 'jpg', 'jpeg', 'gif');
        $extension_viewer             = explode(',', WpfdBase::loadValue($params, 'extension_viewer', $extension_viewer_list));
        $extension_viewer             = array_map('trim', $extension_viewer);
        $category                     = $modelCategory->getCategory($row->catid);
        $rootcategory                 = $modelCategory->getCategory($rootcat);
        $themeSettings                = (isset($params['themesettings']) && intval($params['themesettings']) === 1) ? true : false;
        $themePerCategory             = (isset($params['catparameters']) && intval($params['catparameters']) === 1) ? true : false;
        $defaultThemePerCategory      = isset($params['defaultthemepercategory']) ? $params['defaultthemepercategory'] : 'default';
        $categoryParams               = isset($category->params) ? $category->params : array();

        if ($themeSettings) {
            $prefixTheme = (isset($categoryParams['theme']) && strval($categoryParams['theme']) !== 'default') ? $categoryParams['theme'] . '_' : '';
            $acfGroup = isset($categoryParams[$prefixTheme . 'groupcustomfields']) ? $categoryParams[$prefixTheme . 'groupcustomfields'] : 'none';
            $showCustomFields = (isset($categoryParams[$prefixTheme . 'showcustomfields']) && intval($categoryParams[$prefixTheme . 'showcustomfields']) === 1) ? true : false;
        } else {
            if ($themePerCategory) {
                $selectedTheme = isset($categoryParams['theme']) ? $categoryParams['theme'] : 'default';
                $prefixTheme = (isset($categoryParams['theme']) && strval($categoryParams['theme']) !== 'default') ? $categoryParams['theme'] . '_' : '';
                $themeParams = get_option('_wpfd_' . $selectedTheme . '_config', array());
                $acfGroup = isset($themeParams[$prefixTheme . 'groupcustomfields']) ? strval($themeParams[$prefixTheme . 'groupcustomfields']) : 'none';
                $showCustomFields = (isset($themeParams[$prefixTheme . 'showcustomfields']) && intval($themeParams[$prefixTheme . 'showcustomfields']) === 1) ? true : false;
            } else {
                $prefixTheme = (strval($defaultThemePerCategory) !== 'default') ? $defaultThemePerCategory . '_' : '';
                $themeParams = get_option('_wpfd_' . $defaultThemePerCategory . '_config', array());
                $acfGroup = isset($themeParams[$prefixTheme . 'groupcustomfields']) ? strval($themeParams[$prefixTheme . 'groupcustomfields']) : 'none';
                $showCustomFields = (isset($themeParams[$prefixTheme . 'showcustomfields']) && intval($themeParams[$prefixTheme . 'showcustomfields']) === 1) ? true : false;
            }
        }

        if ($viewer_type !== 'no' &&
            in_array($row->ext, $extension_viewer)
            && ($remote_url === false || $ftpFile === true)
        ) {
            $row->viewer_type = $viewer_type;

            //check access
            if (empty($category) || is_wp_error($category)) {
                return false;
            }

            $roles = array();
            foreach ($user->roles as $role) {
                $roles[] = strtolower($role);
            }
            $allows = array_intersect($roles, $category->roles);
            $canview = (isset($categoryParams['canview']) && !empty($categoryParams['canview'])) ? explode(',', $categoryParams['canview']) : array();
            $singleuser = (isset($params['restrictfile']) && intval($params['restrictfile']) === 1 && in_array($user->ID, $canview)) ? true : false;

            if (WpfdHelperFile::isMediaFile($row->ext)) {
                if ((int) $category->access === 1) {
                    if (!empty($allows) || $singleuser === true) {
                        if (in_array($row->ext, $images_extension_viewer_list)) {
                            if ($this->getWatermarkPreviewLink($row) === false) {
                                $row->viewerlink = WpfdHelperFile::getViewerUrl($row->ID, $row->catid, $token);
                            } else {
                                $row->viewerlink = $this->getWatermarkPreviewLink($row);
                            }
                        } else {
                            $row->viewerlink = WpfdHelperFile::getMediaViewerUrl($row->ID, $row->catid, $row->ext);
                        }
                    }
                } else {
                    if (in_array($row->ext, $images_extension_viewer_list)) {
                        if ($this->getWatermarkPreviewLink($row) === false) {
                            $row->viewerlink = WpfdHelperFile::getViewerUrl($row->ID, $row->catid, $token);
                        } else {
                            $row->viewerlink = $this->getWatermarkPreviewLink($row);
                        }
                    } else {
                        $row->viewerlink = WpfdHelperFile::getMediaViewerUrl($row->ID, $row->catid, $row->ext);
                    }
                }
            } else {
                if (is_user_logged_in()) {
                    $sessionToken = isset($_SESSION['wpfdToken']) ? $_SESSION['wpfdToken'] : null;
                    if ($sessionToken === null) {
                        $token                 = $modelTokens->createToken();
                        $_SESSION['wpfdToken'] = $token;
                    } else {
                        $tokenId = $modelTokens->tokenExists($sessionToken);
                        if ($tokenId) {
                            $modelTokens->updateToken($tokenId);
                            $token = $sessionToken;
                        } else {
                            $token                 = $modelTokens->createToken();
                            $_SESSION['wpfdToken'] = $token;
                        }
                    }
                }

                if ((int) $category->access === 1) {
                    if (!empty($allows) || $singleuser === true) {
                        $row->viewerlink = WpfdHelperFile::getViewerUrl($row->ID, $row->catid, $token);
                    }
                } else {
                    $row->viewerlink = WpfdHelperFile::getViewerUrl($row->ID, $row->catid, $token);
                }
            }

            // Crop file titles
            $row->crop_title = $row->post_title;
            if ($rootcat) {
                $row->crop_title = WpfdBase::cropTitle(
                    $rootcategory->params,
                    $rootcategory->params['theme'],
                    $row->post_title
                );
            } else {
                $row->crop_title = WpfdBase::cropTitle($category->params, $category->params['theme'], $row->post_title);
            }

            // File custom fields
            if (function_exists('wpfdCheckInstallACFPlugins') && wpfdCheckInstallACFPlugins() && $showCustomFields) {
                $fileCustomFields = array();
                $fields = get_fields($row->ID, true);
                $acfGroup = isset($acfGroup) ? $acfGroup : 'none';
                $spGroupFields = array();
                $singleGroup = false;
                $validGroup = wpfdACFCheckValidGroup($acfGroup);

                switch ($acfGroup) {
                    case 'none':
                        $singleGroup = false;
                        break;
                    case 'all_groups':
                        $singleGroup = false;
                        $supportGroups = wpfdACFSupportGroupList();
                        if (is_array($supportGroups) && !empty($supportGroups)) {
                            foreach ($supportGroups as $supportGroup) {
                                $currentFields = acf_get_fields($supportGroup);
                                if (is_array($currentFields) && !empty($currentFields)) {
                                    $currentFields = array_map(function ($spField) {
                                        return $spField['key'];
                                    }, $currentFields);
                                    $spGroupFields = array_merge($currentFields, $spGroupFields);
                                }
                            }
                        }
                        break;
                    default:
                        $spGroupFields = acf_get_fields($acfGroup);
                        if (is_array($spGroupFields) && !empty($spGroupFields)) {
                            $spGroupFields = array_map(function ($spField) {
                                return $spField['key'];
                            }, $spGroupFields);
                            $singleGroup = true;
                        }
                        break;
                }

                if ($validGroup === true && is_array($fields) && !empty($fields) && strval($acfGroup) !== 'none') {
                    foreach ($fields as $key => $field) {
                        if (is_null($field)) {
                            continue;
                        }

                        $fieldObject = get_field_object($key, $row->ID);

                        if (!isset($fieldObject['key']) || (!in_array($fieldObject['key'], $spGroupFields) && $singleGroup === true)
                            || (!in_array($fieldObject['key'], $spGroupFields) && strval($acfGroup) === 'all_groups')) {
                            continue;
                        }

                        $fieldType = isset($fieldObject['type']) ? $fieldObject['type'] : 'none';
                        $fieldMultiple = (isset($fieldObject['multiple']) && intval($fieldObject['multiple']) === 1) ? true : false;
                        $returnFormat = isset($fieldObject['return_format']) ? $fieldObject['return_format'] : 'value';

                        switch ($fieldType) {
                            case 'select':
                                if ($returnFormat === 'array' && is_array($fieldObject['value']) && $fieldMultiple) {
                                    $newValues = array();
                                    foreach ($fieldObject['value'][0] as $arKey => $arValue) {
                                        if (strval($arKey) !== 'value') {
                                            continue;
                                        }

                                        $newValues[] = $arValue;
                                    }

                                    if (!empty($newValues)) {
                                        $fieldObject['value'] = $newValues;
                                    }
                                } elseif ($returnFormat === 'array' && is_array($fieldObject['value']) && $fieldMultiple === false) {
                                    if (isset($fieldObject['value']['value']) && strpos($fieldObject['value']['value'], ':') !== false) {
                                        $fieldObject['value'] = isset($fieldObject['value']['value']) ? $fieldObject['value']['value'] : $fieldObject['value'];
                                    } else {
                                        $fieldObject['value'] = (isset($fieldObject['value']['value']) && isset($fieldObject['value']['label'])) ? $fieldObject['value']['value'] . ' : ' . $fieldObject['value']['label'] : $fieldObject['value'];
                                    }
                                } elseif ($returnFormat === 'label' && is_string($fieldObject['value'])) {
                                    $exactVal = explode(':', $fieldObject['value']);
                                    if (is_array($exactVal) && !empty($exactVal)) {
                                        $fieldObject['value'] = $exactVal[count($exactVal) - 1];
                                    }
                                } elseif ($returnFormat === 'value' && is_string($fieldObject['value'])) {
                                    $exactVal = explode(':', $fieldObject['value']);
                                    if (is_array($exactVal) && !empty($exactVal)) {
                                        $fieldObject['value'] = $exactVal[0];
                                    }
                                }
                                break;
                            case 'checkbox':
                                $newValues = array();
                                if ($returnFormat === 'array' && is_array($fieldObject['value'])) {
                                    foreach ($fieldObject['value'] as $arKey => $arValue) {
                                        if (!isset($arValue['value'])) {
                                            continue;
                                        }

                                        if (strpos($arValue['value'], ':') !== false) {
                                            $newValues[] = $arValue['value'];
                                        } else {
                                            $newValues[] = $arValue['value'] . ' : ' . $arValue['label'];
                                        }
                                    }

                                    if (!empty($newValues)) {
                                        $fieldObject['value'] = $newValues;
                                    }
                                } elseif ($returnFormat === 'label' && is_array($fieldObject['value'])) {
                                    foreach ($fieldObject['value'] as $arKey => $arValue) {
                                        $exactVal = explode(':', $arValue);
                                        if (is_array($exactVal) && !empty($exactVal)) {
                                            $newValues[] = $exactVal[count($exactVal) - 1];
                                        }
                                    }

                                    $fieldObject['value'] = $newValues;
                                } elseif ($returnFormat === 'value' && is_array($fieldObject['value'])) {
                                    foreach ($fieldObject['value'] as $arKey => $arValue) {
                                        $exactVal = explode(':', $arValue);
                                        if (is_array($exactVal) && !empty($exactVal)) {
                                            $newValues[] = $exactVal[0];
                                        }
                                    }

                                    $fieldObject['value'] = $newValues;
                                }
                                break;
                            case 'radio':
                            case 'button_group':
                                if ($returnFormat === 'array' && is_array($fieldObject['value'])) {
                                    $newValues = array();

                                    if (strpos($fieldObject['value']['value'], ':') !== false) {
                                        $newValues[] = $fieldObject['value']['value'];
                                    } else {
                                        $newValues[] = $fieldObject['value']['value'] . ' : ' . $fieldObject['value']['label'];
                                    }

                                    if (!empty($newValues)) {
                                        $fieldObject['value'] = $newValues;
                                    }
                                } elseif ($returnFormat === 'label' && is_string($fieldObject['value'])) {
                                    $exactVal = explode(':', $fieldObject['value']);
                                    if (is_array($exactVal) && !empty($exactVal)) {
                                        $fieldObject['value'] = $exactVal[count($exactVal) - 1];
                                    }
                                } elseif ($returnFormat === 'value' && is_string($fieldObject['value'])) {
                                    $exactVal = explode(':', $field);
                                    if (is_array($exactVal) && !empty($exactVal)) {
                                        $fieldObject['value'] = $exactVal[0];
                                    }
                                }
                                break;
                            case 'image':
                                if (is_array($fieldObject['value'])) {
                                    $fieldObject['value'] = isset($fieldObject['value']['url']) ? $fieldObject['value']['url'] : '';
                                }
                                break;
                            default:
                                break;
                        }

                        if (isset($fieldObject['value']) && is_array($fieldObject['value'])) {
                            $fieldObject['value'] = implode(', ', $fieldObject['value']);
                        }

                        $newField = new stdClass();
                        $newField->type = $fieldType;
                        $newField->name = isset($fieldObject['name']) ? $fieldObject['name'] : '';
                        // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText -- Possibility to translate by our deployment script
                        $newField->label = isset($fieldObject['label']) ? esc_html__($fieldObject['label'], 'wpfd') : '';
                        $newField->value = isset($fieldObject['value']) ? $fieldObject['value'] : '';
                        $fileCustomFields[$newField->name] = $newField;
                    }
                }

                if (!empty($fileCustomFields)) {
                    $row->custom_fields = $fileCustomFields;
                }
            }
        }
        /**
         * Filter to change file title
         *
         * @param string  File title
         * @param integer File id
         *
         * @return string
         *
         * @ignore
         */
        $row->crop_title = apply_filters('wpfd_file_title', $row->crop_title, $row->ID);
        $open_pdf_in = WpfdBase::loadValue($params, 'open_pdf_in', 0);

        if ((int) $open_pdf_in === 1 && strtolower($row->ext) === 'pdf') {
            if (is_user_logged_in()) {
                $token = isset($_SESSION['wpfdToken']) ? $_SESSION['wpfdToken'] : null;
            }
            $row->openpdflink = WpfdHelperFile::getPdfUrl($row->ID, $row->catid, $token) . '&preview=1';

            // WPML
            global $sitepress;
            $wpfd_current_cat_language_code = '';

            /**
             * Filter to switch languages
             *
             * @param boolean Switch language option
             *
             * @return boolean
             *
             * @ignore
             */
            $switchLanguage = apply_filters('wpfd_switch_languages', true);

            if ($sitepress && $switchLanguage) {
                $wpml_args = array('element_id' => (int) $row->catid, 'element_type' => 'wpfd-category' );
                $wpfd_cat_language_code = apply_filters('wpml_element_language_code', null, $wpml_args);
                if ($wpfd_cat_language_code) {
                    $sitepress->switch_lang($wpfd_cat_language_code);
                    $wpfd_current_cat_language_code = $wpfd_cat_language_code;
                }
                $default_lang = $sitepress->get_default_language();

                if ($wpfd_current_cat_language_code !== '' && $wpfd_current_cat_language_code !== $default_lang) {
                     $row->openpdflink .= '&lang='.$wpfd_current_cat_language_code;
                }
            }
        }

        $config = get_option('_wpfd_global_config');
        if (empty($config) || empty($config['uri'])) {
            $seo_uri = 'download';
        } else {
            $seo_uri = rawurlencode($config['uri']);
        }

        $row->seouri = $seo_uri;
        $perlink       = get_option('permalink_structure');
        $rewrite_rules = get_option('rewrite_rules');

        if (wpfd_can_download_files()) {
            global $wp;
            list($row->ID, $row->catid, $lang) = wpfd_correct_wpml_language($row->ID, $row->catid);
            $current_url = home_url($wp->request);
            $check_wpml_dl = false;
            $lang_code = '';
            if (strpos($current_url, '?lang=')) {
                if (defined('ICL_LANGUAGE_CODE')) {
                    $check_wpml_dl = true;
                    $lang_code = ICL_LANGUAGE_CODE;
                }
            }

            /**
             * Filter for customizing download languages
             *
             * @param boolean
             */
            $dlLanguage = apply_filters('wpfd_wpml_download_language', $lang);
            
            if (!empty($rewrite_rules)) {
                if (strpos($perlink, 'index.php')) {
                    if ($check_wpml_dl) {
                        $linkdownload = get_site_url() . '/index.php/' . $seo_uri . '/' . $row->catid . '/';
                    } else {
                        $linkdownload = get_site_url() . '/index.php/' . $dlLanguage . $seo_uri . '/' . $row->catid . '/';
                    }
                    $linkdownload .= $row->catname . '/' . $row->ID . '/' . $row->post_name;
                    $row->linkdownload = $linkdownload;
                } else {
                    if ($check_wpml_dl) {
                        $linkdownload = get_site_url() . '/' . $seo_uri . '/' . $row->catid . '/' . $row->catname;
                    } else {
                        $linkdownload = get_site_url() . $dlLanguage . '/' . $seo_uri . '/' . $row->catid . '/' . $row->catname;
                    }
                    $linkdownload .= '/' . $row->ID . '/' . $row->post_name;
                    $row->linkdownload = $linkdownload;
                }
                $rewrite_download_link = apply_filters('wpfd_rewrite_download_link', false);
                if ($rewrite_download_link) {
                    $row->linkdownload = str_replace(home_url(), home_url().'/index.php', $row->linkdownload);
                }
                if (isset($row->ext) && $row->ext && !$rmdownloadext) {
                    $row->linkdownload .= '.' . $row->ext;
                }
                if ($check_wpml_dl) {
                    $row->linkdownload .= '?lang='.$lang_code;
                }
            } else {
                $linkdownload = admin_url('admin-ajax.php') . '?juwpfisadmin=false&action=wpfd&task=file.download';
                $linkdownload .= '&wpfd_category_id=' . $row->catid . '&wpfd_file_id=' . $row->ID;
                $row->linkdownload = $linkdownload;
            }
        } else {
            $row->linkdownload = '';
        }

        $row->file_custom_icon = isset($metadata['file_custom_icon']) && !empty($metadata['file_custom_icon']) ?
            $metadata['file_custom_icon'] : '';
        $row->remote_file = (isset($metadata['remote_url']) && (int) $metadata['remote_url'] === 1) ? true : false;

        /**
         * Filter file info in front
         *
         * @param object File object
         *
         * @return object
         */
        return apply_filters('wpfd_file_info', $row);
    }

    /**
     * Get full info for file
     *
     * @param integer $id_file File id
     *
     * @return boolean|stdClass
     */
    public function getFullFile($id_file)
    {
        $app         = Application::getInstance('Wpfd');
        $modelConfig = $this->getInstance('configfront');
        $params      = $modelConfig->getGlobalConfig();

        // Fix conflict plugin Go7 Pricing Table
        remove_all_filters('posts_fields');
        $row = get_post((int) $id_file, OBJECT);
        if ($row === false) {
            return false;
        }
        $path_wpfdbase = $app->getPath() . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'classes';
        $path_wpfdbase .= DIRECTORY_SEPARATOR . 'WpfdBase.php';
        require_once $path_wpfdbase;

        $ob              = new stdClass();
        $ob->ID          = $row->ID;
        $ob->author      = $row->post_author;
        $ob->post_name   = $row->post_name;
        /**
         * Filter to change file title
         *
         * @param string  File title
         * @param integer File id
         *
         * @return string
         *
         * @ignore
         */
        $ob->title       = apply_filters('wpfd_file_title', $row->post_title, $row->ID);
        $ob->description = $row->post_excerpt;
        $ob->created     = mysql2date(
            WpfdBase::loadValue($params, 'date_format', get_option('date_format')),
            get_date_from_gmt($row->post_date_gmt)
        );
        $ob->modified    = mysql2date(
            WpfdBase::loadValue($params, 'date_format', get_option('date_format')),
            get_date_from_gmt($row->post_modified_gmt)
        );
        $metadata        = get_post_meta($id_file, '_wpfd_file_metadata', true);
        // phpcs:ignore PHPCompatibility.FunctionUse.NewFunctions.is_countableFound -- is_countable() was declared in functions.php
        if (is_countable($metadata) && count($metadata)) {
            foreach ($metadata as $key => $value) {
                $ob->$key = $value;
            }
        }
        $term_list = wp_get_post_terms($id_file, 'wpfd-category', array('fields' => 'ids'));
        if (!is_wp_error($term_list)) {
            $ob->catid = $term_list[0];
        } else {
            $ob->catid = 0;
        }

        $ob->post_status = $row->post_status;

        /**
         * Filter file info in front
         *
         * @param object File object
         *
         * @return object
         *
         * @ignore
         */
        return apply_filters('wpfd_file_info', $ob);
    }

    /**
     * Increase hit for file
     *
     * @param integer $id_file File id
     *
     * @return boolean
     */
    public function hit($id_file)
    {
        $metadata         = get_post_meta((int) $id_file, '_wpfd_file_metadata', true);
        $hits             = (int) $metadata['hits'];
        $metadata['hits'] = $hits + 1;
        update_post_meta((int) $id_file, '_wpfd_file_metadata', $metadata);

        return true;
    }

    /**
     * Add a file for statistic when downloading file
     *
     * @param integer|string $file_id File id
     * @param string         $date    Date
     *
     * @return void
     */
    public function addChart($file_id, $date)
    {
        global $wpdb;
        $wpdb->query($wpdb->prepare(
            'INSERT INTO ' . $wpdb->prefix . 'wpfd_statistics (related_id,type,date,count) VALUES (%s, "default", %s, 1)',
            $file_id,
            $date
        ));
    }

    /**
     * Add file to chart
     *
     * @param integer|string $file_id File id
     *
     * @return boolean
     */
    public function addCountChart($file_id)
    {
        global $wpdb;
        $date = date('Y-m-d');
        $object = $wpdb->get_row($wpdb->prepare(
            'SELECT * FROM ' . $wpdb->prefix . 'wpfd_statistics WHERE related_id=%s AND date=%s',
            $file_id,
            $date
        ));
        if ($object) {
            $wpdb->query($wpdb->prepare(
                'UPDATE ' . $wpdb->prefix . 'wpfd_statistics SET count=(count+1) WHERE related_id=%s AND date=%s',
                $file_id,
                $date
            ));
        } else {
            $this->addChart($file_id, $date);
        }

        return true;
    }

    /**
     * Get fts file
     *
     * @param integer|string $file_id File id
     *
     * @return object|boolean
     */
    public function getFtsFile($file_id)
    {
        global $wpdb;
        $config = get_option('_wpfd_global_search_config');
        if (!empty($config) && isset($config['plain_text_search']) && $config['plain_text_search'] === 1) {
            $object = $wpdb->get_row($wpdb->prepare(
                'SELECT * FROM ' . $wpdb->prefix . 'wpfd_doc_content WHERE file_id=%s ORDER BY id DESC LIMIT 1',
                $file_id
            ));

            if ($object) {
                return $object;
            }
        }

        return false;
    }

    /**
     * Get preview link for watermark image
     *
     * @param object $file File object
     *
     * @return string|boolean
     */
    public function getWatermarkPreviewLink($file)
    {
        $lists = get_option('wpfd_watermark_category_listing');
        if (is_array($lists) && !empty($lists) && intval($file->catid) !== 0) {
            if (in_array($file->catid, $lists)) {
                if (!class_exists('WpfdHelperFolder')) {
                    require_once WPFD_PLUGIN_DIR_PATH . 'app/admin/helpers/WpfdHelperFolder.php';
                }

                $metaData = get_post_meta($file->ID, '_wpfd_file_metadata', true);
                if (is_array($metaData) && isset($metaData['file'])) {
                    $filePath = WpfdBase::getFilesPath($file->catid) . $metaData['file'];
                    $watermarkedPath = WpfdHelperFolder::getCategoryWatermarkPath();
                    $watermarkedPath = $watermarkedPath . strval($file->catid) . '_' . strval($file->ID) . '_' . strval(md5($filePath)) . '.png';
                    if (file_exists($watermarkedPath)) {
                        $viewerlink = wpfd_abs_path_to_url($watermarkedPath);
                        return $viewerlink;
                    }
                }
            }
        }

        return false;
    }
}
