<?php

namespace SPC_Pro\Modules;

use SPC\Modules\Module_Interface;
use SPC\Modules\Rest_Server;
use SPC\Services\Settings_Store;
use SPC_Pro\Constants;
use SPC_Pro\Modules\PageProfiler\Profile;

/**
 * Frontend pro module.
 */
class Frontend implements Module_Interface {

	const LAZY_LOAD_BEHAVIOUR_VIEWPORT = 'viewport';
	/**
	 * Initialize the module.
	 *
	 * @return void
	 */
	public function init() {

		if ( ! \SPC\Loader::is_cached_page() ) {
			return;
		}

		add_action( 'wp_print_footer_scripts', [ $this, 'add_optimizer' ] );
		add_action( 'wp_print_footer_scripts', [ $this, 'add_js_delay_script' ] );
	}

	/**
	 * Get the optimizer script.
	 *
	 * @param bool $placeholder Placeholder.
	 *
	 * @return string
	 */
	public static function get_optimizer_script( $placeholder = true ) {

		if ( $placeholder ) {
			return '<script id=spcoptimizer></script>';
		}
		global $sw_cloudflare_pagecache;
		/**
		 * @var \SW_CLOUDFLARE_PAGECACHE $sw_cloudflare_pagecache
		 */
		$lazyload_background_selectors = $sw_cloudflare_pagecache->get_core_loader()->get_frontend_module()->is_background_lazyload_enabled()
		? $sw_cloudflare_pagecache->get_core_loader()->get_frontend_module()->get_lazyload_background_selectors() : [];
		return '<script async  src="' . add_query_arg( 'v', SWCFPC_VERSION, SWCFPC_PLUGIN_URL . 'pro/assets/js/optimizer.js' ) . '"></script><script id="spcoptimizer" >
		  var spcDataOptimizer = ' . wp_json_encode(
			[
				'restUrl'        => esc_js( untrailingslashit( rest_url( Rest_Server::REST_NAMESPACE ) ) ),
				'nonce'          => esc_js( wp_create_nonce( 'wp_rest' ) ),
				'missingDevices' => esc_js( Profile::PLACEHOLDER_MISSING ),
				'pageProfileId'  => esc_js( Profile::PLACEHOLDER ),
				'pageUrl'        => esc_js( Profile::PLACEHOLDER_URL ),
				'_t'             => esc_js( Profile::PLACEHOLDER_TIME ),
				'hmac'           => esc_js( Profile::PLACEHOLDER_HMAC ),
				'bgSelectors'    => array_values( $lazyload_background_selectors ),
			]
		) . ';
		</script>';
	}
	/**
	 * Add the optimizer script to the footer.
	 *
	 * @return void
	 */
	public function add_optimizer() {
		if ( ! Settings_Store::get_instance()->is_lazyload_viewport_enabled() ) {
			return;
		}
		echo self::get_optimizer_script();
	}

	/**
	 * Add inline script to the footer for JS delay.
	 */
	public function add_js_delay_script() {
		global $sw_cloudflare_pagecache;

		if ( (int) $sw_cloudflare_pagecache->get_single_config( Constants::SETTING_DELAY_JS ) !== 1 ) {
			return;
		}

		?>

		<script type="text/javascript" id="spc-lazy-js">
			(function () {
			const timeout = setTimeout(loadDelayed, 10000);
			const userEvents = ["mouseover", "keydown", "touchstart", "touchmove", "wheel"];

			function triggerLoad() {
				loadDelayed();
				clearTimeout(timeout);
				userEvents.forEach(e => {
				window.removeEventListener(e, triggerLoad)
				});
			}

			function loadDelayed() {
				document.querySelectorAll("script[data-spc-src]").forEach(el => {
				el.src = el.dataset.spcSrc
				});
			}

			userEvents.forEach(e =>
				window.addEventListener(e, triggerLoad, {passive: true})
			);
			}());
		</script>
		<?php
	}
}
