<?php

/**
 * global array $swcfpc_config - plugin configuration.
 */
defined( 'ABSPATH' ) || die( 'Cheatin&#8217; uh?' );

add_filter( 'swcfpc_fallback_cache_skip_unslashed', 'swcfpc_pro_fallback_cache_skip_unslashed', 0, 2 );
add_filter( 'swcfpc_ignored_query_params', 'swcfpc_pro_add_ignored_query_params' );

/**
 * Skip the fallback cache if the query string contains only ignored parameters.
 *
 * @param bool $skip_from_cache Skip from cache.
 */
function swcfpc_pro_fallback_cache_skip_unslashed( $skip_from_cache, $uri ) {
	return ! swcfpc_pro_are_all_params_excluded( $uri );
}

/**
 * Check if all URL parameters in a URL are excluded via settings.
 *
 * @param string $url URL.
 *
 * @return bool
 */
function swcfpc_pro_are_all_params_excluded( $url ) {
	global $swcfpc_config;

	if (
		! isset( $swcfpc_config['cf_excluded_url_params'] ) ||
		! is_array( $swcfpc_config['cf_excluded_url_params'] ) ||
		empty( $swcfpc_config['cf_excluded_url_params'] )
	) {
		return false;
	}

	$query_params = parse_url( $url, PHP_URL_QUERY );

	if ( empty( $query_params ) ) {
		return true;
	}

	$excluded = $swcfpc_config['cf_excluded_url_params'];

	$params = array_map(
		function ( $param ) {
			return explode( '=', $param )[0];
		},
		explode( '&', $query_params )
	);

	return empty( array_diff( $params, $excluded ) );
}

/**
 * Add ignored Query Params
 *
 * @param array $params Ignored query params.
 *
 * @return array
 */
function swcfpc_pro_add_ignored_query_params( array $params ) {
	global $swcfpc_config;

	if (
		empty( $swcfpc_config['cf_excluded_url_params'] ) ||
		! is_array( $swcfpc_config['cf_excluded_url_params'] )
	) {
		return $params;
	}

	return array_unique( array_merge( $params, $swcfpc_config['cf_excluded_url_params'] ) );
}
