<?php
/**
 * Plugin Name:  Super Page Cache Pro
 * Plugin URI:   https://wordpress.org/plugins/wp-cloudflare-page-cache/
 * Description:  A WordPress performance plugin that lets you get Edge Caching enabled on a Cloudflare free plan.
 * Version:      5.1.6
 * Author:       Themeisle
 * Author URI:   https://themeisle.com
 * License:      GPLv2 or later
 * Text Domain:  wp-cloudflare-page-cache
 * Requires at least: 5.3
 * Requires PHP: 7.4
 * WordPress Available: no
 * Requires License: yes
 */

define( 'SPC_PRO_PATH', __FILE__ );

require_once 'bootstrap.php';

$license_data = (object) [
    'license' => 'valid',
    'key' => 'B5E0B5F8DD8689E6ACA49DD6E6E1A930',
    'item_name' => 'Super Page Cache Pro',
    'expires' => date('Y-m-d H:i:s', strtotime('+1 year')),
    'is_expired' => 'no',
    'plan' => 3,
    'customer_name' => 'GPL',
    'customer_email' => 'noreply@gmail.com',
    'payment_id' => 123321,
    'activations_left' => 99,
    'license_limit' => 100,
    'site_count' => 1
];
update_option('wp_super_page_cache_pro_license_data', $license_data);
set_transient('wp_super_page_cache_pro_license_data', $license_data, 12 * HOUR_IN_SECONDS);
update_option('wp_super_page_cache_pro_license_plan', 3);

add_filter('pre_http_request', function($preempt, $args, $url) {
    if (strpos($url, 'api.themeisle.com/license/') !== false) {
        return [
            'headers' => [],
            'body' => json_encode([
                'success' => true,
                'license' => 'valid',
                'item_id' => false,
                'item_name' => 'Super Page Cache Pro',
                'license_limit' => 100,
                'site_count' => 1,
                'expires' => date('Y-m-d H:i:s', strtotime('+1 year')),
                'activations_left' => 99,
                'checksum' => 'B5E0B5F8DD8689E6ACA49DD6E6E1A930',
                'payment_id' => 123321,
                'customer_name' => 'GPL',
                'customer_email' => 'noreply@gmail.com',
                'price_id' => 3,
                'auto_renew' => true,
                'created_at' => date('Y-m-d H:i:s'),
                'download_id' => 123321,
                'version' => '5.1.3',
                'plan' => 3
            ]),
            'response' => [
                'code' => 200,
                'message' => 'OK'
            ]
        ];
    }
    return $preempt;
}, 10, 3);
