<?php
namespace WPSynchro\Files;

/**
 * Box of helper functions used for file synchronization
 * @since 1.6.0
 */
class FileHelperFunctions
{

    /**
     *  Get files in web root to exclude
     *  @since 1.2.0
     */
    public static function getWPFilesInWebrootToExclude()
    {
        $files = array(
            "wp-activate.php",
            "wp-blog-header.php",
            "wp-comments-post.php",
            "wp-config.php",
            "wp-config-sample.php",
            "wp-cron.php",
            "wp-links-opml.php",
            "wp-load.php",
            "wp-login.php",
            "wp-mail.php",
            "wp-settings.php",
            "wp-signup.php",
            "wp-trackback.php",
            "xmlrpc.php",
        );

        return $files;
    }

    /**
     * Recursively delete files in directory (with max timer)
     * @since 1.0.3
     */
    public static function removeDirectory($dir, &$timer)
    {

        if ($timer->getRemainingSyncTime() < 2) {
            return false;
        }
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (is_dir($dir . "/" . $object)) {
                        $response = self::removeDirectory($dir . "/" . $object, $timer);
                        if ($response === false) {
                            return false;
                        }
                    } else {
                        @unlink($dir . "/" . $object);
                    }
                }
            }
            @rmdir($dir);
            return true;
        } else {
            return false;
        }
    }

}
