<?php

namespace WPSynchro\Utilities\Actions;

use WPSynchro\Utilities\Actions\Action;
use WPSynchro\InstallationFactory;
use WPSynchro\Job;

/**
 * Action: Send success email
 * @since 1.6.0
 */
class EmailOnSyncSuccess implements Action
{

    /**
     * Initialize
     * @since 1.6.0
     */
    public function init()
    {
        static $added = null;
        if ($added !== true) {
            add_action("wpsynchro_synchronization_completed", function ($installation_id, $job_id) {
                (new self())->doAction(func_get_args());
            }, 10, 2);
        }
        $added = true;
    }

    /**
     * Execute action
     * @since 1.6.0
     */
    public function doAction($params)
    {
        $installation_id = $params[0];
        $job_id = $params[1];

        // Get installation
        $inst_factory = new InstallationFactory();
        $installation = $inst_factory->retrieveInstallation($installation_id);
        if (!$installation) {
            return;
        }

        // Get job
        $job = new Job();
        $job->load($installation_id, $job_id);
        if (!$job) {
            return;
        }

        // Get emails to send to, and send
        $emails = $installation->getSuccessEmailList();
        if (count($emails) > 0) {
            $subject = $this->getSubject($job->to_client_home_url, $job->from_client_home_url);
            $content = $this->getContent($job->to_client_home_url, $job->from_client_home_url);
            $headers = array('Content-Type: text/plain; charset=UTF-8');
            foreach ($emails as $email) {
                wp_mail($email, $subject, $content, $headers);
            }
        }
    }

    /**
     * Get subject
     * @since 1.6.0
     */
    public function getSubject($to, $from)
    {
        return sprintf(__("[Synchronization success] - From %s to %s", "wpsynchro"), $to, $from);
    }

    /**
     * Get email content
     * @since 1.6.0
     */
    public function getContent($to, $from)
    {
        $current_url = get_home_url();

        return sprintf(
            __(
                "Hi, \r\n
We just want to notify you that a synchronization was successful.
The synchronization was from %s to %s  \r\n
Synchronization is running on %s \r\n
This is an automated email generated by WP Synchro plugin.",
                "wpsynchro"
            ),
            $to,
            $from,
            $current_url
        );
    }
}
