<?php

class WebinarSysteemPages {
    protected static function write_page($id, $params = []) {
        $ajax_url = admin_url('admin-ajax.php');
        ?>
        <?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
        <div id="<?php echo esc_attr($id) ?>" data-url="<?php echo esc_url($ajax_url) ?>" data-params='<?php echo str_replace('\'', '&apos;', wp_json_encode($params)) ?>'
        ></div>
        <?php
    }

    public static function registration_widgets() {
        wp_enqueue_editor();
        self::write_page("wpws-registration-widgets");
    }

    public static function webinar_list() {
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        if (isset($_GET['webinar_id'])) {
            wp_enqueue_editor();
            // wp_enqueue_media();
            self::write_page("wpws-webinar-editor", [
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                'webinar_id' => $_GET['webinar_id'],
                'enabled_mailinglist_providers' => WebinarsysteemMailingListIntegrations::get_enabled_providers(),
                'woo_commerce_is_enabled' => WebinarSysteemWooCommerceIntegration::is_ready(),
                'is_license_active' => WebinarSysteemLicense::is_license_active(),
                'is_cron_active' => WebinarSysteemCron::was_active_within(),
                'license_status' => WebinarSysteemLicense::get_license_status(),
                'use_realtime_servers' => WebinarSysteemSettings::instance()->get_use_realtime_servers(),
                'renewal_url' => WebinarSysteemLicense::get_renewal_url(),
                'translations' => WebinarSysteemSettings::instance()->get_translations(),
                'max_hosted_attendee_count' => WebinarSysteemLicense::get_max_hosted_attendee_count(),
                'isZoomSetup' => WebinarSysteemHelperFunctions::isZoomSetup(),
                'has_ai_api_key' => !empty(WebinarSysteemSettings::instance()->get_ai_api_key())
            ]);
            return;
        }

        self::write_page("wpws-webinar-list");
    }

    public static function new_webinar() {
        wp_enqueue_editor();

        self::write_page("wpws-webinar-editor", [
            'webinar_id' => null,
            'enabled_mailinglist_providers' => WebinarsysteemMailingListIntegrations::get_enabled_providers(),
            'woo_commerce_is_enabled' => WebinarSysteemWooCommerceIntegration::is_ready(),
            'is_license_active' => WebinarSysteemLicense::is_license_active(),
            'is_cron_active' => WebinarSysteemCron::was_active_within(),
            'license_status' => WebinarSysteemLicense::get_license_status(),
            'use_realtime_servers' => WebinarSysteemSettings::instance()->get_use_realtime_servers(),
            'renewal_url' => WebinarSysteemLicense::get_renewal_url(),
            'translations' => WebinarSysteemSettings::instance()->get_translations(),
            'max_hosted_attendee_count' => WebinarSysteemLicense::get_max_hosted_attendee_count(),
            'isZoomSetup' => WebinarSysteemHelperFunctions::isZoomSetup(),
            'has_ai_api_key' => !empty(WebinarSysteemSettings::instance()->get_ai_api_key())
        ]);
    }

    public static function attendees() {
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $webinar_id = isset($_GET['id']) ? $_GET['id'] : null;
        self::write_page("wpws-attendees", [
            'webinar_id' => (int) $webinar_id,
        ]);
    }

    public static function certificate() {
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $webinar_id = isset($_GET['id']) ? $_GET['id'] : null;
        self::write_page("wpws-certificate", [
            'webinar_id' => (int) $webinar_id,
        ]);
    }

    public static function chats() {
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $webinar_id = isset($_GET['id']) ? $_GET['id'] : null;
        self::write_page("wpws-chats", [
            'webinar_id' => (int) $webinar_id,
        ]);
    }

    public static function questions() {
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $webinar_id = isset($_GET['id']) ? $_GET['id'] : null;
        self::write_page("wpws-questions", [
            'webinar_id' => (int) $webinar_id,
        ]);
    }

    public static function settings() {
        wp_enqueue_editor();
        self::write_page("wpws-settings", []);
    }

    public static function webinar_recordings() {
        self::write_page("wpws-webinar-recordings", [
            'license_key' => WebinarSysteemLicense::get_license()
        ]);
    }

    public static function polls() {
        self::write_page("wpws-poll-list", [
            'translations' => WebinarSysteemSettings::instance()->get_translations(),
        ]);
    }

    public static function simulated_chat() {
        self::write_page("wpws-simulated-chat", [
            'translations' => WebinarSysteemSettings::instance()->get_translations(),
        ]);
    }
}
