<?php

$zoom_js = WebinarSysteemJS::get_plugin_path() . 'includes/js/zoom/zoom.js?v='.WPWS_ZOOM_SDK_VERSION;
$bootstrap_css_url = WebinarSysteemJS::get_plugin_path() . 'includes/js/zoom/bootstrap.css';

 // phpcs:ignore WordPress.Security.NonceVerification.Recommended
if (!isset($_REQUEST['params'])) {
  die('Invalid params');
}

// Make a call to live.getwebinarpress.com to get the signature
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$signature = WebinarSysteemMediaServer::get_zoom_signature($_REQUEST['params']);

if (empty($signature)) {
  die('Failed to load Zoom signature, please contact support');
}

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="theme-color" content="#000000">

    <?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
    <link type="text/css" rel="stylesheet" href="<?php echo $bootstrap_css_url ?>" />

    <title>Zoom</title>
    <script
        src="https://code.jquery.com/jquery-3.4.1.min.js"
        integrity="sha256-CSXorXvZcTkaix6Yvo6HppcZGetbYMGWSFlBw8HfCJo="
        crossorigin="anonymous">
    </script>
  </head>
  <body>
    <noscript>
      You need to enable JavaScript to run this app.
    </noscript>

    <?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
    <input type="hidden" id="signature" value="<?php echo $signature->signature; ?>">
    <?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
    <input type="hidden" id="clientId" value="<?php echo $signature->clientId; ?>">

    <?php // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
    <script src="<?php echo $zoom_js; ?>"></script>
  </body>
</html>
