<?php

return [
    'name' => 'Produkter',
    'description' => 'Vis og oppdater produktinnstillinger',
    'create' => 'Nytt produkt',
    'create_product_type' => [
        'physical' => 'Nytt fysisk produkt',
        'digital' => 'Nytt digitalt produkt',
    ],
    'edit' => 'Rediger produkt - :name',
    'form' => [
        'name' => 'Navn',
        'name_placeholder' => 'Produktnavn (Maksimum 120 tegn)',
        'description' => 'Beskrivelse',
        'description_placeholder' => 'Kort beskrivelse av produkt (Maksimum 400 tegn)',
        'categories' => 'Kategorier',
        'content' => 'Innhold',
        'price' => 'Pris',
        'quantity' => 'Antall',
        'brand' => 'Merke',
        'width' => 'Bredde',
        'height' => 'Høyde',
        'weight' => 'Vekt',
        'date' => [
            'start' => 'Fra dato',
            'end' => 'Til dato',
        ],
        'image' => 'Bilder',
        'collections' => 'Produktsamlinger',
        'labels' => 'Etiketter',
        'price_sale' => 'Salgspris',
        'product_type' => [
            'title' => 'Produkttype',
        ],
        'product' => 'Produkt',
        'total' => 'Total',
        'sub_total' => 'Delsum',
        'shipping_fee' => 'Fraktgebyr',
        'discount' => 'Rabatt',
        'options' => 'Alternativer',
        'shipping' => [
            'height' => 'Høyde',
            'length' => 'Lengde',
            'title' => 'Frakt',
            'weight' => 'Vekt',
            'wide' => 'Bredde',
        ],
        'barcode' => 'Strekkode (ISBN, UPC, GTIN, etc.) ',
        'barcode_placeholder' => 'Skriv inn strekkode',
        'cost_per_item' => 'Kostnad per vare',
        'cost_per_item_placeholder' => 'Skriv inn kostnad per vare',
        'cost_per_item_helper' => 'Kunder vil ikke se denne prisen.',
        'price_includes_tax' => 'Prisen inkluderer avgift',
        'price_includes_tax_helper' => 'Merk av dette hvis den angitte prisen allerede inkluderer avgifter. Systemet vil beregne grunnprisen ved å fjerne avgiftsbeløpet.',
        'stock' => [
            'allow_order_when_out' => 'Tillat kunde å bestille når dette produktet er utsolgt',
            'in_stock' => 'På lager',
            'out_stock' => 'Utsolgt',
            'title' => 'Lagerstatus',
        ],
        'storehouse' => [
            'no_storehouse' => 'Ingen lagerstyring',
            'storehouse' => 'Med lagerstyring',
            'title' => 'Lager',
            'quantity' => 'Antall',
        ],
        'tax' => 'Mva',
        'taxes' => 'Mva',
        'taxes_helper' => 'Standard mva-sats er konfigurert i <a href=":url">Innstillinger -> Mva</a>. Hvis ingen spesifikk mva er valgt for dette produktet, vil standardsatsen bli brukt. For å deaktivere mva for dette produktet, fjern standard mva-sats fra mva-innstillingene.',
        'is_default' => 'Er standard',
        'action' => 'Handling',
        'restock_quantity' => 'Påfyllingsantall',
        'remain' => 'Gjenstår',
        'choose_discount_period' => 'Velg rabattperiode',
        'cancel' => 'Avbryt',
        'no_results' => 'Ingen resultater!',
        'value' => 'Verdi',
        'attribute_name' => 'Attributtnavn',
        'add_more_attribute' => 'Legg til flere attributter',
        'continue' => 'Fortsett',
        'add_new_attributes' => 'Legg til nye attributter',
        'add_new_attributes_description' => 'Å legge til nye attributter hjelper produktet med å ha mange alternativer, som størrelse eller farge.',
        'create_product_variations' => ':link for å opprette produktvarianter!',
        'tags' => 'Tagger',
        'write_some_tags' => 'Skriv noen tagger',
        'variation_existed' => 'Denne varianten finnes allerede.',
        'no_attributes_selected' => 'Ingen attributter valgt!',
        'added_variation_success' => 'Lagt til variant vellykket!',
        'updated_variation_success' => 'Oppdatert variant vellykket!',
        'created_all_variation_success' => 'Opprettet alle varianter vellykket!',
        'updated_product_attributes_success' => 'Oppdatert produktattributter vellykket!',
        'stock_status' => 'Lagerstatus',
        'auto_generate_sku' => 'Autogenerer SKU?',
        'featured_image' => 'Fremhevet bilde (valgfritt)',
        'product_id' => 'Produkt-ID',
        'price_sale_percent_helper' => 'Rabatt :percent fra originalpris.',
        'minimum_order_quantity' => 'Minimum bestillingsantall',
        'minimum_order_quantity_helper' => 'Minimumsantall for å legge inn en bestilling, hvis verdien er 0, er det ingen grense.',
        'maximum_order_quantity' => 'Maksimum bestillingsantall',
        'maximum_order_quantity_helper' => 'Maksimumsantall for å legge inn en bestilling, hvis verdien er 0, er det ingen grense.',
        'video' => 'Video',
        'video_file' => 'Fil',
        'video_url' => 'Eller ekstern video-URL',
        'video_url_help' => 'Skriv inn YouTube eller Vimeo video-URL',
        'enter_video_url' => 'Skriv inn video-URL',
        'video_thumbnail' => 'Video miniatyrbilde',
        'video_thumbnail_help' => 'Velg et miniatyrbilde for videoen. Hvis ikke valgt, vil det automatisk hentes fra video-URL hvis tilgjengelig.',
        'barcode_existed' => 'Denne strekkoden brukes av et annet produkt. Vennligst skriv inn en annen strekkode.',
        'barcode_helper' => 'Må være unik for hvert produkt.',
        'is_new_until' => 'Ny til',
        'is_new_until_helper' => 'Angi en dato til når dette produktet skal merkes som "Nytt". La stå tomt for ikke å merke som nytt basert på dato.',
    ],
    'price' => 'Pris',
    'quantity' => 'Antall',
    'type' => 'Type',
    'image' => 'Miniatyrbilde',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'Variant SKU',
    'brand' => 'Merke',
    'cannot_delete' => 'Produktet kunne ikke slettes',
    'product_deleted' => 'Produktet er slettet',
    'product_collections' => 'Produktsamlinger',
    'products' => 'Produkter',
    'menu' => 'Produkter',
    'control' => [
        'button_add_image' => 'Legg til bilde',
    ],
    'price_sale' => 'Salgspris',
    'price_group_title' => 'Administrer produktpris',
    'store_house_group_title' => 'Administrer lager',
    'shipping_group_title' => 'Administrer frakt',
    'overview' => 'Oversikt',
    'attributes' => 'Attributter',
    'product_has_variations' => 'Produktet har varianter',
    'manage_products' => 'Administrer produkter',
    'add_new_product' => 'Legg til nytt produkt',
    'start_by_adding_new_product' => 'Start med å legge til nye produkter.',
    'edit_this_product' => 'Rediger dette produktet',
    'delete' => 'Slett',
    'related_products' => 'Relaterte produkter',
    'cross_selling_products' => 'Krysssalgsprodukter',
    'up_selling_products' => 'Oppsalgsprodukter',
    'grouped_products' => 'Grupperte produkter',
    'search_products' => 'Søk produkter',
    'selected_products' => 'Valgte produkter',
    'edit_variation_item' => 'Rediger',
    'variations_box_description' => 'Klikk på "Rediger attributt" for å legge til/fjerne attributter for variant eller klikk på "Legg til ny variant" for å legge til variant.',
    'save_changes' => 'Lagre endringer',
    'continue' => 'Fortsett',
    'edit_attribute' => 'Rediger attributt',
    'select_attribute' => 'Velg attributt',
    'add_new_variation' => 'Legg til ny variant',
    'edit_variation' => 'Rediger variant',
    'generate_variations' => 'Generer varianter',
    'generate_variations_confirmation' => 'Er du sikker på at du vil generere varianter for dette produktet?',
    'delete_variation' => 'Slett variant?',
    'delete_variation_confirmation' => 'Er du sikker på at du vil slette denne varianten? Denne handlingen kan ikke angres.',
    'delete_variations_confirmation' => 'Er du sikker på at du vil slette disse variantene? Denne handlingen kan ikke angres.',
    'product_create_validate_name_required' => 'Vennligst skriv inn produktnavn',
    'product_create_validate_sale_price_max' => 'Rabatten må være mindre enn originalprisen',
    'product_create_validate_cost_per_item_max' => 'Kostnad per vare må være mindre enn originalprisen',
    'product_create_validate_sale_price_required_if' => 'Må skrive inn rabatt når du vil planlegge en kampanje',
    'product_create_validate_end_date_after' => 'Sluttdato må være etter startdato',
    'product_create_validate_start_date_required_if' => 'Rabattstartdato kan ikke være tom når planlegging er valgt',
    'product_create_validate_sale_price' => 'Rabatter kan ikke være tomme når planlegging er valgt',
    'stock_statuses' => [
        'in_stock' => 'På lager',
        'out_of_stock' => 'Utsolgt',
        'on_backorder' => 'På restordre',
    ],
    'stock_status' => 'Lagerstatus',
    'processing' => 'Behandler...',
    'delete_selected_variations' => 'Slett valgte varianter',
    'delete_variations' => 'Slett varianter',
    'category' => 'Kategori',
    'categories' => 'Kategorier',
    'tags' => 'Tagger',
    'product_price_flash_sale_warning' => 'Dette produktet er i flash-salg <strong>:name</strong> så prisen er <strong>:price</strong>.',
    'product_price_discount_warning' => 'Dette produktet er i rabatt <strong>:name</strong> så prisen er <strong>:price</strong>.',
    'product_image' => 'Produktbilde',
    'product_name' => 'Produktnavn',
    'product_link' => 'Produktlenke',
    'types' => [
        'physical' => 'Fysisk',
        'digital' => 'Digitalt',
    ],
    'digital_attachments' => [
        'title' => 'Digitale vedlegg',
        'add' => 'Legg til vedlegg',
        'file_name' => 'Filnavn',
        'file_size' => 'Filstørrelse',
        'unsaved' => 'Ikke lagret',
        'add_external_link' => 'Legg til ekstern lenke',
        'enter_file_name' => 'Skriv inn filnavn',
        'enter_external_link_download' => 'Skriv inn ekstern nedlastingslenke',
        'enter_file_size' => 'Skriv inn filstørrelse',
        'external_link_download' => 'Ekstern nedlastingslenke',
        'generate_license_code_after_purchasing_product' => 'Aktiver tildeling av lisenskode for dette produktet',
        'notify_attachment_updated' => 'Send e-post til kunde når vedlegg oppdateres',
    ],
    'license_codes' => [
        'title' => 'Lisenskoder',
        'add' => 'Legg til lisenskode',
        'back' => 'Tilbake til produkt',
        'edit' => 'Rediger lisenskode',
        'generate' => 'Generer koder',
        'manage_codes' => 'Administrer lisenskoder',
        'management' => 'Lisenskodeadministrasjon',
        'variation_breadcrumb' => 'Variant: :name',
        'variation_label' => 'Produktvariant',
        'variation_specific_note' => 'Disse lisenskodene er spesifikke for denne produktvarianten. Kunder som kjøper denne varianten vil motta koder fra dette settet.',
        'main_product_note' => 'Dette produktet har varianter. Hver variant kan ha sine egne lisenskoder, eller kunder kan motta koder fra dette hovedproduktet hvis varianten ikke har koder.',
        'code' => 'Lisenskode',
        'codes' => 'Lisenskoder',
        'status' => 'Status',
        'assigned_at' => 'Tildelt',
        'status_available' => 'Tilgjengelig',
        'status_used' => 'Brukt',
        'statuses' => [
            'available' => 'Tilgjengelig',
            'used' => 'Brukt',
        ],
        'no_codes' => 'Ingen lisenskoder funnet. Legg til noen koder eller generer dem automatisk.',
        'no_codes_warning_title' => 'Ingen lisenskoder tilgjengelig!',
        'no_codes_warning_message' => 'Dette produktet er satt til "Velg fra liste" men har ingen tilgjengelige lisenskoder. Kunder som kjøper dette produktet vil motta autogenererte koder i stedet. Vennligst legg til lisenskoder for å sikre riktig funksjonalitet.',
        'no_codes_auto_generate' => 'Dette produktet er satt til å autogenerere lisenskoder. Ingen manuelle koder nødvendig.',
        'used_code_no_actions' => 'Brukt kode - ingen handlinger tilgjengelig',
        'created_successfully' => 'Lisenskode opprettet vellykket!',
        'updated_successfully' => 'Lisenskode oppdatert vellykket!',
        'deleted_successfully' => 'Lisenskode slettet vellykket!',
        'generated_successfully' => 'Genererte :count lisenskoder vellykket!',
        'duplicates_skipped' => ':count dupliserte koder ble hoppet over.',
        'generation_incomplete' => 'Advarsel: Kunne bare generere :generated av :requested forespurte koder på grunn av duplikatkonflikter.',
        'cannot_edit_used_code' => 'Kan ikke redigere en brukt lisenskode.',
        'cannot_delete_used_code' => 'Kan ikke slette en brukt lisenskode.',
        'show_all' => 'Vis alle',
        'show_less' => 'Vis mindre',
        'more' => 'mer',
        'used_codes_hidden' => ':count brukt(e) lisenskode(r) er skjult. Du kan se alle koder på siden for lisenskodeadministrasjon.',
        'low_stock_title' => 'Lav beholdning av lisenskoder',
        'low_stock_message' => 'Kun :count lisenskoder gjenstår. Vurder å legge til flere koder for å unngå å gå tom.',
        'out_of_stock_title' => 'Tom for lisenskoder!',
        'out_of_stock_message' => 'Ingen lisenskoder tilgjengelig. Kunder vil motta autogenererte koder til du legger til flere.',
        'type' => [
            'title' => 'Tildelingsmetode for lisenskode',
            'auto_generate' => 'Autogenerer (Systemet genererer koder automatisk)',
            'pick_from_list' => 'Velg fra liste (Bruk forhåndsinnførte koder)',
            'description' => 'Velg hvordan lisenskoder skal tildeles kunder når de kjøper dette produktet.',
        ],
        'generate_modal' => [
            'title' => 'Generer lisenskoder',
            'quantity' => 'Antall',
            'format' => 'Format',
            'custom_pattern' => 'Tilpasset mønster',
            'pattern_help' => 'Bruk # for tall, A for store bokstaver, a for små bokstaver',
            'generate' => 'Generer',
        ],
        'errors' => [
            'feature_not_enabled' => 'Lisenskodefunksjonen er ikke aktivert. Vennligst aktiver den i E-handelsinnstillinger > Digitale produkter.',
            'digital_products_not_enabled' => 'Digitale produkter er ikke aktivert. Vennligst aktiver støtte for digitale produkter først.',
            'product_not_found' => 'Produktet ikke funnet.',
            'not_digital_product' => 'Lisenskoder er kun tilgjengelige for digitale produkter. Dette produktet er satt som fysisk produkt.',
            'license_codes_not_enabled_for_product' => 'Lisenskodeadministrasjon er ikke aktivert for dette produktet. Vennligst aktiver "Generer lisenskode etter kjøp av produkt" i produktinnstillingene.',
            'cannot_add_codes_auto_generate' => 'Kan ikke manuelt legge til lisenskoder til produkter satt til autogenerering. Endre lisenskodetype til "Velg fra liste" først.',
            'cannot_generate_codes_auto_generate' => 'Kan ikke manuelt generere lisenskoder for produkter satt til autogenerering. Endre lisenskodetype til "Velg fra liste" først.',
        ],
        'copied' => 'Lisenskode kopiert til utklippstavle!',
    ],
    'this_action_will_reload_page' => 'Denne handlingen vil laste siden på nytt for å oppdatere dataene!',
    'select' => 'Velg',
    'set_this_variant_as_default' => 'Sett denne varianten som standard',
    'download' => 'Last ned',
    'cross_sell_price_type' => [
        'title' => 'Pristype',
        'fixed' => 'Fast',
        'percent' => 'Prosent',
    ],
    'cross_sell_help' => [
        'price' => 'Pris',
        'price_description' => 'Skriv inn beløpet du vil redusere fra originalprisen. Eksempel: Hvis originalprisen er 1000 kr, skriv inn 200 for å redusere prisen til 800 kr.',
        'type' => '* Typefelt',
        'type_description' => 'Velg rabatttype: Fast (reduser et spesifikt beløp) eller Prosent (reduser med en prosentandel).',
    ],
    'apply_for_all_variations' => 'Bruk for alle varianter',
    'export' => [
        'description' => 'Eksporter produktdataene dine til CSV- eller Excel-filer.',
        'total_items' => 'Totale elementer',
        'total_products' => 'Totale produkter',
        'total_variations' => 'Totale varianter',
        'advanced_options' => 'Avanserte alternativer',
        'use_chunked_export' => 'Bruk delt eksport',
        'use_chunked_export_helper' => 'Behandle data i deler for å håndtere store datasett effektivt',
        'include_variations' => 'Inkluder produktvarianter',
        'include_variations_helper' => 'Eksporter produktvarianter sammen med hovedprodukter',
        'optimize_memory' => 'Optimaliser minnebruk',
        'optimize_memory_helper' => 'Aktiver minneoptimalisering for svært store eksporter',
        'chunk_size' => 'Delstørrelse',
        'chunk_size_helper' => 'Antall produkter som skal behandles om gangen (50-5000)',
        'use_streaming' => 'Bruk strømmeeksport',
        'use_streaming_helper' => 'Aktiver strømming for svært store datasett (aktiveres automatisk for >10 000 elementer)',
        'large_dataset_warning_title' => 'Stort produktkatalog oppdaget',
        'large_dataset_warning_message' => 'Katalogen din inneholder :count elementer. På grunn av størrelsen har noen eksportalternativer blitt optimalisert for best ytelse.',
        'large_dataset_specific_message' => 'For :count produkter, bruk CSV-format med strømming aktivert. Systemet kan nå håndtere ditt store produktkatalog effektivt uten tidsavbrudd eller minneproblemer.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (påkrevd)',
        'chunk_label' => 'Behandling',
        'chunk_recommended' => '300 produkter/batch',
        'time_label' => 'Estimert tid',
        'time_estimate' => '1-3 minutter',
        'pro_tip' => 'Pro-tips:',
        'pro_tip_message' => 'Eksporten vil fortsette selv om nettleseren viser en laste-indikator. Når den er startet, vil nedlastingen begynne automatisk.',
        'large_dataset_tip_1' => 'Excel-format er deaktivert - bruk CSV-format for raskere og mer pålitelige eksporter',
        'large_dataset_tip_2' => 'Strømmemodus er automatisk aktivert for å forhindre tidsavbrudd',
        'large_dataset_tip_3' => 'Eksportprosess kan ta 1-3 minutter avhengig av serveren',
        'large_dataset_recommendation' => 'Anbefalt: Bruk CSV-format med 200-500 delstørrelse for optimal ytelse.',
        'excel_disabled_for_large_export' => 'Excel-format ikke tilgjengelig for kataloger over 10 000 elementer',
        'streaming_auto_enabled' => 'Strømmemodus er automatisk aktivert for optimal ytelse med store datasett.',
        'streaming_enabled_title' => 'Optimalisert for stor eksport',
        'streaming_enabled_message' => 'Strømmemodus er aktiv for å sikre jevn eksport uten minneproblemer.',
        'use_multi_file' => 'Bruk flerfilseksport',
        'use_multi_file_helper' => 'Del eksport i flere filer pakket i en ZIP for svært store datasett',
        'multi_file_enabled_title' => 'Flerfilseksport aktivert',
        'multi_file_enabled_message' => 'Eksporten vil bli delt i :count filer pakket i en ZIP for optimal ytelse.',
        'records_per_file' => 'Poster per fil',
        'records_per_file_helper' => 'Antall poster i hver fil ved bruk av flerfilseksport',
        'estimated_files' => 'Estimerte filer',
        'recommended_range' => 'Anbefalt område',
        'range_large_export' => '200-500 elementer',
        'range_medium_export' => '300-800 elementer',
        'range_small_export' => '500-1000 elementer',
        'export_progress' => 'Eksportfremdrift',
        'preparing_export' => 'Forbereder eksport...',
        'items_processed' => ':count elementer behandlet',
        'estimated_time_calculating' => 'Estimert tid: beregner...',
        'medium_dataset_detected' => 'Middels datasett oppdaget',
        'medium_dataset_message' => 'Du eksporterer :count produkter. Vurder å bruke delt eksport for bedre ytelse.',
        'optimal_range' => 'Optimalt område',
        'too_small_slow' => 'For lite - kan være tregt',
        'too_large_timeouts' => 'For stort - kan forårsake tidsavbrudd',
        'excel_disabled_warning' => 'Excel-format deaktivert for store eksporter (:count elementer)',
        'starting_export' => 'Starter eksport...',
        'processing_data' => 'Behandler data...',
        'finalizing_export' => 'Fullfører eksport...',
        'items_processed_suffix' => 'elementer behandlet',
        'estimated_time_prefix' => 'Estimert tid:',
        'seconds_remaining' => 's gjenstår',
        'export_completed' => 'Eksport fullført!',
        'download_starting' => 'Nedlasting starter...',
    ],
    'import' => [
        'description' => 'Importer produktdataene dine fra CSV- eller Excel-filer.',
        'rules' => [
            'in' => ':attribute må være en av de definerte verdiene: :values.',
            'required_string_max' => ':attribute er påkrevd og må være en streng med maksimum lengde :max tegn.',
            'nullable_string' => ':attribute kan være tom eller må være en streng hvis angitt.',
            'nullable_string_max' => ':attribute kan være tom eller må være en streng med maksimum lengde :max tegn hvis angitt',
            'nullable_bool' => 'Om :attribute kan være tom eller må være en boolsk verdi hvis angitt.',
            'nullable_numeric_min' => ':attribute kan være tom eller må være et ikke-negativt tall hvis angitt.',
            'nullable_numeric_min_max' => ':attribute kan være tom eller må være et tall mellom :min og :max hvis angitt.',
            'nullable_array' => ':attribute kan være tom eller må angis som en array hvis spesifisert.',
            'nullable_date_required_if' => ':attribute kan være tom eller må være en gyldig dato hvis angitt, påkrevd hvis :required er spesifisert.',
            'nullable_date_after' => ':attribute kan være tom eller må være en gyldig dato etter :after hvis angitt.',
        ],
        'updated_message' => 'Oppdaterte :count produkt(er) vellykket!',
    ],
    'import_products_intro' => 'Eller importer produkter fra CSV/Excel',
    'select_attributes' => 'Velg attributter for å opprette varianter:',
    'all' => 'Alle',
    'copy' => 'Kopier',
    'product_translations' => 'Produktoversettelser',
    'view' => 'Se produkt - :name',
    'product_information' => 'Produktinformasjon',
    'total_views' => 'Totalt Antall Visninger',
    'total_orders' => 'Fullførte Bestillinger',
    'total_sold' => 'Totalt Solgt',
    'total_revenue' => 'Total Inntekt',
    'pending_orders' => 'Ventende bestillinger',
    'pending_revenue' => 'Ventende inntekter',
    'conversion_rate' => 'Konverteringsrate',
    'total_reviews' => 'Totalt Anmeldelser',
    'average_rating' => 'Gjennomsnittlig Vurdering',
    'views_by_date' => 'Visninger etter Dato (Siste 30 Dager)',
    'recent_orders' => 'Siste Bestillinger',
    'no_views_data' => 'Ingen visningsdata tilgjengelig for de siste 30 dagene.',
    'no_orders' => 'Ingen bestillinger ennå.',
    'date' => 'Dato',
    'views' => 'Visninger',
    'total' => 'Totalt',
    'view_on_frontend' => 'Se på nettstedet',
    'select_attribute' => 'Velg :name',
    'all_categories' => 'Alle kategorier',
    'brands' => 'Merker',
    'browse_products' => 'Bla gjennom produkter',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Velg produkter som skal returneres',
    'show_only_discounted_products' => 'Vis kun produkter med rabatt',
    'specification' => 'Spesifikasjon',
    'download_product_with_external_links' => 'Last ned produktet ":name" med eksterne lenker',
    'number_product_available_singular' => ':number produkt tilgjengelig',
    'number_products_available_plural' => ':number produkter tilgjengelige',
    'cart' => [
        'added_to_cart_success' => ':product er lagt til i handlekurven din.',
        'removed_from_cart_success' => ':product er fjernet fra handlekurven din.',
        'updated_cart_success' => 'Handlekurven din er oppdatert.',
        'item_not_found' => 'Denne varen er ikke lenger i handlekurven din.',
        'out_of_stock' => 'Beklager, :product er for øyeblikket utsolgt.',
        'max_quantity' => 'Du kan bare legge til opptil :max varer.',
        'max_quantity_detail' => 'Beklager, du kan bare bestille :quantity enheter av :product om gangen.',
        'select_options' => 'Vennligst velg produktalternativer før du legger til i handlekurven.',
        'product_out_of_stock' => 'Beklager, dette produktet er for øyeblikket utsolgt.',
        'product_not_exists' => 'Dette produktet er utsolgt eller eksisterer ikke lenger.',
        'not_enough_quantity' => 'Noen produkter har ikke nok lager til å oppdatere.',
        'empty_success' => 'Handlekurven din er tømt.',
    ],
    'wishlist' => [
        'added_success' => ':product er lagt til i ønskelisten din.',
        'removed_success' => ':product er fjernet fra ønskelisten din.',
        'product_not_found' => 'Dette produktet ble ikke funnet.',
        'product_not_in_wishlist' => 'Dette produktet er ikke i ønskelisten din.',
        'product_not_available' => 'Dette produktet er ikke tilgjengelig.',
    ],
    'compare' => [
        'added_success' => ':product er lagt til i sammenligningslisten din.',
        'removed_success' => ':product er fjernet fra sammenligningslisten din.',
        'product_not_found' => 'Dette produktet ble ikke funnet.',
        'product_not_in_compare' => 'Dette produktet er ikke i sammenligningslisten din.',
        'already_in_list' => ':product er allerede i sammenligningslisten din.',
    ],
];
