<?php

return [
    'save_settings' => 'Sačuvaj podešavanja',
    'ecommerce' => 'Elektronska trgovina',
    'general' => [
        'name' => 'Opšta',
        'description' => 'Naziv prodavnice, podaci firme, kontakt i email obaveštenja admina',
    ],
    'currency' => [
        'name' => 'Valute',
        'description' => 'Formati valuta, kursevi, automatska detekcija i decimalni/hiljaditi separatori',
        'currency_setting_description' => 'Pregledajte i ažurirajte valute koje se koriste na veb sajtu',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Omogući automatsko otkrivanje valute posetioca',
            'enable_auto_detect_visitor_currency_helper' => 'Automatski otkrij i prikaži cene u lokalnoj valuti posetioca na osnovu njihove lokacije. Ovo pruža personalizovanije iskustvo kupovine.',
            'add_space_between_price_and_currency' => 'Dodaj razmak između cene i valute',
            'add_space_between_price_and_currency_helper' => 'Kada je omogućeno, dodaje razmak između vrednosti cene i simbola valute (npr. "100 RSD" umesto "100RSD").',
            'thousands_separator' => 'Separator hiljada',
            'thousands_separator_helper' => 'Izaberite karakter za razdvajanje hiljada u prikazu cene (npr. 1,000 ili 1.000 ili 1 000).',
            'decimal_separator' => 'Decimalni separator',
            'decimal_separator_helper' => 'Izaberite karakter za razdvajanje decimalnih vrednosti u cenama (npr. 10.99 ili 10,99).',
            'separator_period' => 'Tačka (.)',
            'separator_comma' => 'Zarez (,)',
            'separator_space' => 'Razmak ( )',
            'api_key' => 'API ključ za kurseve',
            'api_key_helper' => 'Nabavite API ključ za kurseve na :link',
            'update_currency_rates' => 'Ažuriraj kurseve valuta',
            'use_exchange_rate_from_api' => 'Koristi kurs sa API-ja',
            'use_exchange_rate_from_api_helper' => 'Omogući automatska ažuriranja kurseva valuta sa konfigurisan API provajdera. Ovo osigurava da su vaše cene uvek ažurirane sa trenutnim tržišnim stopama.',
            'clear_cache_rates' => 'Očisti keš kurseva',
            'auto_detect_visitor_currency_description' => 'Otkriva valutu posetioca na osnovu jezika pretraživača. Ovo će zameniti podrazumevani izbor valute.',
            'exchange_rate' => [
                'api_provider' => 'API provajder',
                'select' => '-- Izaberi --',
                'none' => 'Bez',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App ID',
            ],
            'default_currency_warning' => 'Za podrazumevanu valutu, kurs mora biti 1.',
        ],
    ],
    'product' => [
        'name' => 'Proizvodi',
        'description' => 'Prikaz zaliha, generisanje SKU, slike varijanti, povezani proizvodi i specifikacije',
        'product_settings' => 'Podešavanja proizvoda',
        'product_settings_description' => 'Konfiguriši pravila za proizvod',
        'form' => [
            'show_number_of_products' => 'Prikaži broj proizvoda na pojedinačnom proizvodu',
            'show_number_of_products_helper' => 'Prikaži ukupan broj proizvoda na stranici detalja proizvoda.',
            'show_out_of_stock_products' => 'Prikaži proizvode van zaliha',
            'show_out_of_stock_products_helper' => 'Ako je omogućeno, proizvodi van zaliha će biti prikazani na stranici liste proizvoda.',
            'how_to_display_product_variation_images' => 'Kako prikazati slike varijacija proizvoda',
            'how_to_display_product_variation_images_helper' => 'Izaberite da li da prikažete samo slike specifične za varijaciju ili da uključite i slike varijacije i glavnog proizvoda.',
            'only_variation_images' => 'Samo slike varijacije',
            'variation_images_and_main_product_images' => 'Slike varijacije i slike glavnog proizvoda',
            'enable_product_options' => 'Omogući opcije proizvoda',
            'enable_product_options_helper' => 'Dozvoli proizvodima da imaju prilagodljive opcije kao što su veličina, boja, itd.',
            'is_enabled_cross_sale_products' => 'Omogući proizvode unakrsne prodaje',
            'is_enabled_cross_sale_products_helper' => 'Prikaži predloge proizvoda unakrsne prodaje da podstakne dodatne kupovine.',
            'is_enabled_related_products' => 'Omogući slične proizvode',
            'is_enabled_related_products_helper' => 'Prikaži slične proizvode na osnovu kategorije, ili izabrane od strane administratora u formi proizvoda.',
            'related_products_source' => 'Izvor sličnih proizvoda',
            'related_products_source_helper' => 'Kada administrator ne izabere slične proizvode u formi proizvoda, prikaži slične proizvode na osnovu ovog izvora.',
            'related_products_source_category' => 'Ista kategorija',
            'related_products_source_brand' => 'Isti brend',
            'trending_products_period' => 'Period popularnih proizvoda',
            'trending_products_period_helper' => 'Izaberite vremenski period za razmatranje prilikom izračunavanja popularnih proizvoda na osnovu broja pregleda.',
            'trending_products_period_1_day' => 'Poslednjih 24 sata',
            'trending_products_period_3_days' => 'Poslednja 3 dana',
            'trending_products_period_7_days' => 'Poslednjih 7 dana (1 nedelja)',
            'trending_products_period_14_days' => 'Poslednjih 14 dana (2 nedelje)',
            'trending_products_period_30_days' => 'Poslednjih 30 dana (1 mesec)',
            'trending_products_period_60_days' => 'Poslednjih 60 dana (2 meseca)',
            'trending_products_period_90_days' => 'Poslednjih 90 dana (3 meseca)',
            'auto_generate_product_sku' => 'Automatski generiši SKU prilikom kreiranja proizvoda',
            'auto_generate_product_sku_helper' => 'Automatski generiši jedinstvene SKU-ove za nove proizvode na osnovu formata ispod.',
            'product_sku_format' => 'Format SKU-a',
            'product_sku_format_helper' => 'Možete koristiti %s (1 string karakter) ili %d (1 cifra) u formatu da bi generisali nasumičan string. Npr: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Omogući specifikaciju proizvoda',
            'enable_product_specification_help' => 'Ako je omogućeno, tabela specifikacija proizvoda će biti prikazana na stranici detalja proizvoda.',
            'make_product_barcode_required' => 'Učini barkod proizvoda obaveznim',
            'make_product_barcode_required_helper' => 'Ako je omogućeno, barkod proizvoda će biti obavezan prilikom kreiranja proizvoda.',
        ],
    ],
    'product_search' => [
        'name' => 'Pretraga proizvoda',
        'description' => 'Ponašanje pretrage, filteri po kategoriji/brendu/tagu/atributima i filtriranje cenovnog opsega',
        'product_search_settings' => 'Pretraga proizvoda',
        'product_search_settings_description' => 'Konfiguriši pravila za pretragu proizvoda',
        'form' => [
            'search_for_an_exact_phrase' => 'Pretraži po tačnoj frazi',
            'search_products_by' => 'Pretraži proizvode po:',
            'enable_filter_products_by_categories' => 'Omogući filtriranje proizvoda po kategorijama',
            'enable_filter_products_by_brands' => 'Omogući filtriranje proizvoda po brendovima',
            'enable_filter_products_by_tags' => 'Omogući filtriranje proizvoda po tagovima',
            'number_of_popular_tags_for_filter' => 'Broj popularnih tagova za filter',
            'number_of_popular_tags_for_filter_placeholder' => 'Unesite broj popularnih tagova za prikaz',
            'number_of_popular_tags_for_filter_helper' => 'Postavite maksimalan broj popularnih tagova za prikaz u filteru. Podrazumevano je 10.',
            'enable_filter_products_by_attributes' => 'Omogući filtriranje proizvoda po atributima',
            'enable_filter_products_by_price' => 'Omogući filtriranje proizvoda po ceni',
            'max_product_price_for_filter' => 'Maksimalna cena proizvoda za filter',
            'max_product_price_for_filter_placeholder' => 'Ako je prazno ili nula, dobićemo maksimalnu cenu proizvoda iz vaših postojećih proizvoda.',
            'max_product_price_for_filter_helper' => 'Možete postaviti fiksnu cenu za ovo ili će dinamički dobiti maksimalnu cenu proizvoda iz vaših postojećih proizvoda. Trenutno je :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Digitalni proizvodi',
        'description' => 'Proizvodi za preuzimanje, licencni kodovi, gostujuća naplata za digitalne proizvode i automatsko završavanje',
        'digital_products_settings' => 'Digitalni proizvodi',
        'digital_products_settings_description' => 'Konfiguriši pravila za digitalne proizvode',
        'form' => [
            'enable_support_digital_product' => 'Da li je omogućena podrška za digitalne proizvode',
            'enable_support_digital_product_helper' => 'Kada je omogućeno, sistem će podržavati prodaju digitalnih proizvoda kao što su softver, e-knjige, muzika i drugi sadržaj koji se može preuzeti.',
            'allow_guest_checkout_for_digital_products' => 'Dozvoli gostima plaćanje za digitalne proizvode',
            'allow_guest_checkout_for_digital_products_helper' => 'Kada je omogućeno, kupci mogu kupiti digitalne proizvode bez kreiranja naloga. Dobićće linkove za preuzimanje putem email-a.',
            'disable_physical_product' => 'Onemogući fizički proizvod',
            'disable_physical_product_helper' => 'Kada je omogućeno, prodavnica će prodavati samo digitalne proizvode. Opcije fizičkih proizvoda će biti skrivene iz formi proizvoda i plaćanja.',
            'enable_license_codes_for_digital_products' => 'Omogući kodove licenci za digitalne proizvode',
            'auto_complete_digital_orders_after_payment' => 'Automatski završi digitalne porudžbine nakon plaćanja',
            'auto_complete_digital_orders_after_payment_helper' => 'Kada je omogućeno, porudžbine koje sadrže samo digitalne proizvode će biti automatski označene kao završene kada se primi plaćanje.',
            'enable_license_codes_for_digital_products_helper' => 'Kada je omogućeno, možete dodati kodove licenci digitalnim proizvodima. Kada je onemogućeno, funkcionalnost kodova licenci će biti skrivena iz formi proizvoda.',
            'hide_used_license_codes_in_product_form' => 'Sakrij iskorišćene kodove licenci u formi proizvoda',
            'hide_used_license_codes_in_product_form_helper' => 'Kada je omogućeno, iskorišćeni kodovi licenci će biti skriveni iz tabele kodova licenci u formi za izmenu proizvoda. Ovo pomaže da interfejs ostane čist kada imate mnogo iskorišćenih kodova.',
        ],
    ],
    'product_review' => [
        'name' => 'Recenzije proizvoda',
        'description' => 'Recenzije kupaca, prikaz ocena, otpremanje slika i zahtevi za odobrenje',
        'form' => [
            'enable_review' => 'Omogući recenzije proizvoda',
            'enable_review_help' => 'Dozvoli kupcima da ostavljaju recenzije i ocene na proizvodima. Kada je onemogućeno, sve funkcije recenzija će biti skrivene iz prodavnice.',
            'allow_customer_upload_image_in_review' => 'Dozvoli kupcima da otpreme slike u recenzijama',
            'allow_customer_upload_image_in_review_help' => 'Kada je onemogućeno, kupci ne mogu otpremiti slike prilikom slanja recenzija',
            'review' => [
                'max_file_size' => 'Maksimalna veličina fajla recenzije (MB)',
                'max_file_number' => 'Maksimalan broj fajlova recenzije',
            ],
            'only_allow_customers_purchased_to_review' => 'Samo kupci koji su kupili proizvod mogu recenzirati proizvod',
            'review_need_to_be_approved' => 'Recenzija mora biti odobrena pre prikazivanja na stranici proizvoda',
            'show_customer_full_name' => 'Prikaži puno ime kupca',
            'show_customer_full_name_help' => 'Ako nije označeno, ime kupca koji recenzira će biti sakriveno i zamenjeno zvezdama (***)',
            'hide_rating_when_no_reviews' => 'Sakrij ocenu kada nema recenzija',
            'hide_rating_when_no_reviews_help' => 'Kada je omogućeno, ocene proizvoda će biti skrivene u listama proizvoda i na stranicama detalja proizvoda kada proizvod nema recenzija',
            'display_uploaded_customer_review_images_list' => 'Prikaži sekciju "Slike od kupaca"',
            'display_uploaded_customer_review_images_list_help' => 'Kada je omogućeno, prikazuje galeriju svih slika koje su otpremili kupci na vrhu sekcije recenzija',
        ],
    ],
    'shopping' => [
        'name' => 'Kupovina',
        'description' => 'Korpa, lista želja, poređenje, praćenje porudžbina, dugme za brzu kupovinu i otpremanje dokaza o plaćanju',
        'general_setting' => 'Opšta podešavanja',
        'return_settings' => 'Podešavanja povraćaja',
        'return_settings_description' => 'Konfiguriši pravila za podešavanja povraćaja',
        'form' => [
            'enable_cart' => 'Omogući korpu za kupovinu',
            'enable_cart_helper' => 'Ako je onemogućeno, dugme korpe će biti uklonjeno, pretvarajući vaš sajt u samo katalog za prikaz.',
            'enable_wishlist' => 'Omogući listu želja',
            'enable_wishlist_helper' => 'Ako je onemogućeno, dugme liste želja će biti uklonjeno sa sajta.',
            'enable_wishlist_sharing' => 'Omogući deljenje liste želja',
            'shared_wishlist_lifetime' => 'Trajanje podeljene liste želja (dani)',
            'shared_wishlist_lifetime_helper' => 'Trajanje podeljene liste želja u danima. Nakon ovog vremena, podeljena lista želja će biti obrisana.',
            'enable_compare' => 'Omogući poređenje',
            'enable_compare_helper' => 'Ako je onemogućeno, dugme poređenja će biti uklonjeno sa sajta.',
            'enable_order_tracking' => 'Omogući praćenje porudžbine',
            'enable_order_tracking_helper' => 'Kupci mogu pratiti svoje porudžbine unosom koda porudžbine i email-a/telefona na :url',
            'order_tracking_method' => 'Metod praćenja porudžbine',
            'order_tracking_method_helper' => 'Izaberite kako će kupci pratiti svoje porudžbine: koristeći ID porudžbine + Email ili ID porudžbine + Broj telefona.',
            'order_tracking_method_email' => 'ID porudžbine + Email',
            'order_tracking_method_phone' => 'ID porudžbine + Telefon',
            'enable_quick_buy_button' => 'Omogući dugme brze kupovine',
            'enable_quick_buy_button_helper' => 'Prikazaće dugme Kupi odmah na listi proizvoda i stranici detalja. Kada kupci kliknu na ovo dugme, proizvod će biti dodat u korpu i preusmereni na stranicu korpe/plaćanja.',
            'enable_order_auto_confirmed' => 'Automatski potvrdi porudžbinu',
            'enable_order_auto_confirmed_helper' => 'Ako je omogućeno, porudžbina će biti automatski potvrđena nakon što kupac napravi porudžbinu.',
            'quick_buy_target' => 'Ciljna stranica brze kupovine',
            'checkout_page' => 'Stranica plaćanja',
            'cart_page' => 'Stranica korpe',
            'cart_destroy_on_logout' => 'Uništi korpu pri odjavi',
            'cart_destroy_on_logout_helper' => 'Korpa će biti uništena kada se kupac odjavi.',
            'hide_product_price' => 'Sakrij cenu proizvoda',
            'hide_product_price_helper' => 'Ova opcija radi samo ako onemogućite korpu za kupovinu, pretvarajući vaš sajt u samo katalog za prikaz. Ako je omogućeno, cena proizvoda će biti sakrivena. Korisno je kada želite da sakrijete cenu i zahtevate od kupaca da vas kontaktiraju za cenu.',
            'hide_product_price_when_zero' => 'Sakrij cenu proizvoda kada je nula',
            'hide_product_price_when_zero_helper' => 'Ako je omogućeno, proizvodi sa cenom 0 neće prikazivati cenu na prodavnici.',
            'enable_payment_proof' => 'Omogući otpremanje dokaza o plaćanju',
            'enable_payment_proof_helper' => 'Dozvoli kupcima da otpreme dokaz o plaćanju za njihove porudžbine. Ovo je korisno za metode ručnog plaćanja.',
            'enable_guest_payment_proof' => 'Dozvoli gostima da otpreme dokaz o plaćanju',
            'enable_guest_payment_proof_helper' => 'Kada je omogućeno, gosti mogu otpremiti dokaz o plaćanju koristeći njihov token porudžbine bez prijavljivanja. Dobićete link za otpremanje u email-u sa potvrdom porudžbine.',
            'payment_proof_payment_methods' => 'Načini plaćanja koji zahtevaju dokaz o plaćanju',
            'payment_proof_payment_methods_helper' => 'Odaberite koje načine plaćanja treba omogućiti kupcima da učitaju dokaz o plaćanju. Obično se koristi za ručne načine plaćanja poput plaćanja pouzećem i bankovnim transferom.',
        ],
    ],
    'checkout' => [
        'name' => 'Plaćanje',
        'panel_description' => 'Gostujuća naplata, obavezna polja, ograničenja porudžbina, prihvatanje uslova i ograničenja zemalja',
        'description' => 'Konfiguriši pravila za podešavanja plaćanja',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Prikaži bankovne informacije na stranici uspešnog plaćanja',
            'mandatory_form_fields_at_checkout' => 'Obavezna polja na stranici plaćanja:',
            'mandatory_form_fields_at_checkout_helper' => 'Izaberite koja polja su obavezna tokom plaćanja. Kupci moraju popuniti ova polja da završe porudžbinu.',
            'hide_form_fields_at_checkout' => 'Sakrij polja kupca na stranici plaćanja:',
            'hide_form_fields_at_checkout_helper' => 'Izaberite koja polja treba sakriti na stranici plaćanja. Ova polja neće biti vidljiva kupcima.',
            'load_countries_states_cities_from_location_plugin' => 'Učitaj države, pokrajine, gradove iz dodatka za lokaciju',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'Nakon promene ove opcije, morate ponovo ažurirati sve adrese. Trebalo bi da ovo postavite jednom.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Zatim trebate da odete u Alati -> Uvoz/Izvoz podataka da uvezete podatke o lokaciji.',
            'minimum_order_amount' => 'Minimalan iznos porudžbine za pravljenje porudžbine (:currency).',
            'minimum_order_amount_helper' => 'Postavite minimalan ukupan iznos potreban da bi porudžbina bila obrađena. Porudžbine ispod ovog iznosa neće biti prihvaćene.',
            'zip_code_enabled' => 'Omogući poštanski broj',
            'zip_code_enabled_helper' => 'Omogući ili onemogući polje poštanskog broja u formi za adresu dostave.',
            'billing_address_enabled' => 'Omogući adresu za naplatu',
            'billing_address_enabled_helper' => 'Dozvoli kupcima da unesu zasebnu adresu za naplatu koja se razlikuje od njihove adrese dostave.',
            'display_tax_fields_at_checkout_page' => 'Prikaži polja poreskih informacija na stranici plaćanja',
            'display_tax_fields_at_checkout_page_helper' => 'Ako je omogućeno, polja poreskih informacija će biti prikazana za unos poreskih podataka kompanije da bi primili fakturu.',
            'use_city_field_as_field_text' => 'Koristi polje grada kao slobodno tekstualno polje',
            'available_countries' => 'Dostupne države',
            'all' => 'Sve',
            'all_helper_text' => 'Ako poništite sve države, primenjivaće se na sve države.',
            'enable_guest_checkout' => 'Omogući plaćanje za goste',
            'enable_guest_checkout_helper' => 'Ako je omogućeno, kupci mogu napraviti porudžbinu bez kreiranja naloga.',
            'recently_viewed' => [
                'enable' => 'Omogući nedavno pregledane proizvode kupca',
                'enable_helper' => 'Pratite i prikazujte proizvode koje su kupci nedavno pregledali. Ovo pomaže kupcima da lako pronađu proizvode koji su ih zanimali.',
                'max' => 'Maksimalan broj nedavno pregledanih proizvoda kupca',
                'max_helper_text' => 'Ako je postavljeno na 0, neće biti ograničenja.',
            ],
            'minimum_order_quantity' => 'Minimalna količina porudžbine',
            'minimum_order_quantity_helper' => 'Minimalna količina za pravljenje porudžbine. Ostavite 0 ako ne želite da postavite.',
            'maximum_order_quantity' => 'Maksimalna količina porudžbine',
            'maximum_order_quantity_helper' => 'Maksimalna količina za pravljenje porudžbine. Ostavite 0 ako ne želite da postavite.',
            'default_country_at_checkout_page' => 'Podrazumevana država na stranici plaćanja',
            'default_country_at_checkout_page_placeholder' => 'Izaberite državu',
            'default_country_at_checkout_page_help' => 'Ako izaberete državu, država će biti podrazumevano izabrana na stranici plaćanja.',
            'checkout_product_quantity_editable' => 'Dozvoli kupcima da promene količinu proizvoda na stranici plaćanja',
            'checkout_product_quantity_editable_helper' => 'Kada je omogućeno, kupci mogu modifikovati količinu proizvoda direktno na stranici plaćanja bez vraćanja u korpu.',
            'show_terms_and_policy_checkbox' => 'Prikaži polje za potvrdu uslova i politike',
            'show_terms_and_policy_checkbox_helper' => 'Ako je omogućeno, kupci moraju da prihvate uslove i politiku pre nego što naprave porudžbinu. Molimo postavite URL uslova i politike privatnosti u Izgled -> Opcije teme prvo.',
            'terms_and_policy_checkbox_checked_by_default' => 'Polje za potvrdu uslova i politike označeno podrazumevano',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Ako je omogućeno, polje za potvrdu uslova i politike će biti unapred označeno kada se učita forma plaćanja.',
            'checkout_acceptance_message_enabled' => 'Prikaži poruku prihvatanja plaćanja',
            'checkout_acceptance_message_enabled_helper' => 'Prikaži informativnu poruku koja obaveštava kupce o uslovima koje prihvataju pravljenjem porudžbine.',
            'hide_customer_info_at_checkout' => 'Sakrij informacije o kupcu na plaćanju',
            'hide_customer_info_at_checkout_helper' => 'Sakrij informacije o nalogu kupca i dugme za odjavu sa stranice plaćanja. Kada je omogućeno, prijavljeni kupci neće videti njihove detalje naloga prikazane.',
        ],
    ],
    'return' => [
        'name' => 'Povraćaj',
        'description' => 'Konfiguriši pravila za podešavanja povraćaja',
        'panel_description' => 'Vraćanje porudžbina, delimična vraćanja i rokovi za vraćanje',
        'form' => [
            'is_enabled_order_return' => 'Da li je omogućen povraćaj porudžbine',
            'allow_partial_return' => 'Dozvoli delimičan povraćaj',
            'allow_partial_return_description' => 'Kupac može vratiti nekoliko proizvoda, ne mora da vrati sve proizvode u porudžbini.',
            'returnable_days' => 'Dani za povraćaj',
            'return_settings_helper' => 'Broj dana u kojima kupac može zatražiti povraćaj nakon završetka porudžbine.',
        ],
    ],
    'invoice' => [
        'name' => 'Fakture',
        'description' => 'Podaci kompanije na fakturama, numerisanje faktura, PDF fontovi i podešavanja pečata',
        'company_settings' => 'Podešavanja kompanije',
        'company_settings_description' => 'Podešavanja informacija o kompaniji za fakturisanje',
        'form' => [
            'company_name' => 'Naziv kompanije',
            'company_address' => 'Adresa kompanije',
            'company_zipcode' => 'Poštanski broj kompanije',
            'company_email' => 'Email kompanije',
            'company_phone' => 'Telefon kompanije',
            'company_logo' => 'Logo kompanije',
            'company_tax_id' => 'PIB kompanije',
            'invoice_code_prefix' => 'Prefiks koda fakture',
            'using_custom_font_for_invoice' => 'Korišćenje prilagođenog fonta za fakturu',
            'invoice_font_family' => 'Familija fonta fakture (Samo za latinske jezike)',
            'enable_invoice_stamp' => 'Omogući pečat fakture',
            'add_language_support' => 'Dodaj podršku za jezik',
            'invoice_processing_library' => 'Biblioteka za obradu faktura',
            'only_latin_languages' => 'Samo latinski jezici',
            'disable_order_invoice_until_order_confirmed' => 'Onemogući fakturu porudžbine dok porudžbina nije potvrđena',
            'date_format' => 'Format datuma',
            'languages' => [
                'arabic' => 'Arapski',
                'bangladesh' => 'Bengalski',
                'chinese' => 'Kineski',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Porez',
        'description' => 'Podešavanja poreza',
        'enable' => 'Omogući porez?',
        'display_product_price_including_taxes' => 'Prikaži cenu proizvoda uključujući poreze?',
        'display_tax_description' => 'Prikaži poreske informacije na ceni proizvoda?',
        'display_tax_description_help' => 'Prikaži tekst kao "(Uključujući X% PDV)" ili "(Isključujući X% PDV)" pored cena proizvoda na stranici detalja proizvoda.',
        'tax_included_in_products_price' => 'Porez uključen u cenu proizvoda',
        'tax_included_in_products_price_description' => 'Porez će biti uključen u cenu proizvoda',
        'tax_setting' => 'Podešavanja poreza',
        'tax_setting_description' => 'Konfiguriši podešavanja poreza',
        'tax_management' => 'Upravljanje porezima',
        'tax_management_description' => 'Pregledajte i upravljajte vašim porezima',
        'form' => [
            'enable_tax' => 'Omogući porez',
            'display_company_invoice_information_fields_at_checkout_page' => 'Prikaži polja informacija o fakturi kompanije na stranici plaćanja',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Ako je omogućeno, polja informacija o fakturi kompanije će biti prikazana na stranici plaćanja. Obavezno je popuniti polja informacija o fakturi kompanije.',
            'default_tax_rate' => 'Podrazumevana stopa poreza',
            'default_tax_rate_description' => 'Važno: primenjivaće se ako nije izabran porez u proizvodu.',
            'select_tax' => '-- Izaberi --',
            'display_product_price_including_taxes' => 'Dodaj porez prikazanim cenama',
            'display_product_price_including_taxes_helper' => 'Automatski dodaje porez cenama proizvoda u prodavnici. Npr. proizvod od $100 sa 10% poreza prikazuje se kao $110. Nije potrebno ako je "Cena uključuje porez" već omogućeno na pojedinačnim proizvodima.',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Kupci',
        'description' => 'Registracija, verifikacija emaila, opcije prijave, brisanje naloga i polja profila',
        'customer_setting' => 'Podešavanja kupca',
        'customer_setting_description' => 'Konfiguriši podešavanja kupca',
        'form' => [
            'enable_customer_registration' => 'Omogući registraciju kupaca',
            'enable_customer_registration_helper' => 'Ako je onemogućeno, kupci neće moći da registruju nove naloge. Postojeći kupci i dalje mogu da se prijave.',
            'verify_customer_email' => 'Verifikuj email kupca',
            'verify_customer_email_helper' => 'Kada je omogućeno, link za verifikaciju će biti poslat na email kupca, kupci moraju kliknuti na ovaj link da verifikuju svoj email pre nego što mogu da se prijave. Potrebno je konfigurisati email u Admin -> Podešavanja -> Email da biste poslali email za verifikaciju.',
            'verification_expire_minutes' => 'Vreme isteka linka za verifikaciju',
            'verification_expire_minutes_helper' => 'Vreme u minutama za koje će link za verifikaciju email-a biti važeći. Podrazumevano je 60 minuta (1 sat). Maksimalno je 10080 minuta (7 dana).',
            'login_using_phone' => 'Prijavite se sa brojem telefona umesto email-a',
            'login_option' => 'Opcija prijave',
            'login_with_email' => 'Prijava sa email-om',
            'login_with_phone' => 'Prijava sa telefonom',
            'login_with_email_or_phone' => 'Prijava sa email-om ili telefonom',
            'enabled_customer_account_deletion' => 'Omogući brisanje naloga kupca',
            'enabled_customer_account_deletion_helper' => 'Kada je omogućeno, kupci mogu obrisati svoj nalog u kontrolnoj tabli kupca → Podešavanja naloga.',
            'enabled_customer_dob_field' => 'Omogući polje datuma rođenja kupca',
            'enabled_customer_dob_field_helper' => 'Kada je omogućeno, kupci mogu uneti svoj datum rođenja u kontrolnoj tabli kupca → Podešavanja naloga.',
            'enabled_phone_field_in_registration_form' => 'Omogući polje telefona u formi registracije',
            'enabled_phone_field_in_registration_form_helper' => 'Kada je omogućeno, polje telefona će biti dodato u formu registracije.',
            'make_customer_phone_number_required' => 'Učini broj telefona kupca obaveznim',
            'make_customer_phone_number_required_helper' => 'Kada je omogućeno, kupci moraju uneti svoj broj telefona tokom registracije. Uvek je obavezno za kupce koji se prijavljuju sa brojem telefona.',
            'default_avatar' => 'Podrazumevani avatar',
            'default_avatar_helper' => 'Podrazumevani avatar za kupca kada nemaju avatar. Ako ne izaberete bilo koju sliku, biće generisana koristeći vaš logo ili prvi karakter imena kupca.',
            'keep_email_field_in_registration_form' => 'Zadrži polje email-a u formi registracije',
            'keep_email_field_in_registration_form_helper' => 'Kada je onemogućeno, polje email-a će biti sakriveno u formi registracije kada je opcija prijave "Prijava sa telefonom".',
        ],
    ],
    'shipping' => [
        'name' => 'Dostava',
        'description' => 'Pravila isporuke, ponašanje besplatne isporuke i redosled prikaza opcija isporuke',
        'shipping_rule' => 'Pravila dostave',
        'shipping_rule_description' => 'Konfiguriši pravila za izračunavanje naknade za dostavu',
        'shipping_setting' => 'Podešavanja dostave',
        'shipping_setting_description' => 'Konfiguriši podešavanja dostave',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Sakrij druge opcije dostave ako ima besplatnu dostavu na listi',
            'disable_shipping_options' => 'Onemogući opcije dostave',
            'disable_shipping_options_helper' => 'Opcije dostave će biti uklonjene na stranici plaćanja, kupac neće moći da izabere opcije dostave.',
            'sort_shipping_options_direction' => 'Smer sortiranja opcija dostave',
            'sort_shipping_options_direction_helper' => 'Sortiraj opcije dostave po ceni od niže ka višoj ili od više ka nižoj.',
            'price_lower_to_higher' => 'Cena od niže ka višoj',
            'price_higher_to_lower' => 'Cena od više ka nižoj',
        ],
    ],
    'webhook' => [
        'name' => 'Webhook',
        'description' => 'Konfiguriši podešavanja webhook-a',
        'webhook_setting' => 'Webhook',
        'webhook_setting_description' => 'Konfiguriši webhook URL-ove da bi primili obaveštenja za različite događaje porudžbine',
        'form' => [
            'order_placed_webhook_url' => 'URL webhook-a za postavljenu porudžbinu (metod: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Da biste primili obaveštenja kada je porudžbina postavljena, možete postaviti eksterni webhook URL. Ako imate eksterni webhook URL, možete uneti ovaj URL, ili ga jednostavno ostaviti praznim.',
            'order_updated_webhook_url' => 'URL webhook-a za ažuriranu porudžbinu (metod: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Da biste primili obaveštenja kada je porudžbina ažurirana, možete postaviti eksterni webhook URL. Ovo uključuje promene statusa, ažuriranja adrese i druge modifikacije porudžbine.',
            'shipping_status_updated_webhook_url' => 'URL webhook-a za ažuriran status dostave (metod: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Da biste primili obaveštenja kada se promeni status dostave (npr. poslato, dostavljeno, otkazano), možete postaviti eksterni webhook URL.',
            'order_completed_webhook_url' => 'URL webhook-a za završenu porudžbinu (metod: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Da biste primili obaveštenja kada je porudžbina završena, možete postaviti eksterni webhook URL.',
            'order_cancelled_webhook_url' => 'URL webhook-a za otkazanu porudžbinu (metod: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Da biste primili obaveštenja kada je porudžbina otkazana, možete postaviti eksterni webhook URL.',
            'payment_status_updated_webhook_url' => 'URL webhook-a za ažuriran status plaćanja (metod: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Da biste primili obaveštenja kada se promeni status plaćanja (npr. plaćeno, neuspelo, vraćeno), možete postaviti eksterni webhook URL.',
            'abandoned_cart_webhook_url' => 'URL webhook-a za napuštenu korpu (metod: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Da biste primili obaveštenja kada su korpe napuštene i pratili kupce, možete postaviti eksterni webhook URL. Obaveštenja se šalju nakon konfigurabilnog vremenskog perioda.',
        ],
        'test_button' => 'Testiraj Webhook',
        'test_success' => 'Webhook test uspešan! Krajnja tačka je odgovorila ispravno.',
        'test_failed' => 'Webhook test nije uspeo. Krajnja tačka nije odgovorila kao što se očekivalo.',
        'test_error' => 'Greška webhook testa: :error',
        'please_enter_url' => 'Molimo prvo unesite webhook URL',
        'testing' => 'Testiranje...',
        'test_failed_title' => 'Test nije uspeo!',
        'test_success_title' => 'Test uspešan!',
        'status_code' => 'Kod statusa',
        'error_occurred' => 'Došlo je do greške prilikom testiranja webhook-a',
    ],
    'store_locator' => [
        'name' => 'Lokatori prodavnica',
        'description' => 'Pregledajte i ažurirajte liste vaših lanaca',
        'store_locator_description' => 'Sve liste vaših lanaca, glavnih prodavnica, filijala, itd. Lokacije mogu biti korišćene za praćenje prodaje i pomoći nam da konfigurišemo stope poreza za naplatu prilikom prodaje proizvoda.',
        'form' => [
            'change_primary_store' => 'promeni podrazumevani lokator prodavnice',
            'add_location' => 'Dodaj lokaciju',
            'edit_location' => 'Izmeni lokaciju',
            'delete_location' => 'Obriši lokaciju',
            'delete_location_confirmation' => 'Da li ste sigurni da želite da obrišete ovu lokaciju? Ova akcija se ne može poništiti.',
            'change_primary_location' => 'Promeni primarnu lokaciju',
            'save_location' => 'Sačuvaj lokaciju',
            'add_new' => 'Dodaj novo',
        ],
            'info' => [
            'title' => 'Kako funkcionišu lokatori prodavnica',
            'primary_store' => 'Adresa primarne prodavnice pojavljuje se na fakturama i koristi se kao podrazumevana adresa za povraćaj za etikete za slanje.',
            'shipping_location' => 'Prodavnice označene kao "lokacija slanja" mogu se odabrati kao izvorno skladište prilikom kreiranja pošiljki.',
            'shipment_selection' => 'Prilikom obrade porudžbina, možete odabrati iz kog skladišta poslati na osnovu zaliha i lokacije kupca.',
        ],
    ],
    'tracking' => [
        'name' => 'Praćenje',
        'description' => 'Facebook Pixel, Google Tag Manager događaji i Google Ads praćenje konverzija',
        'manage_tracking' => 'Upravljanje praćenjem',
        'manage_tracking_description' => 'Upravljanje praćenjem: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Omogući Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Idite na https://developers.facebook.com/docs/meta-pixel da kreirate Facebook Pixel. Uverite se da je vaš piksel aktivan i pravilno konfigurisan.',
            'facebook_pixel_id' => 'Facebook Pixel ID',
            'facebook_pixel_id_placeholder' => 'Primer: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Omogući Facebook Pixel Debug režim',
            'facebook_pixel_debug_mode_helper' => 'Omogući debug režim da biste logovali Facebook Pixel događaje u konzolu pretraživača i rešavali probleme sa praćenjem',
            'enable_google_tag_manager_tracking_events' => 'Omogući Google Tag Manager događaje praćenja',
            'google_tag_manager_tracking_info' => 'Kada je omogućeno, e-commerce događaji će biti praćeni kroz Google Tag Manager. Uverite se da ste konfigurisali Google Tag Manager gore.',
            'google_ads_conversion_id' => 'Google Ads Conversion ID',
            'google_ads_conversion_id_helper' => 'Unesite vaš Google Ads conversion ID (format: AW-123456789/AbC-D_efG-h1_ijk-lmN) da biste pratili konverzije kupovine na stranici zahvalnice.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'Facebook Pixel ID mora biti 15-16 cifara (npr. 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Marketplace',
        'description' => 'Podešavanja za više prodavaca, provizije, registracija prodavaca i konfiguracija isplata',
    ],
    'standard_and_format' => [
        'name' => 'Standard i format',
        'panel_description' => 'Format koda narudžbine, jedinice težine (kg/lb) i jedinice dimenzija (cm/inč)',
        'description' => 'Standardi i formati se koriste za izračunavanje stvari kao što su cene proizvoda, težine dostave i vremena porudžbine.',
        'form' => [
            'change_order_format' => 'Izmeni format koda porudžbine (opciono)',
            'change_order_format_description' => 'Podrazumevani kod porudžbine počinje od: broj. Možete promeniti početni ili krajnji string da kreirate kod porudžbine koji želite, na primer "DH-: broj" ili ": broj-A"',
            'start_with' => 'Počinje sa',
            'end_with' => 'Završava se sa',
            'order_will_be_shown' => 'Vaš kod porudžbine će biti prikazan',
            'weight_unit' => 'Jedinica težine',
            'height_unit' => 'Jedinica dužine / visine',
            'weight_unit_gram' => 'Gram (g)',
            'weight_unit_kilogram' => 'Kilogram (kg)',
            'weight_unit_lb' => 'Funta (lb)',
            'weight_unit_oz' => 'Unca (oz)',
            'height_unit_cm' => 'Centimetar (cm)',
            'height_unit_m' => 'Metar (m)',
            'height_unit_inch' => 'Inč',
        ],
    ],
    'sale_popup' => [
        'name' => 'Sale Popup',
        'description' => 'Prilagodite podešavanja sale popup-a sa lakoćom',
    ],
    'flash_sale' => [
        'name' => 'Brza rasprodaja',
        'description' => 'Konfiguriši podešavanja brze rasprodaje da biste ponudili vremenski ograničene promotivne popuste',
        'enable' => 'Omogući funkcionalnost brze rasprodaje',
        'enable_helper' => 'Kada je omogućeno, možete kreirati i upravljati brzim rasprodajama sa posebnim sniženim cenama za ograničeni vremenski period.',
        'show_sale_count_left' => 'Prikaži praćenje inventara',
        'show_sale_count_left_description' => 'Prikaži traku napretka sa "X prodato od Y" da kreirate hitnost i podstaknete brze kupovine tokom brzih rasprodaja.',
    ],
    'payment_method_cod_minimum_amount' => 'Minimalan iznos porudžbine - :currency (Opciono)',
    'payment_method_cod_minimum_amount_helper' => 'Set the minimum order amount required to use COD payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_cod_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_cod_maximum_amount_helper' => 'Set the maximum order amount allowed for COD payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_minimum_amount' => 'Minimalan iznos porudžbine - :currency (Opciono)',
    'payment_method_minimum_amount_helper' => 'Set the minimum order amount required to use this payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_maximum_amount_helper' => 'Set the maximum order amount allowed for this payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_maximum_amount_error' => 'Maximum order amount to use :payment_method payment method is :amount, you need to remove :more to place an order!',
    'display_bank_info_at_the_checkout_success_page' => 'Prikaži bankovne informacije na stranici uspešnog plaćanja?',
    'invoice_templates' => 'Šabloni faktura',

    'abandoned_cart' => [
        'name' => 'Giỏ hàng bị bỏ rơi',
        'description' => 'Khôi phục doanh số bị mất bằng cách gửi lời nhắc tự động cho khách hàng để lại sản phẩm trong giỏ',
        'panel_description' => 'Thiết lập lời nhắc tự động cho khách hàng bỏ rơi giỏ hàng',
        'how_it_works' => [
            'title' => 'Cách hoạt động',
            'step1_title' => 'Khách hàng thêm sản phẩm',
            'step1_description' => 'Khách hàng thêm sản phẩm vào giỏ hàng và cung cấp địa chỉ email.',
            'step2_title' => 'Giỏ hàng bị bỏ rơi',
            'step2_description' => 'Nếu không có giao dịch mua trong ngưỡng thời gian đã đặt, giỏ hàng được đánh dấu là bị bỏ rơi.',
            'step3_title' => 'Gửi email nhắc nhở',
            'step3_description' => 'Email nhắc nhở tự động được gửi để khuyến khích khách hàng hoàn tất việc mua hàng.',
            'step4_title' => 'Khôi phục doanh số',
            'step4_description' => 'Khách hàng quay lại hoàn tất đơn hàng và giỏ hàng được đánh dấu là đã khôi phục.',
        ],
        'form' => [
            'enable' => 'Bật theo dõi giỏ hàng bị bỏ rơi',
            'enable_helper' => 'Khi được bật, hệ thống sẽ theo dõi giỏ hàng bị bỏ rơi và cho phép bạn gửi email khôi phục cho khách hàng.',
            'timing_section' => 'Cài đặt thời gian',
            'email_section' => 'Cài đặt email nhắc nhở',
            'cleanup_section' => 'Dọn dẹp dữ liệu',
            'time_threshold' => 'Ngưỡng thời gian (giờ)',
            'time_threshold_helper' => 'Giỏ hàng được coi là bị bỏ rơi sau số giờ không hoạt động này. Khuyến nghị: 1-24 giờ.',
            'send_email' => 'Gửi email khôi phục',
            'send_email_helper' => 'Tự động gửi email khôi phục cho khách hàng có giỏ hàng bị bỏ rơi.',
            'max_reminders' => 'Số lượng email nhắc nhở',
            'max_reminders_helper' => 'Số lượng email nhắc nhở gửi cho mỗi giỏ hàng bị bỏ rơi. Mỗi email có thể được tùy chỉnh trong Mẫu Email.',
            'email_delay' => 'Gửi sau (giờ)',
            'email_discount' => 'Giảm giá (%)',
            'email_1_title' => 'Email #1 - Nhắc nhở thân thiện',
            'email_1_description' => 'Lời nhắc nhẹ nhàng đầu tiên để khuyến khích khách hàng quay lại.',
            'email_1_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email đầu tiên. Khuyến nghị: 1-2 giờ.',
            'email_2_title' => 'Email #2 - Kèm ưu đãi',
            'email_2_description' => 'Lời nhắc thứ hai với ưu đãi giảm giá để thúc đẩy mua hàng.',
            'email_2_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email thứ hai. Khuyến nghị: 24 giờ.',
            'email_2_discount_helper' => 'Phần trăm giảm giá để cung cấp trong email này. Đặt 0 nếu không giảm giá.',
            'email_3_title' => 'Email #3 - Cơ hội cuối',
            'email_3_description' => 'Lời nhắc cuối cùng với tính cấp bách và ưu đãi tốt nhất để chốt đơn.',
            'email_3_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email cuối cùng. Khuyến nghị: 72 giờ.',
            'email_3_discount_helper' => 'Phần trăm giảm giá cuối cùng. Thường cao hơn email #2.',
            'cleanup_days' => 'Dọn dẹp sau (ngày)',
            'cleanup_days_helper' => 'Tự động xóa bản ghi giỏ hàng bị bỏ rơi cũ hơn số ngày này.',
            'cronjob_not_setup' => '<strong>Cronjob chưa được cấu hình!</strong> Nhắc nhở giỏ hàng bị bỏ rơi yêu cầu cronjob được cấu hình đúng để hoạt động. <a href=":url">Thiết lập cronjob ngay</a>.',
            'cronjob_not_running' => '<strong>Cronjob không chạy!</strong> Cronjob dường như đã dừng. Vui lòng kiểm tra cấu hình máy chủ của bạn. <a href=":url">Xem trạng thái cronjob</a>.',
            'cronjob_working' => '<strong>Cronjob đang chạy đúng!</strong> Hoạt động cuối: :time. Nhắc nhở giỏ hàng bị bỏ rơi của bạn sẽ được xử lý tự động.',
            'email_setup_warning' => '<strong>Quan trọng:</strong> Đảm bảo cài đặt email của bạn được cấu hình đúng trong <a href=":url">Cài đặt → Email</a>. Gửi email test để xác minh mọi thứ hoạt động trước khi bật tính năng này.',
        ],
    ],
];
