<?php

return [
    'name' => '產品',
    'description' => '查看和更新您的產品設定',
    'create' => '新增產品',
    'create_product_type' => [
        'physical' => '新增實體產品',
        'digital' => '新增數碼產品',
    ],
    'edit' => '編輯產品 - :name',
    'form' => [
        'name' => '名稱',
        'name_placeholder' => '產品名稱(最多120個字元)',
        'description' => '描述',
        'description_placeholder' => '產品簡短描述(最多400個字元)',
        'categories' => '類別',
        'content' => '內容',
        'price' => '價格',
        'quantity' => '數量',
        'brand' => '品牌',
        'width' => '寬度',
        'height' => '高度',
        'weight' => '重量',
        'date' => [
            'start' => '開始日期',
            'end' => '結束日期',
        ],
        'image' => '圖片',
        'collections' => '產品系列',
        'labels' => '標籤',
        'price_sale' => '特價',
        'product_type' => [
            'title' => '產品類型',
        ],
        'product' => '產品',
        'total' => '總計',
        'sub_total' => '小計',
        'shipping_fee' => '運費',
        'discount' => '折扣',
        'options' => '選項',
        'shipping' => [
            'height' => '高度',
            'length' => '長度',
            'title' => '運送',
            'weight' => '重量',
            'wide' => '寬度',
        ],
        'barcode' => '條碼(ISBN、UPC、GTIN 等)',
        'barcode_placeholder' => '輸入條碼',
        'cost_per_item' => '每件成本',
        'cost_per_item_placeholder' => '輸入每件成本',
        'cost_per_item_helper' => '顧客看不到此價格。',
        'price_includes_tax' => '價格含稅',
        'price_includes_tax_helper' => '如果輸入的價格已包含稅金，請勾選此項。系統將通過刪除稅金金額來計算基礎價格。',
        'stock' => [
            'allow_order_when_out' => '允許顧客在此產品缺貨時結帳',
            'in_stock' => '有貨',
            'out_stock' => '缺貨',
            'title' => '庫存狀態',
        ],
        'storehouse' => [
            'no_storehouse' => '無倉庫管理',
            'storehouse' => '有倉庫管理',
            'title' => '倉庫',
            'quantity' => '數量',
        ],
        'tax' => '稅金',
        'taxes' => '稅金',
        'taxes_helper' => '預設稅率在 <a href=":url">設定 -> 稅金</a> 中配置。如果此產品未選擇特定稅金,將套用預設稅率。要停用此產品的稅金,請從稅金設定中移除預設稅率。',
        'is_default' => '是否預設',
        'action' => '操作',
        'restock_quantity' => '補貨數量',
        'remain' => '剩餘',
        'choose_discount_period' => '選擇折扣期間',
        'cancel' => '取消',
        'no_results' => '沒有結果!',
        'value' => '值',
        'attribute_name' => '屬性名稱',
        'add_more_attribute' => '新增更多屬性',
        'continue' => '繼續',
        'add_new_attributes' => '新增屬性',
        'add_new_attributes_description' => '新增屬性可讓產品擁有多個選項,例如尺寸或顏色。',
        'create_product_variations' => ':link 以建立產品變體!',
        'tags' => '標籤',
        'write_some_tags' => '撰寫一些標籤',
        'variation_existed' => '此變體已存在。',
        'no_attributes_selected' => '未選擇屬性!',
        'added_variation_success' => '成功新增變體!',
        'updated_variation_success' => '成功更新變體!',
        'created_all_variation_success' => '成功建立所有變體!',
        'updated_product_attributes_success' => '成功更新產品屬性!',
        'stock_status' => '庫存狀態',
        'auto_generate_sku' => '自動生成 SKU?',
        'featured_image' => '精選圖片(選填)',
        'product_id' => '產品編號',
        'price_sale_percent_helper' => '從原價折扣 :percent。',
        'minimum_order_quantity' => '最低訂購數量',
        'minimum_order_quantity_helper' => '下訂單的最低數量,如果值為 0,則無限制。',
        'maximum_order_quantity' => '最高訂購數量',
        'maximum_order_quantity_helper' => '下訂單的最高數量,如果值為 0,則無限制。',
        'video' => '影片',
        'video_file' => '文件',
        'video_url' => '或外部影片網址',
        'video_url_help' => '輸入 YouTube 或 Vimeo 影片網址',
        'enter_video_url' => '輸入影片網址',
        'video_thumbnail' => '影片縮圖',
        'video_thumbnail_help' => '為影片選擇縮圖。如果未選擇,將自動從影片網址獲取(如果可用)。',
        'barcode_existed' => '此條碼已被另一個產品使用。請輸入另一個條碼。',
        'barcode_helper' => '每個產品必須唯一。',
        'is_new_until' => '新品截止日期',
        'is_new_until_helper' => '設定此產品被標記為「新品」的截止日期。留空則不基於日期標記為新品。',
    ],
    'price' => '價格',
    'quantity' => '數量',
    'type' => '類型',
    'image' => '縮圖',
    'sku' => 'SKU',
    'sku_line' => 'SKU::sku',
    'variation_sku' => '變體 SKU',
    'brand' => '品牌',
    'cannot_delete' => '無法刪除產品',
    'product_deleted' => '產品已刪除',
    'product_collections' => '產品系列',
    'products' => '產品',
    'menu' => '產品',
    'control' => [
        'button_add_image' => '新增圖片',
    ],
    'price_sale' => '特價',
    'price_group_title' => '管理產品價格',
    'store_house_group_title' => '管理倉庫',
    'shipping_group_title' => '管理運送',
    'overview' => '概覽',
    'attributes' => '屬性',
    'product_has_variations' => '產品有變體',
    'manage_products' => '管理產品',
    'add_new_product' => '新增產品',
    'start_by_adding_new_product' => '從新增產品開始。',
    'edit_this_product' => '編輯此產品',
    'delete' => '刪除',
    'related_products' => '相關產品',
    'cross_selling_products' => '交叉銷售產品',
    'up_selling_products' => '追加銷售產品',
    'grouped_products' => '組合產品',
    'search_products' => '搜尋產品',
    'selected_products' => '已選擇的產品',
    'edit_variation_item' => '編輯',
    'variations_box_description' => '點擊「編輯屬性」以新增/移除變體屬性,或點擊「新增變體」以新增變體。',
    'save_changes' => '儲存變更',
    'continue' => '繼續',
    'edit_attribute' => '編輯屬性',
    'select_attribute' => '選擇屬性',
    'add_new_variation' => '新增變體',
    'edit_variation' => '編輯變體',
    'generate_variations' => '生成變體',
    'generate_variations_confirmation' => '您確定要為此產品生成變體嗎?',
    'delete_variation' => '刪除變體?',
    'delete_variation_confirmation' => '您確定要刪除此變體嗎?此操作無法撤銷。',
    'delete_variations_confirmation' => '您確定要刪除這些變體嗎?此操作無法撤銷。',
    'product_create_validate_name_required' => '請輸入產品名稱',
    'product_create_validate_sale_price_max' => '折扣必須小於原價',
    'product_create_validate_cost_per_item_max' => '每件成本必須小於原價',
    'product_create_validate_sale_price_required_if' => '當您想安排促銷時必須輸入折扣',
    'product_create_validate_end_date_after' => '結束日期必須在開始日期之後',
    'product_create_validate_start_date_required_if' => '選擇排程時,折扣開始日期不能留空',
    'product_create_validate_sale_price' => '選擇排程時,折扣不能留空',
    'stock_statuses' => [
        'in_stock' => '有貨',
        'out_of_stock' => '缺貨',
        'on_backorder' => '可預購',
    ],
    'stock_status' => '庫存狀態',
    'processing' => '處理中...',
    'delete_selected_variations' => '刪除選擇的變體',
    'delete_variations' => '刪除變體',
    'category' => '類別',
    'categories' => '分類',
    'tags' => '標籤',
    'product_price_flash_sale_warning' => '此產品在限時搶購 <strong>:name</strong> 中,因此其價格為 <strong>:price</strong>。',
    'product_price_discount_warning' => '此產品在折扣 <strong>:name</strong> 中,因此其價格為 <strong>:price</strong>。',
    'product_image' => '產品圖片',
    'product_name' => '產品名稱',
    'product_link' => '產品連結',
    'types' => [
        'physical' => '實體',
        'digital' => '數碼',
    ],
    'digital_attachments' => [
        'title' => '數碼附件',
        'add' => '新增附件',
        'file_name' => '文件名稱',
        'file_size' => '文件大小',
        'unsaved' => '未儲存',
        'add_external_link' => '新增外部連結',
        'enter_file_name' => '輸入文件名稱',
        'enter_external_link_download' => '輸入外部下載連結',
        'enter_file_size' => '輸入文件大小',
        'external_link_download' => '外部下載連結',
        'generate_license_code_after_purchasing_product' => '為此產品啟用授權碼分配',
        'notify_attachment_updated' => '當附件更新時向顧客發送電子郵件',
    ],
    'license_codes' => [
        'title' => '授權碼',
        'add' => '新增授權碼',
        'back' => '返回產品',
        'edit' => '編輯授權碼',
        'generate' => '生成授權碼',
        'manage_codes' => '管理授權碼',
        'management' => '授權碼管理',
        'variation_breadcrumb' => '變體::name',
        'variation_label' => '產品變體',
        'variation_specific_note' => '這些授權碼專用於此產品變體。購買此變體的顧客將從此池中獲得授權碼。',
        'main_product_note' => '此產品有變體。每個變體可以有自己的授權碼,或者如果變體沒有授權碼,顧客可以從此主產品池中獲得授權碼。',
        'code' => '授權碼',
        'codes' => '授權碼',
        'status' => '狀態',
        'assigned_at' => '分配時間',
        'status_available' => '可用',
        'status_used' => '已使用',
        'statuses' => [
            'available' => '可用',
            'used' => '已使用',
        ],
        'no_codes' => '找不到授權碼。新增一些授權碼或自動生成。',
        'no_codes_warning_title' => '沒有可用的授權碼!',
        'no_codes_warning_message' => '此產品設定為「從清單中選擇」,但沒有可用的授權碼。購買此產品的顧客將收到自動生成的授權碼。請新增授權碼以確保正常運作。',
        'no_codes_auto_generate' => '此產品設定為自動生成授權碼。無需手動授權碼。',
        'used_code_no_actions' => '已使用的授權碼 - 無可用操作',
        'created_successfully' => '授權碼建立成功!',
        'updated_successfully' => '授權碼更新成功!',
        'deleted_successfully' => '授權碼刪除成功!',
        'generated_successfully' => '成功生成 :count 個授權碼!',
        'duplicates_skipped' => '已跳過 :count 個重複授權碼。',
        'generation_incomplete' => '警告:由於重複衝突,只能生成 :requested 個請求中的 :generated 個授權碼。',
        'cannot_edit_used_code' => '無法編輯已使用的授權碼。',
        'cannot_delete_used_code' => '無法刪除已使用的授權碼。',
        'show_all' => '顯示全部',
        'show_less' => '顯示較少',
        'more' => '更多',
        'used_codes_hidden' => ':count 個已使用的授權碼已隱藏。您可以在授權碼管理頁面中查看所有授權碼。',
        'low_stock_title' => '授權碼庫存不足',
        'low_stock_message' => '僅剩 :count 個授權碼。考慮新增更多授權碼以避免用完。',
        'out_of_stock_title' => '授權碼已用完!',
        'out_of_stock_message' => '沒有可用的授權碼。顧客將收到自動生成的授權碼,直到您新增更多為止。',
        'type' => [
            'title' => '授權碼分配方式',
            'auto_generate' => '自動生成(系統自動生成授權碼)',
            'pick_from_list' => '從清單中選擇(使用預先輸入的授權碼)',
            'description' => '選擇顧客購買此產品時應如何分配授權碼。',
        ],
        'generate_modal' => [
            'title' => '生成授權碼',
            'quantity' => '數量',
            'format' => '格式',
            'custom_pattern' => '自訂模式',
            'pattern_help' => '使用 # 代表數字,A 代表大寫字母,a 代表小寫字母',
            'generate' => '生成',
        ],
        'errors' => [
            'feature_not_enabled' => '授權碼功能未啟用。請在「電子商務設定」>「數碼產品」中啟用。',
            'digital_products_not_enabled' => '數碼產品未啟用。請先啟用數碼產品支援。',
            'product_not_found' => '找不到產品。',
            'not_digital_product' => '授權碼僅適用於數碼產品。此產品設定為實體產品。',
            'license_codes_not_enabled_for_product' => '此產品未啟用授權碼管理。請在產品設定中啟用「購買產品後生成授權碼」。',
            'cannot_add_codes_auto_generate' => '無法手動新增授權碼到設定為自動生成的產品。請先將授權碼類型更改為「從清單中選擇」。',
            'cannot_generate_codes_auto_generate' => '無法手動為設定為自動生成的產品生成授權碼。請先將授權碼類型更改為「從清單中選擇」。',
        ],
        'copied' => '授權碼已複製到剪貼簿!',
    ],
    'this_action_will_reload_page' => '此操作將重新載入頁面以更新資料!',
    'select' => '選擇',
    'set_this_variant_as_default' => '將此變體設為預設',
    'download' => '下載',
    'cross_sell_price_type' => [
        'title' => '價格類型',
        'fixed' => '固定',
        'percent' => '百分比',
    ],
    'cross_sell_help' => [
        'price' => '價格',
        'price_description' => '輸入您想從原價減少的金額。例如:如果原價為 $100,輸入 20 以將價格降至 $80。',
        'type' => '* 類型欄位',
        'type_description' => '選擇折扣類型:固定(減少特定金額)或百分比(減少百分比)。',
    ],
    'apply_for_all_variations' => '套用於所有變體',
    'export' => [
        'description' => '將您的產品資料匯出到 CSV 或 Excel 文件。',
        'total_items' => '項目總數',
        'total_products' => '產品總數',
        'total_variations' => '變體總數',
        'advanced_options' => '進階選項',
        'use_chunked_export' => '使用分塊匯出',
        'use_chunked_export_helper' => '分塊處理資料以有效處理大型資料集',
        'include_variations' => '包括產品變體',
        'include_variations_helper' => '匯出產品變體以及主產品',
        'optimize_memory' => '優化記憶體使用',
        'optimize_memory_helper' => '為非常大的匯出啟用記憶體優化',
        'chunk_size' => '分塊大小',
        'chunk_size_helper' => '一次處理的產品數量(50-5000)',
        'use_streaming' => '使用串流匯出',
        'use_streaming_helper' => '為非常大的資料集啟用串流(超過 10,000 個項目時自動啟用)',
        'large_dataset_warning_title' => '檢測到大型產品目錄',
        'large_dataset_warning_message' => '您的目錄包含 :count 個項目。由於規模較大,某些匯出選項已針對最佳效能進行了優化。',
        'large_dataset_specific_message' => '對於您的 :count 個產品,請使用啟用串流的 CSV 格式。系統現在可以高效處理您的大型產品目錄,而不會超時或記憶體問題。',
        'format_label' => '格式',
        'csv_recommended' => 'CSV(必需)',
        'chunk_label' => '處理',
        'chunk_recommended' => '300 個產品/批次',
        'time_label' => '預計時間',
        'time_estimate' => '1-3 分鐘',
        'pro_tip' => '專業提示:',
        'pro_tip_message' => '即使您的瀏覽器顯示載入指示器,匯出也會繼續執行。開始後,下載將自動開始。',
        'large_dataset_tip_1' => 'Excel 格式已停用 - 使用 CSV 格式以獲得更快、更可靠的匯出',
        'large_dataset_tip_2' => '串流模式已自動啟用以防止超時',
        'large_dataset_tip_3' => '匯出過程可能需要 1-3 分鐘,具體取決於您的伺服器',
        'large_dataset_recommendation' => '建議:使用 200-500 分塊大小的 CSV 格式以獲得最佳效能。',
        'excel_disabled_for_large_export' => 'Excel 格式不適用於超過 10,000 個項目的目錄',
        'streaming_auto_enabled' => '串流模式已自動啟用,以在大型資料集下實現最佳效能。',
        'streaming_enabled_title' => '已針對大型匯出進行優化',
        'streaming_enabled_message' => '串流模式已啟用,以確保順利匯出而不會出現記憶體問題。',
        'use_multi_file' => '使用多文件匯出',
        'use_multi_file_helper' => '將匯出拆分為多個文件並打包在 ZIP 中,以處理非常大的資料集',
        'multi_file_enabled_title' => '已啟用多文件匯出',
        'multi_file_enabled_message' => '您的匯出將拆分為 :count 個文件並打包在 ZIP 中,以獲得最佳效能。',
        'records_per_file' => '每個文件的記錄數',
        'records_per_file_helper' => '使用多文件匯出時每個文件中的記錄數',
        'estimated_files' => '預計文件數',
        'recommended_range' => '建議範圍',
        'range_large_export' => '200-500 個項目',
        'range_medium_export' => '300-800 個項目',
        'range_small_export' => '500-1000 個項目',
        'export_progress' => '匯出進度',
        'preparing_export' => '準備匯出...',
        'items_processed' => '已處理 :count 個項目',
        'estimated_time_calculating' => '預計時間:計算中...',
        'medium_dataset_detected' => '檢測到中型資料集',
        'medium_dataset_message' => '您正在匯出 :count 個產品。考慮使用分塊匯出以獲得更好的效能。',
        'optimal_range' => '最佳範圍',
        'too_small_slow' => '太小 - 可能很慢',
        'too_large_timeouts' => '太大 - 可能導致超時',
        'excel_disabled_warning' => 'Excel 格式已針對大型匯出停用(:count 個項目)',
        'starting_export' => '開始匯出...',
        'processing_data' => '處理資料...',
        'finalizing_export' => '完成匯出...',
        'items_processed_suffix' => '個項目已處理',
        'estimated_time_prefix' => '預計時間:',
        'seconds_remaining' => '秒剩餘',
        'export_completed' => '匯出完成!',
        'download_starting' => '開始下載...',
    ],
    'import' => [
        'description' => '從 CSV 或 Excel 文件匯入您的產品資料。',
        'rules' => [
            'in' => ':attribute 必須是已定義值之一::values。',
            'required_string_max' => ':attribute 為必填項,且必須是最大長度為 :max 個字元的字串。',
            'nullable_string' => ':attribute 可以留空,或者如果提供則必須是字串。',
            'nullable_string_max' => ':attribute 可以留空,或者如果提供則必須是最大長度為 :max 個字元的字串',
            'nullable_bool' => ':attribute 可以留空,或者如果提供則必須是布林值。',
            'nullable_numeric_min' => ':attribute 可以留空,或者如果提供則必須是非負數。',
            'nullable_numeric_min_max' => ':attribute 可以留空,或者如果提供則必須是介於 :min 和 :max 之間的數字。',
            'nullable_array' => ':attribute 可以留空,或者如果指定則必須以陣列形式提供。',
            'nullable_date_required_if' => ':attribute 可以留空,或者如果提供則必須是有效日期,如果指定了 :required 則為必填項。',
            'nullable_date_after' => ':attribute 可以留空,或者如果提供則必須是 :after 之後的有效日期。',
        ],
        'updated_message' => '成功更新 :count 個產品!',
    ],
    'import_products_intro' => '或從 CSV/Excel 匯入產品',
    'select_attributes' => '選擇屬性以建立變體:',
    'all' => '全部',
    'copy' => '複製',
    'product_translations' => '產品翻譯',
    'view' => '查看產品 - :name',
    'product_information' => '產品資訊',
    'total_views' => '總瀏覽量',
    'total_orders' => '已完成訂單',
    'total_sold' => '總銷量',
    'total_revenue' => '總收入',
    'pending_orders' => '待處理訂單',
    'pending_revenue' => '待處理收入',
    'conversion_rate' => '轉化率',
    'total_reviews' => '總評論數',
    'average_rating' => '平均評分',
    'views_by_date' => '按日期查看（最近30天）',
    'recent_orders' => '最近訂單',
    'no_views_data' => '最近30天沒有瀏覽數據。',
    'no_orders' => '還沒有訂單。',
    'date' => '日期',
    'views' => '瀏覽量',
    'total' => '總計',
    'view_on_frontend' => '在前台查看',
    'select_attribute' => '選擇 :name',
    'all_categories' => '所有分類',
    'brands' => '品牌',
    'browse_products' => '瀏覽產品',
    'sku_1' => 'SKU:',
    'select_products_to_return' => '選擇要退貨的產品',
    'show_only_discounted_products' => '只顯示特價產品',
    'specification' => '產品規格',
    'download_product_with_external_links' => '下載含外部連結的「:name」產品',
    'number_product_available_singular' => '有 :number 件產品可用',
    'number_products_available_plural' => '有 :number 件產品可供選購',
    'cart' => [
        'added_to_cart_success' => ':product 已加入購物車。',
        'removed_from_cart_success' => ':product 已從購物車中移除。',
        'updated_cart_success' => '購物車已更新。',
        'item_not_found' => '此商品已不在購物車中。',
        'out_of_stock' => '抱歉，:product 目前缺貨。',
        'max_quantity' => '最多只能添加 :max 件商品。',
        'max_quantity_detail' => '抱歉，每次只能訂購 :quantity 件 :product。',
        'select_options' => '請在加入購物車前選擇產品選項。',
        'product_out_of_stock' => '抱歉，此產品目前缺貨。',
        'product_not_exists' => '此產品已缺貨或不存在。',
        'not_enough_quantity' => '部分產品庫存不足，無法更新。',
        'empty_success' => '購物車已清空。',
    ],
    'wishlist' => [
        'added_success' => ':product 已加入願望清單。',
        'removed_success' => ':product 已從願望清單中移除。',
        'product_not_found' => '找不到此產品。',
        'product_not_in_wishlist' => '此產品不在您的願望清單中。',
        'product_not_available' => '此產品不可用。',
    ],
    'compare' => [
        'added_success' => ':product 已加入比較列表。',
        'removed_success' => ':product 已從比較列表中移除。',
        'product_not_found' => '找不到此產品。',
        'product_not_in_compare' => '此產品不在您的比較列表中。',
        'already_in_list' => ':product 已在比較列表中。',
    ],
];
