<?php

return [
    'name' => 'Markedsplads',
    'email' => [
        'title' => 'Markedsplads',
        'description' => 'Konfigurer e-mailskabeloner til markedsplads',
        'store_new_order_title' => 'Besked om ny ordre',
        'store_new_order_description' => 'Send e-mail til butiksejeren når en ordre afgives',
        'verify_vendor_title' => 'Verificer sælger',
        'verify_vendor_description' => 'Send e-mail til administratoren når en sælger registrerer sig',
        'pending_product_approval_title' => 'Afventende produktgodkendelse',
        'pending_product_approval_description' => 'Send e-mail til administratoren når en sælger offentliggør deres produkter',
        'vendor_account_approved_title' => 'Sælgerkonto godkendt',
        'vendor_account_approved_description' => 'Send e-mail til sælger når deres konto godkendes',
        'product_approved_title' => 'Produkt godkendt',
        'product_approved_description' => 'Send e-mail til sælger når deres produkt godkendes',
        'withdrawal_approved_title' => 'Udbetaling godkendt',
        'withdrawal_approved_description' => 'Send e-mail til sælger når deres udbetalingsanmodning godkendes',
        'vendor_account_rejected_title' => 'Sælgerkonto afvist',
        'vendor_account_rejected_description' => 'Send e-mail til sælger når deres konto afvises',
        'vendor_account_unblocked_title' => 'Sælgerkonto ophævet blokering',
        'vendor_account_unblocked_description' => 'Send e-mail til sælger når deres konto ophæves',
        'vendor_account_blocked_title' => 'Sælgerkonto blokeret',
        'vendor_account_blocked_description' => 'Send e-mail til sælger når deres konto blokeres',
        'store_new_order_subject' => 'Ny ordre(r) hos {{ site_title }}',
        'verify_vendor_subject' => 'Ny sælger hos {{ site_title }} skal verificeres',
        'vendor_account_approved_subject' => 'Din konto er blevet godkendt til salg hos {{ site_title }}',
        'vendor_account_rejected_subject' => 'Din konto er blevet afvist til salg hos {{ site_title }}',
        'pending_product_approval_subject' => 'Nyt produkt skal godkendes til salg hos {{ site_title }}',
        'product_approved_subject' => 'Dit produkt er blevet godkendt til salg hos {{ site_title }}',
        'withdrawal_approved_subject' => 'Din udbetalingsanmodning er blevet godkendt',
        'welcome_vendor_title' => 'Velkommen sælger',
        'welcome_vendor_description' => 'Send e-mail til sælger efter registrering',
        'welcome_vendor_subject' => 'Velkommen til {{ site_title }}!',
        'contact_store_title' => 'Kontakt butik',
        'contact_store_description' => 'Send e-mail til butiksejeren når en kunde kontakter butikken',
        'contact_store_subject' => 'Ny kundehenvendelse',
        'vendor_account_blocked_subject' => 'Din sælgerkonto hos {{ site_title }} er blevet blokeret',
        'vendor_account_unblocked_subject' => 'Din sælgerkonto hos {{ site_title }} er blevet ophævet',
        'order_cancellation_to_vendor_title' => 'Ordreannullering (sendes til sælger (leverandør)',
        'order_cancellation_to_vendor_description' => 'Send til sælger (leverandør) når kunde annullerer en ordre',
        'order_cancellation_to_vendor_subject' => 'Ordre :order_id er blevet annulleret af kunde',
        'store_verified_title' => 'Butikverificering godkendt',
        'store_verified_description' => 'Send besked når butik er verificeret',
        'store_verified_subject' => 'Din butik {{ store_name }} er blevet verificeret',
        'store_unverified_title' => 'Butikverificering fjernet',
        'store_unverified_description' => 'Send besked når butikverificering fjernes',
        'store_unverified_subject' => 'Verificeringsstatus ændret for {{ store_name }}',
        'verified_by' => 'Verificeret af',
        'verified_at' => 'Verificeret den',
        'unverified_by' => 'Ophævet af',
        'unverified_at' => 'Ophævet den',
        'verification_note' => 'Verificeringsnotat',
        'store' => 'Butik',
        'order' => 'Ordre',
        'shipment' => 'Forsendelsesinfo',
        'address' => 'Leveringsadresse',
        'products' => 'Ordreprodukter',
        'customer_message' => 'Kundebesked',
        'customer_name' => 'Kundenavn',
        'customer_email' => 'Kunde-e-mail',
        'block_reason' => 'Årsag til blokering',
        'block_date' => 'Blokeringsdato',
        'unblock_date' => 'Ophævelsesdato',
    ],
    'email_templates' => [
        'dear_vendor' => 'Kære :vendor_name,',
        'dear_admin' => 'Kære administrator,',
        'hello' => 'Hej,',
        'happy_selling' => 'God fornøjelse med salget!',
        'email_sent_by_team' => 'Denne e-mail blev sendt af {{ site_title }}-teamet.',

        // Contact Store
        'contact_store_sent_from' => 'Denne e-mail blev sendt fra :customer_name (:customer_email) gennem din profilkontaktformular på :site_title.',
        'contact_store_reply_instruction' => 'Du kan svare direkte på denne e-mail for at svare :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Din sælgerkonto hos {{ site_title }} er blevet <strong>blokeret</strong> fra :block_date.',
        'vendor_account_blocked_reason' => 'Årsag til blokering: :block_reason',
        'vendor_account_blocked_contact_support' => 'Hvis du mener, dette er en fejl eller har spørgsmål, bedes du kontakte vores supportteam.',
        'vendor_account_unblocked_message' => 'Vi er glade for at informere dig om, at din sælgerkonto hos {{ site_title }} er blevet <strong>ophævet</strong> fra :unblock_date.',
        'vendor_account_unblocked_resume' => 'Du kan nu få adgang til din konto og genoptage dine aktiviteter.',
        'vendor_account_unblocked_questions' => 'Hvis du har spørgsmål, er du velkommen til at kontakte vores supportteam.',
        'vendor_account_approved_title' => 'Sælgerkonto godkendt',
        'vendor_account_approved_message' => 'Din konto er blevet godkendt til salg på vores websted <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Sælgerkonto afvist',
        'vendor_account_rejected_message' => 'Vi beklager at måtte informere dig om, at din konto ikke er blevet godkendt til salg på vores websted <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Ordre gennemført!',
        'store_new_order_message' => 'Du har modtaget en ny ordre på :site_title!',
        'customer_information' => 'Kundeoplysninger',
        'field_name' => 'Navn',
        'field_phone' => 'Telefon',
        'field_email' => 'E-mail',
        'field_address' => 'Adresse',
        'field_note' => 'Note',
        'order_number' => 'Ordrenummer',
        'order_date' => 'Ordredato',
        'shipping_method' => 'Forsendelsesmetode',
        'payment_method' => 'Betalingsmetode',

        // Product Approval
        'product_approved_title' => 'Produkt godkendt',
        'product_approved_message' => 'Dit produkt er blevet godkendt til salg på vores websted <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Afventende produktgodkendelse',
        'pending_product_approval_message' => 'Nyt produkt oprettet af :store_name <a href=":product_url">:product_name</a> venter på godkendelse.',

        // Verify Vendor
        'verify_vendor_title' => 'Verificer sælger',
        'verify_vendor_message' => 'Du har en ny sælger, der skal verificeres på :site_title!',
        'vendor_information' => 'Sælgeroplysninger',
        'shop_information' => 'Butiksoplysninger',
        'field_store_name' => 'Butiksnavn',
        'field_store_phone' => 'Butiktelefonnummer',
        'visit_store_button' => 'Besøg butik',

        // Withdrawal
        'withdrawal_approved_title' => 'Udbetaling godkendt',
        'withdrawal_approved_message' => 'Din udbetalingsanmodning er blevet godkendt, vi sender <strong>:withdrawal_amount</strong> til dine bankoplysninger snart.',

        // Order Cancellation
        'order_cancellation_title' => 'Kunde har annulleret ordre :order_id',
        'order_cancellation_message' => 'Kunde :customer_name har annulleret ordre <strong>:order_id</strong> på grund af årsag :cancellation_reason.',
        'order_items_header' => 'Her er hvad der blev bestilt:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Velkommen sælger',
        'welcome_vendor_greeting' => 'Vi er glade for at byde dig velkommen til :store_name!',
        'welcome_vendor_registration_complete' => 'Din sælgerregistrering er blevet gennemført, og du er nu en del af vores livlige fællesskab af sælgere.',
        'welcome_vendor_next_steps' => 'Her er, hvad du kan gøre næste:',
        'welcome_vendor_step_login' => 'Log ind på din sælgerkonto ved hjælp af dine loginoplysninger.',
        'welcome_vendor_step_add_products' => 'Tilføj dine produkter/tjenester til din butik. Sørg for at give detaljerede beskrivelser og fængende billeder for at tiltrække potentielle købere.',
        'welcome_vendor_support' => 'Hvis du har spørgsmål eller har brug for hjælp undervejs, er vores supportteam her for at hjælpe dig. Du er velkommen til at kontakte os!',
        'login_vendor_account_button' => 'Log ind på din sælgerkonto',
        'welcome_vendor_closing' => 'Vi er spændte på at se din butik blomstre på :site_title!',

        // Store Verification
        'store_verified_title' => 'Butikverificering godkendt',
        'store_verified_message' => 'Tillykke! Din butik er blevet verificeret på <strong>:site_title</strong>. Dette verificeringsmærke vil hjælpe med at opbygge tillid hos dine kunder.',
        'dear_store_owner' => 'Kære :store_name-ejer,',
        'verification_details' => 'Verificeringsoplysninger',
        'store_verified_benefits' => 'Fordele ved at være verificeret',
        'verified_badge_benefit' => 'Et verificeringsmærke vist på din butik',
        'increased_trust_benefit' => 'Øget kundetillid og troværdighed',
        'higher_visibility_benefit' => 'Højere synlighed i søgeresultater',
        'visit_your_store' => 'Besøg din butik',
        'congratulations_verified' => 'Tillykke med din verificering!',

        // Store Unverification
        'store_unverified_title' => 'Butikverificeringstatus ændret',
        'store_unverified_message' => 'Vi beklager at måtte informere dig om, at verificeringsstatussen for din butik på <strong>:site_title</strong> er blevet ændret.',
        'unverification_details' => 'Statusændringsoplysninger',
        'store_unverified_impacts' => 'Hvad dette betyder',
        'verified_badge_removed' => 'Verificeringsmærket er blevet fjernet fra din butik',
        'verification_benefits_lost' => 'Verificeringsfordele er ikke længere aktive',
        'store_unverified_next_steps' => 'Hvis du har spørgsmål til denne beslutning eller ønsker at diskutere genverificering, bedes du <strong>kontakte vores supportteam</strong>.',
        'contact_support' => 'Kontakt support',
        'thank_you_understanding' => 'Tak for din forståelse.',
    ],
    'current_balance' => 'Aktuel saldo',
    'settings' => [
        'title' => 'Indstillinger',
        'description' => 'Indstillinger for markedsplads',
        'fee_per_order' => 'Gebyr pr. ordre (%), anbefales: 2 eller 3',
        'default_commission_fee' => 'Standard kommissionsgebyr (%), anbefales: 2 eller 3',
        'enable_commission_fee_for_each_category' => 'Aktiver kommissionsgebyr for hver kategori?',
        'categories' => 'Kategorier',
        'select_categories' => 'Vælg kategorier..',
        'commission_fee' => 'Kommissionsgebyr (%)',
        'commission_fee_by_category' => 'Kommissionsgebyr efter kategori (%)',
        'fee_withdrawal_amount' => 'Udbetalingsgebyr',
        'withdrawal_fee_type' => 'Udbetalingsgebyrtype',
        'withdrawal_fee_types' => [
            'fixed' => 'Fast beløb',
            'percentage' => 'Procent',
        ],
        'check_valid_signature' => 'Kontroller gyldig signatur i sælgers indtjening',
        'verify_vendor' => 'Sælgerverificering (sælger kan kun offentliggøre deres produktliste efter verificering)',
        'verify_vendor_helper' => 'Hvis aktiveret, skal administratoren verificere sælgeren, før de kan offentliggøre deres produktliste.',
        'requires_vendor_documentations_verification' => 'Kræver sælgerdokumentationsverificering',
        'requires_vendor_documentations_verification_helper' => 'Hvis aktiveret, skal sælgere uploade deres dokumentationsfiler, når de ansøger om at blive sælger.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Skjul "Bliv sælger"-menu i kundepanel',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Hvis aktiveret, vil "Bliv sælger"-menuen blive skjult i kundepanelet.',
        'enable_product_approval' => 'Aktiver produktgodkendelse',
        'enable_product_approval_description' => 'Hvis aktiveret, skal administratoren godkende produktet, før det offentliggøres.',
        'hide_store_phone_number' => 'Skjul butiktelefonnummer?',
        'hide_store_email' => 'Skjul butik-e-mail?',
        'hide_store_address' => 'Skjul butiksadresse?',
        'hide_store_social_links' => 'Skjul sociale links til butik?',
        'enable_vendor_categories_filter' => 'Aktiver sælgerkategorifilter',
        'enable_vendor_categories_filter_description' => 'Vis kategorifilter på sælgers butiksside. Kun kategorier, der har sælgerprodukter, vil blive vist.',
        'allow_vendor_manage_shipping' => 'Tillad sælger at administrere forsendelse?',
        'allow_vendor_manage_shipping_description' => 'Hvis aktiveret, kan sælgeren ændre forsendelsesstatus for ordre til "leveres", "leveret", ...',
        'charge_shipping_per_vendor' => 'Opkræv forsendelse pr. sælger?',
        'charge_shipping_per_vendor_description' => 'Hvis aktiveret, vil forsendelse blive opkrævet separat for hver sælger. Hvis deaktiveret, vil forsendelse blive opkrævet én gang for hele ordren.',
        'commission_fee_each_category_fee_name' => 'Kommissionsgebyr for kommissionsindstilling :key',
        'commission_fee_each_category_name' => 'Kategorier for kommissionsindstilling :key',
        'add_new' => 'Tilføj ny',
        'payout_methods' => 'Udbetalingsmetoder',
        'max_upload_filesize' => 'Maks. uploadfilstørrelse (MB)',
        'max_upload_filesize_placeholder' => 'Standard: 10',
        'max_product_images_upload_by_vendor' => 'Maks. antal billeder pr. produkt',
        'enable_vendor_registration' => 'Aktiver sælgerregistrering',
        'enable_vendor_registration_helper' => 'Hvis aktiveret, kan sælgere registrere en konto på webstedet og offentliggøre deres produkter.',
        'minimum_withdrawal_amount' => 'Mindste udbetalingsbeløb (Fast)',
        'minimum_withdrawal_amount_helper' => 'Angiv det mindste beløb, en sælger kan hæve. Standard er 0.',
        'allow_vendor_delete_their_orders' => 'Tillad sælgere at slette deres ordrer',
        'allow_vendor_delete_their_orders_description' => 'Når aktiveret, kan sælgere administrere deres ordreliste ved at fjerne uønskede poster. Brug med forsigtighed, da slettede ordrer kan påvirke transaktionsregistre.',
        'enable_messaging_system' => 'Aktiver beskedsystem',
        'enable_messaging_system_description' => 'Hvis aktiveret, kan sælgere og kunder kommunikere med hinanden via beskedsystemet.',
        'term_and_privacy_policy_url' => 'Vilkår og privatlivspolitik URL',
        'show_vendor_registration_form_at_registration_page' => 'Vis sælgerregistreringsformular på registreringssiden',
        'show_vendor_registration_form_at_registration_page_description' => 'Hvis aktiveret, vil sælgerregistreringsformularen blive vist på registreringssiden.',
        'single_vendor_checkout' => 'Begræns til én sælger pr. ordre',
        'single_vendor_checkout_help' => 'Hvis aktiveret, kan kunder kun købe produkter fra én sælger pr. ordre.',
        'display_order_total_info_for_each_store' => 'Vis ordretotalinfo for hver butik',
        'display_order_total_info_for_each_store_helper' => 'Hvis aktiveret, vises ordretotaloplysningerne for hver butik i ordresammendraget.',
        'show_vendor_info_at_checkout' => 'Vis sælgeroplysninger ved betaling',
        'show_vendor_info_at_checkout_helper' => 'Hvis aktiveret, vises sælgeroplysninger (navn, logo, anmeldelser) på betalingssiden.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Mediefiltyper, der kan uploades af sælger',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Angiv de mediefiltyper, som sælgere kan uploade. Vælg dem på listen ovenfor.',
    ],
    'theme_options' => [
        'name' => 'Markedsplads',
        'description' => 'Temaindstillinger for markedsplads',
        'logo_vendor_dashboard' => 'Logo på sælgerpanelet (Standard er hovedlogoet)',
    ],
    'store_name' => 'Butiksnavn',
    'store_email' => 'Butik-e-mail',
    'store_phone' => 'Butiktelefon',
    'store_address' => 'Butiksadresse',
    'store_url' => 'Butik-URL',
    'product_name' => 'Produktnavn',
    'product_url' => 'Produkt-URL',
    'withdrawal_amount' => 'Udbetalingsbeløb',
    'helpers' => [
        'store_status' => 'Hvis du ændrer status til andet end ":status", vil denne butiks konto også ændre til ":customer"',
    ],
    'tables' => [
        'earnings' => 'Indtjening',
        'products_count' => 'Antal produkter',
    ],
    'vendors' => 'Sælgere',
    'payout_payment_methods' => [
        'bank_transfer' => 'Bankoverførsel',
        'paypal' => 'PayPal',
        'cash' => 'Kontant',
    ],
    'reports' => [
        'name' => 'Rapporter',
        'total_fee_earnings' => 'Samlet gebyrindtjening: :value',
        'total_fee' => 'Samlet gebyr',
        'total_amount' => 'Samlet beløb',
        'store_revenues' => 'Butiksindtægter',
        'sale_commissions' => 'Salgskommissioner',
        'fee' => 'Gebyr (:symbol)',
        'amount' => 'Beløb (:symbol)',
        'top_performing_stores' => 'Bedst præsterende butikker',
        'store_growth' => 'Butiksvækst',
        'withdrawal_status_chart' => 'Udbetalingsstatus',
        'product_distribution' => 'Produktfordeling efter butik',
        'average_commission' => 'Gennemsnitlig kommissionssats',
        'recent_withdrawals' => 'Seneste udbetalinger',
        'number_of_stores' => 'Antal butikker',
        'number_of_products' => 'Antal produkter',
        'orders' => 'Ordrer',
        'revenue' => 'Indtægt',
        'increase' => ':count stigning',
        'decrease' => ':count fald',
    ],
    'vendor' => 'Sælger',
    'vendor_name' => 'Sælgernavn',
    'contact_store' => [
        'form_name' => 'Kontakt butik-formular',
    ],
    'store_statuses' => [
        'pending' => 'Afventende',
        'published' => 'Godkendt',
        'blocked' => 'Blokeret',
    ],
    'view_vendor' => 'Se sælger :name',
    'vendor_information' => 'Sælgeroplysninger',
    'vendor_verified' => 'Sælger verificeret',
    'vendor_not_verified' => 'Sælger ikke verificeret',
    'vendor_verified_at' => 'Sælger verificeret den',
    'view_certificate' => 'Se certifikat',
    'view_government_id' => 'Se ID-kort',
    'documents' => 'Dokumenter',
    'store_products' => 'Butiksprodukter',
    'store_orders' => 'Butiksordrer',
    'total_revenue' => 'Samlet indtægt',
    'total_earnings' => 'Samlet indtjening',
    'pending_withdrawals' => 'Afventende udbetalinger',
    'balance' => 'Saldo',
    'recent_products' => 'Seneste produkter',
    'products_count' => 'Produkter',
    'store_status' => 'Butiksstatus',
    'verified' => 'Verificeret',
    'dashboard' => 'Dashboard',
    'products' => 'Produkter',
    'orders' => 'Ordrer',
    'coupons' => 'Kuponer',
    'withdrawals' => 'Udbetalinger',
    'revenues' => 'Indtægter',
    'messages' => 'Beskeder',
    'reviews' => 'Anmeldelser',
    'order_returns' => 'Ordrereturer',
    'shipments' => 'Forsendelser',
    'vendor_dashboard' => 'Sælgerpanel',
    'become_a_vendor' => 'Bliv sælger',
    'become_vendor' => 'Bliv sælger',
    'product_specification' => 'Produktspecifikation',
    'specification_groups' => 'Specifikationsgrupper',
    'specification_attributes' => 'Specifikationsattributter',
    'specification_tables' => 'Specifikationstabeller',
    'register_as' => 'Registrer som',
    'register' => 'Registrer',
    'i_am_customer' => 'Jeg er kunde',
    'i_am_vendor' => 'Jeg er sælger',
    'i_agree_to_terms' => 'Jeg accepterer :link',
    'i_agree_to_terms_simple' => 'Jeg accepterer vilkårene',
    'terms_and_privacy_policy' => 'Vilkår og privatlivspolitik',
    'send_message_successfully' => 'Besked sendt!',
    'cannot_send_message_to_own_store' => 'Du kan ikke sende en besked til din egen butik.',
    'vendor_account_not_verified' => 'Sælgerkonto er ikke verificeret.',
    'invalid_signature' => 'Ugyldig signatur af sælgeroplysninger',
    'file_not_found' => 'Fil ikke fundet!',
    'update_successfully' => 'Opdatering gennemført!',
    'shop_url_exists' => 'Butik-URL eksisterer allerede. Vælg venligst en anden!',
    'insufficient_balance' => 'Utilstrækkelig saldo eller ingen bankoplysninger',
    'total_amount_exceeds_balance' => 'Det samlede beløb (inkl. gebyr) overstiger din nuværende saldo',
    'registered_successfully' => 'Registrering gennemført!',
    'updated_registration_successfully' => 'Registreringsoplysninger opdateret!',
    'missing_documentations' => 'Manglende dokumentation! Upload venligst dit stiftelsesbevis og ID-kort for at fortsætte.',
    'only_add_products_from_same_store' => 'Du kan kun tilføje produkter fra samme butik til kurven.',
    'checkout_only_one_store' => 'Betaling er kun tilgængelig for produkter fra én butik ad gangen. Fjern venligst varer fra andre butikker før du fortsætter.',
    'coupon_code_invalid' => 'Kuponkoden er ugyldig eller gælder ikke for produkterne',
    'recovered_from_previous_orders' => 'Du har gendannet fra tidligere ordrer!',
    'not_available' => 'Ikke tilgængelig',
    'available' => 'Tilgængelig',
    'stores_seo_title' => 'SEO-titel for butiksliste',
    'stores_seo_description' => 'SEO-beskrivelse for butiksliste',
    'leave_empty_for_default' => 'Lad feltet være tomt for at bruge standardbeskrivelsen.',
    'stores' => 'Butikker',
    'total_products_found' => ':total produkter fundet',
    'language' => 'Sprog',
    'save_settings' => 'Gem indstillinger',
    'payout_info' => 'Udbetalingsoplysninger',
    'payment_method' => 'Betalingsmetode',
    'bank_name' => 'Banknavn',
    'bank_code_ifsc' => 'Bankkode/IFSC',
    'account_holder_name' => 'Kontoindehavers navn',
    'account_number' => 'Kontonummer',
    'upi_id' => 'UPI ID',
    'upi_id_helper' => 'Det er valgfrit. Hvis du har UPI ID, kan du angive det her. Læs mere: https://support.google.com/pay/india/answer/10331134?hl=en',
    'description' => 'Beskrivelse',
    'paypal_id' => 'PayPal ID',
    'pickup_location' => 'Afhentningssted',
    'pickup_location_helper' => 'Hvor vil du afhente din kontantudbetaling?',
    'contact_name' => 'Kontaktnavn',
    'contact_phone' => 'Kontakttelefon',
    'business_name' => 'Firmanavn',
    'tax_id' => 'CVR-nummer',
    'address' => 'Adresse',
    'earnings' => 'Indtjening',
    'our_stores' => 'Vores butikker',
    'quick_actions' => 'Hurtige handlinger',
    'add_product' => 'Tilføj produkt',
    'product' => 'Produkt',
    'create_discount' => 'Opret rabat',
    'store_settings' => 'Butiksindstillinger',
    'withdraw' => 'Udbetal',
    'store_performance' => 'Butikspræstation',
    'conversion_rate' => 'Konverteringsrate',
    'avg_order_value' => 'Gns. ordreværdi',
    'fulfillment_rate' => 'Opfyldelsesrate',
    'store_visibility' => 'Butikssyn lighed',
    'active' => 'Aktiv',
    'sales_reports' => 'Salgsrapporter',
    'revenues_in_label' => 'Indtægter i :label',
    'earnings_in_label' => 'Indtjening i :label',
    'fees' => 'Gebyrer',
    'congratulations_vendor' => 'Tillykke med at være sælger på :site_title',
    'attract_customers_message' => 'Tiltrækker dine kunder med de bedste produkter.',
    'create_new_product_here' => 'Opret et nyt produkt <a href=":url">her</a>',
    'no_orders_yet_message' => 'Du har :total produkt(er), men ingen ordrer endnu',
    'view_your_store_here' => 'Se din butik <a href=":url">her</a>',
    'includes_order_statuses' => 'Inkluderer status Afsluttet, Afventende og Behandler',
    'wait_for_approval' => 'Vent venligst på administratorens gennemgang og godkendelse!',
    'uploaded_certificate' => 'Uploadet certifikat',
    'uploaded_government_id' => 'Uploadet ID-kort',
    'store' => 'Butik',
    'tax_info' => 'Skatteoplysninger',
    'joined_on_date' => 'Tilmeldt den :date',
    'view_your_store' => 'Se din butik',
    'go_to_homepage' => 'Gå til startside',
    'recent_orders' => 'Seneste ordrer',
    'no_orders' => 'Ingen ordrer!',
    'view_full_orders' => 'Se alle ordrer',
    'customer_reviews' => 'Kundeanmeldelser',
    'no_reviews_yet' => 'Ingen anmeldelser endnu',
    'reviews_require_ecommerce' => 'Anmeldelsesfunktion kræver Ecommerce-plugin',
    'view_all_products' => 'Se alle produkter',
    'top_selling_products' => 'Bedst sælgende produkter',
    'no_products' => 'Ingen produkter!',
    'view_full_products' => 'Se alle produkter',
    'inventory_status' => 'Lagerstatus',
    'in_stock' => 'På lager',
    'low_stock' => 'Lavt lager',
    'out_of_stock' => 'Udsolgt',
    'add_new_product' => 'Tilføj nyt produkt',
];
