<?php

return [
    'name' => 'Mercado',
    'email' => [
        'title' => 'Mercado',
        'description' => 'Configurar plantillas de email para Mercado',
        'store_new_order_title' => 'Aviso sobre nuevo pedido',
        'store_new_order_description' => 'Enviar correo electrónico al propietario de la tienda cuando se realiza un pedido',
        'verify_vendor_title' => 'Verificar proveedor',
        'verify_vendor_description' => 'Enviar correo electrónico al administrador cuando un proveedor se registre',
        'pending_product_approval_title' => 'Pendiente de aprobación del producto',
        'pending_product_approval_description' => 'Enviar un correo electrónico al administrador cuando un proveedor publique sus productos.',
        'vendor_account_approved_title' => 'Cuenta de proveedor aprobada',
        'vendor_account_approved_description' => 'Enviar correo electrónico al proveedor cuando se apruebe su cuenta',
        'product_approved_title' => 'Producto aprobado',
        'product_approved_description' => 'Enviar correo electrónico al proveedor cuando su producto sea aprobado',
        'withdrawal_approved_title' => 'Retiro aprobado',
        'withdrawal_approved_description' => 'Enviar un correo electrónico al proveedor cuando se apruebe su solicitud de retiro',
        'vendor_account_rejected_title' => 'Cuenta de proveedor rechazada',
        'vendor_account_rejected_description' => 'Enviar correo electrónico al proveedor cuando su cuenta sea rechazada',
        'vendor_account_unblocked_title' => 'Cuenta de proveedor desbloqueada',
        'vendor_account_unblocked_description' => 'Enviar correo electrónico al proveedor cuando su cuenta sea desbloqueada',
        'vendor_account_blocked_title' => 'Cuenta de proveedor bloqueada',
        'vendor_account_blocked_description' => 'Enviar correo electrónico al proveedor cuando su cuenta sea bloqueada',
        'store_new_order_subject' => 'Nuevo(s) pedido(s) en {{ site_title }}',
        'verify_vendor_subject' => 'Nuevo proveedor en {{ site_title }} necesita ser verificado',
        'vendor_account_approved_subject' => 'Su cuenta ha sido aprobada para vender en {{ site_title }}',
        'vendor_account_rejected_subject' => 'Su cuenta ha sido rechazada para vender en {{ site_title }}',
        'pending_product_approval_subject' => 'Nuevo producto necesita ser aprobado para vender en {{ site_title }}',
        'product_approved_subject' => 'Su producto ha sido aprobado para vender en {{ site_title }}',
        'withdrawal_approved_subject' => 'Su solicitud de retiro ha sido aprobada',
        'welcome_vendor_title' => 'Bienvenido proveedor',
        'welcome_vendor_description' => 'Enviar correo electrónico al proveedor después del registro',
        'welcome_vendor_subject' => '¡Bienvenido a {{ site_title }}!',
        'contact_store_title' => 'Contactar Tienda',
        'contact_store_description' => 'Enviar correo electrónico al propietario de la tienda cuando un cliente contacte la tienda',
        'contact_store_subject' => 'Nuevo Mensaje de Contacto de Cliente',
        'vendor_account_blocked_subject' => 'Su cuenta de proveedor en {{ site_title }} ha sido bloqueada',
        'vendor_account_unblocked_subject' => 'Su cuenta de proveedor en {{ site_title }} ha sido desbloqueada',
        'order_cancellation_to_vendor_title' => 'Cancelación de pedido (se enviará al vendedor (proveedor)',
        'order_cancellation_to_vendor_description' => 'Enviar al vendedor (proveedor) cuando el cliente cancele un pedido',
        'order_cancellation_to_vendor_subject' => 'El pedido :order_id ha sido cancelado por el cliente',
        'store_verified_title' => 'Verificación de Tienda Aprobada',
        'store_verified_description' => 'Enviar notificación cuando la tienda sea verificada',
        'store_verified_subject' => 'Su tienda {{ store_name }} ha sido verificada',
        'store_unverified_title' => 'Verificación de Tienda Removida',
        'store_unverified_description' => 'Enviar notificación cuando se remueva la verificación de la tienda',
        'store_unverified_subject' => 'Estado de verificación cambiado para {{ store_name }}',
        'verified_by' => 'Verificado por',
        'verified_at' => 'Verificado en',
        'unverified_by' => 'No verificado por',
        'unverified_at' => 'No verificado en',
        'verification_note' => 'Nota de verificación',
        'store' => 'Tienda',
        'order' => 'Pedido',
        'shipment' => 'Información de envío',
        'address' => 'Dirección de envío',
        'products' => 'Productos del pedido',
        'customer_message' => 'Mensaje del cliente',
        'customer_name' => 'Nombre del cliente',
        'customer_email' => 'Email del cliente',
        'block_reason' => 'Razón del bloqueo',
        'block_date' => 'Fecha de bloqueo',
        'unblock_date' => 'Fecha de desbloqueo',
    ],
    'email_templates' => [
        'dear_vendor' => 'Estimado :vendor_name,',
        'dear_admin' => 'Estimado Administrador,',
        'hello' => 'Hola,',
        'happy_selling' => '¡Felices ventas!',
        'email_sent_by_team' => 'Este correo fue enviado por el equipo de {{ site_title }}.',
        'contact_store_sent_from' => 'Este correo fue enviado de :customer_name (:customer_email) a través del formulario de contacto de su perfil en :site_title.',
        'contact_store_reply_instruction' => 'Puede responder directamente a este correo para responder a :customer_name (:customer_email).',
        'vendor_account_blocked_message' => 'Su cuenta de proveedor en {{ site_title }} ha sido <strong>bloqueada</strong> desde :block_date.',
        'vendor_account_blocked_reason' => 'Razón del bloqueo: :block_reason',
        'vendor_account_blocked_contact_support' => 'Si cree que esto es un error o tiene alguna pregunta, por favor contacte a nuestro equipo de soporte.',
        'vendor_account_unblocked_message' => 'Nos complace informarle que su cuenta de proveedor en {{ site_title }} ha sido <strong>desbloqueada</strong> desde :unblock_date.',
        'vendor_account_unblocked_resume' => 'Ahora puede acceder a su cuenta y reanudar sus actividades.',
        'vendor_account_unblocked_questions' => 'Si tiene alguna pregunta, no dude en contactar a nuestro equipo de soporte.',
        'vendor_account_approved_title' => 'Cuenta de Proveedor Aprobada',
        'vendor_account_approved_message' => 'Su cuenta ha sido aprobada para vender en nuestro sitio <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Cuenta de Proveedor Rechazada',
        'vendor_account_rejected_message' => 'Lamentamos informarle que su cuenta no ha sido aprobada para vender en nuestro sitio <a href=":site_url">:site_url</a>.',
        'store_new_order_title' => '¡Pedido exitoso!',
        'store_new_order_message' => '¡Tienes un nuevo pedido en :site_title!',
        'customer_information' => 'Información del Cliente',
        'field_name' => 'Nombre',
        'field_phone' => 'Teléfono',
        'field_email' => 'Email',
        'field_address' => 'Dirección',
        'field_note' => 'Nota',
        'order_number' => 'Número de pedido',
        'order_date' => 'Fecha del pedido',
        'shipping_method' => 'Método de Envío',
        'payment_method' => 'Método de Pago',
        'product_approved_title' => 'Producto Aprobado',
        'product_approved_message' => 'Su producto ha sido aprobado para vender en nuestro sitio <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Pendiente de aprobación del producto',
        'pending_product_approval_message' => 'Nuevo producto fue creado por :store_name <a href=":product_url">:product_name</a> está esperando aprobación.',
        'verify_vendor_title' => 'Verificar Proveedor',
        'verify_vendor_message' => '¡Tienes un nuevo proveedor que necesita ser verificado en :site_title!',
        'vendor_information' => 'Información del Proveedor',
        'shop_information' => 'Información de la tienda',
        'field_store_name' => 'Nombre de la Tienda',
        'field_store_phone' => 'Número de Teléfono de la Tienda',
        'visit_store_button' => 'Visitar tienda',
        'withdrawal_approved_title' => 'Retiro Aprobado',
        'withdrawal_approved_message' => 'Su solicitud de pago ha sido aprobada, enviaremos <strong>:withdrawal_amount</strong> a su información bancaria próximamente.',
        'order_cancellation_title' => 'El cliente ha cancelado el pedido :order_id',
        'order_cancellation_message' => 'El cliente :customer_name ha cancelado el pedido <strong>:order_id</strong> debido a la razón :cancellation_reason.',
        'order_items_header' => 'Esto es lo que ordenó:',
        'welcome_vendor_title' => 'Bienvenido proveedor',
        'welcome_vendor_greeting' => '¡Estamos encantados de darte la bienvenida a :store_name!',
        'welcome_vendor_registration_complete' => 'Su registro de proveedor se ha completado exitosamente, y ahora es parte de nuestra vibrante comunidad de vendedores.',
        'welcome_vendor_next_steps' => 'Esto es lo que puede hacer a continuación:',
        'welcome_vendor_step_login' => 'Inicie sesión en su cuenta de proveedor usando sus credenciales.',
        'welcome_vendor_step_add_products' => 'Agregue sus productos/servicios a su tienda. Asegúrese de proporcionar descripciones detalladas e imágenes cautivadoras para atraer compradores potenciales.',
        'welcome_vendor_support' => 'Si tiene alguna pregunta o necesita asistencia en el camino, nuestro equipo de soporte está aquí para ayudarle. ¡No dude en contactarnos!',
        'login_vendor_account_button' => 'Iniciar sesión en su cuenta de proveedor',
        'welcome_vendor_closing' => '¡Estamos emocionados de ver su tienda florecer en :site_title!',
        'store_verified_title' => 'Verificación de Tienda Aprobada',
        'store_verified_message' => '¡Felicitaciones! Su tienda ha sido verificada exitosamente en <strong>:site_title</strong>. Esta insignia de verificación ayudará a construir confianza con sus clientes.',
        'dear_store_owner' => 'Estimado Propietario de :store_name,',
        'verification_details' => 'Detalles de Verificación',
        'store_verified_benefits' => 'Beneficios de estar verificado',
        'verified_badge_benefit' => 'Una insignia verificada mostrada en su tienda',
        'increased_trust_benefit' => 'Mayor confianza y confianza del cliente',
        'higher_visibility_benefit' => 'Mayor visibilidad en los resultados de búsqueda',
        'visit_your_store' => 'Visitar Su Tienda',
        'congratulations_verified' => '¡Felicitaciones por su verificación!',
        'store_unverified_title' => 'Estado de Verificación de Tienda Cambiado',
        'store_unverified_message' => 'Lamentamos informarle que el estado de verificación de su tienda en <strong>:site_title</strong> ha sido cambiado.',
        'unverification_details' => 'Detalles del Cambio de Estado',
        'store_unverified_impacts' => 'Lo que esto significa',
        'verified_badge_removed' => 'La insignia verificada ha sido removida de su tienda',
        'verification_benefits_lost' => 'Los beneficios de verificación ya no están activos',
        'store_unverified_next_steps' => 'Si tiene alguna pregunta sobre esta decisión o le gustaría discutir la re-verificación, por favor <strong>contacte a nuestro equipo de soporte</strong>.',
        'contact_support' => 'Contactar Soporte',
        'thank_you_understanding' => 'Gracias por su comprensión.',
    ],
    'current_balance' => 'Saldo actual',
    'settings' => [
        'title' => 'Configuraciones para el mercado',
        'description' => 'Tarifa de comisión de instalación',
        'fee_per_order' => 'Tarifa por pedido (%), sugerencia: 2 o 3',
        'default_commission_fee' => 'Tarifa de comisión predeterminada (%), sugerida: 2 o 3',
        'enable_commission_fee_for_each_category' => '¿Habilitar tarifa de comisión para cada categoría?',
        'categories' => 'Categorías',
        'select_categories' => 'Seleccione categorías..',
        'commission_fee' => 'Cuota de comisión (%)',
        'commission_fee_by_category' => 'Tarifa de comisión por categoría (%)',
        'check_valid_signature' => 'Verifique la firma válida en las ganancias del proveedor',
        'verify_vendor' => 'Verificación del proveedor (el proveedor simplemente puede publicar su lista de productos después de ser verificado)',
        'verify_vendor_helper' => 'Si está habilitado, el administrador debe verificar al proveedor antes de que pueda publicar su lista de productos.',
        'requires_vendor_documentations_verification' => 'Requiere verificación de documentación del proveedor',
        'requires_vendor_documentations_verification_helper' => 'Si está habilitado, los proveedores deben subir sus archivos de documentación al solicitar convertirse en proveedor.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Ocultar el menú de convertirse en proveedor en el panel del cliente',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Si está habilitado, el menú "Conviértete en proveedor" estará oculto en el panel del cliente.',
        'enable_product_approval' => 'Habilitar aprobación de producto',
        'enable_product_approval_description' => 'Si está habilitado, el administrador debe aprobar el producto antes de su publicación.',
        'hide_store_phone_number' => '¿Ocultar el número de teléfono de la tienda?',
        'hide_store_email' => '¿Ocultar el correo electrónico de la tienda?',
        'hide_store_address' => '¿Ocultar la dirección de la tienda?',
        'hide_store_social_links' => '¿Ocultar enlaces sociales de la tienda?',
        'allow_vendor_manage_shipping' => '¿Permitir que el proveedor gestione el envío?',
        'allow_vendor_manage_shipping_description' => 'Si está habilitado, el proveedor puede cambiar el estado de envío del pedido a "entregando", "entregado",...',
        'fee_withdrawal_amount' => 'Tarifa de retiro',
        'withdrawal_fee_type' => 'Tipo de tarifa de retiro',
        'withdrawal_fee_types' => [
            'fixed' => 'Monto fijo',
            'percentage' => 'Porcentaje',
        ],
        'commission_fee_each_category_fee_name' => 'Tarifa de comisión de configuración de comisión :key',
        'commission_fee_each_category_name' => 'Categorías de configuración de comisión :key',
        'add_new' => 'Agregar nuevo',
        'payout_methods' => 'Métodos de pago',
        'max_upload_filesize' => 'Tamaño máximo de carga (MB)',
        'max_upload_filesize_placeholder' => 'Predeterminado: 10',
        'max_product_images_upload_by_vendor' => 'Número máximo de imágenes para cada producto.',
        'enable_vendor_categories_filter' => 'Habilitar filtro de categorías de proveedor',
        'enable_vendor_categories_filter_description' => 'Mostrar filtro de categorías en la página de la tienda del proveedor. Solo se mostrarán las categorías que tengan productos del proveedor.',
        'charge_shipping_per_vendor' => '¿Cobrar envío por proveedor?',
        'charge_shipping_per_vendor_description' => 'Si está habilitado, el envío se cobrará por separado para cada proveedor. Si está deshabilitado, el envío se cobrará una vez para todo el pedido.',
        'enable_vendor_registration' => 'Habilitar el registro de proveedores',
        'enable_vendor_registration_helper' => 'Si está habilitado, los proveedores pueden registrar una cuenta en el sitio y publicar sus productos.',
        'minimum_withdrawal_amount' => 'Monto mínimo de retiro (fijo)',
        'minimum_withdrawal_amount_helper' => 'Especifique la cantidad mínima que un proveedor puede retirar. El valor predeterminado es 0.',
        'allow_vendor_delete_their_orders' => 'Permitir a los proveedores eliminar sus pedidos',
        'allow_vendor_delete_their_orders_description' => 'Cuando está habilitado, los proveedores pueden administrar su lista de pedidos eliminando entradas no deseadas. Úselo con precaución ya que los pedidos eliminados pueden afectar los registros de transacciones.',
        'enable_messaging_system' => 'Habilitar sistema de mensajería',
        'enable_messaging_system_description' => 'Si está habilitado, los proveedores y los clientes pueden comunicarse entre sí a través del sistema de mensajería.',
        'term_and_privacy_policy_url' => 'URL de términos y política de privacidad',
        'show_vendor_registration_form_at_registration_page' => 'Mostrar formulario de registro de proveedor en la página de registro',
        'show_vendor_registration_form_at_registration_page_description' => 'Si está habilitado, el formulario de registro de proveedor se mostrará en la página de registro.',
        'single_vendor_checkout' => 'Limitar a Un Proveedor por Pedido',
        'single_vendor_checkout_help' => 'Si está habilitado, los clientes solo pueden comprar productos de un proveedor por pedido.',
        'display_order_total_info_for_each_store' => 'Mostrar información total del pedido para cada tienda',
        'display_order_total_info_for_each_store_helper' => 'Si está habilitado, la información total del pedido se mostrará para cada tienda en el resumen del pedido.',
        'show_vendor_info_at_checkout' => 'Mostrar información del proveedor en el checkout',
        'show_vendor_info_at_checkout_helper' => 'Si está habilitado, la información del proveedor (nombre, logo, reseñas) se mostrará en la página de checkout.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Tipos de archivos multimedia que puede subir el proveedor',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Especifique los tipos de archivos multimedia que los proveedores pueden subir. Selecciónelos en la lista anterior.',
    ],
    'theme_options' => [
        'name' => 'Mercado',
        'description' => 'Opciones de tema para Marketplace',
        'logo_vendor_dashboard' => 'Logotipo en el panel del proveedor (el valor predeterminado es el logotipo principal)',
    ],
    'store_name' => 'Nombre de la tienda',
    'store_email' => 'Almacenar correo electrónico',
    'store_phone' => 'Teléfono de la tienda',
    'store_address' => 'Dirección de la tienda',
    'store_url' => 'URL de la tienda',
    'product_name' => 'Nombre del producto',
    'product_url' => 'URL del producto',
    'withdrawal_amount' => 'Cantidad de retiro',
    'helpers' => [
        'store_status' => 'Si cambia el estado que no sea ":status", la cuenta de esta tienda también cambiará a ":cliente".',
    ],
    'tables' => [
        'earnings' => 'Ganancias',
        'products_count' => 'Recuento de productos',
    ],
    'vendors' => 'Vendedores',
    'payout_payment_methods' => [
        'bank_transfer' => 'Transferencia bancaria',
        'paypal' => 'PayPal',
        'cash' => 'Efectivo',
    ],
    'reports' => [
        'name' => 'Informes',
        'total_fee_earnings' => 'Ganancias totales por comisiones: :value',
        'total_fee' => 'Costo total',
        'total_amount' => 'Cantidad total',
        'store_revenues' => 'Ingresos de la tienda',
        'sale_commissions' => 'Comisiones de venta',
        'fee' => 'Tarifa (:símbolo)',
        'amount' => 'Cantidad (:symbol)',
        'top_performing_stores' => 'Tiendas de Mejor Rendimiento',
        'store_growth' => 'Crecimiento de Tienda',
        'withdrawal_status_chart' => 'Estado de Retiros',
        'product_distribution' => 'Distribución de Productos por Tienda',
        'average_commission' => 'Tasa de Comisión Promedio',
        'recent_withdrawals' => 'Retiros Recientes',
        'number_of_stores' => 'Número de Tiendas',
        'number_of_products' => 'Número de Productos',
        'orders' => 'Pedidos',
        'revenue' => 'Ingresos',
        'increase' => ':count aumento',
        'decrease' => ':count disminución',
    ],
    'vendor' => 'Proveedor',
    'vendor_name' => 'Nombre del vendedor',
    'contact_store' => [
        'form_name' => 'Formulario de contacto de la tienda',
    ],
    'store_statuses' => [
        'pending' => 'Pendiente',
        'published' => 'Aprobado',
        'blocked' => 'Bloqueado',
    ],
    'view_vendor' => 'Ver proveedor :name',
    'vendor_information' => 'Información del Proveedor',
    'vendor_verified' => 'Proveedor Verificado',
    'vendor_not_verified' => 'Proveedor No Verificado',
    'vendor_verified_at' => 'Proveedor Verificado En',
    'view_certificate' => 'Ver Certificado',
    'view_government_id' => 'Ver ID Gubernamental',
    'documents' => 'Documentos',
    'store_products' => 'Productos de la Tienda',
    'store_orders' => 'Pedidos de la Tienda',
    'total_revenue' => 'Ingresos Totales',
    'total_earnings' => 'Ganancias Totales',
    'pending_withdrawals' => 'Retiros Pendientes',
    'balance' => 'Saldo',
    'recent_products' => 'Productos Recientes',
    'products_count' => 'Productos',
    'store_status' => 'Estado de la Tienda',
    'verified' => 'Verificado',
    'dashboard' => 'Panel',
    'products' => 'Productos',
    'orders' => 'Pedidos',
    'coupons' => 'Cupones',
    'withdrawals' => 'Retiros',
    'revenues' => 'Ingresos',
    'messages' => 'Mensajes',
    'reviews' => 'Reseñas',
    'order_returns' => 'Devoluciones',
    'shipments' => 'Envíos',
    'vendor_dashboard' => 'Panel del vendedor',
    'become_a_vendor' => 'Conviértete en vendedor',
    'become_vendor' => 'Conviértete en vendedor',
    'product_specification' => 'Especificación del producto',
    'specification_groups' => 'Grupos de especificaciones',
    'specification_attributes' => 'Atributos de especificación',
    'specification_tables' => 'Tablas de especificaciones',
    'register_as' => 'Registrarse como',
    'register' => 'Registrarse',
    'i_am_customer' => 'Soy cliente',
    'i_am_vendor' => 'Soy vendedor',
    'i_agree_to_terms' => 'Acepto :link',
    'i_agree_to_terms_simple' => 'Acepto los términos y condiciones',
    'terms_and_privacy_policy' => 'Términos y política de privacidad',
    'send_message_successfully' => '¡Mensaje enviado correctamente!',
    'cannot_send_message_to_own_store' => 'No puedes enviar un mensaje a tu propia tienda.',
    'vendor_account_not_verified' => 'La cuenta del vendedor no está verificada.',
    'invalid_signature' => 'Firma inválida de la información del vendedor',
    'file_not_found' => '¡Archivo no encontrado!',
    'update_successfully' => '¡Actualizado correctamente!',
    'shop_url_exists' => 'La URL de la tienda ya existe. ¡Por favor elige otra!',
    'insufficient_balance' => 'Saldo insuficiente o falta información bancaria',
    'total_amount_exceeds_balance' => 'El monto total (incluida la comisión) excede su saldo actual',
    'registered_successfully' => '¡Registrado correctamente!',
    'updated_registration_successfully' => '¡Información de registro actualizada correctamente!',
    'missing_documentations' => '¡Faltan documentos! Por favor cargue su certificado de incorporación e identificación gubernamental para continuar.',
    'only_add_products_from_same_store' => 'Solo puedes agregar productos de la misma tienda al carrito.',
    'checkout_only_one_store' => 'El pago solo está disponible para productos de una tienda a la vez. Por favor elimine artículos de otras tiendas antes de continuar.',
    'coupon_code_invalid' => 'El código del cupón no es válido o no se aplica a los productos',
    'recovered_from_previous_orders' => '¡Has recuperado de pedidos anteriores!',
    'not_available' => 'No disponible',
    'available' => 'Disponible',
    'stores_seo_title' => 'Título SEO de la página de listado de tiendas',
    'stores_seo_description' => 'Descripción SEO de la página de listado de tiendas',
    'leave_empty_for_default' => 'Déjelo vacío para usar la descripción predeterminada.',
    'stores' => 'Tiendas',
    'total_products_found' => ':total productos encontrados',
    'language' => 'Idioma',
    'save_settings' => 'Guardar configuración',
    'payout_info' => 'Información de pago',
    'payment_method' => 'Método de pago',
    'bank_name' => 'Nombre del banco',
    'bank_code_ifsc' => 'Código bancario/IFSC',
    'account_holder_name' => 'Nombre del titular de la cuenta',
    'account_number' => 'Número de cuenta',
    'upi_id' => 'ID de UPI',
    'upi_id_helper' => 'Es opcional. Si tiene una ID de UPI, puede proporcionarla aquí. Más información: https://support.google.com/pay/india/answer/10331134?hl=en',
    'description' => 'Descripción',
    'paypal_id' => 'ID de PayPal',
    'pickup_location' => 'Ubicación de recogida',
    'pickup_location_helper' => '¿Dónde le gustaría recoger su pago en efectivo?',
    'contact_name' => 'Nombre de contacto',
    'contact_phone' => 'Teléfono de contacto',
    'business_name' => 'Nombre del negocio',
    'tax_id' => 'ID fiscal',
    'address' => 'Dirección',
    'earnings' => 'Ganancias',
    'our_stores' => 'Nuestras tiendas',
    'quick_actions' => 'Acciones rápidas',
    'add_product' => 'Añadir producto',
    'product' => 'Producto',
    'create_discount' => 'Crear descuento',
    'store_settings' => 'Configuración de tienda',
    'withdraw' => 'Retirar',
    'store_performance' => 'Rendimiento de la tienda',
    'conversion_rate' => 'Tasa de conversión',
    'avg_order_value' => 'Valor promedio del pedido',
    'fulfillment_rate' => 'Tasa de cumplimiento',
    'store_visibility' => 'Visibilidad de la tienda',
    'active' => 'Activo',
    'sales_reports' => 'Informes de ventas',
    'revenues_in_label' => 'Ingresos en :label',
    'earnings_in_label' => 'Ganancias en :label',
    'fees' => 'Tarifas',
    'congratulations_vendor' => 'Felicitaciones por ser un vendedor en :site_title',
    'attract_customers_message' => 'Atrae a tus clientes con los mejores productos.',
    'create_new_product_here' => 'Crea un nuevo producto <a href=":url">aquí</a>',
    'no_orders_yet_message' => 'Tienes :total producto(s) pero aún no hay pedidos',
    'view_your_store_here' => 'Ver tu tienda <a href=":url">aquí</a>',
    'includes_order_statuses' => 'Incluye estados Completado, Pendiente y En proceso',
    'wait_for_approval' => '¡Por favor espera a que el administrador revise y apruebe!',
    'uploaded_certificate' => 'Certificado cargado',
    'uploaded_government_id' => 'ID gubernamental cargado',
    'store' => 'Tienda',
    'tax_info' => 'Información fiscal',
    'joined_on_date' => 'Se unió el :date',
    'view_your_store' => 'Ver tu tienda',
    'go_to_homepage' => 'Ir a la página de inicio',
    'recent_orders' => 'Pedidos recientes',
    'no_orders' => '¡No hay pedidos!',
    'view_full_orders' => 'Ver todos los pedidos',
    'customer_reviews' => 'Reseñas de clientes',
    'no_reviews_yet' => 'Aún no hay reseñas',
    'reviews_require_ecommerce' => 'La función de reseñas requiere el plugin de Ecommerce',
    'view_all_products' => 'Ver todos los productos',
    'top_selling_products' => 'Productos más vendidos',
    'no_products' => '¡No hay productos!',
    'view_full_products' => 'Ver todos los productos',
    'inventory_status' => 'Estado del inventario',
    'in_stock' => 'En stock',
    'low_stock' => 'Stock bajo',
    'out_of_stock' => 'Agotado',
    'add_new_product' => 'Añadir nuevo producto',
];
