<?php

return [
    'name' => 'Marché',
    'description' => 'Module multi-vendeurs pour gérer les boutiques, commandes et retraits.',
    'hello' => 'Bonjour',
    'email' => [
        'title' => 'Marché',
        'description' => 'Configurer les modèles d\'email pour le Marché',
        'store_new_order_title' => 'Avis de nouvelle commande',
        'store_new_order_description' => 'Envoyer un email au propriétaire du magasin lorsqu\'une commande est passée',
        'verify_vendor_title' => 'Vérifier le fournisseur',
        'verify_vendor_description' => 'Envoyer un email à l\'administrateur quand un fournisseur s\'enregistre',
        'pending_product_approval_title' => 'Approbation de produit en attente',
        'pending_product_approval_description' => 'Envoyer un email à l\'administrateur quand un fournisseur publie ses produits',
        'vendor_account_approved_title' => 'Compte fournisseur approuvé',
        'vendor_account_approved_description' => 'Envoyer un email au fournisseur quand son compte est approuvé',
        'product_approved_title' => 'Produit approuvé',
        'product_approved_description' => 'Envoyer un email au fournisseur quand son produit est approuvé',
        'withdrawal_approved_title' => 'Retrait approuvé',
        'withdrawal_approved_description' => 'Envoyer un email au fournisseur quand sa demande de retrait est approuvée',
        'vendor_account_rejected_title' => 'Compte fournisseur rejeté',
        'vendor_account_rejected_description' => 'Envoyer un email au fournisseur quand son compte est rejeté',
        'vendor_account_unblocked_title' => 'Compte fournisseur débloqué',
        'vendor_account_unblocked_description' => 'Envoyer un email au fournisseur quand son compte est débloqué',
        'vendor_account_blocked_title' => 'Compte fournisseur bloqué',
        'vendor_account_blocked_description' => 'Envoyer un email au fournisseur quand son compte est bloqué',
        'store_new_order_subject' => 'Nouvelle(s) commande(s) sur {{ site_title }}',
        'verify_vendor_subject' => 'Nouveau fournisseur sur {{ site_title }} doit être vérifié',
        'vendor_account_approved_subject' => 'Votre compte a été approuvé pour vendre sur {{ site_title }}',
        'vendor_account_rejected_subject' => 'Votre compte a été rejeté pour vendre sur {{ site_title }}',
        'pending_product_approval_subject' => 'Nouveau produit doit être approuvé pour vendre sur {{ site_title }}',
        'product_approved_subject' => 'Votre produit a été approuvé pour vendre sur {{ site_title }}',
        'withdrawal_approved_subject' => 'Votre demande de retrait a été approuvée',
        'welcome_vendor_title' => 'Bienvenue fournisseur',
        'welcome_vendor_description' => 'Envoyer un email au fournisseur après l\'inscription',
        'welcome_vendor_subject' => 'Bienvenue sur {{ site_title }} !',
        'contact_store_title' => 'Contacter le Magasin',
        'contact_store_description' => 'Envoyer un email au propriétaire du magasin quand un client contacte le magasin',
        'contact_store_subject' => 'Nouveau Message de Contact Client',
        'vendor_account_blocked_subject' => 'Votre compte fournisseur sur {{ site_title }} a été bloqué',
        'vendor_account_unblocked_subject' => 'Votre compte fournisseur sur {{ site_title }} a été débloqué',
        'order_cancellation_to_vendor_title' => 'Annulation de commande (sera envoyé au vendeur (fournisseur)',
        'order_cancellation_to_vendor_description' => 'Envoyer au vendeur (fournisseur) quand le client annule une commande',
        'order_cancellation_to_vendor_subject' => 'La commande :order_id a été annulée par le client',
        'store_verified_title' => 'Vérification du Magasin Approuvée',
        'store_verified_description' => 'Envoyer une notification quand le magasin est vérifié',
        'store_verified_subject' => 'Votre magasin {{ store_name }} a été vérifié',
        'store_unverified_title' => 'Vérification du Magasin Supprimée',
        'store_unverified_description' => 'Envoyer une notification quand la vérification du magasin est supprimée',
        'store_unverified_subject' => 'Statut de vérification changé pour {{ store_name }}',
        'verified_by' => 'Vérifié par',
        'verified_at' => 'Vérifié le',
        'unverified_by' => 'Non vérifié par',
        'unverified_at' => 'Non vérifié le',
        'verification_note' => 'Note de vérification',
        'store' => 'Magasin',
        'order' => 'Commande',
        'shipment' => 'Informations d\'expédition',
        'address' => 'Adresse d\'expédition',
        'products' => 'Produits de la commande',
        'customer_message' => 'Message du client',
        'customer_name' => 'Nom du client',
        'customer_email' => 'Email du client',
        'block_reason' => 'Raison du blocage',
        'block_date' => 'Date de blocage',
        'unblock_date' => 'Date de déblocage',
    ],
    'email_templates' => [
        'dear_vendor' => 'Cher :vendor_name,',
        'dear_admin' => 'Cher Administrateur,',
        'hello' => 'Bonjour,',
        'happy_selling' => 'Bonnes ventes !',
        'email_sent_by_team' => 'Ce email a été envoyé par l\'équipe {{ site_title }}.',
        'contact_store_sent_from' => 'Ce email a été envoyé de :customer_name (:customer_email) via le formulaire de contact de votre profil sur :site_title.',
        'contact_store_reply_instruction' => 'Vous pouvez répondre directement à cet email pour répondre à :customer_name (:customer_email).',
        'vendor_account_blocked_message' => 'Votre compte fournisseur sur {{ site_title }} a été <strong>bloqué</strong> depuis :block_date.',
        'vendor_account_blocked_reason' => 'Raison du blocage : :block_reason',
        'vendor_account_blocked_contact_support' => 'Si vous pensez que c\'est une erreur ou avez des questions, veuillez contacter notre équipe de support.',
        'vendor_account_unblocked_message' => 'Nous avons le plaisir de vous informer que votre compte fournisseur sur {{ site_title }} a été <strong>débloqué</strong> depuis :unblock_date.',
        'vendor_account_unblocked_resume' => 'Vous pouvez maintenant accéder à votre compte et reprendre vos activités.',
        'vendor_account_unblocked_questions' => 'Si vous avez des questions, n\'hésitez pas à contacter notre équipe de support.',
        'vendor_account_approved_title' => 'Compte Fournisseur Approuvé',
        'vendor_account_approved_message' => 'Votre compte a été approuvé pour vendre sur notre site <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Compte Fournisseur Rejeté',
        'vendor_account_rejected_message' => 'Nous regrettons de vous informer que votre compte n\'a pas été approuvé pour vendre sur notre site <a href=":site_url">:site_url</a>.',
        'store_new_order_title' => 'Commande réussie !',
        'store_new_order_message' => 'Vous avez une nouvelle commande sur :site_title !',
        'customer_information' => 'Informations Client',
        'field_name' => 'Nom',
        'field_phone' => 'Téléphone',
        'field_email' => 'Email',
        'field_address' => 'Adresse',
        'field_note' => 'Note',
        'order_number' => 'Numéro de commande',
        'order_date' => 'Date de commande',
        'shipping_method' => 'Méthode d\'Expédition',
        'payment_method' => 'Méthode de Paiement',
        'product_approved_title' => 'Produit Approuvé',
        'product_approved_message' => 'Votre produit a été approuvé pour vendre sur notre site <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Approbation de produit en attente',
        'pending_product_approval_message' => 'Nouveau produit a été créé par :store_name <a href=":product_url">:product_name</a> en attente d\'approbation.',
        'verify_vendor_title' => 'Vérifier le Fournisseur',
        'verify_vendor_message' => 'Vous avez un nouveau fournisseur qui doit être vérifié sur :site_title !',
        'vendor_information' => 'Informations du Fournisseur',
        'shop_information' => 'Informations du magasin',
        'field_store_name' => 'Nom du Magasin',
        'field_store_phone' => 'Numéro de Téléphone du Magasin',
        'visit_store_button' => 'Visiter le magasin',
        'withdrawal_approved_title' => 'Retrait Approuvé',
        'withdrawal_approved_message' => 'Votre demande de paiement a été approuvée, nous enverrons <strong>:withdrawal_amount</strong> à vos informations bancaires prochainement.',
        'order_cancellation_title' => 'Le client a annulé la commande :order_id',
        'order_cancellation_message' => 'Le client :customer_name a annulé la commande <strong>:order_id</strong> pour la raison :cancellation_reason.',
        'order_items_header' => 'Voici ce qui a été commandé :',
        'welcome_vendor_title' => 'Bienvenue fournisseur',
        'welcome_vendor_greeting' => 'Nous sommes ravis de vous accueillir dans :store_name !',
        'welcome_vendor_registration_complete' => 'Votre inscription de fournisseur a été terminée avec succès, et vous faites maintenant partie de notre communauté dynamique de vendeurs.',
        'welcome_vendor_next_steps' => 'Voici ce que vous pouvez faire ensuite :',
        'welcome_vendor_step_login' => 'Connectez-vous à votre compte fournisseur en utilisant vos identifiants.',
        'welcome_vendor_step_add_products' => 'Ajoutez vos produits/services à votre magasin. Assurez-vous de fournir des descriptions détaillées et des images captivantes pour attirer les acheteurs potentiels.',
        'welcome_vendor_support' => 'Si vous avez des questions ou besoin d\'assistance en cours de route, notre équipe de support est là pour vous aider. N\'hésitez pas à nous contacter !',
        'login_vendor_account_button' => 'Se connecter à votre compte fournisseur',
        'welcome_vendor_closing' => 'Nous sommes impatients de voir votre magasin prospérer sur :site_title !',
        'store_verified_title' => 'Vérification du Magasin Approuvée',
        'store_verified_message' => 'Félicitations ! Votre magasin a été vérifié avec succès sur <strong>:site_title</strong>. Ce badge de vérification aidera à établir la confiance avec vos clients.',
        'dear_store_owner' => 'Cher Propriétaire de :store_name,',
        'verification_details' => 'Détails de Vérification',
        'store_verified_benefits' => 'Avantages d\'être vérifié',
        'verified_badge_benefit' => 'Un badge vérifié affiché sur votre magasin',
        'increased_trust_benefit' => 'Confiance et assurance client accrues',
        'higher_visibility_benefit' => 'Visibilité plus élevée dans les résultats de recherche',
        'visit_your_store' => 'Visitez Votre Magasin',
        'congratulations_verified' => 'Félicitations pour votre vérification !',
        'store_unverified_title' => 'Statut de Vérification du Magasin Changé',
        'store_unverified_message' => 'Nous regrettons de vous informer que le statut de vérification de votre magasin sur <strong>:site_title</strong> a été changé.',
        'unverification_details' => 'Détails du Changement de Statut',
        'store_unverified_impacts' => 'Ce que cela signifie',
        'verified_badge_removed' => 'Le badge vérifié a été supprimé de votre magasin',
        'verification_benefits_lost' => 'Les avantages de vérification ne sont plus actifs',
        'store_unverified_next_steps' => 'Si vous avez des questions sur cette décision ou souhaitez discuter de la re-vérification, veuillez <strong>contacter notre équipe de support</strong>.',
        'contact_support' => 'Contacter le Support',
        'thank_you_understanding' => 'Merci pour votre compréhension.',
    ],
    'current_balance' => 'Solde actuel',
    'settings' => [
        'title' => 'Paramètres',
        'description' => 'Paramètres pour le marché',
        'fee_per_order' => 'Frais par commande (%), suggestion : 2 ou 3',
        'default_commission_fee' => 'Frais de commission par défaut (%), suggestion : 2 ou 3',
        'enable_commission_fee_for_each_category' => 'Activer les frais de commission pour chaque catégorie ?',
        'categories' => 'Catégories',
        'select_categories' => 'Sélectionner les catégories..',
        'commission_fee' => 'Frais de commission (%)',
        'commission_fee_by_category' => 'Frais de commission par catégorie (%)',
        'fee_withdrawal_amount' => 'Frais de retrait',
        'withdrawal_fee_type' => 'Type de frais de retrait',
        'withdrawal_fee_types' => [
            'fixed' => 'Montant fixe',
            'percentage' => 'Pourcentage',
        ],
        'check_valid_signature' => 'Vérifier la signature valide dans les gains du fournisseur',
        'verify_vendor' => 'Vérification du fournisseur (Le fournisseur ne peut publier sa liste de produits qu\'après avoir été vérifié)',
        'verify_vendor_helper' => 'Si activé, l\'administrateur doit vérifier le fournisseur avant qu\'il puisse publier sa liste de produits.',
        'requires_vendor_documentations_verification' => 'Nécessite la vérification des documents du fournisseur',
        'requires_vendor_documentations_verification_helper' => 'Si activé, les fournisseurs doivent télécharger leurs fichiers de documentation lorsqu\'ils postulent pour devenir fournisseur.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Masquer le menu Devenir fournisseur dans le tableau de bord client',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'S\'il est activé, le menu « Devenir fournisseur » sera masqué dans le tableau de bord client.',
        'enable_product_approval' => 'Activer l\'approbation des produits',
        'enable_product_approval_description' => 'Si cette option est activée, l\'administrateur doit approuver le produit avant sa publication.',
        'hide_store_phone_number' => 'Masquer le numéro de téléphone du magasin ?',
        'hide_store_email' => 'Masquer l\'e-mail du magasin ?',
        'hide_store_address' => 'Masquer l\'adresse du magasin ?',
        'hide_store_social_links' => 'Masquer les liens sociaux du magasin ?',
        'enable_vendor_categories_filter' => 'Activer le filtre des catégories de fournisseurs',
        'enable_vendor_categories_filter_description' => 'Afficher le filtre des catégories sur la page du magasin du fournisseur. Seules les catégories qui ont des produits du fournisseur seront affichées.',
        'allow_vendor_manage_shipping' => 'Permettre au fournisseur de gérer l\'expédition ?',
        'allow_vendor_manage_shipping_description' => 'S\'il est activé, le vendeur peut changer le statut d\'expédition de la commande en "livraison", "livrée", ...',
        'charge_shipping_per_vendor' => 'Facturer l\'expédition par fournisseur ?',
        'charge_shipping_per_vendor_description' => 'Si activé, l\'expédition sera facturée séparément pour chaque fournisseur. Si désactivé, l\'expédition sera facturée une fois pour toute la commande.',
        'commission_fee_each_category_fee_name' => 'Frais de commission du paramètre de commission :key',
        'commission_fee_each_category_name' => 'Catégories du paramètre de commission :key',
        'add_new' => 'Ajouter nouveau',
        'payout_methods' => 'Méthodes de paiement',
        'max_upload_filesize' => 'Taille maximale du fichier de téléchargement (Mo)',
        'max_upload_filesize_placeholder' => 'Par défaut : 10',
        'max_product_images_upload_by_vendor' => 'Nombre maximum d\'images pour chaque produit',
        'enable_vendor_registration' => 'Activer l\'enregistrement du fournisseur',
        'enable_vendor_registration_helper' => 'Si activé, les fournisseurs peuvent enregistrer un compte sur le site et publier leurs produits.',
        'minimum_withdrawal_amount' => 'Montant minimum de retrait (fixe)',
        'minimum_withdrawal_amount_helper' => 'Spécifiez le montant minimum qu\'un fournisseur peut retirer. La valeur par défaut est 0.',
        'allow_vendor_delete_their_orders' => 'Autoriser les fournisseurs à supprimer leurs commandes',
        'allow_vendor_delete_their_orders_description' => 'Lorsqu\'il est activé, les fournisseurs peuvent gérer leur liste de commandes en supprimant les entrées indésirables. À utiliser avec prudence car les commandes supprimées peuvent avoir un impact sur les enregistrements de transactions.',
        'enable_messaging_system' => 'Activer le système de messagerie',
        'enable_messaging_system_description' => 'Si cette option est activée, les fournisseurs et les clients peuvent communiquer entre eux via le système de messagerie.',
        'term_and_privacy_policy_url' => 'URL des conditions et politique de confidentialité',
        'show_vendor_registration_form_at_registration_page' => 'Afficher le formulaire d\'inscription du fournisseur sur la page d\'inscription',
        'show_vendor_registration_form_at_registration_page_description' => 'Si activé, le formulaire d\'inscription du fournisseur sera affiché sur la page d\'inscription.',
        'single_vendor_checkout' => 'Limiter à Un Fournisseur par Commande',
        'single_vendor_checkout_help' => 'Si activé, les clients ne peuvent acheter des produits que d\'un seul fournisseur par commande.',
        'display_order_total_info_for_each_store' => 'Afficher les informations du total de commande pour chaque magasin',
        'display_order_total_info_for_each_store_helper' => 'Si activé, les informations du total de commande seront affichées pour chaque magasin dans le résumé de commande.',
        'show_vendor_info_at_checkout' => 'Afficher les informations du fournisseur au checkout',
        'show_vendor_info_at_checkout_helper' => 'Si activé, les informations du fournisseur (nom, logo, avis) seront affichées sur la page de checkout.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Types de fichiers multimédias pouvant être téléchargés par le fournisseur',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Spécifiez les types de fichiers multimédias que les fournisseurs peuvent télécharger. Sélectionnez-les dans la liste ci-dessus.',
    ],
    'theme_options' => [
        'name' => 'Marché',
        'description' => 'Options de thème pour le Marché',
        'logo_vendor_dashboard' => 'Logo dans le tableau de bord du fournisseur (Par défaut est le logo principal)',
    ],
    'store_name' => 'Nom du magasin',
    'store_email' => 'Email du magasin',
    'store_phone' => 'Téléphone du magasin',
    'store_address' => 'Adresse du magasin',
    'store_url' => 'URL du magasin',
    'product_name' => 'Nom du produit',
    'product_url' => 'URL du produit',
    'withdrawal_amount' => 'Montant de retrait',
    'helpers' => [
        'store_status' => 'Si vous changez le statut autre que ":status", le compte de ce magasin changera aussi en ":customer"',
    ],
    'tables' => [
        'earnings' => 'Montant des gains',
        'products_count' => 'Nombre de produits',
        'show' => 'Afficher',
        'date' => 'Date (JJ/MM/AAAA)',
    ],
    'vendors' => 'Fournisseurs',
    'payout_payment_methods' => [
        'bank_transfer' => 'Virement bancaire',
        'paypal' => 'PayPal',
        'cash' => 'Espèces',
    ],
    'reports' => [
        'name' => 'Rapports',
        'total_fee_earnings' => 'Total des gains de frais : :value',
        'total_fee' => 'Frais total',
        'total_amount' => 'Montant total',
        'store_revenues' => 'Revenus du magasin',
        'sale_commissions' => 'Commissions de vente',
        'fee' => 'Frais (:symbol)',
        'amount' => 'Montant (:symbol)',
        'top_performing_stores' => 'Magasins les Plus Performants',
        'store_growth' => 'Croissance du Magasin',
        'withdrawal_status_chart' => 'Statut des Retraits',
        'product_distribution' => 'Distribution des Produits par Magasin',
        'average_commission' => 'Taux de Commission Moyen',
        'recent_withdrawals' => 'Retraits Récents',
        'number_of_stores' => 'Nombre de Magasins',
        'number_of_products' => 'Nombre de Produits',
        'orders' => 'Commandes',
        'revenue' => 'Revenus',
        'increase' => ':count augmentation',
        'decrease' => ':count diminution',
    ],
    'vendor' => 'Fournisseur',
    'vendor_name' => 'Nom du fournisseur',
    'contact_store' => [
        'form_name' => 'Formulaire de contact du magasin',
    ],
    'store_statuses' => [
        'pending' => 'En attente',
        'published' => 'Approuvé',
        'blocked' => 'Bloqué',
    ],
    'forms' => [
        'back' => 'Retour',
        'drop_files_here_or_click_to_upload' => 'Déposez les fichiers ici ou cliquez pour téléverser',
        'check' => 'Vérifier',
        'error' => 'Erreur',
        'confirm_delete_image' => 'Êtes-vous sûr de vouloir supprimer cette image ?',
        'character_remain' => 'caractères restants',
    ],
    'view_vendor' => 'Voir le fournisseur :name',
    'vendor_information' => 'Informations du Fournisseur',
    'vendor_verified' => 'Fournisseur Vérifié',
    'vendor_not_verified' => 'Fournisseur Non Vérifié',
    'vendor_verified_at' => 'Fournisseur Vérifié Le',
    'view_certificate' => 'Voir le Certificat',
    'view_government_id' => 'Voir l\'ID Gouvernemental',
    'certificate_of_incorporation' => 'Certificat d\'incorporation',
    'drop_certificate_here' => 'Déposez le certificat d\'incorporation ici ou cliquez pour téléverser',
    'government_id' => 'Pièce d\'identité gouvernementale',
    'drop_government_id_here' => 'Déposez la pièce d\'identité gouvernementale ici ou cliquez pour téléverser',
    'documents' => 'Pièces justificatives',
    'store_products' => 'Produits du Magasin',
    'store_orders' => 'Commandes du Magasin',
    'total_revenue' => 'Revenus Totaux',
    'total_earnings' => 'Gains Totaux',
    'pending_withdrawals' => 'Retraits en Attente',
    'balance' => 'Solde',
    'recent_products' => 'Produits Récents',
    'products_count' => 'Produits',
    'store_status' => 'Statut du Magasin',
    'verified' => 'Vérifié',
    'dashboard' => 'Tableau de bord',
    'products' => 'Produits',
    'orders' => 'Commandes',
    'coupons' => 'Coupons',
    'withdrawals' => 'Retraits',
    'revenues' => 'Revenus',
    'messages' => 'Messages',
    'reviews' => 'Avis',
    'order_returns' => 'Retours de commande',
    'shipments' => 'Expéditions',
    'vendor_dashboard' => 'Tableau de bord du vendeur',
    'become_a_vendor' => 'Devenir vendeur',
    'become_vendor' => 'Devenir vendeur',
    'product_specification' => 'Spécification du produit',
    'specification_groups' => 'Groupes de spécifications',
    'specification_attributes' => 'Attributs de spécification',
    'specification_tables' => 'Tables de spécifications',
    'register_as' => 'S\'inscrire en tant que',
    'register' => 'S\'inscrire',
    'i_am_customer' => 'Je suis un client',
    'i_am_vendor' => 'Je suis un vendeur',
    'i_agree_to_terms' => 'J\'accepte :link',
    'i_agree_to_terms_simple' => 'J\'accepte les conditions générales',
    'terms_and_privacy_policy' => 'Conditions générales et politique de confidentialité',
    'send_message_successfully' => 'Message envoyé avec succès!',
    'cannot_send_message_to_own_store' => 'Vous ne pouvez pas envoyer de message à votre propre boutique.',
    'vendor_account_not_verified' => 'Le compte du vendeur n\'est pas vérifié.',
    'invalid_signature' => 'Signature invalide des informations du vendeur',
    'file_not_found' => 'Fichier introuvable!',
    'notices' => [
        'file_not_found' => 'Le fichier est introuvable.',
    ],
    'update_successfully' => 'Mis à jour avec succès!',
    'shop_url_exists' => 'L\'URL de la boutique existe déjà. Veuillez en choisir une autre!',
    'insufficient_balance' => 'Solde insuffisant ou informations bancaires manquantes',
    'total_amount_exceeds_balance' => 'Le montant total (frais inclus) dépasse votre solde actuel',
    'registered_successfully' => 'Enregistré avec succès!',
    'updated_registration_successfully' => 'Informations d\'inscription mises à jour avec succès!',
    'updated_registration_info_successfully' => 'Informations d\'inscription mises à jour avec succès!',
    'missing_documentations' => 'Documents manquants! Veuillez télécharger votre certificat d\'incorporation et votre pièce d\'identité gouvernementale pour continuer.',
    'only_add_products_from_same_store' => 'Vous ne pouvez ajouter que des produits de la même boutique au panier.',
    'checkout_only_one_store' => 'Le paiement n\'est disponible que pour les produits d\'une seule boutique à la fois. Veuillez retirer les articles des autres boutiques avant de continuer.',
    'coupon_code_invalid' => 'Le code du coupon n\'est pas valide ou ne s\'applique pas aux produits',
    'recovered_from_previous_orders' => 'Vous avez récupéré des commandes précédentes!',
    'not_available' => 'Non disponible',
    'available' => 'Disponible',
    'stores_seo_title' => 'Titre SEO de la page de liste des boutiques',
    'stores_seo_description' => 'Description SEO de la page de liste des boutiques',
    'leave_empty_for_default' => 'Laissez vide pour utiliser la description par défaut.',
    'stores' => 'Boutiques',
    'total_products_found' => ':total produits trouvés',
    'language' => 'Langue',
    'save_settings' => 'Enregistrer les paramètres',
    'payout_info' => 'Informations de paiement',
    'payment_method' => 'Méthode de paiement',
    'bank_name' => 'Nom de la banque',
    'bank_code_ifsc' => 'Code bancaire/IFSC',
    'account_holder_name' => 'Nom du titulaire du compte',
    'account_number' => 'Numéro de compte',
    'upi_id' => 'ID UPI',
    'upi_id_helper' => 'C\'est facultatif. Si vous avez un ID UPI, vous pouvez le fournir ici. En savoir plus : https://support.google.com/pay/india/answer/10331134?hl=en',
    'description' => 'Description détaillée',
    'paypal_id' => 'ID PayPal',
    'pickup_location' => 'Lieu de collecte',
    'pickup_location_helper' => 'Où souhaitez-vous récupérer votre paiement en espèces?',
    'contact_name' => 'Nom du contact',
    'contact_phone' => 'Téléphone du contact',
    'business_name' => 'Nom de l\'entreprise',
    'tax_id' => 'Numéro fiscal',
    'address' => 'Adresse',
    'earnings' => 'Gains',
    'our_stores' => 'Nos boutiques',
    'quick_actions' => 'Actions rapides',
    'add_product' => 'Ajouter un produit',
    'product' => 'Produit',
    'create_discount' => 'Créer une réduction',
    'store_settings' => 'Paramètres de la boutique',
    'withdraw' => 'Retirer',
    'store_performance' => 'Performance de la boutique',
    'conversion_rate' => 'Taux de conversion',
    'avg_order_value' => 'Valeur moyenne de commande',
    'fulfillment_rate' => 'Taux de réalisation',
    'store_visibility' => 'Visibilité de la boutique',
    'active' => 'Actif',
    'sales_reports' => 'Rapports de ventes',
    'revenues_in_label' => 'Revenus dans :label',
    'earnings_in_label' => 'Gains dans :label',
    'fees' => 'Frais',
    'congratulations_vendor' => 'Félicitations pour être un vendeur sur :site_title',
    'attract_customers_message' => 'Attirez vos clients avec les meilleurs produits.',
    'create_new_product_here' => 'Créez un nouveau produit <a href=":url">ici</a>',
    'no_orders_yet_message' => 'Vous avez :total produit(s) mais aucune commande pour le moment',
    'view_your_store_here' => 'Voir votre boutique <a href=":url">ici</a>',
    'includes_order_statuses' => 'Inclut les statuts Complété, En attente et En traitement',
    'wait_for_approval' => 'Veuillez attendre que l\'administrateur examine et approuve !',
    'uploaded_certificate' => 'Certificat téléchargé',
    'uploaded_government_id' => 'Pièce d\'identité téléchargée',
    'store' => 'Boutique',
    'tax_info' => 'Informations fiscales',
    'joined_on_date' => 'Rejoint le :date',
    'view_your_store' => 'Voir votre boutique',
    'go_to_homepage' => 'Aller à la page d\'accueil',
    'recent_orders' => 'Commandes récentes',
    'no_orders' => 'Aucune commande !',
    'view_full_orders' => 'Voir toutes les commandes',
    'customer_reviews' => 'Avis des clients',
    'no_reviews_yet' => 'Pas encore d\'avis',
    'reviews_require_ecommerce' => 'La fonctionnalité d\'avis nécessite le plugin Ecommerce',
    'view_all_products' => 'Voir tous les produits',
    'top_selling_products' => 'Produits les plus vendus',
    'no_products' => 'Aucun produit !',
    'view_full_products' => 'Voir tous les produits',
    'inventory_status' => 'État des stocks',
    'in_stock' => 'En stock',
    'low_stock' => 'Stock faible',
    'out_of_stock' => 'Rupture de stock',
    'add_new_product' => 'Ajouter un nouveau produit',
];
