<?php

return [
    'name' => '市場',
    'email' => [
        'title' => '市場',
        'description' => 'マーケットプレイス用のメールテンプレートを設定',
        'store_new_order_title' => '新規ご注文に関するお知らせ',
        'store_new_order_description' => '注文時にストアオーナーにメールを送信',
        'verify_vendor_title' => 'ベンダーの確認',
        'verify_vendor_description' => 'ベンダーが登録するときに管理者に電子メールを送信する',
        'pending_product_approval_title' => '製品承認待ち',
        'pending_product_approval_description' => 'ベンダーが製品を投稿したときに管理者にメールを送信する',
        'vendor_account_approved_title' => 'ベンダーアカウントが承認されました',
        'vendor_account_approved_description' => 'アカウントが承認されたらベンダーに電子メールを送信する',
        'product_approved_title' => '製品承認済み',
        'product_approved_description' => '製品が承認されたらベンダーに電子メールを送信する',
        'withdrawal_approved_title' => '出金が承認されました',
        'withdrawal_approved_description' => '出金リクエストが承認されたらベンダーに電子メールを送信する',
        'vendor_account_rejected_title' => 'ベンダーアカウントが拒否されました',
        'vendor_account_rejected_description' => 'アカウントが拒否された場合にベンダーにメールを送信する',
        'vendor_account_unblocked_title' => 'ベンダーアカウントのブロックが解除されました',
        'vendor_account_unblocked_description' => 'アカウントのブロックが解除されたときにベンダーにメールを送信する',
        'vendor_account_blocked_title' => 'ベンダーアカウントがブロックされました',
        'vendor_account_blocked_description' => 'アカウントがブロックされた場合にベンダーにメールを送信する',
        'store_new_order_subject' => '{{ site_title }} での新しい注文',
        'verify_vendor_subject' => '{{ site_title }} の新しいベンダーを確認する必要があります',
        'vendor_account_approved_subject' => 'あなたのアカウントは {{ site_title }} での販売が承認されました',
        'vendor_account_rejected_subject' => 'あなたのアカウントは {{ site_title }} での販売を拒否されました',
        'pending_product_approval_subject' => '新しい商品を {{ site_title }} で販売するには承認が必要です',
        'product_approved_subject' => 'あなたの商品は {{ site_title }} での販売が承認されました',
        'withdrawal_approved_subject' => '出金リクエストが承認されました',
        'welcome_vendor_title' => 'ようこそベンダー',
        'welcome_vendor_description' => '登録後にベンダーにメールを送信する',
        'welcome_vendor_subject' => '{{ site_title }} へようこそ!',
        'contact_store_title' => 'ストアに問い合わせる',
        'contact_store_description' => '顧客がストアに連絡したときにストアのオーナーにメールを送信する',
        'contact_store_subject' => '新規顧客連絡先メッセージ',
        'vendor_account_blocked_subject' => '{{ site_title }} のベンダー アカウントがブロックされました',
        'vendor_account_unblocked_subject' => '{{ site_title }} のベンダー アカウントのブロックが解除されました',
        'order_cancellation_to_vendor_title' => '注文キャンセル（販売者（ベンダー）に送信されます）',
        'order_cancellation_to_vendor_description' => '顧客が注文をキャンセルしたときに販売者（ベンダー）に送信',
        'order_cancellation_to_vendor_subject' => '注文 :order_id が顧客によってキャンセルされました',
        'store_verified_title' => 'ストア認証承認',
        'store_verified_description' => 'ストアが認証されたときに通知を送信',
        'store_verified_subject' => 'あなたのストア {{ store_name }} が認証されました',
        'store_unverified_title' => 'ストア認証削除',
        'store_unverified_description' => 'ストア認証が削除されたときに通知を送信',
        'store_unverified_subject' => '{{ store_name }} の認証ステータスが変更されました',
        'verified_by' => '認証者',
        'verified_at' => '認証日時',
        'unverified_by' => '認証解除者',
        'unverified_at' => '認証解除日時',
        'verification_note' => '認証メモ',
        'store' => '店',
        'order' => '注文',
        'shipment' => '出荷情報',
        'address' => 'お届け先の住所',
        'products' => '注文商品',
        'customer_message' => 'お客様からのメッセージ',
        'customer_name' => '顧客名',
        'customer_email' => '顧客の電子メール',
        'block_reason' => 'ブロックの理由',
        'block_date' => 'ブロックした日付',
        'unblock_date' => 'ブロックを解除した日',
    ],
    'email_templates' => [
        'dear_vendor' => ':vendor_name様',
        'dear_admin' => '管理者様',
        'hello' => 'こんにちは、',
        'happy_selling' => 'ハッピーセリング！',
        'email_sent_by_team' => 'このメールは{{ site_title }}チームから送信されました。',

        // Contact Store
        'contact_store_sent_from' => 'このメールは:customer_name (:customer_email)から:site_titleのプロフィール連絡フォーム経由で送信されました。',
        'contact_store_reply_instruction' => 'このメールに直接返信して:customer_name (:customer_email)に返答できます。',

        // Vendor Account Status
        'vendor_account_blocked_message' => '{{ site_title }}でのベンダーアカウントが:block_dateから<strong>ブロック</strong>されました。',
        'vendor_account_blocked_reason' => 'ブロック理由: :block_reason',
        'vendor_account_blocked_contact_support' => 'これが間違いだと思われる場合や質問がある場合は、サポートチームにお問い合わせください。',
        'vendor_account_unblocked_message' => '{{ site_title }}でのベンダーアカウントが:unblock_dateから<strong>ブロック解除</strong>されたことをお知らせいたします。',
        'vendor_account_unblocked_resume' => 'アカウントにアクセスして活動を再開できます。',
        'vendor_account_unblocked_questions' => 'ご質問がございましたら、お気軽にサポートチームにお問い合わせください。',
        'vendor_account_approved_title' => 'ベンダーアカウント承認',
        'vendor_account_approved_message' => 'あなたのアカウントは私たちのサイト<a href=":site_url">:site_url</a>での販売が承認されました。',
        'vendor_account_rejected_title' => 'ベンダーアカウント拒否',
        'vendor_account_rejected_message' => '申し訳ございませんが、あなたのアカウントは私たちのサイト<a href=":site_url">:site_url</a>での販売が承認されませんでした。',

        // Store New Order
        'store_new_order_title' => '注文成功！',
        'store_new_order_message' => ':site_titleで新しい注文を受けました！',
        'customer_information' => '顧客情報',
        'field_name' => '名前',
        'field_phone' => '電話',
        'field_email' => 'メール',
        'field_address' => '住所',
        'field_note' => 'メモ',
        'order_number' => '注文番号',
        'order_date' => '注文日',
        'shipping_method' => '配送方法',
        'payment_method' => '支払い方法',

        // Product Approval
        'product_approved_title' => '製品承認',
        'product_approved_message' => 'あなたの製品は私たちのサイト<a href=":site_url">:site_url</a>での販売が承認されました。',
        'pending_product_approval_title' => '製品承認待ち',
        'pending_product_approval_message' => ':store_nameによって作成された新しい製品<a href=":product_url">:product_name</a>が承認待ちです。',

        // Verify Vendor
        'verify_vendor_title' => 'ベンダー認証',
        'verify_vendor_message' => ':site_titleで認証が必要な新しいベンダーがいます！',
        'vendor_information' => 'ベンダー情報',
        'shop_information' => 'ショップ情報',
        'field_store_name' => 'ストア名',
        'field_store_phone' => 'ストア電話番号',
        'visit_store_button' => 'ストアを訪問',

        // Withdrawal
        'withdrawal_approved_title' => '出金承認',
        'withdrawal_approved_message' => 'あなたの支払いリクエストが承認されました。<strong>:withdrawal_amount</strong>をあなたの銀行情報に間もなく送金いたします。',

        // Order Cancellation
        'order_cancellation_title' => '顧客が注文:order_idをキャンセルしました',
        'order_cancellation_message' => '顧客:customer_nameが注文<strong>:order_id</strong>を理由:cancellation_reasonによりキャンセルしました。',
        'order_items_header' => 'ご注文内容:',

        // Welcome Vendor
        'welcome_vendor_title' => 'ベンダーをお迎えします',
        'welcome_vendor_greeting' => ':store_nameへようこそ！',
        'welcome_vendor_registration_complete' => 'ベンダー登録が正常に完了し、あなたは私たちの活気ある販売者コミュニティの一員になりました。',
        'welcome_vendor_next_steps' => '次にできることは以下の通りです：',
        'welcome_vendor_step_login' => '認証情報を使ってベンダーアカウントにログイン。',
        'welcome_vendor_step_add_products' => '製品/サービスをストアに追加。潜在的な購入者を惹きつけるために、詳細な説明と魅力的な画像を提供してください。',
        'welcome_vendor_support' => '質問がある場合やサポートが必要な場合は、サポートチームがお手伝いします。お気軽にお問い合わせください！',
        'login_vendor_account_button' => 'ベンダーアカウントにログイン',
        'welcome_vendor_closing' => ':site_titleでのあなたのストアの繁栄を楽しみにしています！',

        // Store Verification
        'store_verified_title' => 'ストア認証承認',
        'store_verified_message' => 'おめでとうございます！あなたのストアは<strong>:site_title</strong>で正常に認証されました。この認証バッジは顧客との信頼構築に役立ちます。',
        'dear_store_owner' => ':store_nameオーナー様',
        'verification_details' => '認証詳細',
        'store_verified_benefits' => '認証されることの利点',
        'verified_badge_benefit' => 'ストアに表示される認証バッジ',
        'increased_trust_benefit' => '顧客の信頼と安心感の向上',
        'higher_visibility_benefit' => '検索結果での高い視認性',
        'visit_your_store' => 'あなたのストアを訪問',
        'congratulations_verified' => '認証おめでとうございます！',

        // Store Unverification
        'store_unverified_title' => 'ストア認証ステータス変更',
        'store_unverified_message' => '申し訳ございませんが、<strong>:site_title</strong>でのあなたのストアの認証ステータスが変更されました。',
        'unverification_details' => 'ステータス変更詳細',
        'store_unverified_impacts' => 'これが意味すること',
        'verified_badge_removed' => '認証バッジがストアから削除されました',
        'verification_benefits_lost' => '認証の利点はもはや有効ではありません',
        'store_unverified_next_steps' => 'この決定について質問がある場合や再認証について話し合いたい場合は、<strong>サポートチームにお問い合わせ</strong>ください。',
        'contact_support' => 'サポートに連絡',
        'thank_you_understanding' => 'ご理解いただきありがとうございます。',
    ],
    'current_balance' => '現在の残高',
    'settings' => [
        'title' => '設定',
        'description' => 'マーケットプレイスの設定',
        'fee_per_order' => '注文ごとの手数料 (%)、推奨: 2 または 3',
        'default_commission_fee' => 'デフォルトの手数料 (%)、推奨: 2 または 3',
        'enable_commission_fee_for_each_category' => 'カテゴリごとに手数料を有効にしますか?',
        'categories' => 'カテゴリー',
        'select_categories' => 'カテゴリを選択してください。',
        'commission_fee' => '手数料(%)',
        'commission_fee_by_category' => 'カテゴリ別手数料 (%)',
        'fee_withdrawal_amount' => '出金手数料',
        'withdrawal_fee_type' => '出金手数料タイプ',
        'withdrawal_fee_types' => [
            'fixed' => '固定金額',
            'percentage' => 'パーセンテージ',
        ],
        'check_valid_signature' => 'ベンダーの収益で有効な署名を確認する',
        'verify_vendor' => 'ベンダーの検証 (ベンダーは検証を受けた後に製品リストを投稿することができます)',
        'verify_vendor_helper' => '有効にした場合、管理者は製品リストを投稿する前にベンダーを確認する必要があります。',
        'requires_vendor_documentations_verification' => 'ベンダーのドキュメントの検証が必要',
        'requires_vendor_documentations_verification_helper' => '有効にすると、ベンダーはベンダーになる申請時にドキュメント ファイルをアップロードする必要があります。',
        'hide_become_vendor_menu_in_customer_dashboard' => '顧客ダッシュボードでベンダーになるメニューを非表示にする',
        'hide_become_vendor_menu_in_customer_dashboard_description' => '有効にすると、「ベンダーになる」メニューが顧客ダッシュボードに非表示になります。',
        'enable_product_approval' => '製品の承認を有効にする',
        'enable_product_approval_description' => '有効にした場合、管理者は製品を公開する前に承認する必要があります。',
        'hide_store_phone_number' => '店舗の電話番号を非表示にしますか?',
        'hide_store_email' => 'ストアのメールを非表示にしますか?',
        'hide_store_address' => '店舗の住所を非表示にしますか?',
        'hide_store_social_links' => 'ストアのソーシャルリンクを非表示にしますか?',
        'enable_vendor_categories_filter' => 'ベンダーカテゴリフィルターを有効にする',
        'enable_vendor_categories_filter_description' => 'ベンダーストアページにカテゴリフィルターを表示します。ベンダー製品があるカテゴリのみが表示されます。',
        'allow_vendor_manage_shipping' => 'ベンダーによる配送管理を許可しますか?',
        'allow_vendor_manage_shipping_description' => '有効にすると、ベンダーは注文の出荷ステータスを「配達中」、「配達済み」などに変更できます。',
        'charge_shipping_per_vendor' => 'ベンダーごとに配送料を請求しますか？',
        'charge_shipping_per_vendor_description' => '有効にすると、各ベンダーに対して個別に配送料が請求されます。無効にすると、注文全体に対して一度だけ配送料が請求されます。',
        'commission_fee_each_category_fee_name' => 'コミッション設定 :key のコミッション手数料',
        'commission_fee_each_category_name' => 'コミッション設定 :key のカテゴリ',
        'add_new' => '新規追加',
        'payout_methods' => '支払い方法',
        'max_upload_filesize' => '最大アップロードファイルサイズ (MB)',
        'max_upload_filesize_placeholder' => 'デフォルト: 10',
        'max_product_images_upload_by_vendor' => '各商品の画像の最大数',
        'enable_vendor_registration' => 'ベンダー登録を有効にする',
        'enable_vendor_registration_helper' => '有効にすると、ベンダーはサイトにアカウントを登録して製品を投稿できます。',
        'minimum_withdrawal_amount' => '最低出金額（固定）',
        'minimum_withdrawal_amount_helper' => 'ベンダーが引き出すことができる最低金額を指定します。デフォルトは 0 です。',
        'allow_vendor_delete_their_orders' => 'ベンダーが注文を削除できるようにする',
        'allow_vendor_delete_their_orders_description' => '有効にすると、ベンダーは不要なエントリを削除して注文リストを管理できます。削除された注文は取引記録に影響を与える可能性があるため、慎重に使用してください。',
        'enable_messaging_system' => 'メッセージング システムを有効にする',
        'enable_messaging_system_description' => '有効にすると、ベンダーと顧客はメッセージング システムを介して相互に通信できるようになります。',
        'term_and_privacy_policy_url' => '規約とプライバシーポリシーのURL',
        'show_vendor_registration_form_at_registration_page' => '登録ページでベンダー登録フォームを表示する',
        'show_vendor_registration_form_at_registration_page_description' => '有効にすると、ベンダー登録フォームが登録ページに表示されます。',
        'single_vendor_checkout' => '注文ごとに 1 つのベンダーに制限',
        'single_vendor_checkout_help' => '有効にすると、顧客は注文ごとに 1 つのベンダーからのみ製品を購入できます。',
        'display_order_total_info_for_each_store' => '各ストアの注文合計情報を表示',
        'display_order_total_info_for_each_store_helper' => '有効にすると、注文サマリーで各ストアの注文合計情報が表示されます。',
        'show_vendor_info_at_checkout' => 'チェックアウト時にベンダー情報を表示',
        'show_vendor_info_at_checkout_helper' => '有効にすると、チェックアウトページでベンダー情報（名前、ロゴ、レビュー）が表示されます。',
        'media_file_types_can_be_uploaded_by_vendor' => 'ベンダーがアップロードできるメディアファイルタイプ',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'ベンダーがアップロードできるメディアファイルタイプを指定します。上記のリストで選択してください。',
    ],
    'theme_options' => [
        'name' => '市場',
        'description' => 'マーケットプレイスのテーマオプション',
        'logo_vendor_dashboard' => 'ベンダー ダッシュボードのロゴ (デフォルトはメイン ロゴ)',
    ],
    'store_name' => '店名',
    'store_email' => 'ストアメール',
    'store_phone' => '店舗電話',
    'store_address' => '店舗住所',
    'store_url' => 'ストアURL',
    'product_name' => '製品名',
    'product_url' => '製品URL',
    'withdrawal_amount' => '出金額',
    'helpers' => [
        'store_status' => '「:status」以外のステータスを変更すると、このストアのアカウントも「:customer」に変更されます。',
    ],
    'tables' => [
        'earnings' => '収益',
        'products_count' => '製品数',
    ],
    'vendors' => 'ベンダー',
    'payout_payment_methods' => [
        'bank_transfer' => '銀行振込',
        'paypal' => 'PayPal',
        'cash' => '現金',
    ],
    'reports' => [
        'name' => 'レポート',
        'total_fee_earnings' => '合計手数料収益: :value',
        'total_fee' => '合計料金',
        'total_amount' => '合計金額',
        'store_revenues' => '店舗収益',
        'sale_commissions' => '販売手数料',
        'fee' => '料金(:symbol)',
        'amount' => '金額(:symbol)',
        'top_performing_stores' => 'トップパフォーマンスストア',
        'store_growth' => 'ストア成長',
        'withdrawal_status_chart' => '出金ステータス',
        'product_distribution' => 'ストア別製品分布',
        'average_commission' => '平均コミッション率',
        'recent_withdrawals' => '最近の出金',
        'number_of_stores' => 'ストア数',
        'number_of_products' => '製品数',
        'orders' => '注文',
        'revenue' => '売上',
        'increase' => ':count 増加',
        'decrease' => ':count 減少',
    ],
    'vendor' => 'ベンダー',
    'vendor_name' => 'ベンダー名',
    'contact_store' => [
        'form_name' => 'ストアへのお問い合わせフォーム',
    ],
    'store_statuses' => [
        'pending' => '保留中',
        'published' => '承認された',
        'blocked' => 'ブロックされました',
    ],
    'view_vendor' => 'ベンダー :name を表示',
    'vendor_information' => 'ベンダー情報',
    'vendor_verified' => 'ベンダー認証済み',
    'vendor_not_verified' => 'ベンダー未認証',
    'vendor_verified_at' => 'ベンダー認証日',
    'view_certificate' => '証明書を表示',
    'view_government_id' => '政府IDを表示',
    'documents' => '書類',
    'store_products' => 'ストア製品',
    'store_orders' => 'ストア注文',
    'total_revenue' => '総売上',
    'total_earnings' => '総収益',
    'pending_withdrawals' => '保留中の出金',
    'balance' => '残高',
    'recent_products' => '最近の製品',
    'products_count' => '製品',
    'store_status' => 'ストアステータス',
    'verified' => '認証済み',
    'dashboard' => 'ダッシュボード',
    'products' => '製品',
    'orders' => '注文',
    'coupons' => 'クーポン',
    'withdrawals' => '出金',
    'revenues' => '収益',
    'messages' => 'メッセージ',
    'reviews' => 'レビュー',
    'order_returns' => '注文返品',
    'shipments' => '配送',
    'vendor_dashboard' => 'ベンダーダッシュボード',
    'become_a_vendor' => 'ベンダーになる',
    'become_vendor' => 'ベンダーになる',
    'product_specification' => '製品仕様',
    'specification_groups' => '仕様グループ',
    'specification_attributes' => '仕様属性',
    'specification_tables' => '仕様表',
    'register_as' => '登録区分',
    'register' => '登録',
    'i_am_customer' => '私は顧客です',
    'i_am_vendor' => '私はベンダーです',
    'i_agree_to_terms' => ':linkに同意します',
    'i_agree_to_terms_simple' => '利用規約に同意します',
    'terms_and_privacy_policy' => '利用規約とプライバシーポリシー',
    'send_message_successfully' => 'メッセージが送信されました！',
    'cannot_send_message_to_own_store' => '自分のストアにメッセージを送信することはできません。',
    'vendor_account_not_verified' => 'ベンダーアカウントが認証されていません。',
    'invalid_signature' => 'ベンダー情報の署名が無効です',
    'file_not_found' => 'ファイルが見つかりません！',
    'update_successfully' => '更新が成功しました！',
    'shop_url_exists' => 'ショップURLが既に存在します。別のものを選択してください！',
    'insufficient_balance' => '残高不足または銀行情報がありません',
    'total_amount_exceeds_balance' => '合計金額（手数料を含む）が現在の残高を超えています',
    'registered_successfully' => '登録が成功しました！',
    'updated_registration_successfully' => '登録情報が更新されました！',
    'missing_documentations' => '書類が不足しています！続行するには、登記証明書と身分証明書をアップロードしてください。',
    'only_add_products_from_same_store' => 'カートに追加できるのは同じストアの製品のみです。',
    'checkout_only_one_store' => 'チェックアウトは一度に1つのストアの製品のみ利用可能です。続行する前に他のストアの商品を削除してください。',
    'coupon_code_invalid' => 'クーポンコードが無効であるか、製品に適用されません',
    'recovered_from_previous_orders' => '以前の注文から復元しました！',
    'not_available' => '利用不可',
    'available' => '利用可能',
    'stores_seo_title' => 'ストアリストページのSEOタイトル',
    'stores_seo_description' => 'ストアリストページのSEO説明',
    'leave_empty_for_default' => 'デフォルトの説明を使用する場合は空のままにしてください。',
    'stores' => 'ストア',
    'total_products_found' => ':total 個の製品が見つかりました',
    'language' => '言語',
    'save_settings' => '設定を保存',
    'payout_info' => '支払い情報',
    'payment_method' => '支払い方法',
    'bank_name' => '銀行名',
    'bank_code_ifsc' => '銀行コード/IFSC',
    'account_holder_name' => '口座名義',
    'account_number' => '口座番号',
    'upi_id' => 'UPI ID',
    'upi_id_helper' => 'これはオプションです。UPI IDをお持ちの場合は、ここで提供できます。詳細：https://support.google.com/pay/india/answer/10331134?hl=en',
    'description' => '説明',
    'paypal_id' => 'PayPal ID',
    'pickup_location' => '受取場所',
    'pickup_location_helper' => '現金支払いをどこで受け取りたいですか？',
    'contact_name' => '連絡先名',
    'contact_phone' => '連絡先電話',
    'business_name' => '事業者名',
    'tax_id' => '税務番号',
    'address' => '住所',
    'earnings' => '収益',
    'our_stores' => '私たちのストア',
    'quick_actions' => 'クイックアクション',
    'add_product' => '製品を追加',
    'product' => '製品',
    'create_discount' => '割引を作成',
    'store_settings' => 'ストア設定',
    'withdraw' => '出金',
    'store_performance' => 'ストアパフォーマンス',
    'conversion_rate' => 'コンバージョン率',
    'avg_order_value' => '平均注文額',
    'fulfillment_rate' => 'フルフィルメント率',
    'store_visibility' => 'ストアの可視性',
    'active' => 'アクティブ',
    'sales_reports' => '売上レポート',
    'revenues_in_label' => ':label の収益',
    'earnings_in_label' => ':label の収益',
    'fees' => '手数料',
    'congratulations_vendor' => ':site_title のベンダーになっておめでとうございます',
    'attract_customers_message' => '最高の製品で顧客を引き付けましょう。',
    'create_new_product_here' => '<a href=":url">ここ</a>で新しい製品を作成',
    'no_orders_yet_message' => ':total 個の製品がありますが、まだ注文はありません',
    'view_your_store_here' => '<a href=":url">ここ</a>でストアを表示',
    'includes_order_statuses' => '完了、保留中、処理中のステータスを含む',
    'wait_for_approval' => '管理者が確認して承認するまでお待ちください！',
    'uploaded_certificate' => 'アップロードされた証明書',
    'uploaded_government_id' => 'アップロードされた身分証明書',
    'store' => 'ストア',
    'tax_info' => '税務情報',
    'joined_on_date' => ':date に参加',
    'view_your_store' => 'ストアを表示',
    'go_to_homepage' => 'ホームページへ',
    'recent_orders' => '最近の注文',
    'no_orders' => '注文がありません！',
    'view_full_orders' => 'すべての注文を表示',
    'customer_reviews' => '顧客レビュー',
    'no_reviews_yet' => 'まだレビューはありません',
    'reviews_require_ecommerce' => 'レビュー機能にはEコマースプラグインが必要です',
    'view_all_products' => 'すべての製品を表示',
    'top_selling_products' => 'トップセラー製品',
    'no_products' => '製品がありません！',
    'view_full_products' => 'すべての製品を表示',
    'inventory_status' => '在庫状況',
    'in_stock' => '在庫あり',
    'low_stock' => '在庫僅少',
    'out_of_stock' => '在庫切れ',
    'add_new_product' => '新しい製品を追加',
];
