<?php

return [
    'name' => 'Markedsplass',
    'email' => [
        'title' => 'Markedsplass',
        'description' => 'Konfigurer e-postmaler for markedsplassen',
        'store_new_order_title' => 'Varsel om ny bestilling',
        'store_new_order_description' => 'Send e-post til butikkeieren når en bestilling er plassert',
        'verify_vendor_title' => 'Verifiser leverandør',
        'verify_vendor_description' => 'Send e-post til administrator når en leverandør registrerer seg',
        'pending_product_approval_title' => 'Produktgodkjenning venter',
        'pending_product_approval_description' => 'Send e-post til administrator når en leverandør legger ut produkter',
        'vendor_account_approved_title' => 'Leverandørkonto godkjent',
        'vendor_account_approved_description' => 'Send e-post til leverandør når kontoen deres er godkjent',
        'product_approved_title' => 'Produkt godkjent',
        'product_approved_description' => 'Send e-post til leverandør når produktet deres er godkjent',
        'withdrawal_approved_title' => 'Uttak godkjent',
        'withdrawal_approved_description' => 'Send e-post til leverandør når uttaksforespørselen deres er godkjent',
        'vendor_account_rejected_title' => 'Leverandørkonto avvist',
        'vendor_account_rejected_description' => 'Send e-post til leverandør når kontoen deres er avvist',
        'vendor_account_unblocked_title' => 'Leverandørkonto låst opp',
        'vendor_account_unblocked_description' => 'Send e-post til leverandør når kontoen deres er låst opp',
        'vendor_account_blocked_title' => 'Leverandørkonto blokkert',
        'vendor_account_blocked_description' => 'Send e-post til leverandør når kontoen deres er blokkert',
        'store_new_order_subject' => 'Ny(e) bestilling(er) på {{ site_title }}',
        'verify_vendor_subject' => 'Ny leverandør på {{ site_title }} må verifiseres',
        'vendor_account_approved_subject' => 'Kontoen din er godkjent for salg på {{ site_title }}',
        'vendor_account_rejected_subject' => 'Kontoen din er avvist for salg på {{ site_title }}',
        'pending_product_approval_subject' => 'Nytt produkt må godkjennes for salg på {{ site_title }}',
        'product_approved_subject' => 'Produktet ditt er godkjent for salg på {{ site_title }}',
        'withdrawal_approved_subject' => 'Uttaksforespørselen din er godkjent',
        'welcome_vendor_title' => 'Velkommen leverandør',
        'welcome_vendor_description' => 'Send e-post til leverandør etter registrering',
        'welcome_vendor_subject' => 'Velkommen til {{ site_title }}!',
        'contact_store_title' => 'Kontakt butikk',
        'contact_store_description' => 'Send e-post til butikkeieren når en kunde kontakter butikken',
        'contact_store_subject' => 'Ny kundehenvendelse',
        'vendor_account_blocked_subject' => 'Leverandørkontoen din på {{ site_title }} er blokkert',
        'vendor_account_unblocked_subject' => 'Leverandørkontoen din på {{ site_title }} er låst opp',
        'order_cancellation_to_vendor_title' => 'Bestillingskansellering (sendes til selger (leverandør))',
        'order_cancellation_to_vendor_description' => 'Send til selger (leverandør) når kunde kansellerer en bestilling',
        'order_cancellation_to_vendor_subject' => 'Bestilling :order_id er kansellert av kunden',
        'store_verified_title' => 'Butikkverifisering godkjent',
        'store_verified_description' => 'Send varsel når butikk er verifisert',
        'store_verified_subject' => 'Butikken din {{ store_name }} er verifisert',
        'store_unverified_title' => 'Butikkverifisering fjernet',
        'store_unverified_description' => 'Send varsel når butikkverifisering er fjernet',
        'store_unverified_subject' => 'Verifiseringsstatus endret for {{ store_name }}',
        'verified_by' => 'Verifisert av',
        'verified_at' => 'Verifisert den',
        'unverified_by' => 'Verifisering fjernet av',
        'unverified_at' => 'Verifisering fjernet den',
        'verification_note' => 'Verifiseringsnotat',
        'store' => 'Butikk',
        'order' => 'Bestilling',
        'shipment' => 'Fraktinformasjon',
        'address' => 'Leveringsadresse',
        'products' => 'Bestillingsprodukter',
        'customer_message' => 'Kundemelding',
        'customer_name' => 'Kundenavn',
        'customer_email' => 'Kunde-e-post',
        'block_reason' => 'Årsak til blokkering',
        'block_date' => 'Blokkeringsdato',
        'unblock_date' => 'Opplåsingsdato',
    ],
    'email_templates' => [
        'dear_vendor' => 'Kjære :vendor_name,',
        'dear_admin' => 'Kjære administrator,',
        'hello' => 'Hei,',
        'happy_selling' => 'Lykke til med salget!',
        'email_sent_by_team' => 'Denne e-posten ble sendt av {{ site_title }}-teamet.',

        // Contact Store
        'contact_store_sent_from' => 'Denne e-posten ble sendt fra :customer_name (:customer_email) gjennom kontaktskjemaet på profilen din på :site_title.',
        'contact_store_reply_instruction' => 'Du kan svare direkte på denne e-posten for å svare til :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Leverandørkontoen din på {{ site_title }} er <strong>blokkert</strong> fra og med :block_date.',
        'vendor_account_blocked_reason' => 'Årsak til blokkering: :block_reason',
        'vendor_account_blocked_contact_support' => 'Hvis du tror dette er en feil eller har spørsmål, vennligst kontakt vårt supportteam.',
        'vendor_account_unblocked_message' => 'Vi er glade for å informere deg om at leverandørkontoen din på {{ site_title }} er <strong>låst opp</strong> fra og med :unblock_date.',
        'vendor_account_unblocked_resume' => 'Du kan nå få tilgang til kontoen din og gjenoppta aktivitetene dine.',
        'vendor_account_unblocked_questions' => 'Hvis du har spørsmål, ta gjerne kontakt med vårt supportteam.',
        'vendor_account_approved_title' => 'Leverandørkonto godkjent',
        'vendor_account_approved_message' => 'Kontoen din er godkjent for salg på nettstedet vårt <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Leverandørkonto avvist',
        'vendor_account_rejected_message' => 'Vi beklager å informere deg om at kontoen din ikke er godkjent for salg på nettstedet vårt <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Bestilling vellykket!',
        'store_new_order_message' => 'Du har fått en ny bestilling på :site_title!',
        'customer_information' => 'Kundeinformasjon',
        'field_name' => 'Navn',
        'field_phone' => 'Telefon',
        'field_email' => 'E-post',
        'field_address' => 'Adresse',
        'field_note' => 'Merknad',
        'order_number' => 'Bestillingsnummer',
        'order_date' => 'Bestillingsdato',
        'shipping_method' => 'Fraktmetode',
        'payment_method' => 'Betalingsmetode',

        // Product Approval
        'product_approved_title' => 'Produkt godkjent',
        'product_approved_message' => 'Produktet ditt er godkjent for salg på nettstedet vårt <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Produktgodkjenning venter',
        'pending_product_approval_message' => 'Nytt produkt opprettet av :store_name <a href=":product_url">:product_name</a> venter på godkjenning.',

        // Verify Vendor
        'verify_vendor_title' => 'Verifiser leverandør',
        'verify_vendor_message' => 'Du har en ny leverandør som må verifiseres på :site_title!',
        'vendor_information' => 'Leverandørinformasjon',
        'shop_information' => 'Butikkinformasjon',
        'field_store_name' => 'Butikknavn',
        'field_store_phone' => 'Butikktelefon',
        'visit_store_button' => 'Besøk butikken',

        // Withdrawal
        'withdrawal_approved_title' => 'Uttak godkjent',
        'withdrawal_approved_message' => 'Uttaksforespørselen din er godkjent, vi sender <strong>:withdrawal_amount</strong> til bankinformasjonen din snart.',

        // Order Cancellation
        'order_cancellation_title' => 'Kunden har kansellert bestilling :order_id',
        'order_cancellation_message' => 'Kunde :customer_name har kansellert bestilling <strong>:order_id</strong> på grunn av :cancellation_reason.',
        'order_items_header' => 'Dette ble bestilt:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Velkommen leverandør',
        'welcome_vendor_greeting' => 'Vi er glade for å ønske deg velkommen til :store_name!',
        'welcome_vendor_registration_complete' => 'Leverandørregistreringen din er fullført, og du er nå en del av vårt livlige selgerfellesskap.',
        'welcome_vendor_next_steps' => 'Her er hva du kan gjøre videre:',
        'welcome_vendor_step_login' => 'Logg inn på leverandørkontoen din med påloggingsinformasjonen din.',
        'welcome_vendor_step_add_products' => 'Legg til produktene/tjenestene dine i butikken. Sørg for å gi detaljerte beskrivelser og tiltalende bilder for å tiltrekke potensielle kjøpere.',
        'welcome_vendor_support' => 'Hvis du har spørsmål eller trenger hjelp underveis, er supportteamet vårt her for å hjelpe deg. Ta gjerne kontakt!',
        'login_vendor_account_button' => 'Logg inn på leverandørkontoen din',
        'welcome_vendor_closing' => 'Vi gleder oss til å se butikken din blomstre på :site_title!',

        // Store Verification
        'store_verified_title' => 'Butikkverifisering godkjent',
        'store_verified_message' => 'Gratulerer! Butikken din er verifisert på <strong>:site_title</strong>. Dette verifiseringsmerket vil bidra til å bygge tillit hos kundene dine.',
        'dear_store_owner' => 'Kjære :store_name-eier,',
        'verification_details' => 'Verifiseringsdetaljer',
        'store_verified_benefits' => 'Fordeler ved å være verifisert',
        'verified_badge_benefit' => 'Et verifiseringsmerke vises på butikken din',
        'increased_trust_benefit' => 'Økt kundetillit og selvtillit',
        'higher_visibility_benefit' => 'Høyere synlighet i søkeresultater',
        'visit_your_store' => 'Besøk butikken din',
        'congratulations_verified' => 'Gratulerer med verifiseringen!',

        // Store Unverification
        'store_unverified_title' => 'Butikkverifiseringsstatus endret',
        'store_unverified_message' => 'Vi beklager å informere deg om at verifiseringsstatusen til butikken din på <strong>:site_title</strong> er endret.',
        'unverification_details' => 'Detaljer om statusendring',
        'store_unverified_impacts' => 'Hva dette betyr',
        'verified_badge_removed' => 'Verifiseringsmerket er fjernet fra butikken din',
        'verification_benefits_lost' => 'Verifiseringsfordeler er ikke lenger aktive',
        'store_unverified_next_steps' => 'Hvis du har spørsmål om denne beslutningen eller ønsker å diskutere re-verifisering, vennligst <strong>kontakt vårt supportteam</strong>.',
        'contact_support' => 'Kontakt support',
        'thank_you_understanding' => 'Takk for din forståelse.',
    ],
    'current_balance' => 'Nåværende saldo',
    'settings' => [
        'title' => 'Innstillinger',
        'description' => 'Innstillinger for markedsplassen',
        'fee_per_order' => 'Gebyr per bestilling (%), anbefalt: 2 eller 3',
        'default_commission_fee' => 'Standard provisjon (%), anbefalt: 2 eller 3',
        'enable_commission_fee_for_each_category' => 'Aktiver provisjon for hver kategori?',
        'categories' => 'Kategorier',
        'select_categories' => 'Velg kategorier..',
        'commission_fee' => 'Provisjon (%)',
        'commission_fee_by_category' => 'Provisjon etter kategori (%)',
        'fee_withdrawal_amount' => 'Uttaksgebyr',
        'withdrawal_fee_type' => 'Type uttaksgebyr',
        'withdrawal_fee_types' => [
            'fixed' => 'Fast beløp',
            'percentage' => 'Prosentandel',
        ],
        'check_valid_signature' => 'Sjekk gyldig signatur i leverandørens inntekter',
        'verify_vendor' => 'Leverandørverifisering (leverandør kan kun legge ut produkter etter å ha blitt verifisert)',
        'verify_vendor_helper' => 'Hvis aktivert, må administrator verifisere leverandøren før de kan legge ut produkter.',
        'requires_vendor_documentations_verification' => 'Krever verifisering av leverandørdokumentasjon',
        'requires_vendor_documentations_verification_helper' => 'Hvis aktivert, må leverandører laste opp dokumentasjonsfiler når de søker om å bli leverandør.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Skjul "Bli leverandør"-menyen i kundepanelet',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Hvis aktivert, vil "Bli leverandør"-menyen være skjult i kundepanelet.',
        'enable_product_approval' => 'Aktiver produktgodkjenning',
        'enable_product_approval_description' => 'Hvis aktivert, må administrator godkjenne produktet før det publiseres.',
        'hide_store_phone_number' => 'Skjul butikktelefon?',
        'hide_store_email' => 'Skjul butikk-e-post?',
        'hide_store_address' => 'Skjul butikkadresse?',
        'hide_store_social_links' => 'Skjul sosiale lenker for butikk?',
        'enable_vendor_categories_filter' => 'Aktiver leverandørkategorifilter',
        'enable_vendor_categories_filter_description' => 'Vis kategorifilter på leverandørbutikksiden. Kun kategorier med leverandørprodukter vil vises.',
        'allow_vendor_manage_shipping' => 'Tillat leverandør å håndtere frakt?',
        'allow_vendor_manage_shipping_description' => 'Hvis aktivert, kan leverandøren endre fraktstatus for bestilling til "leveres", "levert", ...',
        'charge_shipping_per_vendor' => 'Belast frakt per leverandør?',
        'charge_shipping_per_vendor_description' => 'Hvis aktivert, vil frakt belastes separat for hver leverandør. Hvis deaktivert, vil frakt belastes én gang for hele bestillingen.',
        'commission_fee_each_category_fee_name' => 'Provisjon for provisjonsinnstilling :key',
        'commission_fee_each_category_name' => 'Kategorier for provisjonsinnstilling :key',
        'add_new' => 'Legg til ny',
        'payout_methods' => 'Utbetalingsmetoder',
        'max_upload_filesize' => 'Maks opplastingsstørrelse (MB)',
        'max_upload_filesize_placeholder' => 'Standard: 10',
        'max_product_images_upload_by_vendor' => 'Maks antall bilder per produkt',
        'enable_vendor_registration' => 'Aktiver leverandørregistrering',
        'enable_vendor_registration_helper' => 'Hvis aktivert, kan leverandører registrere en konto på nettstedet og legge ut produkter.',
        'minimum_withdrawal_amount' => 'Minimum uttaksbeløp (fast)',
        'minimum_withdrawal_amount_helper' => 'Spesifiser minimumsbeløpet en leverandør kan ta ut. Standard er 0.',
        'allow_vendor_delete_their_orders' => 'Tillat leverandører å slette bestillinger',
        'allow_vendor_delete_their_orders_description' => 'Når aktivert, kan leverandører administrere bestillingslisten sin ved å fjerne uønskede oppføringer. Bruk med forsiktighet da slettede bestillinger kan påvirke transaksjonsregistre.',
        'enable_messaging_system' => 'Aktiver meldingssystem',
        'enable_messaging_system_description' => 'Hvis aktivert, kan leverandører og kunder kommunisere med hverandre via meldingssystemet.',
        'term_and_privacy_policy_url' => 'Vilkår og personvernpolicy URL',
        'show_vendor_registration_form_at_registration_page' => 'Vis leverandørregistreringsskjema på registreringssiden',
        'show_vendor_registration_form_at_registration_page_description' => 'Hvis aktivert, vil leverandørregistreringsskjemaet vises på registreringssiden.',
        'single_vendor_checkout' => 'Begrens til én leverandør per bestilling',
        'single_vendor_checkout_help' => 'Hvis aktivert, kan kunder kun kjøpe produkter fra én leverandør per bestilling.',
        'display_order_total_info_for_each_store' => 'Vis totalsuminfo for hver butikk',
        'display_order_total_info_for_each_store_helper' => 'Hvis aktivert, vil totalinformasjonen for bestillingen vises for hver butikk i bestillingsoversikten.',
        'show_vendor_info_at_checkout' => 'Vis leverandørinformasjon ved kassen',
        'show_vendor_info_at_checkout_helper' => 'Hvis aktivert, vil leverandørinformasjon (navn, logo, anmeldelser) vises på kassesiden.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Mediefiltyper som kan lastes opp av leverandør',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Spesifiser mediefiltyper som leverandører kan laste opp. Velg dem i listen ovenfor.',
    ],
    'theme_options' => [
        'name' => 'Markedsplass',
        'description' => 'Temainnstillinger for markedsplassen',
        'logo_vendor_dashboard' => 'Logo i leverandørpanelet (standard er hovedlogoen)',
    ],
    'store_name' => 'Butikknavn',
    'store_email' => 'Butikk-e-post',
    'store_phone' => 'Butikktelefon',
    'store_address' => 'Butikkadresse',
    'store_url' => 'Butikk-URL',
    'product_name' => 'Produktnavn',
    'product_url' => 'Produkt-URL',
    'withdrawal_amount' => 'Uttaksbeløp',
    'helpers' => [
        'store_status' => 'Hvis du endrer statusen til noe annet enn ":status", vil denne butikkens konto også endres til ":customer"',
    ],
    'tables' => [
        'earnings' => 'Inntekter',
        'products_count' => 'Antall produkter',
    ],
    'vendors' => 'Leverandører',
    'payout_payment_methods' => [
        'bank_transfer' => 'Bankoverføring',
        'paypal' => 'PayPal',
        'cash' => 'Kontant',
    ],
    'reports' => [
        'name' => 'Rapporter',
        'total_fee_earnings' => 'Total gebyrinntekt: :value',
        'total_fee' => 'Totalt gebyr',
        'total_amount' => 'Totalbeløp',
        'store_revenues' => 'Butikkinntekter',
        'sale_commissions' => 'Salgsprovisjoner',
        'fee' => 'Gebyr (:symbol)',
        'amount' => 'Beløp (:symbol)',
        'top_performing_stores' => 'Butikker med best ytelse',
        'store_growth' => 'Butikkvekst',
        'withdrawal_status_chart' => 'Uttaksstatus',
        'product_distribution' => 'Produktfordeling per butikk',
        'average_commission' => 'Gjennomsnittlig provisjonssats',
        'recent_withdrawals' => 'Nylige uttak',
        'number_of_stores' => 'Antall butikker',
        'number_of_products' => 'Antall produkter',
        'orders' => 'Bestillinger',
        'revenue' => 'Inntekt',
        'increase' => ':count økning',
        'decrease' => ':count nedgang',
    ],
    'vendor' => 'Leverandør',
    'vendor_name' => 'Leverandørnavn',
    'contact_store' => [
        'form_name' => 'Kontakt butikk-skjema',
    ],
    'store_statuses' => [
        'pending' => 'Venter',
        'published' => 'Godkjent',
        'blocked' => 'Blokkert',
    ],
    'view_vendor' => 'Se leverandør :name',
    'vendor_information' => 'Leverandørinformasjon',
    'vendor_verified' => 'Leverandør verifisert',
    'vendor_not_verified' => 'Leverandør ikke verifisert',
    'vendor_verified_at' => 'Leverandør verifisert den',
    'view_certificate' => 'Se sertifikat',
    'view_government_id' => 'Se ID-dokument',
    'documents' => 'Dokumenter',
    'store_products' => 'Butikkprodukter',
    'store_orders' => 'Butikkbestillinger',
    'total_revenue' => 'Total inntekt',
    'total_earnings' => 'Total fortjeneste',
    'pending_withdrawals' => 'Ventende uttak',
    'balance' => 'Saldo',
    'recent_products' => 'Nylige produkter',
    'products_count' => 'Produkter',
    'store_status' => 'Butikkstatus',
    'verified' => 'Verifisert',
    'dashboard' => 'Dashbord',
    'products' => 'Produkter',
    'orders' => 'Bestillinger',
    'coupons' => 'Kuponger',
    'withdrawals' => 'Uttak',
    'revenues' => 'Inntekter',
    'messages' => 'Meldinger',
    'reviews' => 'Anmeldelser',
    'order_returns' => 'Bestillingsreturer',
    'shipments' => 'Forsendelser',
    'vendor_dashboard' => 'Leverandør dashbord',
    'become_a_vendor' => 'Bli leverandør',
    'become_vendor' => 'Bli leverandør',
    'product_specification' => 'Produktspesifikasjoner',
    'specification_groups' => 'Spesifikasjonsgrupper',
    'specification_attributes' => 'Spesifikasjonsattributter',
    'specification_tables' => 'Spesifikasjonstabeller',
    'register_as' => 'Registrer som',
    'register' => 'Registrer',
    'i_am_customer' => 'Jeg er kunde',
    'i_am_vendor' => 'Jeg er leverandør',
    'i_agree_to_terms' => 'Jeg godtar :link',
    'i_agree_to_terms_simple' => 'Jeg godtar vilkårene',
    'terms_and_privacy_policy' => 'Vilkår og personvernregler',
    'send_message_successfully' => 'Melding sendt',
    'cannot_send_message_to_own_store' => 'Du kan ikke sende melding til din egen butikk',
    'vendor_account_not_verified' => 'Leverandørkonto ikke verifisert',
    'invalid_signature' => 'Ugyldig signatur',
    'file_not_found' => 'Fil ikke funnet',
    'update_successfully' => 'Oppdatert',
    'shop_url_exists' => 'Butikk-URL finnes allerede',
    'insufficient_balance' => 'Utilstrekkelig saldo',
    'total_amount_exceeds_balance' => 'Totalbeløp overstiger saldo',
    'registered_successfully' => 'Registrert',
    'updated_registration_successfully' => 'Registrering oppdatert',
    'missing_documentations' => 'Manglende dokumentasjon',
    'only_add_products_from_same_store' => 'Du kan bare legge til produkter fra samme butikk',
    'checkout_only_one_store' => 'Du kan bare handle fra én butikk',
    'coupon_code_invalid' => 'Kupongkode er ugyldig',
    'recovered_from_previous_orders' => 'Gjenopprettet fra tidligere bestillinger',
    'not_available' => 'Ikke tilgjengelig',
    'available' => 'Tilgjengelig',
    'stores_seo_title' => 'Butikker',
    'stores_seo_description' => 'Utforsk våre butikker',
    'leave_empty_for_default' => 'La stå tom for standardverdi',
    'stores' => 'Butikker',
    'total_products_found' => 'Totalt :total produkter funnet',
    'language' => 'Språk',
    'save_settings' => 'Lagre innstillinger',
    'payout_info' => 'Utbetalingsinformasjon',
    'payment_method' => 'Betalingsmetode',
    'bank_name' => 'Banknavn',
    'bank_code_ifsc' => 'Bankkode / IFSC',
    'account_holder_name' => 'Kontoinnehavers navn',
    'account_number' => 'Kontonummer',
    'upi_id' => 'UPI ID',
    'upi_id_helper' => 'Eksempel: 123456789@paytm',
    'description' => 'Beskrivelse',
    'paypal_id' => 'PayPal ID',
    'pickup_location' => 'Hentested',
    'pickup_location_helper' => 'Fullstendig adresse for henting av produkter',
    'contact_name' => 'Kontaktperson',
    'contact_phone' => 'Kontakttelefon',
    'business_name' => 'Bedriftsnavn',
    'tax_id' => 'Skatte-ID',
    'address' => 'Adresse',
    'earnings' => 'Inntjening',
    'our_stores' => 'Våre butikker',
    'quick_actions' => 'Hurtighandlinger',
    'add_product' => 'Legg til produkt',
    'product' => 'Produkt',
    'create_discount' => 'Opprett rabatt',
    'store_settings' => 'Butikkinnstillinger',
    'withdraw' => 'Ta ut',
    'store_performance' => 'Butikkytelse',
    'conversion_rate' => 'Konverteringsrate',
    'avg_order_value' => 'Gjennomsnittlig ordrebeløp',
    'fulfillment_rate' => 'Oppfyllelsesrate',
    'store_visibility' => 'Butikk synlighet',
    'active' => 'Aktiv',
    'sales_reports' => 'Salgsrapporter',
    'revenues_in_label' => 'Inntekter i :label',
    'earnings_in_label' => 'Inntjening i :label',
    'fees' => 'Avgifter',
    'congratulations_vendor' => 'Gratulerer! Leverandørregistreringen din var vellykket!',
    'attract_customers_message' => 'La oss tiltrekke oss kunder ved å legge til ditt første produkt.',
    'create_new_product_here' => 'Opprett nytt produkt her',
    'no_orders_yet_message' => 'Ingen bestillinger ennå. Se butikken din for å sikre at den ser flott ut for kundene.',
    'view_your_store_here' => 'Se butikken din her',
    'includes_order_statuses' => 'Inkluderer bestillinger med statuser: :statuses.',
    'wait_for_approval' => 'Vent på godkjenning',
    'uploaded_certificate' => 'Sertifikat lastet opp',
    'uploaded_government_id' => 'Offentlig ID lastet opp',
    'store' => 'Butikk',
    'tax_info' => 'Skatteinformasjon',
    'joined_on_date' => 'Ble med :date',
    'view_your_store' => 'Se butikken din',
    'go_to_homepage' => 'Gå til hjemmesiden',
    'recent_orders' => 'Nylige bestillinger',
    'no_orders' => 'Ingen bestillinger',
    'view_full_orders' => 'Se alle bestillinger',
    'customer_reviews' => 'Kundeanmeldelser',
    'no_reviews_yet' => 'Ingen anmeldelser ennå',
    'reviews_require_ecommerce' => 'For å se anmeldelser, aktiver Reviews-plugin i Ecommerce-plugin.',
    'view_all_products' => 'Se alle produkter',
    'top_selling_products' => 'Bestselgende produkter',
    'no_products' => 'Ingen produkter',
    'view_full_products' => 'Se alle produkter',
    'inventory_status' => 'Lagerstatus',
    'in_stock' => 'På lager',
    'low_stock' => 'Lavt lager',
    'out_of_stock' => 'Utsolgt',
    'add_new_product' => 'Legg til nytt produkt',
];
