<?php

return [
    'name' => 'Marketplace',
    'email' => [
        'title' => 'Marketplace',
        'description' => 'Konfiguruj szablony e-mail dla Marketplace',
        'store_new_order_title' => 'Powiadomienie o nowym zamówieniu',
        'store_new_order_description' => 'Wyślij e-mail do właściciela sklepu gdy zamówienie zostanie złożone',
        'verify_vendor_title' => 'Weryfikuj sprzedawcę',
        'verify_vendor_description' => 'Wyślij e-mail do administratora gdy sprzedawca się zarejestruje',
        'pending_product_approval_title' => 'Oczekujące zatwierdzenie produktu',
        'pending_product_approval_description' => 'Wyślij e-mail do administratora gdy sprzedawca opublikuje swoje produkty',
        'vendor_account_approved_title' => 'Konto sprzedawcy zatwierdzone',
        'vendor_account_approved_description' => 'Wyślij e-mail do sprzedawcy gdy jego konto zostanie zatwierdzone',
        'product_approved_title' => 'Produkt zatwierdzony',
        'product_approved_description' => 'Wyślij e-mail do sprzedawcy gdy jego produkt zostanie zatwierdzony',
        'withdrawal_approved_title' => 'Wypłata zatwierdzona',
        'withdrawal_approved_description' => 'Wyślij e-mail do sprzedawcy gdy jego prośba o wypłatę zostanie zatwierdzona',
        'vendor_account_rejected_title' => 'Konto sprzedawcy odrzucone',
        'vendor_account_rejected_description' => 'Wyślij e-mail do sprzedawcy gdy jego konto zostanie odrzucone',
        'vendor_account_unblocked_title' => 'Konto sprzedawcy odblokowane',
        'vendor_account_unblocked_description' => 'Wyślij e-mail do sprzedawcy gdy jego konto zostanie odblokowane',
        'vendor_account_blocked_title' => 'Konto sprzedawcy zablokowane',
        'vendor_account_blocked_description' => 'Wyślij e-mail do sprzedawcy gdy jego konto zostanie zablokowane',
        'store_new_order_subject' => 'Nowe zamówienie(a) na {{ site_title }}',
        'verify_vendor_subject' => 'Nowy sprzedawca na {{ site_title }} wymaga weryfikacji',
        'vendor_account_approved_subject' => 'Twoje konto zostało zatwierdzone do sprzedaży na {{ site_title }}',
        'vendor_account_rejected_subject' => 'Twoje konto zostało odrzucone do sprzedaży na {{ site_title }}',
        'pending_product_approval_subject' => 'Nowy produkt wymaga zatwierdzenia do sprzedaży na {{ site_title }}',
        'product_approved_subject' => 'Twój produkt został zatwierdzony do sprzedaży na {{ site_title }}',
        'withdrawal_approved_subject' => 'Twoja prośba o wypłatę została zatwierdzona',
        'welcome_vendor_title' => 'Witaj sprzedawco',
        'welcome_vendor_description' => 'Wyślij e-mail do sprzedawcy po rejestracji',
        'welcome_vendor_subject' => 'Witamy na {{ site_title }}!',
        'contact_store_title' => 'Kontakt ze Sklepem',
        'contact_store_description' => 'Wyślij e-mail do właściciela sklepu gdy klient skontaktuje się ze sklepem',
        'contact_store_subject' => 'Nowa Wiadomość Kontaktowa od Klienta',
        'vendor_account_blocked_subject' => 'Twoje konto sprzedawcy na {{ site_title }} zostało zablokowane',
        'vendor_account_unblocked_subject' => 'Twoje konto sprzedawcy na {{ site_title }} zostało odblokowane',
        'order_cancellation_to_vendor_title' => 'Anulowanie zamówienia (zostanie wysłane do sprzedawcy)',
        'order_cancellation_to_vendor_description' => 'Wyślij do sprzedawcy gdy klient anuluje zamówienie',
        'order_cancellation_to_vendor_subject' => 'Zamówienie :order_id zostało anulowane przez klienta',
        'store_verified_title' => 'Weryfikacja Sklepu Zatwierdzona',
        'store_verified_description' => 'Wyślij powiadomienie gdy sklep zostanie zweryfikowany',
        'store_verified_subject' => 'Twój sklep {{ store_name }} został zweryfikowany',
        'store_unverified_title' => 'Weryfikacja Sklepu Usunięta',
        'store_unverified_description' => 'Wyślij powiadomienie gdy weryfikacja sklepu zostanie usunięta',
        'store_unverified_subject' => 'Status weryfikacji zmieniony dla {{ store_name }}',
        'verified_by' => 'Zweryfikowane przez',
        'verified_at' => 'Zweryfikowane dnia',
        'unverified_by' => 'Niezweryfikowane przez',
        'unverified_at' => 'Niezweryfikowane dnia',
        'verification_note' => 'Notatka weryfikacji',
        'store' => 'Sklep',
        'order' => 'Zamówienie',
        'shipment' => 'Informacje o przesyłce',
        'address' => 'Adres dostawy',
        'products' => 'Produkty zamówienia',
        'customer_message' => 'Wiadomość klienta',
        'customer_name' => 'Imię klienta',
        'customer_email' => 'E-mail klienta',
        'block_reason' => 'Powód blokady',
        'block_date' => 'Data blokady',
        'unblock_date' => 'Data odblokowania',
    ],
    'email_templates' => [
        'dear_vendor' => 'Drogi :vendor_name,',
        'dear_admin' => 'Drogi Administratorze,',
        'hello' => 'Witaj,',
        'happy_selling' => 'Szczęśliwej sprzedaży!',
        'email_sent_by_team' => 'Ten e-mail został wysłany przez zespół {{ site_title }}.',

        // Contact Store
        'contact_store_sent_from' => 'Ten e-mail został wysłany od :customer_name (:customer_email) przez formularz kontaktowy w profilu na :site_title.',
        'contact_store_reply_instruction' => 'Możesz odpowiedzieć bezpośrednio na ten e-mail aby odpowiedzieć :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Twoje konto sprzedawcy na {{ site_title }} zostało <strong>zablokowane</strong> od :block_date.',
        'vendor_account_blocked_reason' => 'Powód blokady: :block_reason',
        'vendor_account_blocked_contact_support' => 'Jeśli uważasz, że to pomyłka lub masz pytania, skontaktuj się z naszym zespołem wsparcia.',
        'vendor_account_unblocked_message' => 'Z przyjemnością informujemy, że twoje konto sprzedawcy na {{ site_title }} zostało <strong>odblokowane</strong> od :unblock_date.',
        'vendor_account_unblocked_resume' => 'Możesz teraz uzyskać dostęp do swojego konta i wznowić swoje działania.',
        'vendor_account_unblocked_questions' => 'Jeśli masz pytania, nie wahaj się skontaktować z naszym zespołem wsparcia.',
        'vendor_account_approved_title' => 'Konto Sprzedawcy Zatwierdzone',
        'vendor_account_approved_message' => 'Twoje konto zostało zatwierdzone do sprzedaży na naszej stronie <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Konto Sprzedawcy Odrzucone',
        'vendor_account_rejected_message' => 'Przykro nam poinformować, że twoje konto nie zostało zatwierdzone do sprzedaży na naszej stronie <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Zamówienie udane!',
        'store_new_order_message' => 'Otrzymałeś nowe zamówienie na :site_title!',
        'customer_information' => 'Informacje o Kliencie',
        'field_name' => 'Imię',
        'field_phone' => 'Telefon',
        'field_email' => 'E-mail',
        'field_address' => 'Adres',
        'field_note' => 'Notatka',
        'order_number' => 'Numer zamówienia',
        'order_date' => 'Data zamówienia',
        'shipping_method' => 'Metoda Dostawy',
        'payment_method' => 'Metoda Płatności',

        // Product Approval
        'product_approved_title' => 'Produkt Zatwierdzony',
        'product_approved_message' => 'Twój produkt został zatwierdzony do sprzedaży na naszej stronie <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Oczekujące zatwierdzenie produktu',
        'pending_product_approval_message' => 'Nowy produkt został utworzony przez :store_name <a href=":product_url">:product_name</a> oczekuje na zatwierdzenie.',

        // Verify Vendor
        'verify_vendor_title' => 'Zweryfikuj Sprzedawcę',
        'verify_vendor_message' => 'Masz nowego sprzedawcę, który wymaga weryfikacji na :site_title!',
        'vendor_information' => 'Informacje o Sprzedawcy',
        'shop_information' => 'Informacje o sklepie',
        'field_store_name' => 'Nazwa Sklepu',
        'field_store_phone' => 'Numer Telefonu Sklepu',
        'visit_store_button' => 'Odwiedź sklep',

        // Withdrawal
        'withdrawal_approved_title' => 'Wypłata Zatwierdzona',
        'withdrawal_approved_message' => 'Twoja prośba o wypłatę została zatwierdzona, wkrótce wyślemy <strong>:withdrawal_amount</strong> na twoje dane bankowe.',

        // Order Cancellation
        'order_cancellation_title' => 'Klient anulował zamówienie :order_id',
        'order_cancellation_message' => 'Klient :customer_name anulował zamówienie <strong>:order_id</strong> z powodu :cancellation_reason.',
        'order_items_header' => 'Oto co zamówiłeś:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Witaj sprzedawco',
        'welcome_vendor_greeting' => 'Z radością witamy cię w :store_name!',
        'welcome_vendor_registration_complete' => 'Twoja rejestracja sprzedawcy została pomyślnie zakończona i jesteś teraz częścią naszej żywej społeczności sprzedawców.',
        'welcome_vendor_next_steps' => 'Oto co możesz teraz zrobić:',
        'welcome_vendor_step_login' => 'Zaloguj się do swojego konta sprzedawcy używając swoich danych logowania.',
        'welcome_vendor_step_add_products' => 'Dodaj swoje produkty/usługi do swojego sklepu. Upewnij się, że podajesz szczegółowe opisy i atrakcyjne zdjęcia, aby przyciągnąć potencjalnych kupujących.',
        'welcome_vendor_support' => 'Jeśli masz pytania lub potrzebujesz pomocy po drodze, nasz zespół wsparcia jest tutaj, aby ci pomóc. Nie wahaj się skontaktować!',
        'login_vendor_account_button' => 'Zaloguj się do konta sprzedawcy',
        'welcome_vendor_closing' => 'Jesteśmy podekscytowani widząc twój sklep rozkwitający na :site_title!',

        // Store Verification
        'store_verified_title' => 'Weryfikacja Sklepu Zatwierdzona',
        'store_verified_message' => 'Gratulacje! Twój sklep został pomyślnie zweryfikowany na <strong>:site_title</strong>. Ta odznaka weryfikacji pomoże budować zaufanie z twoimi klientami.',
        'dear_store_owner' => 'Drogi Właścicielu :store_name,',
        'verification_details' => 'Szczegóły Weryfikacji',
        'store_verified_benefits' => 'Korzyści z bycia zweryfikowanym',
        'verified_badge_benefit' => 'Odznaka weryfikacji wyświetlana w twoim sklepie',
        'increased_trust_benefit' => 'Zwiększone zaufanie i pewność klientów',
        'higher_visibility_benefit' => 'Wyższa widoczność w wynikach wyszukiwania',
        'visit_your_store' => 'Odwiedź Swój Sklep',
        'congratulations_verified' => 'Gratulacje weryfikacji!',

        // Store Unverification
        'store_unverified_title' => 'Status Weryfikacji Sklepu Zmieniony',
        'store_unverified_message' => 'Przykro nam poinformować, że status weryfikacji twojego sklepu na <strong>:site_title</strong> został zmieniony.',
        'unverification_details' => 'Szczegóły Zmiany Statusu',
        'store_unverified_impacts' => 'Co to oznacza',
        'verified_badge_removed' => 'Odznaka weryfikacji została usunięta z twojego sklepu',
        'verification_benefits_lost' => 'Korzyści z weryfikacji nie są już aktywne',
        'store_unverified_next_steps' => 'Jeśli masz pytania dotyczące tej decyzji lub chcesz omówić ponowną weryfikację, <strong>skontaktuj się z naszym zespołem wsparcia</strong>.',
        'contact_support' => 'Skontaktuj się ze Wsparciem',
        'thank_you_understanding' => 'Dziękujemy za zrozumienie.',
    ],
    'current_balance' => 'Obecne saldo',
    'settings' => [
        'title' => 'Ustawienia',
        'description' => 'Ustawienia dla marketplace',
        'fee_per_order' => 'Opłata za zamówienie (%), sugestia: 2 lub 3',
        'default_commission_fee' => 'Domyślna prowizja (%), sugestia: 2 lub 3',
        'enable_commission_fee_for_each_category' => 'Włączyć prowizję dla każdej kategorii?',
        'categories' => 'Kategorie',
        'select_categories' => 'Wybierz kategorie..',
        'commission_fee' => 'Prowizja (%)',
        'commission_fee_by_category' => 'Prowizja według kategorii (%)',
        'fee_withdrawal_amount' => 'Opłata za wypłatę',
        'withdrawal_fee_type' => 'Typ opłaty za wypłatę',
        'withdrawal_fee_types' => [
            'fixed' => 'Stała kwota',
            'percentage' => 'Procent',
        ],
        'check_valid_signature' => 'Sprawdź ważny podpis w zarobkach sprzedawcy',
        'verify_vendor' => 'Weryfikacja sprzedawcy (Sprzedawca może publikować produkty dopiero po weryfikacji)',
        'verify_vendor_helper' => 'Jeśli włączone, administrator musi zweryfikować sprzedawcę zanim będzie mógł publikować swoje produkty.',
        'requires_vendor_documentations_verification' => 'Wymaga weryfikacji dokumentacji sprzedawcy',
        'requires_vendor_documentations_verification_helper' => 'Jeśli włączone, sprzedawcy muszą przesłać swoje pliki dokumentacji podczas aplikowania na sprzedawcę.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Ukryj menu zostań sprzedawcą w panelu klienta',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Jeśli włączone, menu "Zostań sprzedawcą" będzie ukryte w panelu klienta.',
        'enable_product_approval' => 'Włącz zatwierdzanie produktów',
        'enable_product_approval_description' => 'Jeśli włączone, administrator musi zatwierdzić produkt zanim zostanie opublikowany.',
        'hide_store_phone_number' => 'Ukryć numer telefonu sklepu?',
        'hide_store_email' => 'Ukryć e-mail sklepu?',
        'hide_store_address' => 'Ukryć adres sklepu?',
        'hide_store_social_links' => 'Ukryć linki społecznościowe sklepu?',
        'enable_vendor_categories_filter' => 'Włącz filtr kategorii sprzedawcy',
        'enable_vendor_categories_filter_description' => 'Pokaż filtr kategorii na stronie sklepu sprzedawcy. Tylko kategorie które mają produkty sprzedawcy będą wyświetlane.',
        'allow_vendor_manage_shipping' => 'Pozwól sprzedawcy zarządzać dostawą?',
        'allow_vendor_manage_shipping_description' => 'Jeśli włączone, sprzedawca może zmieniać status dostawy zamówienia na "dostarczanie", "dostarczone", ...',
        'charge_shipping_per_vendor' => 'Naliczać dostawę na sprzedawcę?',
        'charge_shipping_per_vendor_description' => 'Jeśli włączone, dostawa będzie naliczana osobno dla każdego sprzedawcy. Jeśli wyłączone, dostawa będzie naliczana raz dla całego zamówienia.',
        'commission_fee_each_category_fee_name' => 'Prowizja ustawienia prowizji :key',
        'commission_fee_each_category_name' => 'Kategorie ustawienia prowizji :key',
        'add_new' => 'Dodaj nowy',
        'payout_methods' => 'Metody wypłat',
        'max_upload_filesize' => 'Maksymalny rozmiar pliku (MB)',
        'max_upload_filesize_placeholder' => 'Domyślnie: 10',
        'max_product_images_upload_by_vendor' => 'Maksymalna liczba zdjęć dla każdego produktu',
        'enable_vendor_registration' => 'Włącz rejestrację sprzedawcy',
        'enable_vendor_registration_helper' => 'Jeśli włączone, sprzedawcy mogą zarejestrować konto na stronie i publikować swoje produkty.',
        'minimum_withdrawal_amount' => 'Minimalna kwota wypłaty (Stała)',
        'minimum_withdrawal_amount_helper' => 'Określ minimalną kwotę jaką sprzedawca może wypłacić. Domyślnie 0.',
        'allow_vendor_delete_their_orders' => 'Pozwól sprzedawcom usuwać swoje zamówienia',
        'allow_vendor_delete_their_orders_description' => 'Gdy włączone, sprzedawcy mogą zarządzać swoją listą zamówień przez usuwanie niechcianych pozycji. Używaj ostrożnie, ponieważ usunięte zamówienia mogą wpłynąć na zapisy transakcji.',
        'enable_messaging_system' => 'Włącz system wiadomości',
        'enable_messaging_system_description' => 'Jeśli włączone, sprzedawcy i klienci mogą komunikować się ze sobą przez system wiadomości.',
        'term_and_privacy_policy_url' => 'URL regulaminu i polityki prywatności',
        'show_vendor_registration_form_at_registration_page' => 'Pokaż formularz rejestracji sprzedawcy na stronie rejestracji',
        'show_vendor_registration_form_at_registration_page_description' => 'Jeśli włączone, formularz rejestracji sprzedawcy będzie wyświetlany na stronie rejestracji.',
        'single_vendor_checkout' => 'Ogranicz do Jednego Sprzedawcy na Zamówienie',
        'single_vendor_checkout_help' => 'Jeśli włączone, klienci mogą kupować produkty tylko od jednego sprzedawcy na zamówienie.',
        'display_order_total_info_for_each_store' => 'Wyświetl informacje o całkowitej wartości zamówienia dla każdego sklepu',
        'display_order_total_info_for_each_store_helper' => 'Jeśli włączone, informacje o całkowitej wartości zamówienia będą wyświetlane dla każdego sklepu w podsumowaniu zamówienia.',
        'show_vendor_info_at_checkout' => 'Pokaż informacje o sprzedawcy przy kasie',
        'show_vendor_info_at_checkout_helper' => 'Jeśli włączone, informacje o sprzedawcy (nazwa, logo, recenzje) będą wyświetlane na stronie kasy.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Typy plików multimedialnych mogą być przesłane przez sprzedawcę',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Określ typy plików multimedialnych które sprzedawcy mogą przesyłać. Wybierz je z powyższej listy.',
    ],
    'theme_options' => [
        'name' => 'Marketplace',
        'description' => 'Opcje motywu dla Marketplace',
        'logo_vendor_dashboard' => 'Logo w panelu sprzedawcy (Domyślnie główne logo)',
    ],
    'store_name' => 'Nazwa sklepu',
    'store_email' => 'E-mail sklepu',
    'store_phone' => 'Telefon sklepu',
    'store_address' => 'Adres sklepu',
    'store_url' => 'URL sklepu',
    'product_name' => 'Nazwa produktu',
    'product_url' => 'URL produktu',
    'withdrawal_amount' => 'Kwota wypłaty',
    'helpers' => [
        'store_status' => 'Jeśli zmienisz status inny niż ":status" to konto tego sklepu również zmieni się na ":customer"',
    ],
    'tables' => [
        'earnings' => 'Zarobki',
        'products_count' => 'Liczba Produktów',
    ],
    'vendors' => 'Sprzedawcy',
    'payout_payment_methods' => [
        'bank_transfer' => 'Przelew Bankowy',
        'paypal' => 'PayPal',
        'cash' => 'Gotówka',
    ],
    'reports' => [
        'name' => 'Raporty',
        'total_fee_earnings' => 'Całkowite zarobki z opłat: :value',
        'total_fee' => 'Całkowita opłata',
        'total_amount' => 'Całkowita kwota',
        'store_revenues' => 'Przychody sklepów',
        'sale_commissions' => 'Prowizje sprzedaży',
        'fee' => 'Opłata (:symbol)',
        'amount' => 'Kwota (:symbol)',
        'top_performing_stores' => 'Najlepiej Działające Sklepy',
        'store_growth' => 'Wzrost Sklepów',
        'withdrawal_status_chart' => 'Status Wypłat',
        'product_distribution' => 'Dystrybucja Produktów według Sklepu',
        'average_commission' => 'Średnia Stawka Prowizji',
        'recent_withdrawals' => 'Ostatnie Wypłaty',
        'number_of_stores' => 'Liczba Sklepów',
        'number_of_products' => 'Liczba Produktów',
        'orders' => 'Zamówienia',
        'revenue' => 'Przychody',
        'increase' => ':count wzrost',
        'decrease' => ':count spadek',
    ],
    'vendor' => 'Sprzedawca',
    'vendor_name' => 'Nazwa sprzedawcy',
    'contact_store' => [
        'form_name' => 'Formularz Kontaktu ze Sklepem',
    ],
    'store_statuses' => [
        'pending' => 'Oczekujące',
        'published' => 'Zatwierdzone',
        'blocked' => 'Zablokowane',
    ],
    'view_vendor' => 'Zobacz sprzedawcę :name',
    'vendor_information' => 'Informacje o Sprzedawcy',
    'vendor_verified' => 'Sprzedawca Zweryfikowany',
    'vendor_not_verified' => 'Sprzedawca Niezweryfikowany',
    'vendor_verified_at' => 'Sprzedawca Zweryfikowany Dnia',
    'view_certificate' => 'Zobacz Certyfikat',
    'view_government_id' => 'Zobacz Dowód Tożsamości',
    'documents' => 'Dokumenty',
    'store_products' => 'Produkty Sklepu',
    'store_orders' => 'Zamówienia Sklepu',
    'total_revenue' => 'Całkowite Przychody',
    'total_earnings' => 'Całkowite Zarobki',
    'pending_withdrawals' => 'Oczekujące Wypłaty',
    'balance' => 'Saldo',
    'recent_products' => 'Ostatnie Produkty',
    'products_count' => 'Produkty',
    'store_status' => 'Status Sklepu',
    'verified' => 'Zweryfikowany',
    'dashboard' => 'Panel',
    'products' => 'Produkty',
    'orders' => 'Zamówienia',
    'coupons' => 'Kupony',
    'withdrawals' => 'Wypłaty',
    'revenues' => 'Przychody',
    'messages' => 'Wiadomości',
    'reviews' => 'Recenzje',
    'order_returns' => 'Zwroty Zamówień',
    'shipments' => 'Przesyłki',
    'vendor_dashboard' => 'Panel Sprzedawcy',
    'become_a_vendor' => 'Zostań Sprzedawcą',
    'become_vendor' => 'Zostań Sprzedawcą',
    'product_specification' => 'Specyfikacja Produktu',
    'specification_groups' => 'Grupy Specyfikacji',
    'specification_attributes' => 'Atrybuty Specyfikacji',
    'specification_tables' => 'Tabele Specyfikacji',
    'register_as' => 'Zarejestruj się jako',
    'register' => 'Zarejestruj się',
    'i_am_customer' => 'Jestem klientem',
    'i_am_vendor' => 'Jestem sprzedawcą',
    'i_agree_to_terms' => 'Zgadzam się z :link',
    'i_agree_to_terms_simple' => 'Zgadzam się z regulaminem',
    'terms_and_privacy_policy' => 'Regulamin i polityka prywatności',
    'send_message_successfully' => 'Wiadomość została wysłana',
    'cannot_send_message_to_own_store' => 'Nie możesz wysłać wiadomości do własnego sklepu',
    'vendor_account_not_verified' => 'Konto sprzedawcy nie zostało zweryfikowane',
    'invalid_signature' => 'Nieprawidłowy podpis',
    'file_not_found' => 'Nie znaleziono pliku',
    'update_successfully' => 'Zaktualizowano pomyślnie',
    'shop_url_exists' => 'URL sklepu już istnieje',
    'insufficient_balance' => 'Niewystarczające saldo',
    'total_amount_exceeds_balance' => 'Łączna kwota przekracza saldo',
    'registered_successfully' => 'Zarejestrowano pomyślnie',
    'updated_registration_successfully' => 'Rejestracja zaktualizowana pomyślnie',
    'missing_documentations' => 'Brak dokumentacji',
    'only_add_products_from_same_store' => 'Możesz dodawać tylko produkty z tego samego sklepu',
    'checkout_only_one_store' => 'Możesz dokonać zakupu tylko z jednego sklepu',
    'coupon_code_invalid' => 'Kod kuponu jest nieprawidłowy',
    'recovered_from_previous_orders' => 'Przywrócono z poprzednich zamówień',
    'not_available' => 'Niedostępne',
    'available' => 'Dostępne',
    'stores_seo_title' => 'Sklepy',
    'stores_seo_description' => 'Poznaj nasze sklepy',
    'leave_empty_for_default' => 'Zostaw puste dla wartości domyślnej',
    'stores' => 'Sklepy',
    'total_products_found' => 'Znaleziono :total produktów',
    'language' => 'Język',
    'save_settings' => 'Zapisz ustawienia',
    'payout_info' => 'Informacje o wypłacie',
    'payment_method' => 'Metoda płatności',
    'bank_name' => 'Nazwa banku',
    'bank_code_ifsc' => 'Kod banku / IFSC',
    'account_holder_name' => 'Nazwa posiadacza konta',
    'account_number' => 'Numer konta',
    'upi_id' => 'ID UPI',
    'upi_id_helper' => 'Przykład: 123456789@paytm',
    'description' => 'Opis',
    'paypal_id' => 'ID PayPal',
    'pickup_location' => 'Miejsce odbioru',
    'pickup_location_helper' => 'Pełny adres do odbioru produktów',
    'contact_name' => 'Imię i nazwisko kontaktu',
    'contact_phone' => 'Telefon kontaktowy',
    'business_name' => 'Nazwa firmy',
    'tax_id' => 'NIP',
    'address' => 'Adres',
    'earnings' => 'Zarobki',
    'our_stores' => 'Nasze Sklepy',
    'quick_actions' => 'Szybkie akcje',
    'add_product' => 'Dodaj produkt',
    'product' => 'Produkt',
    'create_discount' => 'Utwórz zniżkę',
    'store_settings' => 'Ustawienia sklepu',
    'withdraw' => 'Wypłać',
    'store_performance' => 'Wyniki sklepu',
    'conversion_rate' => 'Wskaźnik konwersji',
    'avg_order_value' => 'Średnia wartość zamówienia',
    'fulfillment_rate' => 'Wskaźnik realizacji',
    'store_visibility' => 'Widoczność sklepu',
    'active' => 'Aktywny',
    'sales_reports' => 'Raporty sprzedaży',
    'revenues_in_label' => 'Przychody w :label',
    'earnings_in_label' => 'Zarobki w :label',
    'fees' => 'Opłaty',
    'congratulations_vendor' => 'Gratulacje! Rejestracja sprzedawcy zakończona sukcesem!',
    'attract_customers_message' => 'Przyciągnijmy klientów, dodając Twój pierwszy produkt.',
    'create_new_product_here' => 'Utwórz nowy produkt tutaj',
    'no_orders_yet_message' => 'Brak zamówień. Zobacz swój sklep, aby upewnić się, że wygląda świetnie dla klientów.',
    'view_your_store_here' => 'Zobacz swój sklep tutaj',
    'includes_order_statuses' => 'Zawiera zamówienia ze statusami: :statuses.',
    'wait_for_approval' => 'Czekaj na zatwierdzenie',
    'uploaded_certificate' => 'Certyfikat przesłany',
    'uploaded_government_id' => 'Dowód tożsamości przesłany',
    'store' => 'Sklep',
    'tax_info' => 'Informacje podatkowe',
    'joined_on_date' => 'Dołączył :date',
    'view_your_store' => 'Zobacz swój sklep',
    'go_to_homepage' => 'Przejdź do strony głównej',
    'recent_orders' => 'Ostatnie zamówienia',
    'no_orders' => 'Brak zamówień',
    'view_full_orders' => 'Zobacz wszystkie zamówienia',
    'customer_reviews' => 'Recenzje klientów',
    'no_reviews_yet' => 'Brak recenzji',
    'reviews_require_ecommerce' => 'Aby zobaczyć recenzje, włącz wtyczkę Reviews w wtyczce Ecommerce.',
    'view_all_products' => 'Zobacz wszystkie produkty',
    'top_selling_products' => 'Najlepiej sprzedające się produkty',
    'no_products' => 'Brak produktów',
    'view_full_products' => 'Zobacz wszystkie produkty',
    'inventory_status' => 'Stan magazynu',
    'in_stock' => 'Na stanie',
    'low_stock' => 'Niski stan',
    'out_of_stock' => 'Wyprzedane',
    'add_new_product' => 'Dodaj nowy produkt',
];
