<?php

return [
    'name' => 'Mercado',
    'email' => [
        'withdrawal_approved_title' => 'Saque aprovado',
        'verify_vendor_title' => 'Verificar vendedor',
        'vendor_account_approved_title' => 'Conta do vendedor aprovada',
        'product_approved_title' => 'Produto aprovado',
        'pending_product_approval_title' => 'Aprovação do produto pendente',
        'pending_product_approval_description' => 'Enviar email ao admin quando o vendedor incluir seus produtos',
        'product_approved_description' => 'Enviar email ao vendedor quando seus produtos forem aprovados',
        'store_new_order_description' => 'Enviar email para o dono da loja quando um pedido for realizado',
        'store_new_order_title' => 'Informar sobre novo pedido',
        'vendor_account_approved_description' => 'Enviar email ao vendedor quando sua conta for aprovada',
        'verify_vendor_description' => 'Enviar email ao admin quando um vendedor for registrado',
        'withdrawal_approved_description' => 'Enviar um email ao vendedor quando sua solicitação de saque for aprovada',
        'title' => 'Mercado',
        'description' => 'Configurar modelos de e-mail para o Marketplace',
        'vendor_account_rejected_title' => 'Conta de fornecedor rejeitada',
        'vendor_account_rejected_description' => 'Enviar e-mail ao fornecedor quando sua conta for rejeitada',
        'vendor_account_unblocked_title' => 'Conta de fornecedor desbloqueada',
        'vendor_account_unblocked_description' => 'Enviar e-mail ao fornecedor quando sua conta for desbloqueada',
        'vendor_account_blocked_title' => 'Conta de fornecedor bloqueada',
        'vendor_account_blocked_description' => 'Enviar e-mail ao fornecedor quando sua conta for bloqueada',
        'store_new_order_subject' => 'Novo(s) pedido(s) em {{ site_title }}',
        'verify_vendor_subject' => 'O novo fornecedor em {{ site_title }} precisa ser verificado',
        'vendor_account_approved_subject' => 'Sua conta foi aprovada para venda em {{ site_title }}',
        'vendor_account_rejected_subject' => 'Sua conta foi rejeitada por venda em {{ site_title }}',
        'pending_product_approval_subject' => 'O novo produto precisa ser aprovado para venda em {{ site_title }}',
        'product_approved_subject' => 'Seu produto foi aprovado para venda em {{ site_title }}',
        'withdrawal_approved_subject' => 'Sua solicitação de saque foi aprovada',
        'welcome_vendor_title' => 'Bem-vindo fornecedor',
        'welcome_vendor_description' => 'Enviar e-mail para o fornecedor após cadastrado',
        'welcome_vendor_subject' => 'Bem-vindo ao {{ site_title }}!',
        'contact_store_title' => 'Contate a loja',
        'contact_store_description' => 'Envie um e-mail ao proprietário da loja quando um cliente entrar em contato com a loja',
        'contact_store_subject' => 'Nova mensagem de contato do cliente',
        'vendor_account_blocked_subject' => 'Sua conta de fornecedor em {{ site_title }} foi bloqueada',
        'vendor_account_unblocked_subject' => 'Sua conta de fornecedor em {{ site_title }} foi desbloqueada',
        'store' => 'Loja',
        'order' => 'Ordem',
        'shipment' => 'Informações de envio',
        'address' => 'Endereço para envio',
        'products' => 'Encomendar produtos',
        'customer_message' => 'Mensagem do cliente',
        'customer_name' => 'Nome do cliente',
        'customer_email' => 'E-mail do cliente',
        'block_reason' => 'Motivo do bloqueio',
        'block_date' => 'Data do bloqueio',
        'unblock_date' => 'Data de desbloqueio',
        'order_cancellation_to_vendor_title' => 'Cancelamento de pedido (será enviado ao vendedor (fornecedor))',
        'order_cancellation_to_vendor_description' => 'Enviar ao vendedor (fornecedor) quando o cliente cancelar um pedido',
        'order_cancellation_to_vendor_subject' => 'O pedido :order_id foi cancelado pelo cliente',
        'store_verified_title' => 'Verificação da loja aprovada',
        'store_verified_description' => 'Enviar notificação quando a loja for verificada',
        'store_verified_subject' => 'Sua loja {{ store_name }} foi verificada',
        'store_unverified_title' => 'Verificação da loja removida',
        'store_unverified_description' => 'Enviar notificação quando a verificação da loja for removida',
        'store_unverified_subject' => 'Status de verificação alterado para {{ store_name }}',
        'verified_by' => 'Verificado por',
        'verified_at' => 'Verificado em',
        'unverified_by' => 'Não verificado por',
        'unverified_at' => 'Não verificado em',
        'verification_note' => 'Nota de verificação',
    ],
    'email_templates' => [
        'dear_vendor' => 'Prezado :vendor_name,',
        'dear_admin' => 'Prezado Administrador,',
        'hello' => 'Olá,',
        'happy_selling' => 'Boas vendas!',
        'email_sent_by_team' => 'Este e-mail foi enviado pela equipe {{ site_title }}.',
        'contact_store_sent_from' => 'Este e-mail foi enviado de :customer_name (:customer_email) através do formulário de contato do seu perfil em :site_title.',
        'contact_store_reply_instruction' => 'Você pode responder diretamente a este e-mail para responder a :customer_name (:customer_email).',
        'vendor_account_blocked_message' => 'Sua conta de fornecedor em {{ site_title }} foi <strong>bloqueada</strong> em :block_date.',
        'vendor_account_blocked_reason' => 'Motivo do bloqueio: :block_reason',
        'vendor_account_blocked_contact_support' => 'Se você acredita que isso é um erro ou tem alguma dúvida, entre em contato com nossa equipe de suporte.',
        'vendor_account_unblocked_message' => 'Temos o prazer de informar que sua conta de fornecedor em {{ site_title }} foi <strong>desbloqueada</strong> em :unblock_date.',
        'vendor_account_unblocked_resume' => 'Você pode agora acessar sua conta e retomar suas atividades.',
        'vendor_account_unblocked_questions' => 'Se você tiver alguma dúvida, sinta-se à vontade para entrar em contato com nossa equipe de suporte.',
        'vendor_account_approved_title' => 'Conta de fornecedor aprovada',
        'vendor_account_approved_message' => 'Sua conta foi aprovada para vender em nosso site <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Conta de fornecedor rejeitada',
        'vendor_account_rejected_message' => 'Lamentamos informar que sua conta não foi aprovada para vender em nosso site <a href=":site_url">:site_url</a>.',
        'store_new_order_title' => 'Pedido realizado com sucesso!',
        'store_new_order_message' => 'Você recebeu um novo pedido em :site_title!',
        'customer_information' => 'Informações do cliente',
        'field_name' => 'Nome',
        'field_phone' => 'Telefone',
        'field_email' => 'E-mail',
        'field_address' => 'Endereço',
        'field_note' => 'Observação',
        'order_number' => 'Número do pedido',
        'order_date' => 'Data do pedido',
        'shipping_method' => 'Método de envio',
        'payment_method' => 'Método de pagamento',
        'product_approved_title' => 'Produto aprovado',
        'product_approved_message' => 'Seu produto foi aprovado para venda em nosso site <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Aprovação de produto pendente',
        'pending_product_approval_message' => 'Novo produto foi criado por :store_name <a href=":product_url">:product_name</a> está aguardando aprovação.',
        'verify_vendor_title' => 'Verificar fornecedor',
        'verify_vendor_message' => 'Você tem um novo fornecedor que precisa ser verificado em :site_title!',
        'vendor_information' => 'Informações do fornecedor',
        'shop_information' => 'Informações da loja',
        'field_store_name' => 'Nome da loja',
        'field_store_phone' => 'Telefone da loja',
        'visit_store_button' => 'Visitar loja',
        'withdrawal_approved_title' => 'Saque aprovado',
        'withdrawal_approved_message' => 'Sua solicitação de pagamento foi aprovada, enviaremos <strong>:withdrawal_amount</strong> para suas informações bancárias em breve.',
        'order_cancellation_title' => 'O cliente cancelou o pedido :order_id',
        'order_cancellation_message' => 'O cliente :customer_name cancelou o pedido <strong>:order_id</strong> devido ao motivo :cancellation_reason.',
        'order_items_header' => 'Aqui está o que você pediu:',
        'welcome_vendor_title' => 'Bem-vindo fornecedor',
        'welcome_vendor_greeting' => 'Estamos felizes em recebê-lo em :store_name!',
        'welcome_vendor_registration_complete' => 'Seu registro de fornecedor foi concluído com sucesso e agora você faz parte de nossa vibrante comunidade de vendedores.',
        'welcome_vendor_next_steps' => 'Aqui está o que você pode fazer a seguir:',
        'welcome_vendor_step_login' => 'Faça login em sua conta de fornecedor usando suas credenciais.',
        'welcome_vendor_step_add_products' => 'Adicione seus produtos/serviços à sua loja. Certifique-se de fornecer descrições detalhadas e imagens atraentes para atrair potenciais compradores.',
        'welcome_vendor_support' => 'Se você tiver alguma dúvida ou precisar de assistência ao longo do caminho, nossa equipe de suporte está aqui para ajudá-lo. Sinta-se à vontade para entrar em contato!',
        'login_vendor_account_button' => 'Faça login na sua conta de fornecedor',
        'welcome_vendor_closing' => 'Estamos ansiosos para ver sua loja prosperar em :site_title!',
        'store_verified_title' => 'Verificação da loja aprovada',
        'store_verified_message' => 'Parabéns! Sua loja foi verificada com sucesso em <strong>:site_title</strong>. Este selo de verificação ajudará a construir confiança com seus clientes.',
        'dear_store_owner' => 'Prezado proprietário de :store_name,',
        'verification_details' => 'Detalhes da verificação',
        'store_verified_benefits' => 'Benefícios de ser verificado',
        'verified_badge_benefit' => 'Um selo de verificação exibido em sua loja',
        'increased_trust_benefit' => 'Maior confiança do cliente',
        'higher_visibility_benefit' => 'Maior visibilidade nos resultados de pesquisa',
        'visit_your_store' => 'Visite sua loja',
        'congratulations_verified' => 'Parabéns pela sua verificação!',
        'store_unverified_title' => 'Status de verificação da loja alterado',
        'store_unverified_message' => 'Lamentamos informar que o status de verificação de sua loja em <strong>:site_title</strong> foi alterado.',
        'unverification_details' => 'Detalhes da mudança de status',
        'store_unverified_impacts' => 'O que isso significa',
        'verified_badge_removed' => 'O selo de verificação foi removido da sua loja',
        'verification_benefits_lost' => 'Os benefícios da verificação não estão mais ativos',
        'store_unverified_next_steps' => 'Se você tiver alguma dúvida sobre esta decisão ou gostaria de discutir a re-verificação, por favor <strong>entre em contato com nossa equipe de suporte</strong>.',
        'contact_support' => 'Contatar suporte',
        'thank_you_understanding' => 'Obrigado pela compreensão.',
    ],
    'current_balance' => 'Saldo atual',
    'settings' => [
        'title' => 'Definições para o marketplace',
        'hide_store_phone_number' => 'Ocultar telefone da loja?',
        'enable_product_approval' => 'Permitir aprovação do produto',
        'verify_vendor' => 'Verificação do Vendedor ( Somente poderá publicar seus produtos após aprovação)',
        'fee_per_order' => 'Taxa por pedido (%)',
        'check_valid_signature' => 'Verificar assinatura do válida nos ganhos do vendedor',
        'description' => 'Taxa de comissão de configuração',
        'default_commission_fee' => 'Taxa de comissão padrão (%), sugestão: 2 ou 3',
        'enable_commission_fee_for_each_category' => 'Habilitar taxa de comissão para cada categoria?',
        'categories' => 'Categorias',
        'select_categories' => 'Selecione categorias..',
        'commission_fee' => 'Taxa de comissão (%)',
        'commission_fee_by_category' => 'Taxa de comissão por categoria (%)',
        'verify_vendor_helper' => 'Se ativado, o administrador deverá verificar o fornecedor antes de publicar sua lista de produtos.',
        'requires_vendor_documentations_verification' => 'Requer verificação de documentação do fornecedor',
        'requires_vendor_documentations_verification_helper' => 'Se ativado, os fornecedores deverão fazer upload de seus arquivos de documentação ao se inscreverem para se tornarem fornecedores.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Ocultar o menu de tornar-se fornecedor no painel do cliente',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Se ativado, o menu “Torne-se um fornecedor” ficará oculto no painel do cliente.',
        'enable_product_approval_description' => 'Se ativado, o administrador deverá aprovar o produto antes de ser publicado.',
        'hide_store_email' => 'Ocultar e-mail da loja?',
        'hide_store_address' => 'Ocultar endereço da loja?',
        'hide_store_social_links' => 'Ocultar links sociais da loja?',
        'allow_vendor_manage_shipping' => 'Permitir que o fornecedor gerencie o frete?',
        'allow_vendor_manage_shipping_description' => 'Se estiver habilitado, o fornecedor pode alterar o status de envio do pedido para "entregando", "entregue", ...',
        'commission_fee_each_category_fee_name' => 'Taxa de comissão da configuração de comissão :key',
        'commission_fee_each_category_name' => 'Categorias da configuração de comissão :key',
        'add_new' => 'Adicionar novo',
        'payout_methods' => 'Métodos de pagamento',
        'max_upload_filesize' => 'Tamanho máximo do arquivo de upload (MB)',
        'max_upload_filesize_placeholder' => 'Padrão: 10',
        'max_product_images_upload_by_vendor' => 'Número máximo de imagens para cada produto',
        'enable_vendor_registration' => 'Habilitar registro de fornecedor',
        'enable_vendor_registration_helper' => 'Se ativado, os fornecedores podem registrar uma conta no site e publicar seus produtos.',
        'minimum_withdrawal_amount' => 'Valor mínimo de retirada (fixo)',
        'minimum_withdrawal_amount_helper' => 'Especifique o valor mínimo que um fornecedor pode sacar. O padrão é 0.',
        'allow_vendor_delete_their_orders' => 'Permitir que os fornecedores excluam seus pedidos',
        'allow_vendor_delete_their_orders_description' => 'Quando ativado, os fornecedores podem gerenciar sua lista de pedidos removendo entradas indesejadas. Use com cuidado, pois os pedidos excluídos podem afetar os registros de transações.',
        'enable_messaging_system' => 'Habilitar sistema de mensagens',
        'enable_messaging_system_description' => 'Se ativado, fornecedores e clientes poderão se comunicar entre si por meio do sistema de mensagens.',
        'term_and_privacy_policy_url' => 'URL do termo e da política de privacidade',
        'show_vendor_registration_form_at_registration_page' => 'Mostrar formulário de registro de fornecedor na página de registro',
        'show_vendor_registration_form_at_registration_page_description' => 'Se ativado, o formulário de registro do fornecedor será exibido na página de registro.',
        'single_vendor_checkout' => 'Limite a um fornecedor por pedido',
        'single_vendor_checkout_help' => 'Se ativado, os clientes só poderão comprar produtos de um fornecedor por pedido.',
        'fee_withdrawal_amount' => 'Taxa de saque',
        'withdrawal_fee_type' => 'Tipo de taxa de saque',
        'withdrawal_fee_types' => [
            'fixed' => 'Valor fixo',
            'percentage' => 'Porcentagem',
        ],
        'enable_vendor_categories_filter' => 'Habilitar filtro de categorias de fornecedores',
        'enable_vendor_categories_filter_description' => 'Mostrar filtro de categorias na página da loja do fornecedor. Somente categorias que possuem produtos do fornecedor serão exibidas.',
        'charge_shipping_per_vendor' => 'Cobrar frete por fornecedor?',
        'charge_shipping_per_vendor_description' => 'Se ativado, o frete será cobrado separadamente para cada fornecedor. Se desativado, o frete será cobrado uma vez para todo o pedido.',
        'display_order_total_info_for_each_store' => 'Exibir informações do total do pedido para cada loja',
        'display_order_total_info_for_each_store_helper' => 'Se ativado, as informações totais do pedido serão exibidas para cada loja no resumo do pedido.',
        'show_vendor_info_at_checkout' => 'Mostrar informações do fornecedor no checkout',
        'show_vendor_info_at_checkout_helper' => 'Se ativado, as informações do fornecedor (nome, logotipo, avaliações) serão exibidas na página de checkout.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Tipos de arquivo de mídia que podem ser carregados pelo fornecedor',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Especifique os tipos de arquivo de mídia que os fornecedores podem fazer upload. Selecione-os na lista acima.',
    ],
    'theme_options' => [
        'name' => 'Mercado',
        'description' => 'Opções de tema para Marketplace',
        'logo_vendor_dashboard' => 'Logotipo no painel do fornecedor (o padrão é o logotipo principal)',
    ],
    'store_name' => 'Nome da loja',
    'store_email' => 'Email da loja',
    'store_phone' => 'Telefone da loja',
    'store_address' => 'Endereço da loja',
    'store_url' => 'URL da loja',
    'product_name' => 'Nome do produto',
    'product_url' => 'URL do produto',
    'withdrawal_amount' => 'Sacar montante',
    'helpers' => [
        'store_status' => 'Se você alterar o status diferente de ":status" a conta desta loja também mudará para ":customer"',
    ],
    'tables' => [
        'earnings' => 'Ganhos',
        'products_count' => 'Contagem de produtos',
    ],
    'vendors' => 'Fornecedores',
    'payout_payment_methods' => [
        'bank_transfer' => 'Transferência Bancária',
        'paypal' => 'PayPal',
        'cash' => 'Dinheiro',
    ],
    'reports' => [
        'name' => 'Relatórios',
        'total_fee_earnings' => 'Total de ganhos com taxas: :value',
        'total_fee' => 'Taxa total',
        'total_amount' => 'Montante total',
        'store_revenues' => 'Receitas da loja',
        'sale_commissions' => 'Comissões de venda',
        'fee' => 'Taxa (:symbol)',
        'amount' => 'Quantia (:symbol)',
        'top_performing_stores' => 'Lojas de melhor desempenho',
        'store_growth' => 'Crescimento da loja',
        'withdrawal_status_chart' => 'Status de saque',
        'product_distribution' => 'Distribuição de produtos por loja',
        'average_commission' => 'Taxa de comissão média',
        'recent_withdrawals' => 'Saques recentes',
        'number_of_stores' => 'Número de lojas',
        'number_of_products' => 'Número de produtos',
        'orders' => 'Pedidos',
        'revenue' => 'Receita',
        'increase' => ':count aumento',
        'decrease' => ':count diminuição',
    ],
    'vendor' => 'Fornecedor',
    'vendor_name' => 'Nome do fornecedor',
    'contact_store' => [
        'form_name' => 'Formulário de contato da loja',
    ],
    'store_statuses' => [
        'pending' => 'Pendente',
        'published' => 'Aprovado',
        'blocked' => 'Bloqueado',
    ],
    'view_vendor' => 'Ver fornecedor :name',
    'vendor_information' => 'Informações do fornecedor',
    'vendor_verified' => 'Fornecedor verificado',
    'vendor_not_verified' => 'Fornecedor não verificado',
    'vendor_verified_at' => 'Fornecedor verificado em',
    'view_certificate' => 'Ver certificado',
    'view_government_id' => 'Ver documento de identidade',
    'documents' => 'Documentos',
    'store_products' => 'Produtos da loja',
    'store_orders' => 'Pedidos da loja',
    'total_revenue' => 'Receita total',
    'total_earnings' => 'Ganhos totais',
    'pending_withdrawals' => 'Saques pendentes',
    'balance' => 'Saldo',
    'recent_products' => 'Produtos recentes',
    'products_count' => 'Produtos',
    'store_status' => 'Status da loja',
    'verified' => 'Verificado',
    'dashboard' => 'Painel',
    'products' => 'Produtos',
    'orders' => 'Pedidos',
    'coupons' => 'Cupons',
    'withdrawals' => 'Saques',
    'revenues' => 'Receitas',
    'messages' => 'Mensagens',
    'reviews' => 'Avaliações',
    'order_returns' => 'Devoluções de pedidos',
    'shipments' => 'Remessas',
    'vendor_dashboard' => 'Painel do fornecedor',
    'become_a_vendor' => 'Torne-se um fornecedor',
    'become_vendor' => 'Tornar-se fornecedor',
    'product_specification' => 'Especificação do produto',
    'specification_groups' => 'Grupos de especificação',
    'specification_attributes' => 'Atributos de especificação',
    'specification_tables' => 'Tabelas de especificação',
    'register_as' => 'Registrar-se como',
    'register' => 'Registrar',
    'i_am_customer' => 'Sou um cliente',
    'i_am_vendor' => 'Sou um fornecedor',
    'i_agree_to_terms' => 'Concordo com :link',
    'i_agree_to_terms_simple' => 'Concordo com os termos e condições',
    'terms_and_privacy_policy' => 'Termos e política de privacidade',
    'send_message_successfully' => 'Mensagem enviada com sucesso!',
    'cannot_send_message_to_own_store' => 'Você não pode enviar uma mensagem para sua própria loja.',
    'vendor_account_not_verified' => 'A conta do fornecedor não está verificada.',
    'invalid_signature' => 'Assinatura inválida das informações do fornecedor',
    'file_not_found' => 'Arquivo não encontrado!',
    'update_successfully' => 'Atualizado com sucesso!',
    'shop_url_exists' => 'URL da loja já existe. Por favor, escolha outra!',
    'insufficient_balance' => 'Saldo insuficiente ou sem informações bancárias',
    'total_amount_exceeds_balance' => 'O valor total (incluindo taxa) excede seu saldo atual',
    'registered_successfully' => 'Registrado com sucesso!',
    'updated_registration_successfully' => 'Informações de registro atualizadas com sucesso!',
    'missing_documentations' => 'Documentação ausente! Faça upload do seu certificado de incorporação e documento de identidade para continuar.',
    'only_add_products_from_same_store' => 'Você só pode adicionar produtos da mesma loja ao carrinho.',
    'checkout_only_one_store' => 'O checkout está disponível apenas para produtos de uma loja por vez. Remova itens de outras lojas antes de prosseguir.',
    'coupon_code_invalid' => 'O código do cupom não é válido ou não se aplica aos produtos',
    'recovered_from_previous_orders' => 'Você recuperou de pedidos anteriores!',
    'not_available' => 'Não disponível',
    'available' => 'Disponível',
    'stores_seo_title' => 'Título SEO da página de listagem de lojas',
    'stores_seo_description' => 'Descrição SEO da página de listagem de lojas',
    'leave_empty_for_default' => 'Deixe em branco para usar a descrição padrão.',
    'stores' => 'Lojas',
    'total_products_found' => ':total produtos encontrados',
    'language' => 'Idioma',
    'save_settings' => 'Salvar configurações',
    'payout_info' => 'Informações de pagamento',
    'payment_method' => 'Método de pagamento',
    'bank_name' => 'Nome do banco',
    'bank_code_ifsc' => 'Código do banco/IFSC',
    'account_holder_name' => 'Nome do titular da conta',
    'account_number' => 'Número da conta',
    'upi_id' => 'ID UPI',
    'upi_id_helper' => 'É opcional. Se você tiver um ID UPI, pode fornecê-lo aqui. Saiba mais: https://support.google.com/pay/india/answer/10331134?hl=en',
    'description' => 'Descrição',
    'paypal_id' => 'ID do PayPal',
    'pickup_location' => 'Local de coleta',
    'pickup_location_helper' => 'Onde você gostaria de coletar seu pagamento em dinheiro?',
    'contact_name' => 'Nome de contato',
    'contact_phone' => 'Telefone de contato',
    'business_name' => 'Nome da empresa',
    'tax_id' => 'ID fiscal',
    'address' => 'Endereço',
    'earnings' => 'Ganhos',
    'our_stores' => 'Nossas lojas',
    'quick_actions' => 'Ações rápidas',
    'add_product' => 'Adicionar produto',
    'product' => 'Produto',
    'create_discount' => 'Criar desconto',
    'store_settings' => 'Configurações da loja',
    'withdraw' => 'Sacar',
    'store_performance' => 'Desempenho da loja',
    'conversion_rate' => 'Taxa de conversão',
    'avg_order_value' => 'Valor médio do pedido',
    'fulfillment_rate' => 'Taxa de atendimento',
    'store_visibility' => 'Visibilidade da loja',
    'active' => 'Ativo',
    'sales_reports' => 'Relatórios de vendas',
    'revenues_in_label' => 'Receitas em :label',
    'earnings_in_label' => 'Ganhos em :label',
    'fees' => 'Taxas',
    'congratulations_vendor' => 'Parabéns por ser um fornecedor em :site_title',
    'attract_customers_message' => 'Atraia seus clientes com os melhores produtos.',
    'create_new_product_here' => 'Crie um novo produto <a href=":url">aqui</a>',
    'no_orders_yet_message' => 'Você tem :total produto(s), mas ainda não tem pedidos',
    'view_your_store_here' => 'Veja sua loja <a href=":url">aqui</a>',
    'includes_order_statuses' => 'Inclui status Concluído, Pendente e Processando',
    'wait_for_approval' => 'Aguarde a revisão e aprovação do administrador!',
    'uploaded_certificate' => 'Certificado carregado',
    'uploaded_government_id' => 'Documento de identidade carregado',
    'store' => 'Loja',
    'tax_info' => 'Informações fiscais',
    'joined_on_date' => 'Entrou em :date',
    'view_your_store' => 'Ver sua loja',
    'go_to_homepage' => 'Ir para a página inicial',
    'recent_orders' => 'Pedidos recentes',
    'no_orders' => 'Sem pedidos!',
    'view_full_orders' => 'Ver todos os pedidos',
    'customer_reviews' => 'Avaliações de clientes',
    'no_reviews_yet' => 'Ainda sem avaliações',
    'reviews_require_ecommerce' => 'O recurso de avaliações requer o plugin de comércio eletrônico',
    'view_all_products' => 'Ver todos os produtos',
    'top_selling_products' => 'Produtos mais vendidos',
    'no_products' => 'Sem produtos!',
    'view_full_products' => 'Ver todos os produtos',
    'inventory_status' => 'Status do estoque',
    'in_stock' => 'Em estoque',
    'low_stock' => 'Estoque baixo',
    'out_of_stock' => 'Fora de estoque',
    'add_new_product' => 'Adicionar novo produto',
];
