<?php

return [
    'name' => 'Newsletters',
    'newsletter_form' => 'Newsletters form',
    'description' => 'View and delete newsletter subscribers',
    'settings' => [
        'email' => [
            'templates' => [
                'title' => 'Newsletter',
                'description' => 'Config newsletter email templates',
                'to_admin' => [
                    'title' => 'Email send to admin',
                    'description' => 'Template for sending email to admin',
                    'subject' => 'New user subscribed your newsletter',
                    'newsletter_email' => 'Email of user who subscribe newsletter',
                ],
                'to_user' => [
                    'title' => 'Email send to user',
                    'description' => 'Template for sending email to subscriber',
                    'subject' => '{{ site_title }}: Subscription Confirmed!',
                    'newsletter_name' => 'Full name of user who subscribe newsletter',
                    'newsletter_email' => 'Email of user who subscribe newsletter',
                    'newsletter_unsubscribe_link' => 'Link for unsubscribe newsletter',
                    'newsletter_unsubscribe_url' => 'URL for unsubscribe newsletter',
                ],
            ],
        ],
        'title' => 'Newsletter',
        'panel_description' => 'View and update newsletter settings',
        'description' => 'Settings for newsletter (auto send newsletter email to SendGrid, Mailchimp... when someone register newsletter on website).',
        'mailchimp_api_key' => 'Mailchimp API Key',
        'mailchimp_api_key_helper' => 'Enter your Mailchimp API key to automatically sync newsletter subscribers. Get your API key from Mailchimp: Account → Extras → API Keys → Create A Key.',
        'mailchimp_api_key_instruction' => 'To get your API key: Login to Mailchimp → Click your profile name → Account → Extras → API keys → Create A Key. <a href="https://mailchimp.com/help/about-api-keys/" target="_blank" rel="noopener">Learn more</a>',
        'mailchimp_list_id' => 'Mailchimp List ID',
        'mailchimp_list_id_helper' => 'Enter your Mailchimp Audience (List) ID where subscribers will be added.',
        'mailchimp_list' => 'Mailchimp List',
        'mailchimp_list_helper' => 'Select the Mailchimp audience list where new subscribers will be automatically added.',
        'sendgrid_api_key' => 'SendGrid API Key',
        'sendgrid_api_key_helper' => 'Enter your SendGrid API key to automatically sync newsletter subscribers. The API key must have "Marketing" permissions enabled.',
        'sendgrid_api_key_instruction' => 'To create an API key: Login to SendGrid → Settings → API Keys → Create API Key → Select "Restricted Access" → Enable "Marketing" permissions. <a href="https://docs.sendgrid.com/ui/account-and-settings/api-keys" target="_blank" rel="noopener">Learn more</a>',
        'sendgrid_list_id' => 'SendGrid List ID',
        'sendgrid_list_id_helper' => 'Enter your SendGrid contact list ID where subscribers will be added.',
        'sendgrid_list' => 'SendGrid List',
        'sendgrid_list_helper' => 'Select the SendGrid contact list where new subscribers will be automatically added.',
        'enable_newsletter_contacts_list_api' => 'Enable newsletter contacts list API?',
        'enable_newsletter_contacts_list_api_helper' => 'When enabled, new newsletter subscribers will be automatically synced to your email marketing service (Mailchimp or SendGrid). This allows you to manage and send campaigns through your preferred platform.',
    ],
    'statuses' => [
        'subscribed' => 'Subscribed',
        'unsubscribed' => 'Unsubscribed',
    ],
    'email_templates' => [
        // Admin email template
        'admin_new_subscriber_title' => 'New Subscriber',
        'admin_new_subscriber_message' => 'New user has been subscribed your newsletter:',

        // Subscriber email template
        'subscriber_success_title' => 'Subscribe Successfully',
        'subscriber_thank_you_message' => 'Thank you for subscribing our newsletter!',
        'subscriber_unsubscribe_instruction' => 'To unsubscribe newsletter, click :newsletter_unsubscribe_link',
    ],

    'enter_your_email' => 'Enter Your Email',
    'subscribe' => 'Subscribe',
    'newsletter_popup' => 'Newsletter Popup',
    'enable_newsletter_popup' => 'Enable Newsletter Popup',
    'popup_image' => 'Desktop Image',
    'popup_image_helper' => 'For devices with width from 1200px and above.',
    'popup_tablet_image' => 'Tablet Image',
    'popup_tablet_image_helper' => 'For devices with width from 768px to 1199px. If empty, will use the desktop image.',
    'popup_mobile_image' => 'Mobile Image',
    'popup_mobile_image_helper' => 'For devices with width less than 768px. If empty, will use the tablet image.',
    'popup_title' => 'Popup Title',
    'popup_subtitle' => 'Popup Subtitle',
    'popup_description' => 'Popup Description',
    'popup_delay_seconds' => 'Popup Delay (seconds)',
    'popup_delay_helper' => 'The delay time before showing the newsletter popup after the page loads. Set to 0 to show immediately. Default is 5 seconds.',
    'display_on_pages' => 'Display on pages',
    'homepage' => 'Homepage',
    'all_pages' => 'All Pages',
    'subscribe_success' => 'Subscribe to newsletter successfully!',
    'unsubscribe_success' => 'Unsubscribe to newsletter successfully',
    'email_not_exist_or_unsubscribed' => 'Your email does not exist in the system or you have unsubscribed already!',
    'email_address' => 'Email Address',
    'dont_show_popup_again' => "Don't show this popup again",
    'here' => 'here',
];
