<?php

return [
    'name' => 'Boletines',
    'newsletter_form' => 'Formulario de boletines',
    'description' => 'Ver y eliminar suscriptores del boletín',
    'settings' => [
        'email' => [
            'templates' => [
                'title' => 'Boletin informativo',
                'description' => 'Configurar plantillas de correo electrónico para boletines',
                'to_admin' => [
                    'title' => 'Enviar correo electrónico al administrador',
                    'description' => 'Plantilla para enviar correo electrónico al administrador',
                    'subject' => 'Nuevo usuario suscrito a tu boletín',
                    'newsletter_email' => 'Correo electrónico del usuario que se suscribe al boletín',
                ],
                'to_user' => [
                    'title' => 'Enviar correo electrónico al usuario',
                    'description' => 'Plantilla para enviar correo electrónico al suscriptor',
                    'subject' => '{{ site_title }}: ¡Suscripción confirmada!',
                    'newsletter_name' => 'Nombre completo del usuario que se suscribe al boletín',
                    'newsletter_email' => 'Correo electrónico del usuario que se suscribe al boletín',
                    'newsletter_unsubscribe_link' => 'Enlace para darse de baja del boletín',
                    'newsletter_unsubscribe_url' => 'URL para darse de baja del boletín',
                ],
            ],
        ],
        'title' => 'Boletin informativo',
        'description' => 'Configuración del boletín (enviar automáticamente el boletín por correo electrónico a SendGrid, Mailchimp... cuando alguien se registra en el boletín en el sitio web).',
        'mailchimp_api_key' => 'Clave API de Mailchimp',
        'mailchimp_api_key_helper' => 'Ingrese su clave API de Mailchimp para sincronizar automáticamente los suscriptores del boletín. Obtenga su clave API desde Mailchimp: Cuenta → Extras → Claves API → Crear una clave.',
        'mailchimp_api_key_instruction' => 'Para obtener su clave API: Inicie sesión en Mailchimp → Haga clic en su nombre de perfil → Cuenta → Extras → Claves API → Crear una clave. <a href="https://mailchimp.com/help/about-api-keys/" target="_blank" rel="noopener">Más información</a>',
        'mailchimp_list_id' => 'ID de lista de Mailchimp',
        'mailchimp_list_id_helper' => 'Ingrese el ID de audiencia (lista) de Mailchimp donde se agregarán los suscriptores.',
        'mailchimp_list' => 'Lista de MailChimp',
        'mailchimp_list_helper' => 'Seleccione la lista de audiencia de Mailchimp donde se agregarán automáticamente los nuevos suscriptores.',
        'sendgrid_api_key' => 'Clave API de SendGrid',
        'sendgrid_api_key_helper' => 'Ingrese su clave API de SendGrid para sincronizar automáticamente los suscriptores del boletín. La clave API debe tener permisos de "Marketing" habilitados.',
        'sendgrid_api_key_instruction' => 'Para crear una clave API: Inicie sesión en SendGrid → Configuración → Claves API → Crear clave API → Seleccione "Acceso restringido" → Habilite permisos de "Marketing". <a href="https://docs.sendgrid.com/ui/account-and-settings/api-keys" target="_blank" rel="noopener">Más información</a>',
        'sendgrid_list_id' => 'ID de lista de Sendgrid',
        'sendgrid_list_id_helper' => 'Ingrese el ID de lista de contactos de SendGrid donde se agregarán los suscriptores.',
        'sendgrid_list' => 'Lista de cuadrícula de envío',
        'sendgrid_list_helper' => 'Seleccione la lista de contactos de SendGrid donde se agregarán automáticamente los nuevos suscriptores.',
        'panel_description' => 'Ver y actualizar la configuración del boletín',
        'enable_newsletter_contacts_list_api' => '¿Habilitar la API de la lista de contactos del boletín?',
        'enable_newsletter_contacts_list_api_helper' => 'Cuando está habilitado, los nuevos suscriptores del boletín se sincronizarán automáticamente con su servicio de marketing por correo electrónico (Mailchimp o SendGrid). Esto le permite administrar y enviar campañas a través de su plataforma preferida.',
    ],
    'statuses' => [
        'subscribed' => 'Suscrito',
        'unsubscribed' => 'Dado de baja',
    ],
    'email_templates' => [
        // Admin email template
        'admin_new_subscriber_title' => 'Nuevo suscriptor',
        'admin_new_subscriber_message' => 'Un nuevo usuario se ha suscrito a tu boletín:',

        // Subscriber email template
        'subscriber_success_title' => 'Suscripción exitosa',
        'subscriber_thank_you_message' => '¡Gracias por suscribirte a nuestro boletín!',
        'subscriber_unsubscribe_instruction' => 'Para darte de baja del boletín, haz clic en :newsletter_unsubscribe_link',
    ],

    'enter_your_email' => 'Ingrese su correo electrónico',
    'subscribe' => 'Suscribir',
    'newsletter_popup' => 'Ventana emergente del boletín',
    'enable_newsletter_popup' => 'Habilitar ventana emergente de boletín',
    'popup_image' => 'Imagen de escritorio',
    'popup_image_helper' => 'Para dispositivos con un ancho de 1200px o más.',
    'popup_tablet_image' => 'Imagen de tableta',
    'popup_tablet_image_helper' => 'Para dispositivos con un ancho de 768px a 1199px. Si está vacío, se utilizará la imagen de escritorio.',
    'popup_mobile_image' => 'Imagen móvil',
    'popup_mobile_image_helper' => 'Para dispositivos con un ancho menor a 768px. Si está vacío, se utilizará la imagen de tableta.',
    'popup_title' => 'Título emergente',
    'popup_subtitle' => 'Subtítulo emergente',
    'popup_description' => 'Descripción emergente',
    'popup_delay_seconds' => 'Retraso de ventana emergente (segundos)',
    'popup_delay_helper' => 'El tiempo de demora antes de mostrar la ventana emergente del boletín después de que se carga la página. ',
    'display_on_pages' => 'Mostrar en páginas',
    'homepage' => 'Página principal',
    'all_pages' => 'Todas las páginas',
    'subscribe_success' => '¡Suscríbete al boletín con éxito!',
    'unsubscribe_success' => 'Cancelar la suscripción al boletín con éxito',
    'email_not_exist_or_unsubscribed' => '¡Tu correo electrónico no existe en el sistema o ya te has dado de baja!',
    'email_address' => 'Dirección de correo electrónico',
    'dont_show_popup_again' => 'No volver a mostrar esta ventana emergente',
    'here' => 'aquí',
];
