/* global jQuery, TRX_ADDONS_STORAGE */

let TRX_Addons_BP_Social_Network_Post_Actions = function () {



	let self = this,

		window_width = jQuery( window ).width();



	self.init_reactions = function () {



		if ( jQuery( '.trx_addons_bp_social_network_post_reaction_btn-js, .trx_addons_bp_social_network_post_reactions_item_btn-js, .trx_addons_bp_social_network_post_history_reaction_item_btn-js' ).length <= 0 ) {

			return false;

		}



		let init_reactions_sending = false;



		jQuery( document ).on( 'click', '.trx_addons_bp_social_network_post_reaction_btn-js, .trx_addons_bp_social_network_post_reactions_item_btn-js, .trx_addons_bp_social_network_post_history_reaction_item_btn-js', function (e) {



			e.preventDefault();



			let $btn = jQuery( this ),

				$check_parent = $btn.parent( '.trx_addons_bp_social_network_post_reactions-wrapper-js' );



			if ( ! init_reactions_sending && ! ( window_width < 1024 && $check_parent.length > 0 ) ) {



				init_reactions_sending = true;



				let $wrapper = $btn.closest( '.trx_addons_bp_social_network_post_reactions-wrapper-js' );



				if ( $wrapper.length <= 0 ) {

					$wrapper = $btn.closest( '.trx_addons_bp_social_network_post_history_reactions-js' ).parent().find( '.trx_addons_bp_social_network_post_reactions-wrapper-js' );

				}



				let $history = $wrapper.parent().find( '.trx_addons_bp_social_network_post_history_reactions-js' );



				jQuery.post( TRX_ADDONS_STORAGE['ajax_url'], {

					action: $btn.data( 'is_reacted' ) ? 'trx_addons_bp_social_network_post_remove_reaction' : 'trx_addons_bp_social_network_post_add_reaction',

					nonce: TRX_ADDONS_STORAGE['ajax_nonce'],

					post_id: $wrapper.data( 'post_id' ),

					user_id: $wrapper.data( 'user_id' ),

					reaction: $btn.data( 'reaction' ),

				} ).done( function( response ) {

					var rez = {};



					try {

						rez = JSON.parse( response );

					} catch (e) {

						rez = { error: TRX_ADDONS_STORAGE['msg_ajax_error'] };

						console.log( response );

					}



					if ( rez.error === '' ) {



						$wrapper.html( jQuery( rez.reaction_content ).html() );



						if ( $history.length > 0 ) {

							$history.replaceWith( jQuery( rez.history ) );

						} else {

							$wrapper.after( jQuery( rez.history ) );

						}

					} else {

						alert( TRX_ADDONS_STORAGE['msg_error_like'] );

					}



					if ( $wrapper.hasClass( 'open' ) ) {

						$wrapper.removeClass( 'open' );

					}

					init_reactions_sending = false;

				} );

			} else {



				if ( $check_parent.hasClass( 'open' ) ) {

					$check_parent.removeClass( 'open' );

				} else {

					$check_parent.addClass( 'open' );

				}

			}

		} );

	};



	self.init_resize = function () {

		jQuery( document ).on( 'action.resize_trx_addons', function () {

			window_width = jQuery( window ).width();

		} );

	};



	self.reinit_share_list = function () {

		jQuery( document ).on( 'click', '.trx_addons_bp_social_network_post_share_list-wrapper .socials_share .socials_caption:not(.inited)', function (e) {

			e.preventDefault();

			jQuery( document ).trigger( 'action.init_hidden_elements', [ jQuery( 'body' ) ] );

			jQuery( this ).trigger( 'click' );

		} );

	};



	self.init = function () {

		//reactions

		self.init_reactions();

		self.init_resize();



		//share

		self.reinit_share_list();

	};

};



jQuery(document).ready(function() {

	"use strict";



	let bp_social_network = new TRX_Addons_BP_Social_Network_Post_Actions();

	bp_social_network.init();

});