<?php
/* BP Classic support functions (addon for a compatibility with BuddyPress under 12.0.0)
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'anesta_bp_classic_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'anesta_bp_classic_theme_setup9', 9 );
	function anesta_bp_classic_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'anesta_filter_tgmpa_required_plugins', 'anesta_bp_classic_tgmpa_required_plugins' );
			add_filter( 'anesta_filter_theme_plugins', 'anesta_bp_classic_theme_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'anesta_bp_classic_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('anesta_filter_tgmpa_required_plugins',	'anesta_bp_classic_tgmpa_required_plugins');
	function anesta_bp_classic_tgmpa_required_plugins( $list = array() ) {
		if ( anesta_storage_isset( 'required_plugins', 'bp-classic' ) && anesta_storage_get_array( 'required_plugins', 'bp-classic', 'install' ) !== false ) {
			$list[] = array(
				'name'     => esc_html__( 'BP Classic', 'anesta' ),
				'slug'     => 'bp-classic',
				'required' => false,
			);
		}
		return $list;
	}
}

// Filter theme-supported plugins list
if ( ! function_exists( 'anesta_bp_classic_theme_plugins' ) ) {
	//Handler of the add_filter( 'anesta_filter_theme_plugins', 'anesta_bp_classic_theme_plugins' );
	function anesta_bp_classic_theme_plugins( $list = array() ) {
		if ( ! empty( $list['bbpress']['group'] ) ) {
			//$list['bbpress']['title'] = esc_html__( 'BBPress', 'anesta' );
			$list = anesta_add_group_and_logo_to_slave( $list, 'bbpress', 'bp-classic' );
		}
		return $list;
	}
}

// Check if BP Classic is installed and activated
if ( ! function_exists( 'anesta_exists_bp_classic' ) ) {
	function anesta_exists_bp_classic() {
		return class_exists( 'BP_Classic' );
	}
}
