<?php
$anesta_slider_sc = anesta_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $anesta_slider_sc ) && strpos( $anesta_slider_sc, '[' ) !== false && strpos( $anesta_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( anesta_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$anesta_anchor_icon = anesta_get_theme_option( 'front_page_title_anchor_icon' );
		$anesta_anchor_text = anesta_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $anesta_anchor_icon ) || ! empty( $anesta_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $anesta_anchor_icon ) ? ' icon="' . esc_attr( $anesta_anchor_icon ) . '"' : '' )
									. ( ! empty( $anesta_anchor_text ) ? ' title="' . esc_attr( $anesta_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $anesta_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$anesta_scheme = anesta_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $anesta_scheme ) && ! anesta_is_inherit( $anesta_scheme ) ) {
			echo ' scheme_' . esc_attr( $anesta_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( anesta_get_theme_option( 'front_page_title_paddings' ) );
		if ( anesta_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$anesta_css      = '';
		$anesta_bg_image = anesta_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $anesta_bg_image ) ) {
			$anesta_css .= 'background-image: url(' . esc_url( anesta_get_attachment_url( $anesta_bg_image ) ) . ');';
		}
		if ( ! empty( $anesta_css ) ) {
			echo ' style="' . esc_attr( $anesta_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$anesta_anchor_icon = anesta_get_theme_option( 'front_page_title_anchor_icon' );
		$anesta_anchor_text = anesta_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $anesta_anchor_icon ) || ! empty( $anesta_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $anesta_anchor_icon ) ? ' icon="' . esc_attr( $anesta_anchor_icon ) . '"' : '' )
									. ( ! empty( $anesta_anchor_text ) ? ' title="' . esc_attr( $anesta_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( anesta_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' anesta-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$anesta_css      = '';
			$anesta_bg_mask  = anesta_get_theme_option( 'front_page_title_bg_mask' );
			$anesta_bg_color_type = anesta_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $anesta_bg_color_type ) {
				$anesta_bg_color = anesta_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $anesta_bg_color_type ) {
				$anesta_bg_color = anesta_get_scheme_color( 'bg_color', $anesta_scheme );
			} else {
				$anesta_bg_color = '';
			}
			if ( ! empty( $anesta_bg_color ) && $anesta_bg_mask > 0 ) {
				$anesta_css .= 'background-color: ' . esc_attr(
					1 == $anesta_bg_mask ? $anesta_bg_color : anesta_hex2rgba( $anesta_bg_color, $anesta_bg_mask )
				) . ';';
			}
			if ( ! empty( $anesta_css ) ) {
				echo ' style="' . esc_attr( $anesta_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$anesta_caption = anesta_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $anesta_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $anesta_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $anesta_caption, 'anesta_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$anesta_description = anesta_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $anesta_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $anesta_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $anesta_description ), 'anesta_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( anesta_get_theme_option( 'front_page_title_button1_link' ) != '' || anesta_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						anesta_show_layout( anesta_customizer_partial_refresh_front_page_title_button1_link() );
						anesta_show_layout( anesta_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
