<?php
defined('ABSPATH') || exit;

if (!class_exists('Felan_Cookie')) {

	class Felan_Cookie
	{

		protected static $instance = null;

		public static function instance()
		{
			if (null === self::$instance) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		function initialize()
		{
			// Notice Cookie Confirm.
			add_action('wp_ajax_notice_cookie_confirm', array($this, 'notice_cookie_confirm'));
			add_action('wp_ajax_nopriv_notice_cookie_confirm', array($this, 'notice_cookie_confirm'));
		}

		public function notice_cookie_confirm()
		{
			setcookie('notice_cookie_confirm', 'yes', time() + 365 * 86400, COOKIEPATH, COOKIE_DOMAIN);

			wp_die();
		}

	function get_notice_cookie_messages()
	{
		$privacy_policy = Felan_Helper::felan_get_option('privacy_policy');
		$notice_messages = sprintf( esc_html__('This site uses cookies for the best user experience. %s', 'felan'), '<a href="' . esc_url(get_permalink($privacy_policy)) . '">' . esc_html__('Privacy Policy', 'felan') . '</a>' );
		$button_accept = esc_html__('Accept', 'felan');
		$button_not_accept = esc_html__('Not Accept', 'felan');

			$messages = '';
			$messages .= '<svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M3.49776 7.82403L2.56589 8.0384C2.56589 8.0384 1.27308 10.0334 0.99089 12.1553C0.813702 13.4875 0.807139 15.2265 0.92964 16.0928C1.05433 16.959 1.50058 18.8031 2.20276 20.1025C2.8787 21.3537 3.53714 21.8459 4.25683 22.2812C4.56526 22.4672 4.84089 23.1037 5.32214 23.4122C5.77277 23.7009 6.36776 23.7578 6.36776 23.7578C6.36776 23.7578 8.01276 26.3412 11.5718 26.7897C15.7478 27.3147 17.7909 25.429 17.7909 25.429C17.7909 25.429 19.4621 25.4247 21.0393 24.7487C22.809 23.9897 23.754 22.4103 23.754 22.4103C23.754 22.4103 25.97 20.5028 26.6721 18.219C27.2365 16.3859 27.2518 12.9012 26.8187 11.2606C26.3856 9.61997 25.5478 8.2309 24.8828 7.34059C24.3534 6.63184 18.4428 3.49059 17.7296 3.21059C17.0187 2.93278 10.3971 2.49965 10.15 2.68559C9.90277 2.87372 3.49776 7.82403 3.49776 7.82403Z" fill="#AC5811"/>
			<path d="M5.80339 4.32085C4.2612 5.57647 3.46276 6.23272 2.66214 7.80335C1.86151 9.37397 2.11964 11.4587 2.26401 12.2287C2.4062 12.9987 2.66432 14.484 2.80651 15.2255C2.9487 15.9693 3.32714 17.7324 4.37495 18.824C5.84276 20.353 7.17276 20.8802 7.17276 20.8802C7.17276 20.8802 8.2512 22.5515 10.8565 23.5074C14.2821 24.763 15.8243 22.9365 17.1368 22.4508C18.4493 21.9652 20.0199 21.9368 21.3631 20.994C22.704 20.0512 24.1893 18.9093 25.1606 16.5118C26.1318 14.1143 25.9306 13.0577 25.959 12.4584C25.9874 11.859 25.9021 8.97585 24.7887 7.20616C23.6753 5.43647 22.3365 4.37335 21.8203 4.03647C20.6784 3.29491 16.6009 1.52085 15.5749 1.32179C14.5468 1.12272 10.8806 1.43335 9.42589 2.03272C7.9712 2.6321 5.80339 4.32085 5.80339 4.32085Z" fill="url(#paint0_radial_5691_34328)"/>
			<path d="M12.3113 15.6318C12.0685 15.5552 11.8125 15.1943 11.7513 14.4221C11.666 13.3218 12.4775 13.0177 12.4775 13.0177C12.4775 13.0177 13.4444 12.7618 14.1247 12.519C14.7569 12.2937 15.2119 12.0049 15.2119 12.0049C15.2119 12.0049 15.2732 10.8259 15.6647 10.478C16.0585 10.1302 16.7519 10.1609 17.5241 10.2505C18.2941 10.3402 19.5344 10.8543 19.3528 11.3224C19.1713 11.7905 18.9591 12.2587 18.2197 12.683C17.4803 13.1052 16.951 13.499 16.5725 13.8315C16.1941 14.1662 15.5007 14.5862 14.3522 15.0105C13.2038 15.4349 12.6613 15.7412 12.3113 15.6318Z" fill="#FFC86E"/>
			<path d="M5.80787 5.79113C5.08162 5.64238 4.05568 7.21519 3.86537 7.73581C3.67287 8.25644 3.47599 9.52519 3.45412 10.1049C3.42568 10.8246 3.41255 11.5005 3.71443 12.0496C3.9463 12.4739 4.50849 12.7124 5.0138 12.2749C5.51912 11.8374 6.3963 10.6386 6.62818 10.4702C6.86005 10.3018 7.53818 10.0786 7.2713 8.97613C7.16193 8.5255 6.05287 7.59363 5.99818 7.46675C5.94568 7.34206 6.21912 5.87644 5.80787 5.79113Z" fill="#FFC86E"/>
			<path d="M10.9419 3.81436C10.9703 4.23655 11.3159 4.91249 11.69 5.2778C12.25 5.82249 14.8181 7.66436 15.4831 7.55936C16.1481 7.45436 16.8722 6.25999 17.0844 5.92749C17.2966 5.59499 17.7187 5.12686 17.885 4.91467C18.0512 4.70249 18.4887 4.21905 18.1278 3.73561C17.7647 3.25217 16.8591 2.93499 16.2553 2.88905C15.6516 2.84311 14.7131 2.45155 13.9125 2.48217C13.1119 2.5128 10.8675 2.72499 10.9419 3.81436Z" fill="#FFC86E"/>
			<path d="M21.5119 9.44658C21.5622 9.90595 22.2075 10.0066 22.7216 10.3391C23.2356 10.6716 23.5834 11.0194 23.8853 10.9275C24.1872 10.8378 24.5984 10.3544 24.5044 9.50783C24.3841 8.42064 23.7037 7.02939 22.7522 7.07533C22.1769 7.10376 22.2556 8.10345 22.2556 8.10345C22.2556 8.10345 21.4812 9.17533 21.5119 9.44658Z" fill="#FFC86E"/>
			<path d="M9.07153 6.61453C9.07153 6.61453 7.00872 6.60141 7.04591 6.80703C7.08528 7.01266 7.26466 7.69078 7.80278 7.71703C8.34091 7.74328 9.03434 7.79359 9.36684 7.69078C9.69934 7.58797 10.6225 6.84422 10.6225 6.51172C10.6225 6.17922 10.2506 5.69141 10.2506 5.69141L9.07153 6.61453Z" fill="#CF701E"/>
			<path d="M12.0181 10.3944C12.0181 10.3944 11.994 10.4097 11.959 10.4381C11.8562 10.5234 11.6593 10.7225 11.7359 10.9456C11.8387 11.2409 12.4403 11.7922 13.0309 11.7922C13.6215 11.7922 13.9409 11.2409 14.0437 10.8822C14.1465 10.5234 14.094 10.3047 14.094 10.3047L12.0181 10.3944Z" fill="#CF701E"/>
			<path d="M7.41775 12.0766C7.41775 12.0766 7.059 12.2056 7.07213 12.4353C7.08525 12.665 7.17494 13.0894 7.6365 13.5378C8.10244 13.9906 8.77838 14.1153 9.39307 13.9491C10.0078 13.7828 10.4562 13.3213 10.4059 12.7066C10.3556 12.0919 9.76494 11.6172 9.76494 11.6172L7.41775 12.0766Z" fill="#CF701E"/>
			<path d="M4.76435 15.4734C4.76435 15.4734 4.37935 15.5631 4.41872 15.8191C4.4581 16.075 4.89341 16.8822 5.58466 16.7925C6.27591 16.7028 7.36747 15.9087 7.36747 15.6003C7.36747 15.2919 6.81622 14.8828 6.81622 14.8828L4.76435 15.4734Z" fill="#CF701E"/>
			<path d="M9.4806 18.6758C9.4806 18.6758 9.33841 19.5027 10.454 19.8045C12.3134 20.3055 12.5059 19.1767 12.5059 19.1767L9.4806 18.6758Z" fill="#CF701E"/>
			<path d="M16.7846 19.0586C16.7846 19.0586 16.2859 19.5573 16.8525 19.9489C17.419 20.3405 18.0643 20.4739 18.6725 20.4061C19.2806 20.3383 19.6962 19.8527 19.6962 19.8527L16.7846 19.0586Z" fill="#CF701E"/>
			<path d="M21.4397 13.5195C21.4397 13.5195 20.4991 13.9942 21.2275 14.8145C21.781 15.4402 23.0475 15.3133 23.566 14.9611C23.905 14.7314 24.0057 14.3245 23.8788 14.1189C23.7497 13.9133 21.4397 13.5195 21.4397 13.5195Z" fill="#CF701E"/>
			<path d="M17.7997 8.08547C17.7997 8.08547 17.7493 9.15953 19.1975 9.12453C21.2231 9.07422 20.9671 7.81641 20.9671 7.81641L17.7997 8.08547Z" fill="#CF701E"/>
			<path d="M18.736 6.73998C18.736 6.73998 17.7866 7.33061 17.6838 7.57342C17.581 7.81623 17.3622 8.58623 18.4647 8.53592C19.5672 8.48561 20.6697 8.44623 21.0416 7.99779C21.4135 7.54936 21.3238 7.13811 21.1707 6.80561C21.0175 6.47311 20.1557 5.21529 19.471 5.23061C19.0225 5.23936 18.736 6.73998 18.736 6.73998Z" fill="#593329"/>
			<path d="M19.4666 5.22808C19.4666 5.22808 18.8651 5.15151 18.3379 6.08776C17.8129 7.02401 17.6772 7.58183 17.6772 7.58183C17.6772 7.58183 18.7469 7.5862 19.3879 7.50964C20.0288 7.43308 20.4641 7.03495 20.4641 7.03495C20.4641 7.03495 19.9413 5.34401 19.4666 5.22808Z" fill="#925849"/>
			<path d="M12.1866 9.59995C12.1866 9.59995 11.6616 9.56495 11.6222 9.76839C11.5828 9.97401 11.6987 10.4968 11.8781 10.7265C12.0575 10.9562 12.5956 11.4703 13.1337 11.3675C13.6719 11.2646 13.9913 10.7374 14.0809 10.5559C14.1619 10.3853 14.2494 10.2015 14.0963 9.97183C13.9409 9.73995 12.1866 9.59995 12.1866 9.59995Z" fill="#593329"/>
			<path d="M12.9676 8.7793C12.5213 8.73117 11.4451 9.58648 11.6376 9.87961C11.8519 10.2012 11.8891 9.99773 12.4797 10.293C12.9676 10.5359 13.1797 10.7612 13.486 10.7218C13.7922 10.6824 14.1576 10.1771 14.0941 9.97148C14.0307 9.76586 13.5713 8.84273 12.9676 8.7793Z" fill="#925849"/>
			<path d="M7.91653 5.31812L6.86653 6.04437C6.86653 6.04437 6.82715 6.53656 7.0459 6.80562C7.26465 7.07468 7.32809 7.24093 8.35403 7.24093C9.37997 7.24093 10.3403 7.10093 10.5197 6.37031C10.699 5.63968 10.384 5.17156 10.1915 4.90249C9.99903 4.63343 7.91653 5.31812 7.91653 5.31812Z" fill="#593329"/>
			<path d="M7.92974 4.17817C7.69349 4.27879 7.13568 5.03785 7.00661 5.37035C6.87755 5.70285 6.84911 6.05723 6.86661 6.0616C7.0788 6.1141 8.32786 6.23004 8.87911 6.14035C9.43036 6.05067 9.8788 5.80785 10.0582 5.48629C10.2004 5.23035 10.1894 4.89129 10.1894 4.89129C10.1894 4.89129 9.81536 4.21754 9.3013 4.01192C8.78943 3.80629 8.01943 4.13879 7.92974 4.17817Z" fill="#925949"/>
			<path d="M7.05035 12.1217C7.05035 12.1217 6.96285 12.2552 7.1291 12.5111C7.29535 12.7671 7.62129 13.0733 8.1091 13.2155C8.59692 13.3555 8.94254 13.548 9.26192 13.5108C9.58348 13.4714 10.2113 13.2155 10.2354 12.3317C10.2616 11.448 10.0822 11.0367 9.69723 10.6517C9.31223 10.2667 9.03442 10.3324 9.03442 10.3324L7.05035 12.1217Z" fill="#593329"/>
			<path d="M7.16193 11.3031C7.0263 11.5306 6.92568 12.2699 7.09193 12.4362C7.25818 12.6024 8.25787 12.6134 8.52037 12.5849C8.78505 12.5565 9.64911 12.1496 9.66224 11.8412C9.67536 11.5327 9.50912 11.1237 9.50912 10.9706C9.50912 10.8174 9.70162 10.4587 9.17662 10.3296C8.65162 10.2006 7.44193 10.8284 7.16193 11.3031Z" fill="#925849"/>
			<path d="M5.42937 14.624C5.42937 14.624 4.60468 14.8274 4.55218 15.1096C4.50187 15.3918 4.61999 15.6762 4.90218 15.9452C5.18437 16.2143 5.38999 16.4965 5.60655 16.4702C5.8253 16.444 6.40062 15.9321 6.57999 15.7658C6.75937 15.5996 7.0153 15.3043 6.99124 15.0615C6.96718 14.8187 6.86218 14.5737 6.63249 14.3812C6.40499 14.1887 5.42937 14.624 5.42937 14.624Z" fill="#593329"/>
			<path d="M5.63506 13.8948C5.25006 13.9035 4.95475 14.3695 4.82787 14.5357C4.69881 14.702 4.48225 15.1001 4.57193 15.1635C4.66162 15.227 5.0335 15.2663 5.21287 15.3823C5.39225 15.4982 5.66131 15.6776 5.86693 15.5113C6.07256 15.3451 6.25193 14.8835 6.35475 14.7304C6.45756 14.5773 6.63693 14.3848 6.63693 14.3848C6.63693 14.3848 6.24975 13.8817 5.63506 13.8948Z" fill="#925849"/>
			<path d="M10.3403 16.9848C10.2637 17.0745 9.17432 17.9583 9.17432 17.9583C9.17432 17.9583 9.21369 18.7283 9.4565 18.9077C9.69932 19.087 10.4562 19.343 10.944 19.4458C11.4318 19.5486 12.3024 19.6645 12.5212 19.5748C12.7399 19.4852 12.9696 19.0105 12.9828 18.3958C12.9959 17.7811 12.7771 17.3217 12.5343 17.0395C12.2915 16.7573 12.0968 16.6523 12.0968 16.6523L10.3403 16.9848Z" fill="#593329"/>
			<path d="M11.7885 18.1361C11.9307 17.9764 12.0969 16.6486 12.0969 16.6486C12.0969 16.6486 11.1104 15.8917 10.6991 15.8414C10.2879 15.7911 9.80223 15.8283 9.66004 15.9814C9.52004 16.1345 8.96879 16.6858 9.0191 17.0445C9.06942 17.4033 9.17223 17.9545 9.17223 17.9545C9.17223 17.9545 11.4932 18.4708 11.7885 18.1361Z" fill="#925849"/>
			<path d="M16.5703 18.7674C16.5703 18.7674 16.4456 19.5987 17.36 19.7562C18.2744 19.9115 19.0334 20.1193 19.4294 20.0362C19.8253 19.9531 20.2191 19.4237 20.2606 19.0387C20.3022 18.6537 20.3241 18.0981 20.2606 17.9471C20.0944 17.5468 19.3244 16.4509 18.9503 16.3349C18.7403 16.2715 18.5412 16.3065 18.5412 16.3065L16.5703 18.7674Z" fill="#593329"/>
			<path d="M17.1631 17.3133C16.754 17.7661 16.544 18.4202 16.5659 18.7658C16.5878 19.0918 18.1387 18.9496 18.3224 18.838C18.5062 18.7265 18.9065 18.2277 18.9196 18.0615C18.9328 17.8952 18.8059 17.3746 18.784 17.053C18.7621 16.7315 18.7534 16.294 18.5762 16.3049C18.399 16.3158 17.7449 16.6702 17.1631 17.3133Z" fill="#925849"/>
			<path d="M22.4088 11.668C22.4088 11.668 22.7697 11.7205 23.2138 11.9873C23.7322 12.298 24.2747 13.0898 24.2331 13.7352C24.1916 14.3805 23.6294 14.6714 22.9447 14.6823C22.26 14.6933 21.5906 14.6561 21.4659 14.3017C21.3413 13.9473 22.4088 11.668 22.4088 11.668Z" fill="#593329"/>
			<path d="M21.8619 11.8829C21.7547 12.0316 21.4769 12.4866 21.3828 13.0685C21.2888 13.6504 21.3522 14.3154 21.56 14.4313C21.7678 14.5451 22.9119 13.5585 22.9731 13.4535C23.0366 13.3485 22.6078 11.7582 22.4722 11.686C22.3366 11.6138 21.9975 11.697 21.8619 11.8829Z" fill="#925849"/>
			<defs>
			<radialGradient id="paint0_radial_5691_34328" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(14.0358 12.5997) scale(11.6379)">
			<stop offset="0.507" stop-color="#F29F58"/>
			<stop offset="0.715" stop-color="#F09D56"/>
			<stop offset="0.826" stop-color="#EB9550"/>
			<stop offset="0.914" stop-color="#E18745"/>
			<stop offset="0.99" stop-color="#D47436"/>
			<stop offset="1" stop-color="#D27133"/>
			</radialGradient>
			</defs>
			</svg>';
			$messages .= '<p>' . $notice_messages . '</p>';
			$messages .= '<div class="btn">';
			$messages .= '<a id="felan-button-cookie-notice-not-ok" class="felan-button text size-xs wide">' . $button_not_accept . '</a>';
			$messages .= '<a id="felan-button-cookie-notice-ok" class="felan-button full-filled size-xs wide">' . $button_accept . '</a>';
			$messages .= '</div>';

			return $messages;
		}
	}

	Felan_Cookie::instance()->initialize();
}
