<?php

if (!defined('ABSPATH')) {
    exit;
}

class Felan_WooCommerce_Notice_Remover
{

    public function __construct()
    {
        add_action('init', array($this, 'init'));
    }

    public function init()
    {
        if (!class_exists('WooCommerce')) {
            return;
        }

        add_action('admin_notices', array($this, 'remove_template_outdated_notices'), 1);
        add_action('admin_notices', array($this, 'remove_woocommerce_admin_notices'), 1);
        add_action('woocommerce_admin_field_template_check', '__return_false');
        add_filter('woocommerce_template_outdated', '__return_false');
        add_filter('woocommerce_template_version_check', '__return_false');
        add_action('admin_notices', array($this, 'remove_template_files_notice'), 1);
    }

    public function remove_template_outdated_notices()
    {
        global $wp_filter;

        if (isset($wp_filter['admin_notices'])) {
            foreach ($wp_filter['admin_notices']->callbacks as $priority => $callbacks) {
                foreach ($callbacks as $key => $callback) {
                    if (
                        is_array($callback['function']) &&
                        is_object($callback['function'][0]) &&
                        method_exists($callback['function'][0], 'template_outdated_notice')
                    ) {
                        remove_action('admin_notices', $callback['function'], $priority);
                    }

                    if (
                        is_array($callback['function']) &&
                        is_object($callback['function'][0]) &&
                        method_exists($callback['function'][0], 'admin_notices')
                    ) {
                        $class_name = get_class($callback['function'][0]);
                        if (
                            strpos($class_name, 'WC_Admin') !== false ||
                            strpos($class_name, 'WooCommerce') !== false
                        ) {
                            remove_action('admin_notices', $callback['function'], $priority);
                        }
                    }
                }
            }
        }
    }

    public function remove_woocommerce_admin_notices()
    {
        if (function_exists('WC_Admin_Notices')) {
            WC_Admin_Notices::remove_notice('template_files');
            WC_Admin_Notices::remove_notice('template_outdated');
        }

        remove_action('admin_notices', 'woocommerce_admin_notices');
        remove_action('admin_notices', 'woocommerce_template_outdated_notice');
    }

    public function remove_template_files_notice()
    {
        add_filter('woocommerce_admin_notices', function ($notices) {
            if (is_array($notices)) {
                foreach ($notices as $key => $notice) {
                    if (
                        isset($notice['message']) &&
                        (strpos($notice['message'], 'outdated copies') !== false ||
                            strpos($notice['message'], 'template files') !== false ||
                            strpos($notice['message'], 'Your theme (Felan)') !== false)
                    ) {
                        unset($notices[$key]);
                    }
                }
            }
            return $notices;
        });

        add_filter('woocommerce_admin_field_template_check', '__return_false');
        add_filter('woocommerce_admin_field_template_files', '__return_false');
    }
}

new Felan_WooCommerce_Notice_Remover();
