<?php

class Felan_WC_Order_Meta {
    public static function init(): self {
        static $instance = null;
        if ($instance === null) {
            $instance = new self();
        }
        return $instance;
    }

    private function __construct() {
        add_action('wp_enqueue_scripts', [$this, 'enqueue_styles'], 20);
        add_filter('woocommerce_order_item_display_meta_key', [$this, 'filter_meta_key'], 10, 3);
        add_filter('woocommerce_order_item_display_meta_value', [$this, 'filter_meta_value'], 10, 3);
        add_filter('woocommerce_order_item_get_formatted_meta_data', [$this, 'filter_formatted_meta'], 10, 2);
        add_filter('woocommerce_hidden_order_itemmeta', [$this, 'hidden_itemmeta']);
    }

    public function enqueue_styles(): void {
        if (is_admin()) {
            return;
        }
        $handle = 'felan-woocommerce-frontend-fixes';
        wp_register_style($handle, false);
        wp_enqueue_style($handle);
        $css = '.wc-item-meta .wc-item-meta-label{display:none!important;}';
        wp_add_inline_style($handle, $css);
    }

    public function filter_meta_key($display_key, $meta, $item) {
        $map = array(
            'felan_service_package_new' => '',
            'felan_project_package_new' => '',
            'felan_freelancer_package_new' => '',
            'felan_wallet_package_new' => '',
            'felan_service_package_addons' => _n('Add-on Service', 'Add-on Services', 1, 'felan'),
            'felan_project_package_addons' => _n('Add-on Service', 'Add-on Services', 1, 'felan'),
            'felan_freelancer_package_addons' => _n('Add-on Service', 'Add-on Services', 1, 'felan'),
            'felan_wallet_package_addons' => _n('Add-on Service', 'Add-on Services', 1, 'felan'),
        );
        return isset($map[$meta->key]) ? $map[$meta->key] : $display_key;
    }

    public function filter_meta_value($display_value, $meta, $item) {
        $hidden = array(
            'felan_service_package_time_type', 'felan_project_package_time_type', 'felan_freelancer_package_time_type', 'felan_wallet_package_time_type',
            'felan_service_package_time', 'felan_project_package_time', 'felan_freelancer_package_time', 'felan_wallet_package_time',
            'felan_service_package_des', 'felan_project_package_des', 'felan_freelancer_package_des', 'felan_wallet_package_des',
            'felan_service_total_price', 'felan_project_total_price', 'felan_freelancer_total_price', 'felan_wallet_amount',
            'felan_service_price_default', 'felan_project_price_default', 'felan_freelancer_price_default', 'felan_wallet_price_default',
            'felan_service_basic_revisions', 'felan_service_standard_revisions', 'felan_service_premium_revisions',
            'felan_service_basic_number_revisions', 'felan_service_standard_number_revisions', 'felan_service_premium_number_revisions',
            'felan_service_service_id', 'felan_service_selected_package', 'felan_service_number_revisions',
        );
        if (in_array($meta->key, $hidden, true)) {
            return null;
        }

        if (!in_array($meta->key, ['felan_service_package_new', 'felan_project_package_new', 'felan_freelancer_package_new', 'felan_wallet_package_new'], true)) {
            return $display_value;
        }

        $package_data = json_decode($meta->value, true);
        if (!is_array($package_data)) {
            return $display_value;
        }

        $selected_package_type = '';
        $package_time_value = '';
        $service_order_service_id = 0;
        $precalc_revisions = null;

        foreach ($item->get_meta_data() as $m) {
            if (strpos($m->key, 'package_type') !== false && strpos($m->key, 'time_type') === false) {
                $selected_package_type = $m->value;
            }
            if ($m->key === 'felan_service_package_time') {
                $package_time_value = $m->value;
            }
            if ($m->key === 'felan_service_selected_package') {
                $selected_package_type = $m->value;
            }
            if ($m->key === 'felan_service_service_id') {
                $service_order_service_id = intval($m->value);
            }
            if ($m->key === 'felan_service_number_revisions') {
                $precalc_revisions = $m->value;
            }
        }

        if ($selected_package_type === '') {
            foreach ($item->get_meta_data() as $m) {
                if (in_array($m->value, ['basic', 'standard', 'premium'], true)) {
                    $selected_package_type = $m->value;
                    break;
                }
            }
        }
        if ($selected_package_type === '' && $package_time_value !== '') {
            $tv = intval($package_time_value);
            $selected_package_type = $tv <= 5 ? 'basic' : ($tv <= 10 ? 'standard' : 'premium');
        }

        $package_price = '';
        $package_des = '';
        $package_time = '';
        $package_time_type = '';
        foreach ($item->get_meta_data() as $m) {
            switch ($m->key) {
                case 'felan_service_total_price':
                case 'felan_project_total_price':
                case 'felan_freelancer_total_price':
                case 'felan_wallet_amount':
                    $package_price = '$' . number_format($m->value);
                    break;
                case 'felan_service_package_des':
                case 'felan_project_package_des':
                case 'felan_freelancer_package_des':
                case 'felan_wallet_package_des':
                    $package_des = $m->value;
                    break;
                case 'felan_service_package_time':
                case 'felan_project_package_time':
                case 'felan_freelancer_package_time':
                case 'felan_wallet_package_time':
                    $package_time = $m->value;
                    break;
                case 'felan_service_package_time_type':
                case 'felan_project_package_time_type':
                case 'felan_freelancer_package_time_type':
                case 'felan_wallet_package_time_type':
                    $package_time_type = $m->value;
                    break;
            }
        }

        $delivery_time = '';
        if ($package_time !== '' && $package_time_type !== '') {
            $tv = intval($package_time);
            $units = array(
                'day' => _n('Day', 'Days', $tv, 'felan'),
                'days' => _n('Day', 'Days', $tv, 'felan'),
                'week' => _n('Week', 'Weeks', $tv, 'felan'),
                'weeks' => _n('Week', 'Weeks', $tv, 'felan'),
                'month' => _n('Month', 'Months', $tv, 'felan'),
                'months' => _n('Month', 'Months', $tv, 'felan'),
                'year' => _n('Year', 'Years', $tv, 'felan'),
                'years' => _n('Year', 'Years', $tv, 'felan'),
                'hr' => _n('Hour', 'Hours', $tv, 'felan'),
                'hour' => _n('Hour', 'Hours', $tv, 'felan'),
                'hours' => _n('Hour', 'Hours', $tv, 'felan'),
            );
            $unit = isset($units[$package_time_type]) ? $units[$package_time_type] : $package_time_type;
            $delivery_time = $package_time . ' ' . $unit;
        }

        $features = array();
        $revision_found = false;
        if ($precalc_revisions !== null) {
            $rv = is_string($precalc_revisions) ? trim(strtolower($precalc_revisions)) : $precalc_revisions;
            if ($rv === 'unlimited' || (string)$rv === '0') {
                $features[] = '<li class="felan-feature-item"><span class="felan-feature-label">' . __('Number of Revisions:', 'felan') . '</span> <span class="felan-feature-value">' . __('Unlimited', 'felan') . '</span></li>';
            } elseif (is_numeric($rv)) {
                $cnt = intval($rv);
                $features[] = '<li class="felan-feature-item"><span class="felan-feature-label">' . __('Number of Revisions:', 'felan') . '</span> <span class="felan-feature-value">' . sprintf(_n('%d Revision', '%d Revisions', $cnt, 'felan'), $cnt) . '</span></li>';
            }
            $revision_found = true;
        }
        if (!$revision_found && function_exists('felan_service_revisions') && !empty($service_order_service_id) && !empty($selected_package_type)) {
            $rev = felan_service_revisions($service_order_service_id, $selected_package_type);
            $rv = is_string($rev) ? trim(strtolower($rev)) : $rev;
            if ($rv === 'unlimited' || (string)$rv === '0') {
                $features[] = '<li class="felan-feature-item"><span class="felan-feature-label">' . __('Number of Revisions:', 'felan') . '</span> <span class="felan-feature-value">' . __('Unlimited', 'felan') . '</span></li>';
            } elseif (is_numeric($rv)) {
                $cnt = intval($rv);
                $features[] = '<li class="felan-feature-item"><span class="felan-feature-label">' . __('Number of Revisions:', 'felan') . '</span> <span class="felan-feature-value">' . sprintf(_n('%d Revision', '%d Revisions', $cnt, 'felan'), $cnt) . '</span></li>';
            }
            $revision_found = true;
        }
        if (!$revision_found) {
            $keys = [
                'felan_service_basic_revisions', 'felan_service_standard_revisions', 'felan_service_premium_revisions',
                'felan_service_basic_number_revisions', 'felan_service_standard_number_revisions', 'felan_service_premium_number_revisions',
            ];
            foreach ($item->get_meta_data() as $rm) {
                if (in_array($rm->key, $keys, true) || preg_match('/felan_service_.*_revisions?$/', $rm->key)) {
                    $rv = is_string($rm->value) ? trim(strtolower($rm->value)) : $rm->value;
                    if ($rv === 'unlimited' || (string)$rv === '0') {
                        $features[] = '<li class="felan-feature-item"><span class="felan-feature-label">' . __('Number of Revisions:', 'felan') . '</span> <span class="felan-feature-value">' . __('Unlimited', 'felan') . '</span></li>';
                    } elseif (is_numeric($rv)) {
                        $cnt = intval($rm->value);
                        $features[] = '<li class="felan-feature-item"><span class="felan-feature-label">' . __('Number of Revisions:', 'felan') . '</span> <span class="felan-feature-value">' . sprintf(_n('%d Revision', '%d Revisions', $cnt, 'felan'), $cnt) . '</span></li>';
                    }
                    break;
                }
            }
        }

        $summary_rows = array();
        if ($selected_package_type) {
            $names = array('basic' => __('Basic', 'felan'), 'standard' => __('Standard', 'felan'), 'premium' => __('Premium', 'felan'));
            $summary_rows[] = '<div class="felan-row felan-row-package"><span class="felan-label">' . __('Package:', 'felan') . '</span><span class="felan-value">' . (isset($names[$selected_package_type]) ? $names[$selected_package_type] : ucfirst($selected_package_type)) . '</span></div>';
        }
        if ($package_price) {
            $summary_rows[] = '<div class="felan-row felan-row-price"><span class="felan-label">' . __('Price:', 'felan') . '</span><span class="felan-value">' . $package_price . '</span></div>';
        }
        if ($package_des) {
            $summary_rows[] = '<div class="felan-row felan-row-description"><span class="felan-label">' . __('Description:', 'felan') . '</span><span class="felan-value">' . esc_html($package_des) . '</span></div>';
        }

        $feature_titles = array();
        foreach ($package_data as $pkg) {
            if (isset($pkg['felan-service_package_new_title']) && isset($pkg['felan-service_package_new_list'])) {
                $title = $pkg['felan-service_package_new_title'];
                $list = $pkg['felan-service_package_new_list'];
                if (!empty($selected_package_type) && in_array($selected_package_type, $list)) {
                    $feature_titles[] = '<li class="felan-feature-item"><span class="felan-feature-value">' . esc_html($title) . '</span></li>';
                } elseif (empty($selected_package_type)) {
                    $feature_titles[] = '<li class="felan-feature-item"><span class="felan-feature-value">' . esc_html($title) . '</span></li>';
                }
            }
        }
        $selected_addons = array();
        foreach ($item->get_meta_data() as $m) {
            if ($m->key === 'felan_service_package_addons' || $m->key === 'felan_service_order_package_addons') {
                $val = is_string($m->value) ? json_decode($m->value, true) : (is_array($m->value) ? $m->value : array());
                if (is_array($val)) { $selected_addons = $val; }
                break;
            }
        }
        $addons_html = '';
        if (!empty($selected_addons)) {
            $currency_symbol = function_exists('felan_get_option') ? felan_get_option('currency_sign_default') : '$';
            $addon_items = array();
            foreach ($selected_addons as $addon) {
                $title = '';
                $priceDisplay = '';
                if (is_array($addon)) {
                    $title = isset($addon['title']) ? $addon['title'] : (isset($addon['felan-service_addons_title']) ? $addon['felan-service_addons_title'] : '');
                    $rawPrice = null;
                    if (isset($addon['price'])) { $rawPrice = $addon['price']; }
                    elseif (isset($addon['price_not_format'])) { $rawPrice = $addon['price_not_format']; }
                    elseif (isset($addon['felan-service_addons_price'])) { $rawPrice = $addon['felan-service_addons_price']; }

                    if ($rawPrice !== null && $rawPrice !== '') {
                        $num = is_numeric($rawPrice) ? (float)$rawPrice : floatval(preg_replace('/[^0-9.]/', '', (string)$rawPrice));
                        if ($num > 0) { $priceDisplay = ' — ' . esc_html($currency_symbol) . esc_html((string)(int)$num); }
                    }
                } else {
                    $title = (string)$addon;
                }
                if ($title !== '') {
                    $addon_items[] = '<li class="felan-feature-item"><span class="felan-feature-value">' . esc_html($title) . $priceDisplay . '</span></li>';
                }
            }
            if (!empty($addon_items)) {
                $addons_html = '<div class="felan-package-addons"><div class="felan-label">' . __('Selected Add-ons:', 'felan') . '</div><ul class="felan-features-list">' . implode('', $addon_items) . '</ul></div>';
            }
        }
        if ($delivery_time) {
            $features[] = '<li class="felan-feature-item"><span class="felan-feature-label">' . __('Delivery Time:', 'felan') . '</span> <span class="felan-feature-value">' . $delivery_time . '</span></li>';
        }

        $summary_html = '<div class="felan-package-summary">' . implode('', $summary_rows) . '</div>';
        $features_html = '';
        if (!empty($features) || !empty($feature_titles)) {
            $features_html = '<div class="felan-package-features"><div class="felan-label">' . __('Features:', 'felan') . '</div><ul class="felan-features-list">' . implode('', array_merge($features, $feature_titles)) . '</ul></div>';
        }
        return '<div class="felan-meta felan-package-details">' . $summary_html . $features_html . $addons_html . '</div>';
    }

    public function filter_formatted_meta($formatted_meta, $item) {
        if (!is_array($formatted_meta)) {
            return $formatted_meta;
        }
        $hidden = array(
            'felan_service_package_time_type', 'felan_project_package_time_type', 'felan_freelancer_package_time_type', 'felan_wallet_package_time_type',
            'felan_service_package_time', 'felan_project_package_time', 'felan_freelancer_package_time', 'felan_wallet_package_time',
            'felan_service_package_des', 'felan_project_package_des', 'felan_freelancer_package_des', 'felan_wallet_package_des',
            'felan_service_total_price', 'felan_project_total_price', 'felan_freelancer_total_price', 'felan_wallet_amount',
            'felan_service_price_default', 'felan_project_price_default', 'felan_freelancer_price_default', 'felan_wallet_price_default',
            'felan_service_basic_revisions', 'felan_service_standard_revisions', 'felan_service_premium_revisions',
            'felan_service_basic_number_revisions', 'felan_service_standard_number_revisions', 'felan_service_premium_number_revisions',
            'felan_service_service_id', 'felan_service_selected_package', 'felan_service_number_revisions',
        );
        $filtered = array();
        foreach ($formatted_meta as $id => $m) {
            if (!in_array($m->key, $hidden, true)) {
                $filtered[$id] = $m;
            }
        }
        return $filtered;
    }

    public function hidden_itemmeta($hidden) {
        $extra = array(
            'felan_service_package_time_type', 'felan_project_package_time_type', 'felan_freelancer_package_time_type', 'felan_wallet_package_time_type',
            'felan_service_package_time', 'felan_project_package_time', 'felan_freelancer_package_time', 'felan_wallet_package_time',
            'felan_service_package_des', 'felan_project_package_des', 'felan_freelancer_package_des', 'felan_wallet_package_des',
            'felan_service_total_price', 'felan_project_total_price', 'felan_freelancer_total_price', 'felan_wallet_amount',
            'felan_service_price_default', 'felan_project_price_default', 'felan_freelancer_price_default', 'felan_wallet_price_default',
            'felan_service_basic_revisions', 'felan_service_standard_revisions', 'felan_service_premium_revisions',
            'felan_service_basic_number_revisions', 'felan_service_standard_number_revisions', 'felan_service_premium_number_revisions',
            'felan_service_service_id', 'felan_service_selected_package', 'felan_service_number_revisions',
        );
        return array_unique(array_merge($hidden, $extra));
    }
}

Felan_WC_Order_Meta::init();


