<?php

if (!defined('ABSPATH')) {
    exit;
}

if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have permission to access this script.', 'felan'));
}

class Felan_Template_Updater {

    public static function update_all_templates() {
        $woocommerce_dir = get_template_directory() . '/woocommerce';

        if (!is_dir($woocommerce_dir)) {
            echo '<div class="notice notice-error"><p>' . esc_html__('WooCommerce directory not found in theme.', 'felan') . '</p></div>';
            return;
        }

        $files = self::get_all_php_files($woocommerce_dir);
        $updated_count = 0;

        echo '<div class="wrap">';
        echo '<h1>' . esc_html__('Update WooCommerce Template Files', 'felan') . '</h1>';
        echo '<div class="notice notice-info"><p>' . esc_html__('Updating version numbers in template files...', 'felan') . '</p></div>';

        foreach ($files as $file) {
            if (self::update_file_version($file)) {
                $updated_count++;
                echo '<p>✓ ' . esc_html__('Updated:', 'felan') . ' ' . esc_html(basename($file)) . '</p>';
            }
        }

        echo '<div class="notice notice-success">';
        echo '<p><strong>' . esc_html__('Complete!', 'felan') . '</strong> ' . sprintf(esc_html__('Updated %d file(s).', 'felan'), $updated_count) . '</p>';
        echo '</div>';

        echo '<p><a href="' . esc_url(admin_url('admin.php?page=wc-status')) . '" class="button button-primary">' . esc_html__('Back to WooCommerce Status', 'felan') . '</a></p>';
        echo '</div>';
    }

    private static function update_file_version($file_path) {
        if (!file_exists($file_path)) {
            return false;
        }

        $content = file_get_contents($file_path);
        if ($content === false) {
            return false;
        }

        $wc_version = '9.4.3';
        if (function_exists('WC') && isset(WC()->version)) {
            $wc_version = WC()->version;
        }

        $patterns = array(
            '/@version\s+([0-9.]+)/' => '@version ' . $wc_version,
            '/version\s+([0-9.]+)/' => 'version ' . $wc_version,
            '/Version:\s+([0-9.]+)/' => 'Version: ' . $wc_version
        );

        $updated = false;
        foreach ($patterns as $pattern => $replacement) {
            if (preg_match($pattern, $content)) {
                $content = preg_replace($pattern, $replacement, $content);
                $updated = true;
                break;
            }
        }

        if ($updated) {
            return file_put_contents($file_path, $content) !== false;
        }

        return false;
    }

    private static function get_all_php_files($dir) {
        $files = array();

        if (!is_dir($dir)) {
            return $files;
        }

        $items = scandir($dir);
        foreach ($items as $item) {
            if ($item === '.' || $item === '..') {
                continue;
            }

            $path = $dir . '/' . $item;
            if (is_dir($path)) {
                $files = array_merge($files, self::get_all_php_files($path));
            } elseif (is_file($path) && pathinfo($path, PATHINFO_EXTENSION) === 'php') {
                $files[] = $path;
            }
        }

        return $files;
    }
}

if (isset($_GET['action']) && $_GET['action'] === 'update_woocommerce_templates') {
    Felan_Template_Updater::update_all_templates();
    exit;
}
