/**
 * Admin Custom Field - Disable ID field after it has value
 */
(function($) {
    'use strict';

    /**
     * Disable ID fields that have value
     * Targets inputs with name pattern: custom_field_*[*][id]
     */
    function disableCustomFieldIds() {
        // Target all text inputs inside custom field panels
        $('input.glf-text[name$="[id]"]').each(function() {
            var $input = $(this);
            var name = $input.attr('name') || '';

            // Check if this is a custom field ID input
            if (name.match(/custom_field_(jobs|company|freelancer|project|service)\[\d+\]\[id\]/)) {
                var value = $input.val();

                if (value && value.trim() !== '') {
                    $input.addClass('field-id-locked');
                    $input.prop('readonly', true);
                    $input.attr('title', (typeof felanAdminCustomField !== 'undefined' ? felanAdminCustomField.idLockedMessage : 'ID cannot be changed after being set'));
                }
            }
        });
    }

    $(document).ready(function() {
        // Run on page load with delay to ensure DOM is ready
        setTimeout(disableCustomFieldIds, 1000);

        // Run when panel is opened/expanded
        $(document).on('click', '.glf-field-panel-title, .glf-group-toggle', function() {
            setTimeout(disableCustomFieldIds, 200);
        });

        // Run when new panel item is added
        $(document).on('click', '.glf-clone-button-add', function() {
            setTimeout(disableCustomFieldIds, 500);
        });

        // Also run on any AJAX complete
        $(document).ajaxComplete(function() {
            setTimeout(disableCustomFieldIds, 200);
        });

        // Run when tab is changed
        $(document).on('click', '.glf-tab li a', function() {
            setTimeout(disableCustomFieldIds, 300);
        });
    });

})(jQuery);

