/**
 * Freelancer Withdraw Admin Scripts
 * Payment Info Modal Handler
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Create modal HTML
        if (!$('#payment-info-modal').length) {
            $('body').append(
                '<div id="payment-info-modal" class="payment-info-modal">' +
                    '<div class="payment-info-modal-content">' +
                        '<div class="payment-info-modal-header">' +
                            '<h2>' + felanWithdrawAdmin.modalTitle + '</h2>' +
                            '<button class="payment-info-modal-close">&times;</button>' +
                        '</div>' +
                        '<div class="payment-info-modal-body"></div>' +
                    '</div>' +
                '</div>'
            );
        }

        var modal = $('#payment-info-modal');
        var modalBody = $('.payment-info-modal-body');

        // Open modal
        $(document).on('click', '.view-payment-info', function(e) {
            e.preventDefault();
            var userId = $(this).data('user-id');
            var withdrawId = $(this).data('withdraw-id');

            modal.show();
            modalBody.html('<div class="payment-info-loading">' + felanWithdrawAdmin.loadingText + '</div>');

            // AJAX request to get payment info
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'get_user_payment_info',
                    user_id: userId,
                    withdraw_id: withdrawId,
                    nonce: felanWithdrawAdmin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        modalBody.html(response.data.html);
                    } else {
                        modalBody.html('<div class="payment-info-error">' + response.data.message + '</div>');
                    }
                },
                error: function() {
                    modalBody.html('<div class="payment-info-error">' + felanWithdrawAdmin.errorText + '</div>');
                }
            });
        });

        // Close modal
        $(document).on('click', '.payment-info-modal-close, .payment-info-modal', function(e) {
            if (e.target === this) {
                modal.hide();
            }
        });

        // Close modal on ESC key
        $(document).on('keydown', function(e) {
            if (e.key === 'Escape' && modal.is(':visible')) {
                modal.hide();
            }
        });

        // Copy to clipboard functionality
        $(document).on('click', '.copy-btn', function(e) {
            e.preventDefault();
            var $btn = $(this);
            var textToCopy = $btn.data('copy');

            // Use modern Clipboard API if available
            if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(textToCopy).then(function() {
                    showCopySuccess($btn);
                }).catch(function() {
                    // Fallback for older browsers
                    fallbackCopyText(textToCopy, $btn);
                });
            } else {
                // Fallback for older browsers
                fallbackCopyText(textToCopy, $btn);
            }
        });

        // Show copy success feedback
        function showCopySuccess($btn) {
            $btn.addClass('copied');
            var originalTitle = $btn.attr('title');
            $btn.attr('title', 'Copied!');

            setTimeout(function() {
                $btn.removeClass('copied');
                $btn.attr('title', originalTitle);
            }, 2000);
        }

        // Fallback copy method for older browsers
        function fallbackCopyText(text, $btn) {
            var $temp = $('<textarea>');
            $('body').append($temp);
            $temp.val(text).select();

            try {
                var successful = document.execCommand('copy');
                if (successful) {
                    showCopySuccess($btn);
                }
            } catch (err) {
                console.error('Copy failed:', err);
            }

            $temp.remove();
        }
    });

})(jQuery);
