/**
 * Service Order Admin AJAX Handler
 */
(function($) {
    'use strict';

    $(document).ready(function() {
        // Handle service order status change
        $(document).on('click', '.felan-service-order-status-change', function(e) {
            e.preventDefault();

            var $link = $(this);
            var orderId = $link.data('order-id');
            var newStatus = $link.data('new-status');
            var orderNonce = $link.data('nonce');
            var $row = $link.closest('tr');
            var $statusCell = $row.find('.status.column-status');
            var $actions = $row.find('.row-actions');

            // Confirm action
            if (!confirm(felanServiceOrderAdmin.i18n.confirm)) {
                return;
            }

            // Show loading state
            var originalText = $link.text();
            $link.text(felanServiceOrderAdmin.i18n.updating);
            $link.css('opacity', '0.5');

            // AJAX request
            $.ajax({
                url: felanServiceOrderAdmin.ajax_url,
                type: 'POST',
                data: {
                    action: 'felan_change_service_order_status',
                    order_id: orderId,
                    new_status: newStatus,
                    order_nonce: orderNonce,
                    security: felanServiceOrderAdmin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        // Update status cell
                        $statusCell.html(response.data.status_html);

                        // Update row actions
                        $actions.empty();

                        // Add default actions (View, Trash, etc.)
                        var editUrl = $row.find('a.row-title').attr('href');
                        var trashUrl = $actions.find('.trash a').attr('href');

                        var actionsHtml = '<span class="view"><a href="' + editUrl + '">' +
                                        felanServiceOrderAdmin.i18n.view + '</a> | </span>';

                        // Add status change action
                        if (response.data.new_actions['pending-order']) {
                            actionsHtml += '<span class="pending-order">' +
                                         response.data.new_actions['pending-order'] + ' | </span>';
                        }
                        if (response.data.new_actions['inprogress-order']) {
                            actionsHtml += '<span class="inprogress-order">' +
                                         response.data.new_actions['inprogress-order'] + ' | </span>';
                        }

                        actionsHtml += '<span class="trash"><a href="' + (trashUrl || '#') +
                                     '" class="submitdelete" aria-label="Move to Trash">Trash</a></span>';

                        $actions.html(actionsHtml);

                        // Add success animation
                        $row.css('background-color', '#d4edda');
                        setTimeout(function() {
                            $row.css('background-color', '');
                        }, 1500);

                        // Show success message
                        showNotice(response.data.message, 'success');
                    } else {
                        // Restore link
                        $link.text(originalText);
                        $link.css('opacity', '1');
                        showNotice(response.data.message || felanServiceOrderAdmin.i18n.error, 'error');
                    }
                },
                error: function(xhr, status, error) {
                    // Restore link
                    $link.text(originalText);
                    $link.css('opacity', '1');
                    showNotice(felanServiceOrderAdmin.i18n.error + ': ' + error, 'error');
                }
            });
        });

        /**
         * Show admin notice
         */
        function showNotice(message, type) {
            var noticeClass = type === 'error' ? 'notice-error' : 'notice-success';
            var $notice = $('<div class="notice ' + noticeClass + ' is-dismissible"><p>' +
                          message + '</p></div>');

            $('.wrap h1').after($notice);

            // Auto dismiss after 3 seconds
            setTimeout(function() {
                $notice.fadeOut(function() {
                    $(this).remove();
                });
            }, 3000);
        }
    });

})(jQuery);
