(function ($) {
  "use strict";

  var submit_form = $("#submit_company_form"),
    company_title_error = submit_form.data("titleerror"),
    company_des_error = submit_form.data("deserror"),
    company_cat_error = submit_form.data("caterror"),
    company_size_error = submit_form.data("sizeerror"),
    company_email_error = submit_form.data("emailerror");

  var ajax_url = felan_submit_vars.ajax_url,
    company_dashboard = felan_submit_vars.company_dashboard,
    custom_field_company = felan_submit_vars.custom_field_company;

  $(document).ready(function () {
    
    submit_form.on('submit', function(e) {
      e.preventDefault();
      
      var hasError = false;
      
      submit_form.find("label.error").remove();
      submit_form.find(".error").removeClass("error");
      
      var company_title = submit_form.find('input[name="company_title"]').val().trim();
      if (!company_title) {
        var $field = submit_form.find('input[name="company_title"]');
        $field.addClass("error");
        $('<label class="error">' + company_title_error + '</label>').insertAfter($field);
        hasError = true;
      }
      
      var company_categories = submit_form.find('select[name="company_categories"]').val();
      if (!company_categories && submit_form.find('select[name="company_categories"]').length > 0) {
        var $field = submit_form.find('select[name="company_categories"]');
        var $container = $field.closest('.select2-field');
        if ($container.length > 0) {
          $container.addClass("error");
          $('<label class="error">' + company_cat_error + '</label>').insertAfter($container);
        } else {
          $field.addClass("error");
          $('<label class="error">' + company_cat_error + '</label>').insertAfter($field);
        }
        hasError = true;
      }
      
      var company_size = submit_form.find('select[name="company_size"]').val();
      if (!company_size && submit_form.find('select[name="company_size"]').length > 0) {
        var $field = submit_form.find('select[name="company_size"]');
        var $container = $field.closest('.select2-field');
        if ($container.length > 0) {
          $container.addClass("error");
          $('<label class="error">' + company_size_error + '</label>').insertAfter($container);
        } else {
          $field.addClass("error");
          $('<label class="error">' + company_size_error + '</label>').insertAfter($field);
        }
        hasError = true;
      }
      
      var company_email = submit_form.find('input[name="company_email"]').val().trim();
      if (!company_email) {
        var $field = submit_form.find('input[name="company_email"]');
        $field.addClass("error");
        $('<label class="error">' + company_email_error + '</label>').insertAfter($field);
        hasError = true;
      } else if (company_email && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(company_email)) {
        var $field = submit_form.find('input[name="company_email"]');
        $field.addClass("error");
        $('<label class="error">Please enter a valid email address</label>').insertAfter($field);
        hasError = true;
      }
      
      var company_des_content = '';
      if (tinymce.get("company_des")) {
        company_des_content = tinymce.get("company_des").getContent({format: 'text'}).trim();
      }
      if (!company_des_content) {
        var $label = submit_form.find('.label-des-company');
        $label.closest('.form-group').addClass("error");
        $('<label class="error">' + company_des_error + '</label>').insertAfter($label);
        hasError = true;
      }
      
      if (hasError) {
        setTimeout(function() {
          var $firstError = submit_form.find("label.error:visible").first();
          if ($firstError.length) {
            $("html, body").animate({
              scrollTop: $firstError.offset().top - 100
            }, 500);
          }
        }, 100);
        return false;
      }
      
      ajax_load();
      return false;
    });

    function ajax_load() {
      var company_form = submit_form.find('input[name="company_form"]').val(),
        company_action = submit_form.find('input[name="company_action"]').val(),
        company_id = submit_form.find('input[name="company_id"]').val(),
        company_title = submit_form.find('input[name="company_title"]').val(),
        company_categories = submit_form
          .find('select[name="company_categories"]')
          .val(),
        company_new_categories = submit_form
          .find('input[name="company_new_categories"]')
          .val(),
        company_url = submit_form.find('input[name="company_url"]').val(),
        company_des = tinymce.get("company_des").getContent(),
        company_website = submit_form
          .find('input[name="company_website"]')
          .val(),
        company_phone = submit_form.find('input[name="company_phone"]').val(),
        company_phone_code = submit_form
          .find('select[name="prefix_code"]')
          .val(),
        company_email = submit_form.find('input[name="company_email"]').val(),
        company_founded = submit_form
          .find('select[name="company_founded"]')
          .val(),
        company_size = submit_form.find('select[name="company_size"]').val(),
        company_twitter = submit_form
          .find('input[name="company_twitter"]')
          .val(),
        company_linkedin = submit_form
          .find('input[name="company_linkedin"]')
          .val(),
        company_facebook = submit_form
          .find('input[name="company_facebook"]')
          .val(),
        company_instagram = submit_form
          .find('input[name="company_instagram"]')
          .val(),
        company_social_name = submit_form
          .find('input[name="company_social_name[]"]')
          .map(function () {
            return $(this).val();
          })
          .get(),
        company_social_url = submit_form
          .find('input[name="company_social_url[]"]')
          .map(function () {
            return $(this).val();
          })
          .get(),
        company_location = submit_form
          .find('select[name="company_location"]')
          .val(),
        company_new_location = submit_form
          .find('input[name="company_new_location"]')
          .val(),
        company_map_address = submit_form
          .find('input[name="felan_map_address"]')
          .val(),
        company_map_location = submit_form
          .find('input[name="felan_map_location"]')
          .val(),
        company_latitude = submit_form
          .find('input[name="felan_latitude"]')
          .val(),
        company_longtitude = submit_form
          .find('input[name="felan_longtitude"]')
          .val(),
        company_avatar_url = submit_form
          .find('input[name="company_avatar_url"]')
          .val(),
        company_avatar_id = submit_form
          .find('input[name="company_avatar_id"]')
          .val(),
        company_thumbnail_url = submit_form
          .find('input[name="company_thumbnail_url"]')
          .val(),
        company_thumbnail_id = submit_form
          .find('input[name="company_thumbnail_id"]')
          .val(),
        felan_gallery_ids = submit_form
          .find('input[name="felan_gallery_ids[]"]')
          .map(function () {
            return $(this).val();
          })
          .get(),
        company_video_url = submit_form
          .find('input[name="company_video_url"]')
          .val();

      var additional = {};
      $("#company-submit-additional").each(function () {
        $.each(custom_field_company, function (index, value) {
          var val = $(".form-control[name=" + value.id + "]").val();
          if (value.type == "radio") {
            val = $("input[name=" + value.id + "]:checked").val();
          }
          if (value.type == "checkbox_list") {
            var arr_checkbox = [];
            $('input[name="' + value.id + '[]"]:checked').each(function () {
              arr_checkbox.push($(this).val());
            });
            val = arr_checkbox;
          }
          if (value.type == "image") {
            val = $("input#custom_image_id_" + value.id).val();
          }
          if (value.type == "file") {
            val = $(".drop-cv-" + value.id).data("attachment-id");
          }
          additional[value.id] = val;
        });
      });

      $.ajax({
        type: "POST",
        dataType: "json",
        url: ajax_url,
        data: {
          action: "company_submit_ajax",
          felan_submit_company_nonce_field: $('input[name="felan_submit_company_nonce_field"]').val(),
          company_form: company_form,
          company_action: company_action,
          company_id: company_id,
          company_title: company_title,
          company_categories: company_categories,
          company_new_categories: company_new_categories,
          company_url: company_url,
          company_des: company_des,
          company_website: company_website,
          company_founded: company_founded,
          company_phone: company_phone,
          company_phone_code: company_phone_code,
          company_email: company_email,
          company_size: company_size,

          company_twitter: company_twitter,
          company_linkedin: company_linkedin,
          company_facebook: company_facebook,
          company_instagram: company_instagram,
          company_social_name: company_social_name,
          company_social_url: company_social_url,

          company_location: company_location,
          company_new_location: company_new_location,
          company_map_address: company_map_address,
          company_map_location: company_map_location,
          company_latitude: company_latitude,
          company_longtitude: company_longtitude,

          company_avatar_url: company_avatar_url,
          company_avatar_id: company_avatar_id,
          company_thumbnail_url: company_thumbnail_url,
          company_thumbnail_id: company_thumbnail_id,
          felan_gallery_ids: felan_gallery_ids,
          company_video_url: company_video_url,

          custom_field_company: additional,
        },
        beforeSend: function () {
          $(".btn-submit-company .btn-loading").fadeIn();
        },
        success: function (data) {
          $(".btn-submit-company .btn-loading").fadeOut();
          if (data.success === true) {
            window.location.href = company_dashboard;
          } else {
            alert(data.message || data.data || 'An error occurred. Please try again.');
          }
        },
        error: function (xhr, status, error) {
          $(".btn-submit-company .btn-loading").fadeOut();
          alert('Security check failed or network error. Please refresh and try again.');
        },
      });
    }
  });
})(jQuery);
