(function ($) {
    "use strict";
    $(document).ready(function () {
        var ajax_url = felan_freelancer_review_vars.ajax_url;

        $("body").on("click", ".btn-action-review",
            function (e) {
                e.preventDefault();
                var freelancer_id = $(this).attr('freelancer-id');

                if (!freelancer_id) {
                    alert('Error: Freelancer ID is missing. Please refresh the page and try again.');
                    return false;
                }

                $.ajax({
                    type: "POST",
                    url: ajax_url,
                    dataType: "json",
                    data: {
                        action: "felan_freelancer_write_a_review",
                        nonce: felan_template_vars.nonces.write_review,
                        freelancer_id: freelancer_id,
                    },
                    beforeSend: function () {
                    },
                    success: function (response) {
                        if (response.html_review) {
                            var $viewForm = $('#form-popup-view');
                            if ($viewForm.length > 0) {
                                $viewForm.hide();
                            }

                            var $editForm = $('#form-popup-review.form-review-jobs');

                            if ($editForm.length === 0) {
                                return;
                            }

                            $editForm.find('.reviewForm-project .content-popup-review').html(response.html_review);
                            $editForm.find('.reviewForm-project input[name="action"]').val('felan_freelancer_submit_review_ajax');
                            var $freelancerIdInput = $editForm.find('.reviewForm-project input[name="freelancer_id"]');
                            if ($freelancerIdInput.length) {
                                $freelancerIdInput.val(freelancer_id);
                            } else {
                                $editForm.find('.reviewForm-project').append('<input type="hidden" name="freelancer_id" value="' + freelancer_id + '">');
                            }

                            if (response.nonce) {
                                $editForm.find('input[name="nonce"]').val(response.nonce);
                            }

                            if (response.has_existing_review) {
                                $editForm.addClass('form-review-jobs-edit');
                                $editForm.find('.reviewForm-project .felan-submit-freelancer-rating').text('Update');

                                var formDisabled = $editForm.attr('data-disabled') === 'true';

                                if (formDisabled) {
                                    $editForm.find('.reviewForm-project textarea').prop('readonly', true).prop('disabled', true);
                                    $editForm.find('.reviewForm-project input[type="radio"]').prop('disabled', true);
                                    $editForm.find('.reviewForm-project .rate').css('pointer-events', 'none').css('opacity', '0.6');
                                    $editForm.find('#btn-submit-review').hide();
                                } else {
                                    $editForm.find('.reviewForm-project textarea').prop('readonly', false).prop('disabled', false);
                                    $editForm.find('.reviewForm-project input[type="radio"]').prop('disabled', false);
                                    $editForm.find('.reviewForm-project .rate').css('pointer-events', 'auto').css('opacity', '1');
                                    $editForm.find('#btn-submit-review').show();
                                }
                            } else {
                                $editForm.removeClass('form-review-jobs-edit');
                                $editForm.find('.reviewForm-project .felan-submit-freelancer-rating').text('Submit');
                                $editForm.find('.reviewForm-project textarea').prop('readonly', false).prop('disabled', false);
                                $editForm.find('.reviewForm-project input[type="radio"]').prop('disabled', false);
                                $editForm.find('.reviewForm-project .rate').css('pointer-events', 'auto').css('opacity', '1');
                                $editForm.find('#btn-submit-review').show();
                            }

                            $editForm.css({
                                'opacity': '1',
                                'visibility': 'visible',
                                'display': 'block'
                            });

                            $('body').addClass('popup-open');
                        }
                    },
                    error: function (xhr, status, error) {
                        alert('Error loading review form. Please try again.');
                    }
                });
            }
        );

        $("body").on("click", "#form-popup-review.form-review-jobs .btn-close, #form-popup-review.form-review-jobs .bg-overlay, #form-popup-review.form-review-jobs .button-cancel", function (e) {
            e.preventDefault();
            $('#form-popup-review.form-review-jobs').css({ opacity: "0", visibility: "hidden", display: "none" });
            $('body').removeClass('popup-open');
        });
    });
})(jQuery);
