(function ($) {
    "use strict";
    $(document).ready(function () {
        var ajax_url = felan_company_review_vars.ajax_url;

        $("body").on("click", ".btn-action-review",
            function (e) {
                e.preventDefault();
                var company_id = $(this).attr('company-id');

                $.ajax({
                    type: "POST",
                    url: ajax_url,
                    dataType: "json",
                    data: {
                        action: "felan_company_write_a_review",
                        nonce: felan_template_vars.nonces.write_review,
                        company_id: company_id,
                    },
                    beforeSend: function () {

                    },
                    success: function (response) {
                        if (response.html_review) {
                            $('.reviewForm .content-popup-review').html(response.html_review);
                            $('.reviewForm input[name="company_id"]').val(company_id);

                            if (response.nonce) {
                                $('.reviewForm input[name="nonce"]').val(response.nonce);
                            }

                            if (response.has_existing_review) {
                                $('#form-popup-review').addClass('form-review-project-edit');
                                $('.reviewForm .felan-submit-company-rating').text('Update Review');

                                var formDisabled = $('#form-popup-review').attr('data-disabled') === 'true';

                                if (formDisabled) {
                                    $('.reviewForm textarea').prop('readonly', true).prop('disabled', true);
                                    $('.reviewForm input[type="radio"]').prop('disabled', true);
                                    $('.reviewForm .rate').css('pointer-events', 'none').css('opacity', '0.6');
                                    $('#btn-submit-review').hide();
                                } else {
                                    $('.reviewForm textarea').prop('readonly', false).prop('disabled', false);
                                    $('.reviewForm input[type="radio"]').prop('disabled', false);
                                    $('.reviewForm .rate').css('pointer-events', 'auto').css('opacity', '1');
                                    $('#btn-submit-review').show();
                                }
                            } else {
                                $('#form-popup-review').removeClass('form-review-project-edit');
                                $('.reviewForm .felan-submit-company-rating').text('Submit Review');
                                $('.reviewForm textarea').prop('readonly', false).prop('disabled', false);
                                $('.reviewForm input[type="radio"]').prop('disabled', false);
                                $('.reviewForm .rate').css('pointer-events', 'auto').css('opacity', '1');
                                $('#btn-submit-review').show();
                            }

                            if (typeof $.fn.validate !== 'undefined' && $('.reviewForm').length) {
                                var $form = $('.reviewForm');
                                if ($form.data('validator')) {
                                    $form.validate().destroy();
                                }
                                initReviewFormValidation();
                            }

                            $('#form-popup-review').css({ opacity: "1", visibility: "visible", display: "block" });
                            $('body').addClass('popup-open');
                        }
                    },
                    error: function (xhr, status, error) {
                    }
                });

            }
        );

        $("body").on("click", ".btn-action-view",
            function (e) {
                e.preventDefault();
                var company_id = $(this).attr('company-id');

                $.ajax({
                    type: "POST",
                    url: ajax_url,
                    dataType: "json",
                    data: {
                        action: "felan_company_view_review",
                        company_id: company_id,
                    },
                    beforeSend: function () {

                    },
                    success: function (response) {

                        if (response.html_review) {
                            $('.reviewForm .content-popup-review').html(response.html_review);
                            $('.reviewForm input[name="company_id"]').val(company_id);

                            if (response.nonce) {
                                $('.reviewForm input[name="nonce"]').val(response.nonce);
                            }

                            if (response.has_existing_review) {
                                $('#form-popup-review').addClass('form-review-project-edit');
                                $('.reviewForm .felan-submit-company-rating').text('Update Review');

                                var formDisabled = $('#form-popup-review').attr('data-disabled') === 'true';

                                if (formDisabled) {
                                    $('.reviewForm textarea').prop('readonly', true).prop('disabled', true);
                                    $('.reviewForm input[type="radio"]').prop('disabled', true);
                                    $('.reviewForm .rate').css('pointer-events', 'none').css('opacity', '0.6');
                                    $('#btn-submit-review').hide();
                                } else {
                                    $('.reviewForm textarea').prop('readonly', false).prop('disabled', false);
                                    $('.reviewForm input[type="radio"]').prop('disabled', false);
                                    $('.reviewForm .rate').css('pointer-events', 'auto').css('opacity', '1');
                                    $('#btn-submit-review').show();
                                }
                            } else {
                                $('#form-popup-review').removeClass('form-review-project-edit');
                                $('.reviewForm .felan-submit-company-rating').text('Submit Review');
                                $('.reviewForm textarea').prop('readonly', false).prop('disabled', false);
                                $('.reviewForm input[type="radio"]').prop('disabled', false);
                                $('.reviewForm .rate').css('pointer-events', 'auto').css('opacity', '1');
                                $('#btn-submit-review').show();
                            }

                            $('#form-popup-review').css({ opacity: "1", visibility: "unset" });

                            if (typeof $.fn.validate !== 'undefined' && $('.reviewForm').length) {
                                var $form = $('.reviewForm');
                                if ($form.data('validator')) {
                                    $form.validate().destroy();
                                }
                                initReviewFormValidation();
                            }
                        }
                    },
                    error: function (xhr, status, error) {
                    }
                });

            }
        );

        function initReviewFormValidation() {
            if (typeof $.fn.validate !== 'undefined') {
                $(".reviewForm").validate({
                    rules: {
                        message: {
                            required: true,
                        },
                    },
                    messages: {
                        message: {
                            required: "This field is required",
                        },
                    },
                    errorPlacement: function (error, element) {
                        if (element.is(":radio")) {
                            error.appendTo(element.parents("fieldset"));
                        } else {
                            error.insertAfter(element);
                        }
                    },
                    submitHandler: function (form) {
                        var $this = $(".reviewForm").find(".felan-submit-company-rating");
                        var $form = $(".reviewForm");

                        var formdata = false;
                        if (window.FormData) {
                            formdata = new FormData($form[0]);
                        }

                        $.ajax({
                            type: "POST",
                            url: ajax_url,
                            data: formdata ? formdata : $form.serialize(),
                            enctype: "multipart/form-data",
                            dataType: "json",
                            processData: false,
                            contentType: false,
                            beforeSend: function () {
                                $this.children("i").remove();
                                $this.append(
                                    '<i class="fa-left fal fa-spinner fa-spin large"></i>'
                                );
                                $('.reviewForm .felan-message-error').html('').hide();
                            },
                            success: function (data) {
                                if (data.success) {
                                    window.location.reload();
                                } else {
                                    var errorMsg = 'An error occurred';
                                    if (data.data && data.data.message) {
                                        errorMsg = data.data.message;
                                    } else if (data.message) {
                                        errorMsg = data.message;
                                    }
                                    var $errorMsg = $('.reviewForm .felan-message-error');
                                    if ($errorMsg.length) {
                                        $errorMsg.html('<span class="error-text">' + errorMsg + '</span>').fadeIn();
                                    } else {
                                        alert(errorMsg);
                                    }
                                }
                            },
                            error: function (xhr, status, error) {
                                var errorMsg = 'An error occurred. Please try again.';
                                if (xhr.responseJSON && xhr.responseJSON.data && xhr.responseJSON.data.message) {
                                    errorMsg = xhr.responseJSON.data.message;
                                } else if (xhr.responseJSON && xhr.responseJSON.message) {
                                    errorMsg = xhr.responseJSON.message;
                                }
                                var $errorMsg = $('.reviewForm .felan-message-error');
                                if ($errorMsg.length) {
                                    $errorMsg.html('<span class="error-text">' + errorMsg + '</span>').fadeIn();
                                } else {
                                    alert(errorMsg);
                                }
                            },
                            complete: function () {
                                $this.children("i").remove();
                            },
                        });
                    },
                });
            }
        }

        initReviewFormValidation();

        $('body').on('click', '#form-popup-review.form-review-project .btn-close, #form-popup-review.form-review-project .bg-overlay, #form-popup-review.form-review-project .button-cancel', function(e) {
            e.preventDefault();
            $('#form-popup-review').css({ opacity: "0", visibility: "hidden" });
        });
    });
})(jQuery);
