var NOTIFICATION = NOTIFICATION || {};
(function ($) {
  "use strict";
  var ajax_url = felan_template_vars.ajax_url,
    notification = $(".felan-notification"),
    icon = notification.find(".icon-noti"),
    content = notification.find(".content-noti");

  NOTIFICATION = {
    init: function () {
      this.content_active();
      this.refresh_notification();
    },

    content_active: function () {
      icon.on("click", function (e) {
        e.preventDefault();
        e.stopPropagation();
        content.toggleClass("active");
      });

      // Click outside to close dropdown
      $(document).on("click", function (e) {
        if (!$(e.target).closest(".felan-notification").length) {
          content.removeClass("active");
        }
      });

      // Prevent clicks inside dropdown content from closing it (except specific interactive elements)
      content.on("click", function (e) {
        // Don't stop propagation for these elements - they have their own handlers
        if (!$(e.target).closest(".action-setting, .btn-quick-read, .link-page").length) {
          e.stopPropagation();
        }
      });
    },

    refresh_notification: function () {
      $("body").on("click", ".felan-notification .btn-delete", function (e) {
        e.preventDefault();
        var noti_id = $(this).data("noti-id");
        ajax_load(noti_id, "delete");
      });

      $("body").on("click", ".felan-notification .noti-clear", function (e) {
        e.preventDefault();
        ajax_load("", "clear");
      });

      $("body").on("click", ".felan-notification .noti-refresh", function (e) {
        e.preventDefault();
        ajax_load();
      });

      // Mark as Read click handler
      $("body").on("click", ".felan-notification .btn-mark-read, .felan-notification .btn-quick-read", function (e) {
        e.preventDefault();
        e.stopPropagation();
        var noti_id = $(this).data("noti-id");
        ajax_load(noti_id, "read");
      });

      // Mark as Unread click handler
      $("body").on("click", ".felan-notification .btn-mark-unread", function (e) {
        e.preventDefault();
        e.stopPropagation();
        var noti_id = $(this).data("noti-id");
        ajax_load(noti_id, "unread");
      });

      function close_noti() {
        notification.find(".close-noti").on("click", function (e) {
          e.preventDefault();
          content.removeClass("active");
        });
      }
      close_noti();

      function ajax_load(noti_id = "", action_click = "") {
        return $.ajax({
          type: "POST",
          url: ajax_url,
          dataType: "json",
          data: {
            action: "felan_refresh_notification",
            noti_id: noti_id,
            action_click: action_click,
          },
          beforeSend: function () {
            $('.content-noti .noti-refresh .fa-sync').addClass('fa-spin');
          },
          success: function (data) {
            if (data.success == true) {
              icon.find("span").text(data.count);
              content.html(data.noti_content);
              close_noti();
            }
            $('.content-noti .noti-refresh .fa-sync').removeClass('fa-spin');
          },
        });
      }

      // Auto mark as read when clicking notification link
      $("body").on("click", ".felan-notification .link-page", function (e) {
        var noti_id = $(this).data("noti-id");
        var href = $(this).attr("href");

        // Only intercept normal left clicks without modifiers responsible for navigation
        if (e.which === 1 && !e.ctrlKey && !e.metaKey && !e.shiftKey && !e.altKey) {
          if (href && href !== "#" && href !== "javascript:void(0);") {
            e.preventDefault(); // Stop immediate navigation

            if (noti_id) {
              ajax_load(noti_id, "read").always(function () {
                // Navigate after AJAX completes (whether success or error)
                window.location.href = href;
              });
            } else {
              window.location.href = href;
            }
            return;
          }
        }

        // For other cases (Ctrl+Click, etc.), fire AJAX "fire and forget"
        if (noti_id) {
          ajax_load(noti_id, "read");
        }
      });
    },
  };

  $(document).ready(function () {
    NOTIFICATION.init();
  });
})(jQuery);
