(function ($) {
    "use strict";

    var form_refund = $("#form-project-order-refund");
    var ajax_url = felan_project_detail_vars.ajax_url;
    var payment_url = felan_project_detail_vars.payment_url;

    $(document).ready(function () {

        function clearErrorOnForm($form) {
            var $errorMsg = $form.find('.felan-message-error');
            if ($errorMsg.length) {
                $errorMsg.fadeOut().html('');
            }
        }

        $(document).on('click', '#form-popup-review.form-review-jobs .btn-close, #form-popup-review.form-review-jobs .bg-overlay, #form-popup-review.form-review-jobs .button-cancel', function (e) {
            var $popup = $('#form-popup-review.form-review-jobs');
            var $form = $popup.find('.reviewForm-project');
            if ($form.length) {
                clearErrorOnForm($form);
            }
        });

        $(document).on('input change', '.reviewForm-project textarea[name="message"]', function() {
            var $form = $(this).closest('.reviewForm-project');
            clearErrorOnForm($form);
        });

        $(document).on('change', '.reviewForm-project input[type="radio"][name^="rating_"]', function() {
            var $form = $(this).closest('.reviewForm-project');
            clearErrorOnForm($form);
        });

        $("body").on("click", ".btn-action-review", function (e) {
            e.preventDefault();
            var freelancer_id = $(this).attr("freelancer-id");
            var order_id = $(this).attr("order-id") || '';

            if (!freelancer_id) {
                alert('Error: Freelancer ID is missing. Please refresh the page and try again.');
                return false;
            }

            $.ajax({
                type: "POST",
                url: ajax_url,
                dataType: "json",
                data: {
                    action: "felan_freelancer_write_a_review",
                    nonce: felan_template_vars.nonces.write_review,
                    freelancer_id: freelancer_id,
                },
                beforeSend: function () {
                },
                success: function (response) {
                    if (response.html_review) {
                        var $viewForm = $('#form-popup-view');
                        if ($viewForm.length > 0) {
                            $viewForm.hide();
                        }

                        var $editForm = $('#form-popup-review.form-review-jobs');

                        if ($editForm.length === 0) {
                            return;
                        }

                        $editForm.find('.reviewForm-project .content-popup-review').html(response.html_review);
                        $editForm.find('.reviewForm-project input[name="action"]').val('felan_freelancer_submit_review_ajax');
                        var $freelancerIdInput = $editForm.find('.reviewForm-project input[name="freelancer_id"]');
                        if ($freelancerIdInput.length) {
                            $freelancerIdInput.val(freelancer_id);
                        } else {
                            $editForm.find('.reviewForm-project').append('<input type="hidden" name="freelancer_id" value="' + freelancer_id + '">');
                        }
                        $editForm.find('.reviewForm-project input[name="order_id"]').val(order_id);

                        if (response.nonce) {
                            $editForm.find('input[name="nonce"]').val(response.nonce);
                        }

                        if (response.has_existing_review) {
                            $editForm.addClass('form-review-jobs-edit');
                            $editForm.find('.reviewForm-project .felan-submit-freelancer-rating').text('Update Review');

                            var formDisabled = $editForm.attr('data-disabled') === 'true';

                            if (formDisabled) {
                                $editForm.find('.reviewForm-project textarea').prop('readonly', true).prop('disabled', true);
                                $editForm.find('.reviewForm-project input[type="radio"]').prop('disabled', true);
                                $editForm.find('.reviewForm-project .rate').css('pointer-events', 'none').css('opacity', '0.6');
                                $editForm.find('#btn-submit-review').hide();
                            } else {
                                $editForm.find('.reviewForm-project textarea').prop('readonly', false).prop('disabled', false);
                                $editForm.find('.reviewForm-project input[type="radio"]').prop('disabled', false);
                                $editForm.find('.reviewForm-project .rate').css('pointer-events', 'auto').css('opacity', '1');
                                $editForm.find('#btn-submit-review').show();
                            }
                        } else {
                            $editForm.removeClass('form-review-jobs-edit');
                            $editForm.find('.reviewForm-project .felan-submit-freelancer-rating').text('Submit');
                            $editForm.find('.reviewForm-project textarea').prop('readonly', false).prop('disabled', false);
                            $editForm.find('.reviewForm-project input[type="radio"]').prop('disabled', false);
                            $editForm.find('.reviewForm-project .rate').css('pointer-events', 'auto').css('opacity', '1');
                            $editForm.find('#btn-submit-review').show();
                        }

                        $editForm.css({
                            'opacity': '1',
                            'visibility': 'visible',
                            'display': 'block'
                        });

                        $('body').addClass('popup-open');
                    }
                },
                error: function (xhr, status, error) {
                }
            });
        });

        $("body").on("click", ".btn-approve-proposal", function (e) {
            e.preventDefault();
            ajax_load("inprogress", $(this));
        });

        $("body").on("click", ".btn-reject-proposal", function (e) {
            e.preventDefault();
            ajax_load("reject", $(this));
        });

        $("body").on("click", ".btn-complete", function (e) {
            if ($(this).closest('.reviewForm-project').length > 0 || $(this).hasClass('felan-submit-freelancer-rating')) {
                return;
            }

            e.preventDefault();
            ajax_load("completed", $(this));
        });

        $("body").on("click", ".reviewForm-project .btn-complete-without-feedback", function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            e.stopPropagation();

            var $button = $(this);
            var $form = $button.closest('.reviewForm-project');
            var order_id = $form.find('input[name="order_id"]').val();

            if (!order_id) {
                var $errorMsg = $form.find('.felan-message-error');
                if ($errorMsg.length) {
                    $errorMsg.html('<span class="error-text">Order ID is missing.</span>').fadeIn();
                }
                return false;
            }

            $button.find(".btn-loading").fadeIn();
            $button.prop('disabled', true);

            var project_id = $form.find('input[name="project_id"]').val() || $('input[name="project_id"]').val();

            $.ajax({
                type: "POST",
                url: ajax_url,
                dataType: "json",
                data: {
                    action: "felan_employer_project_detail",
                    action_click: "completed",
                    order_id: order_id,
                    project_id: project_id,
                },
                success: function (data) {
                    $button.find(".btn-loading").fadeOut();
                    $button.prop('disabled', false);
                    if (data.success === true) {
                        window.location.reload();
                    } else {
                        var $errorMsg = $form.find('.felan-message-error');
                        var errorMessage = data.message || 'Submission failed';
                        if ($errorMsg.length) {
                            $errorMsg.html('<span class="error-text">' + errorMessage + '</span>').fadeIn();
                        } else {
                            alert(errorMessage);
                        }
                    }
                },
                error: function (xhr, status, error) {
                    $button.find(".btn-loading").fadeOut();
                    $button.prop('disabled', false);
                    var $errorMsg = $form.find('.felan-message-error');
                    var errorMsg = 'Error submitting request.';
                    if (xhr.responseText) {
                        try {
                            var response = JSON.parse(xhr.responseText);
                            if (response.message) {
                                errorMsg = response.message;
                            }
                        } catch (e) {
                        }
                    }
                    if ($errorMsg.length) {
                        $errorMsg.html('<span class="error-text">' + errorMsg + '</span>').fadeIn();
                    } else {
                        alert(errorMsg);
                    }
                }
            });

            return false;
        });

        $("body").on("click", ".order-status .btn-canceled", function (e) {
            e.preventDefault();
            ajax_load("canceled", $(this));
        });

        $("body").on("click", ".btn-order-refund", function (e) {
            var item_id = $(this).attr("order-id");
            form_refund.find('#btn-project-refund').attr("order-id",item_id);
        });

        $("body").on("click", "#btn-project-refund", function (e) {
            e.preventDefault();
            var tell_us = form_refund.find('input[name="reason"]:checked').val(),
                content_refund = form_refund.find('textarea[name="project_content_refund"]').val();
            ajax_load("refund",$(this), tell_us,content_refund);
        });

        function ajax_load(action_click = "", $button, tell_us = "", content_refund = "") {
            var order_id = $('input[name="order_id"]').val();
            var project_id = $('input[name="project_id"]').val();
            var proposal_price = $('input[name="proposal_price"]').val();
            var projects_budget_show = $('input[name="projects_budget_show"]').val();
            var proposal_time = $('input[name="proposal_time"]').val();
            var proposal_fixed_time = $('input[name="proposal_fixed_time"]').val();
            var proposal_rate = $('input[name="proposal_rate"]').val();

            $.ajax({
                dataType: "json",
                url: ajax_url,
                data: {
                    action: "felan_employer_project_detail",
                    action_click: action_click,
                    content_refund: content_refund,
                    tell_us: tell_us,
                    project_id: project_id,
                    order_id: order_id,
                    proposal_price: proposal_price,
                    projects_budget_show: projects_budget_show,
                    proposal_time: proposal_time,
                    proposal_fixed_time: proposal_fixed_time,
                    proposal_rate: proposal_rate,
                },
                beforeSend: function () {
                    $button.find(".btn-loading").fadeIn();
                },
                success: function (data) {
                    $button.find(".btn-loading").fadeOut();
                    if (data.success === true) {
                        if(action_click == 'inprogress'){
                            window.location.href = payment_url;
                        } else {
                            window.location.reload();
                        }
                    } else {
                        form_refund.find(".felan-message-error").text(data.message);
                    }
                }
            });
        }

        //Message
        var form_message = $('#felan-form-message-order');
        $("body").on("click", ".btn-send-message", function (e) {
            e.preventDefault();
            var message_content= form_message.find('#message_content').val();
            var recipient_id = form_message.find('#recipient_id').val();
            var order_id = form_message.find('#order_id').val();
            var user_role = form_message.find('#user_role').val();
            var attachment_id = form_message.find('#felan_drop_cv').data("attachment-id");
            var $this = $(this);

            $.ajax({
                dataType: "json",
                url: ajax_url,
                data: {
                    action: 'felan_project_order_message',
                    nonce: felan_template_vars.nonces.order_message,
                    message_content: message_content,
                    recipient_id: recipient_id,
                    order_id: order_id,
                    user_role: user_role,
                    attachment_id: attachment_id,
                },
                beforeSend: function () {
                    $this.find(".btn-loading").fadeIn();
                },
                success: function (data) {
                    $this.find(".btn-loading").fadeOut();
                    form_message.find(".message_error").html(data.message);
                    if (data.success === true) {
                        window.location.reload();
                        form_message.find(".message_error").addClass("true");
                    }
                }
            });
        });
    });
})(jQuery);
