(function ($) {
    "use strict";

    if (typeof $.validator !== 'undefined') {
        var originalValidate = $.fn.validate;
        $.fn.validate = function(options) {
            var $form = $(this);
            var action = $form.find('input[name="action"]').val();
            if (action === 'felan_service_submit_review_ajax' || $form.hasClass('no-validate')) {
                return this;
            }
            return originalValidate.apply(this, arguments);
        };
    }

    $(document).ready(function () {
        var ajax_url = felan_service_review_vars.ajax_url;

        function disableValidate($form) {
            $form.attr('novalidate', 'novalidate');
            $form.addClass('no-validate');
            try {
                var validator = $form.data('validator');
                if (validator) {
                    $form.off('.validate');
                    $form.unbind('submit');
                    $form.removeData('validator');
                }
            } catch (err) {
            }
        }

        $('.reviewForm-service').each(function() {
            var $form = $(this);
            disableValidate($form);
        });

        function clearErrorOnForm($form) {
            var $errorMsg = $form.find('.felan-message-error');
            if ($errorMsg.length) {
                $errorMsg.fadeOut().html('');
            }
        }

        $(document).on('click', '#form-popup-review.form-review-service .btn-close, #form-popup-review.form-review-service .bg-overlay, #form-popup-review.form-review-service .button-cancel', function (e) {
            var $popup = $('#form-popup-review.form-review-service');
            var $form = $popup.find('.reviewForm-service');
            if ($form.length) {
                clearErrorOnForm($form);
            }
        });

        $(document).on('input change', '.reviewForm-service textarea[name="message"]', function() {
            var $form = $(this).closest('.reviewForm-service');
            clearErrorOnForm($form);
        });

        $(document).on('change', '.reviewForm-service input[type="radio"][name^="rating_"]', function() {
            var $form = $(this).closest('.reviewForm-service');
            clearErrorOnForm($form);
        });

        $("body").on("click", ".btn-action-review", function (e) {
            e.preventDefault();

            var service_id = $(this).attr('service-id');
            var order_id = $(this).attr('order-id') || '';

            $.ajax({
                type: "POST",
                url: ajax_url,
                dataType: "json",
                data: {
                    action: "felan_service_write_a_review",
                    nonce: felan_template_vars.nonces.write_review,
                    service_id: service_id,
                    order_id: order_id,
                },
                success: function (response) {
                    if (response.html_review) {
                        $('.reviewForm-service .content-popup-review').html(response.html_review);
                        $('.reviewForm-service input[name="service_id"]').val(service_id);
                        $('.reviewForm-service input[name="order_id"]').val(response.order_id || order_id);

                        var $existingForm = $('.reviewForm-service');
                        if ($existingForm.length) {
                            disableValidate($existingForm);
                        }

                        if (response.has_existing_review) {
                            $('#form-popup-review').addClass('form-review-service-edit');
                            $('.reviewForm-service .felan-submit-service-rating').text('Update Review');

                            var formDisabled = $('#form-popup-review').attr('data-disabled') === 'true';
                            if (formDisabled) {
                                $('.reviewForm-service textarea').prop('readonly', true).prop('disabled', true);
                                $('.reviewForm-service input[type="radio"]').prop('disabled', true);
                                $('.reviewForm-service .rate').css('pointer-events', 'none').css('opacity', '0.6');
                                $('#btn-submit-review').hide();
                            } else {
                                $('.reviewForm-service textarea').prop('readonly', false).prop('disabled', false);
                                $('.reviewForm-service input[type="radio"]').prop('disabled', false);
                                $('.reviewForm-service .rate').css('pointer-events', 'auto').css('opacity', '1');
                                $('#btn-submit-review').show();
                            }
                        } else {
                            $('#form-popup-review').removeClass('form-review-service-edit');
                            $('.reviewForm-service .felan-submit-service-rating').text('Submit');
                            $('.reviewForm-service textarea').prop('readonly', false).prop('disabled', false);
                            $('.reviewForm-service input[type="radio"]').prop('disabled', false);
                            $('.reviewForm-service .rate').css('pointer-events', 'auto').css('opacity', '1');
                            $('#btn-submit-review').show();
                        }

                        if ($('#form-popup-review').length) {
                            $('#form-popup-review').fadeIn();
                            $('body').addClass('popup-open');
                        }
                    }
                }
            });
        });

        $("body").on("click", ".btn-action-view", function (e) {
            e.preventDefault();

            var service_id = $(this).attr('service-id');
            var order_id = $(this).attr('order-id') || '';

            $.ajax({
                type: "POST",
                url: ajax_url,
                dataType: "json",
                data: {
                    action: "felan_service_write_a_review",
                    nonce: felan_template_vars.nonces.write_review,
                    service_id: service_id,
                    order_id: order_id,
                },
                success: function (response) {
                    if (response.html_review) {
                        var $editForm = $('#form-popup-review');

                        if ($editForm.length === 0) {
                            var enableEdit = response.enable_edit_review !== false;
                            var dataDisabled = enableEdit ? '' : 'data-disabled="true"';
                            var formHtml = '<div class="form-popup felan-form-popup form-review-service" id="form-popup-review" style="display: none; visibility: hidden; opacity: 0;" ' + dataDisabled + '>' +
                                '<div class="bg-overlay"></div>' +
                                '<form class="service-popup inner-popup custom-scrollbar reviewForm reviewForm-service" method="post" action="#" novalidate="novalidate">' +
                                '<a href="#" class="btn-close"><i class="far fa-times"></i></a>' +
                                '<h5>Your Review</h5>' +
                                '<div class="content-popup-review"></div>' +
                                '<div class="felan-message-error"></div>' +
                                '<div class="button-warpper">' +
                                '<a href="#" class="felan-button button-outline button-cancel">Cancel</a>' +
                                '<button class="felan-button btn-complete felan-submit-service-rating" id="btn-submit-review" type="submit" style="color: #fff;border-color: #1F72F2;margin-right: 0">' +
                                'Submit' +
                                '<span class="btn-loading"><i class="far fa-spinner fa-spin large"></i></span>' +
                                '</button>' +
                                '</div>' +
                                '<input type="hidden" name="nonce" value="' + (response.nonce || '') + '">' +
                                '<input type="hidden" name="action" value="felan_service_submit_review_ajax">' +
                                '<input type="hidden" name="service_id" value="">' +
                                '<input type="hidden" name="order_id" value="">' +
                                '</form>' +
                                '</div>';
                            $('body').append(formHtml);
                            $editForm = $('#form-popup-review');

                            var $newForm = $editForm.find('.reviewForm');
                            if ($newForm.length > 0) {
                                disableValidate($newForm);
                            }

                            $editForm.find('.btn-close, .bg-overlay, .button-cancel').on('click', function (e) {
                                e.preventDefault();
                                var $form = $editForm.find('.reviewForm-service');
                                if ($form.length) {
                                    clearErrorOnForm($form);
                                }
                                $editForm.fadeOut();
                                $('body').removeClass('popup-open');
                            });
                        }

                        $editForm.find('.reviewForm-service .content-popup-review').html(response.html_review);
                        $editForm.find('.reviewForm-service input[name="service_id"]').val(service_id);
                        $editForm.find('.reviewForm-service input[name="order_id"]').val(response.order_id || order_id);

                        if (response.nonce) {
                            $editForm.find('input[name="nonce"]').val(response.nonce);
                        }

                        var $formContent = $editForm.find('.reviewForm-service');
                        if ($formContent.length) {
                            disableValidate($formContent);
                        }

                        if (response.has_existing_review) {
                            $editForm.addClass('form-review-service-edit');
                            $editForm.find('.reviewForm-service .felan-submit-service-rating').text('Update Review');

                            var formDisabled = $editForm.attr('data-disabled') === 'true';

                            if (formDisabled) {
                                $editForm.find('.reviewForm-service textarea').prop('readonly', true).prop('disabled', true);
                                $editForm.find('.reviewForm-service input[type="radio"]').prop('disabled', true);
                                $editForm.find('.reviewForm-service .rate').css('pointer-events', 'none').css('opacity', '0.6');
                                $editForm.find('#btn-submit-review').hide();
                            } else {
                                $editForm.find('.reviewForm-service textarea').prop('readonly', false).prop('disabled', false);
                                $editForm.find('.reviewForm-service input[type="radio"]').prop('disabled', false);
                                $editForm.find('.reviewForm-service .rate').css('pointer-events', 'auto').css('opacity', '1');
                                $editForm.find('#btn-submit-review').show();
                            }
                        } else {
                            $editForm.removeClass('form-review-service-edit');
                            $editForm.find('.reviewForm-service .felan-submit-service-rating').text('Submit');
                            $editForm.find('.reviewForm-service textarea').prop('readonly', false).prop('disabled', false);
                            $editForm.find('.reviewForm-service input[type="radio"]').prop('disabled', false);
                            $editForm.find('.reviewForm-service .rate').css('pointer-events', 'auto').css('opacity', '1');
                            $editForm.find('#btn-submit-review').show();
                        }

                        $editForm.css({
                            'opacity': '1',
                            'visibility': 'unset'
                        });

                        $('body').addClass('popup-open');
                    }
                }
            });
        });

        $(document).on("submit", ".reviewForm-service", function (e) {
            var $form = $(this);
            var action = $form.find('input[name="action"]').val();

            if (action === 'felan_service_submit_review_ajax') {
                e.preventDefault();
                e.stopImmediatePropagation();
                e.stopPropagation();

                disableValidate($form);

                var service_id = $form.find('input[name="service_id"]').val();
                var order_id = $form.find('input[name="order_id"]').val();
                var message = $form.find('textarea[name="message"]').val();
                var rating_salary = $form.find('input[name="rating_salary"]:checked').val();
                var rating_service = $form.find('input[name="rating_service"]:checked').val();
                var rating_skill = $form.find('input[name="rating_skill"]:checked').val();
                var rating_work = $form.find('input[name="rating_work"]:checked').val();

                var $errorMsg = $form.find('.felan-message-error');

                function showError(message) {
                    if ($errorMsg.length) {
                        $errorMsg.html('<span class="error-text">' + message + '</span>').fadeIn();
                    } else {
                        alert(message);
                    }
                }

                function hideError() {
                    if ($errorMsg.length) {
                        $errorMsg.fadeOut().html('');
                    }
                }

                if (!service_id) {
                    showError(felan_service_review_vars.errors.service_id_missing);
                    return false;
                }
                hideError();

                if (!message || message.trim() === '') {
                    showError(felan_service_review_vars.errors.message_required);
                    return false;
                }
                hideError();

                if (!rating_salary || !rating_service || !rating_skill || !rating_work) {
                    showError(felan_service_review_vars.errors.ratings_required);
                    return false;
                }
                hideError();

                var $this = $form.find("#btn-submit-review, .felan-submit-service-rating");
                var formDataToSend = $form.serialize();

                $.ajax({
                    type: "POST",
                    url: ajax_url,
                    data: formDataToSend,
                    dataType: "json",
                    beforeSend: function () {
                        hideError();
                        $this.children("i").remove();
                        $this.append('<i class="fa-left fal fa-spinner fa-spin large"></i>');
                    },
                    success: function (data) {
                        if (data.success) {
                            hideError();
                            window.location.reload();
                        } else {
                            var errorMessage = data.data && data.data.message ? data.data.message : felan_service_review_vars.errors.submission_failed;
                            showError(errorMessage);
                        }
                    },
                    error: function (xhr, status, error) {
                        var errorMsg = felan_service_review_vars.errors.submit_error;
                        if (xhr.responseText) {
                            try {
                                var response = JSON.parse(xhr.responseText);
                                if (response.data && response.data.message) {
                                    errorMsg = response.data.message;
                                }
                            } catch (e) {
                            }
                        }
                        showError(errorMsg);
                    },
                    complete: function () {
                        $this.children("i").removeClass("fal fa-spinner fa-spin large");
                        $this.children("i").addClass("fa fa-check");
                    },
                });

                return false;
            }
        });

        $("body").on("click", ".reviewForm-service .btn-complete-without-feedback", function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            e.stopPropagation();

            var $button = $(this);
            var $form = $button.closest('.reviewForm');
            var order_id = $form.find('input[name="order_id"]').val();

            if (!order_id) {
                var $errorMsg = $form.find('.felan-message-error');
                if ($errorMsg.length) {
                    $errorMsg.html('<span class="error-text">' + (felan_service_review_vars.errors && felan_service_review_vars.errors.service_id_missing ? felan_service_review_vars.errors.service_id_missing.replace('Service', 'Order') : 'Order ID is missing.') + '</span>').fadeIn();
                }
                return false;
            }

            $button.find(".btn-loading").fadeIn();
            $button.prop('disabled', true);

            $.ajax({
                type: "POST",
                url: ajax_url,
                dataType: "json",
                data: {
                    action: "felan_employer_service_detail",
                    action_click: "completed",
                    order_id: order_id,
                },
                success: function (data) {
                    $button.find(".btn-loading").fadeOut();
                    $button.prop('disabled', false);
                    if (data.success === true) {
                        window.location.reload();
                    } else {
                        var $errorMsg = $form.find('.felan-message-error');
                        var errorMessage = data.message || (felan_service_review_vars.errors && felan_service_review_vars.errors.submission_failed ? felan_service_review_vars.errors.submission_failed : 'Submission failed');
                        if ($errorMsg.length) {
                            $errorMsg.html('<span class="error-text">' + errorMessage + '</span>').fadeIn();
                        } else {
                            alert(errorMessage);
                        }
                    }
                },
                error: function (xhr, status, error) {
                    $button.find(".btn-loading").fadeOut();
                    $button.prop('disabled', false);
                    var $errorMsg = $form.find('.felan-message-error');
                    var errorMsg = felan_service_review_vars.errors && felan_service_review_vars.errors.submit_error ? felan_service_review_vars.errors.submit_error : 'Error submitting request.';
                    if (xhr.responseText) {
                        try {
                            var response = JSON.parse(xhr.responseText);
                            if (response.message) {
                                errorMsg = response.message;
                            }
                        } catch (e) {
                        }
                    }
                    if ($errorMsg.length) {
                        $errorMsg.html('<span class="error-text">' + errorMsg + '</span>').fadeIn();
                    } else {
                        alert(errorMsg);
                    }
                }
            });

            return false;
        });
    });
})(jQuery);
