var FREELANCER_REVIEW = FREELANCER_REVIEW || {};

(function ($) {
  "use strict";

  FREELANCER_REVIEW = {
    init: function () {
      FREELANCER_REVIEW.submit_review();
    },

    submit_review: function () {
      var ajax_url = felan_freelancer_review_vars.ajax_url;
      var freelancer_review = $(".freelancer-review-details");

      freelancer_review.find("input:file").change(function () {
        $(".fileList span").remove();
        for (var i = 0; i < this.files.length; i++) {
          var fileName = this.files[i].name;
          $(".fileList").append("<span>" + fileName + "</span>");
        }
      });

      freelancer_review.find(".entry-nav .reply").on("click", function (e) {
        e.preventDefault();
        $(".author-review").removeClass("active");
        $(".author-review .form-reply").html("");
        var $this = $(this);
        var form_reply = $(".duplicate-form-reply").html();
        var comment_id = $this
          .parents(".author-review")
          .find(".form-reply")
          .data("id");
        $(".add-new-review").hide();
        $this.parents(".author-review").addClass("active");
        $this.parents(".author-review").find(".form-reply").html(form_reply);
        $this
          .parents(".author-review")
          .find('.form-reply input[name="comment_id"]')
          .val(comment_id);
      });

      $("body").on(
        "click",
        ".form-reply .felan-submit-freelancer-reply",
        function (e) {
          e.preventDefault();
          var $this = $(this);
          var $form = $this.parents("form");
          var message = $form.find("textarea").val();
          if (message == "") {
            $form.find("#message-error").fadeIn();
          } else {
            $form.find("#message-error").fadeOut();

            $.ajax({
              type: "POST",
              url: ajax_url,
              data: $form.serialize(),
              dataType: "json",
              beforeSend: function () {
                $this.attr("disabled", true);
                $this.children("i").remove();
                $this.append(
                  '<i class="fa-left fal fa-spinner fa-spin large"></i>'
                );
              },
              success: function () {
                window.location.reload();
              },
              complete: function () {
                $this.children("i").removeClass("fal fa-spinner fa-spin large");
                $this.children("i").addClass("fa fa-check");
              },
            });
          }
        }
      );

      $("body").on("click", ".cancel-reply", function (e) {
        e.preventDefault();
        freelancer_review.find(".author-review").removeClass("active");
        freelancer_review.find(".author-review .form-reply").html("");
        freelancer_review.find(".add-new-review").show();
      });

      function clearErrorOnForm($form) {
        var $errorMsg = $form.find('.felan-message-error');
        if ($errorMsg.length) {
          $errorMsg.fadeOut().html('');
        }
      }

      $(document).on('input change', '.reviewForm textarea[name="message"]', function() {
        var $form = $(this).closest('.reviewForm');
        clearErrorOnForm($form);
      });

      $(document).on('change', '.reviewForm input[type="radio"][name^="rating_"]', function() {
        var $form = $(this).closest('.reviewForm');
        clearErrorOnForm($form);
      });

      $(document).on('click', '.reviewForm .btn-close, .reviewForm .bg-overlay, .reviewForm .button-cancel', function (e) {
        var $form = $(this).closest('.reviewForm');
        if ($form.length) {
          clearErrorOnForm($form);
        }
      });

      $("body").on("submit", ".reviewForm", function(e) {
        var $form = $(this);
        var action = $form.find('input[name="action"]').val();

        if (action === 'felan_freelancer_submit_review_ajax') {
          if ($form.data('validator')) {
            $form.removeData('validator');
            $form.unbind('submit');
          }

          e.preventDefault();
          e.stopImmediatePropagation();

          var $errorMsg = $form.find('.felan-message-error');

          function showError(message) {
            if ($errorMsg.length) {
              $errorMsg.html('<span class="error-text">' + message + '</span>').fadeIn();
            } else {
              alert(message);
            }
          }

          function hideError() {
            if ($errorMsg.length) {
              $errorMsg.fadeOut().html('');
            }
          }

          var freelancer_id = $form.find('input[name="freelancer_id"]').val();
          var message = $form.find('textarea[name="message"]').val();
          var rating_team = $form.find('input[name="rating_team"]:checked').val();
          var rating_working = $form.find('input[name="rating_working"]:checked').val();
          var rating_skill = $form.find('input[name="rating_skill"]:checked').val();
          var rating_salary = $form.find('input[name="rating_salary"]:checked').val();

          if (!freelancer_id) {
            showError(felan_freelancer_review_vars.errors.freelancer_id_missing);
            return false;
          }
          hideError();

          if (!rating_team || !rating_working || !rating_skill || !rating_salary) {
            showError(felan_freelancer_review_vars.errors.ratings_required);
            return false;
          }
          hideError();

          if (!message || message.trim() === '') {
            showError(felan_freelancer_review_vars.errors.message_required);
            return false;
          }
          hideError();

          var $this = $form.find("#btn-submit-review, .felan-submit-freelancer-rating");

          var formDataToSend = $form.serialize();

          $.ajax({
            type: "POST",
            url: ajax_url,
            data: formDataToSend,
            dataType: "json",
            beforeSend: function () {
              hideError();
              $this.children("i").remove();
              $this.append(
                '<i class="fa-left fal fa-spinner fa-spin large"></i>'
              );
            },
            success: function (data) {
              if (data.success) {
                hideError();
                window.location.reload();
              } else {
                var errorMessage = data.data && data.data.message ? data.data.message : felan_freelancer_review_vars.errors.submission_failed;
                showError(errorMessage);
              }
            },
            error: function (xhr, status, error) {
              var errorMsg = felan_freelancer_review_vars.errors.submit_error;
              if (xhr.responseText) {
                try {
                  var response = JSON.parse(xhr.responseText);
                  if (response.data && response.data.message) {
                    errorMsg = response.data.message;
                  }
                } catch (e) {
                }
              }
              showError(errorMsg);
            },
            complete: function () {
              $this.children("i").removeClass("fal fa-spinner fa-spin large");
              $this.children("i").addClass("fa fa-check");
            },
          });

          return false;
        }

        // For service and company review forms, let jQuery Validate handle it
        // Don't prevent default - jQuery Validate's submitHandler will process it
      });

      $(".reviewForm").each(function() {
        var $form = $(this);
        var action = $form.find('input[name="action"]').val();

        if (action === 'felan_freelancer_submit_review_ajax') {
          return;
        }

        $form.validate({
          rules: {
            message: {
              required: true,
            },
          },
          messages: {
            message: {
              required: "This field is required",
            },
          },
          errorPlacement: function (error, element) {
            if (element.is(":radio")) {
              error.appendTo(element.parents("fieldset"));
            } else {
              error.insertAfter(element);
            }
          },
          submitHandler: function (form) {
            return true;
          },
        });
      });
    },
  };

  $(document).ready(FREELANCER_REVIEW.init());
})(jQuery);
