var JOBS = JOBS || {};
(function (r) {
  "use strict";
  JOBS = {
    init: function () {
      this.toggle_insights();
      this.toggle_insights_sidebar();
      this.toggle_overview();
      this.toggle_review();
      this.apply_popup();
      this.felan_alert_message();
      this.felan_crop_image();
      this.popup_job_alerts();
    },
    toggle_insights: function () {
      var e = r(".show-more-insights");
      var t = r(".hide-all-insights");
      var s = r(".jobs-insights-details");
      s.addClass("on");
      e.click(function (i) {
        i.preventDefault();
        s.removeClass("on");
        t.show();
        r(this).hide();
      });
      t.click(function (i) {
        i.preventDefault();
        s.addClass("on");
        e.show();
        r(this).hide();
      });
    },
    toggle_insights_sidebar: function () {
      var e = r(".show-more-insights-sidebar");
      var t = r(".hide-all-insights-sidebar");
      var s = r(".jobs-insights-sidebar");
      s.addClass("on");
      e.click(function (i) {
        i.preventDefault();
        s.removeClass("on");
        t.show();
        r(this).hide();
      });
      t.click(function (i) {
        i.preventDefault();
        s.addClass("on");
        e.show();
        r(this).hide();
      });
    },
    toggle_overview: function () {
      var e = r(".show-more-description");
      var t = r(".hide-all-description");
      var s = r(".felan-description-details");
      var i = r(".felan-description").height();
      s.addClass("on");
      e.click(function (i) {
        i.preventDefault();
        s.removeClass("on");
        t.show();
        r(this).hide();
      });
      t.click(function (i) {
        i.preventDefault();
        s.addClass("on");
        e.show();
        r(this).hide();
      });
      if (i < 330) {
        s.find(".toggle-description").hide();
      }
    },
    toggle_review: function () {
      var e = r(".show-more-review");
      var t = r(".hide-all-review");
      var s = r(".felan-review-details");
      var i = r(".felan-review").height();
      s.addClass("on");
      e.click(function (i) {
        i.preventDefault();
        s.removeClass("on");
        t.show();
        r(this).hide();
      });
      t.click(function (i) {
        i.preventDefault();
        s.addClass("on");
        e.show();
        r(this).hide();
      });
      if (i < 120) {
        s.find(".toggle-review").hide();
      }
    },
    apply_popup: function () {
      var i = r(".form-popup-apply");
      var n = i.find(".btn-close");
      var a = i.find(".bg-overlay");
      var o = i.find(".button-cancel");
      i.each(function () {
        var e = r("#" + r(this).attr("id"));
        var i = r(".felan-button-apply." + r(this).attr("id"));
        function t(i) {
          i.preventDefault();
          e.css({ opacity: "1", visibility: "unset" });
        }
        function s(i) {
          i.preventDefault();
          e.css({ opacity: "0", visibility: "hidden" });
        }
        i.on("click", t);
        a.on("click", s);
        n.on("click", s);
        o.on("click", s);
      });
    },
    felan_alert_message: function () {
      r("body").on("click", ".btn-add-to-message", function (i) {
        i.preventDefault();
        var e = r(this).data("text");
        var t = '<div class="felan_alert_message fadeInRight">' + e + "</div>";
        r("body").find(".felan_alert_message").remove();
        r("body").append(t).fadeIn(500);
        setTimeout(function () {
          r("body")
            .find(".felan_alert_message")
            .removeClass("fadeInRight")
            .addClass("fadeOutRight show");
        }, 2e3);
      });
    },
    felan_crop_image: function () {
      var i = r(".felan_crop_image img"),
        e = i.attr("height"),
        t = i.attr("width");
      i.css({ height: e, width: t, "object-fit": "cover" });
    },
    popup_job_alerts: function () {
      r(".alert-form").each(function () {
        var e = r(this);
        if (sessionStorage.getItem("hide-alert-form") == "true") {
          e.fadeOut(0);
        } else {
          e.fadeIn(0);
          var i = e.find(".close");
          i.on("click", function (i) {
            i.preventDefault();
            sessionStorage.setItem("hide-alert-form", "true");
            e.fadeOut(0);
          });
        }
      });
    },
  };
  r(document).ready(function () {
    JOBS.init();
  });
})(jQuery);
