(function ($) {
  "use strict";

  jQuery(document).ready(function () {
    // Initialize upload for each custom upload field
    $(".felan-fields-custom_upload").each(function () {
      var $field = $(this);
      var field_id = $field.find("input.cv_attachment_id").attr("id").replace("cv_attachment_id_", "");

      if (!field_id) return;

      var ajax_url = felan_upload_cv_vars.ajax_url;
      var title = felan_upload_cv_vars.title;
      var cv_file = felan_upload_cv_vars.cv_file;
      var cv_max_file_size = felan_upload_cv_vars.cv_max_file_size;
      var upload_nonce = felan_upload_cv_vars.upload_nonce;
      var url = felan_upload_cv_vars.url;

      var uploader = new plupload.Uploader({
        browse_button: "felan_select_cv_" + field_id,
        file_data_name: "felan_thumbnail_upload_file",
        container: "felan_cv_container_" + field_id,
        url: url,
        filters: {
          mime_types: [
            {
              title: title,
              extensions: cv_file,
            },
          ],
          max_file_size: cv_max_file_size,
          prevent_duplicates: true,
        },
      });

      uploader.init();

      uploader.bind("UploadProgress", function (up, file) {
        $("#felan_select_cv_" + field_id + " i").removeClass("far fa-arrow-from-bottom");
        $("#felan_select_cv_" + field_id + " i").addClass("fal fa-spinner fa-spin");
      });

      uploader.bind("FilesAdded", function (up, files) {
        up.refresh();
        uploader.start();
      });

      uploader.bind("Error", function (up, err) {
        $("#cv_errors_log_" + field_id).html("Error #" + err.code + ": " + err.message);
      });

      uploader.bind("FileUploaded", function (up, file, ajax_response) {
        var response = $.parseJSON(ajax_response.response);
        if (response.success) {
          // Remove previous file UI if exists
          $("#felan_cv_container_" + field_id).find(".file-uploaded-item").remove();
          $("#felan_cv_upload_" + field_id).show();

          // Update hidden input
          var $hiddenInput = $("#cv_attachment_id_" + field_id);
          $hiddenInput.val(response.attachment_id);

          // Create file uploaded item
          var $html =
            '<div class="file-uploaded-item">' +
            '<div class="file-info">' +
            '<i class="far fa-file-alt"></i>' +
            '<span class="file-name">' + response.title + "</span>" +
            "</div>" +
            '<div class="media-item-actions">' +
            '<a href="#" class="icon-file-delete" data-field-id="' + field_id + '" data-attachment-id="' + response.attachment_id + '">' +
            '<i class="far fa-trash-alt"></i>' +
            "</a>" +
            "</div>" +
            "</div>";

          $("#felan_cv_container_" + field_id).prepend($html);
          $("#felan_cv_upload_" + field_id).hide();

          // Reset button
          $("#felan_select_cv_" + field_id + " i").removeClass("fal fa-spinner fa-spin");
          $("#felan_select_cv_" + field_id + " i").addClass("far fa-arrow-from-bottom");
        }
      });
    });

    // Handle file delete - mark for deletion on submit
    $("body").on("click", ".felan-fields-custom_upload .icon-file-delete, .felan-fields-custom_upload .media-item-actions", function (e) {
      e.preventDefault();
      e.stopPropagation();

      var $this = $(this),
        field_id = $this.data("field-id"),
        attachment_id = $this.data("attachment-id");

      if (!field_id || !attachment_id) {
        return;
      }

      // Hide UI immediately
      $this.closest(".file-uploaded-item").remove();
      $("#felan_cv_upload_" + field_id).show();
      $("#cv_attachment_id_" + field_id).val("");

      // Mark for deletion on submit
      if (!$("input[name='felan_delete_file_" + field_id + "']").length) {
        $("#felan_cv_container_" + field_id).append(
          '<input type="hidden" name="felan_delete_file_' + field_id + '" value="' + attachment_id + '">'
        );
      }
    });
  });
})(jQuery);

