(function ($) {
    "use strict";
    var ajax_url = felan_mess_file_vars.ajax_url,
        title = felan_mess_file_vars.title,
        file_type = felan_mess_file_vars.file_type,
        max_file_size = felan_mess_file_vars.max_file_size,
        file_max_size = felan_mess_file_vars.file_max_size || '1000kb',
        file_url = felan_mess_file_vars.file_url,
        file_upload_nonce = felan_mess_file_vars.file_upload_nonce;

	function showFileUploadError(message) {
		var errorElement = $(".felan-message-error");
		if (errorElement.length) {
			errorElement.html(message).show();
		}
	}

	function hideFileUploadError() {
		var errorElement = $(".felan-message-error");
		if (errorElement.length) {
			errorElement.hide();
		}
	}

    $(document).ready(function () {
        // Validation: Check if plupload is available
        if (typeof plupload === 'undefined') {
            console.error('plupload is not loaded');
            showFileUploadError('File upload functionality is not available. Please refresh the page.');
            return;
        }

        // Validation: Check if required DOM elements exist
        var $selectFileBtn = $("#felan_select_file");
        var $fileContainer = $("#felan_file_container");
        if (!$selectFileBtn.length || !$fileContainer.length) {
            console.error('Required DOM elements not found');
            return;
        }

        var featured_image = function () {
            // Handle empty file_type - allow all file types
            var mimeTypesConfig = [];
            if (file_type && file_type.trim() !== '') {
                mimeTypesConfig = [
                    {
                        title: title,
                        extensions: file_type,
                    },
                ];
            }

            var uploader_featured_image = new plupload.Uploader({
                browse_button: "felan_select_file",
                file_data_name: "felan_thumbnail_upload_file",
                drop_element: "felan_select_file",
                container: "felan_file_container",
                url: file_url,
                filters: {
                    mime_types: mimeTypesConfig,
                    max_file_size: file_max_size,
                    prevent_duplicates: true,
                },
            });
            uploader_featured_image.init();

            uploader_featured_image.bind("UploadProgress", function (up, file) {
                $("#felan_select_file i").removeClass("far fa-file-upload fal fa-spinner fa-spin large");
                $("#felan_select_file i").addClass("fal fa-spinner fa-spin large");
            });

            uploader_featured_image.bind("FilesAdded", function (up, files) {
                var maxfiles = 1;
                hideFileUploadError(); // Hide any previous errors
                up.refresh();
                uploader_featured_image.start();
            });
            uploader_featured_image.bind("Error", function (up, err) {
                var messages = felan_mess_file_vars.messages || {
                    upload_failed: 'Upload failed',
                    file_size_error: 'File too large (max'
                };

                // Handle file size errors specifically
                if (err.message.indexOf("File size") !== -1) {
                    showFileUploadError(messages.file_size_error + " " + file_max_size + ")");
                    return;
                }

                // Handle other upload errors
                showFileUploadError(messages.upload_failed + ": " + err.message);
            });
            uploader_featured_image.bind(
                "FileUploaded",
                function (up, file, ajax_response) {
                    var response = $.parseJSON(ajax_response.response);
                    if (response.success) {
                        hideFileUploadError(); // Hide any previous errors
                        $(".file_url").val(response.url);
                        $("#felan_drop_file").attr(
                            "data-attachment-id",
                            response.attachment_id
                        );
                        $("#felan_drop_file .cv-icon-delete").remove();

                        // Update button icon and show file info without replacing the button
                        var $selectFileBtn = $("#felan_select_file");
                        var $selectFileIcon = $selectFileBtn.find("i");
                        if ($selectFileIcon.length) {
                            $selectFileIcon.removeClass("far fa-file-upload fal fa-spinner fa-spin large").addClass("far fa-check-circle large");
                        }

                        // Display file info in the view area
                        var $html =
                            '<button><i class="far fa-check-circle large"></i><span>' +
                            response.title +
                            "</span>" +
                            '<a class="icon cv-icon-delete" data-attachment-id="' +
                            response.attachment_id +
                            '" href="#" ><i class="far fa-trash-alt large"></i></a></button>';

                        $("#felan_mess_file_view").html($html);
                    } else {
                        // Show server-side error message
                        showFileUploadError(response.reason || "File upload failed");
                        // Reset button icon on error
                        var $selectFileIcon = $("#felan_select_file i");
                        if ($selectFileIcon.length) {
                            $selectFileIcon.removeClass("fal fa-spinner fa-spin large").addClass("far fa-file-upload");
                        }
                    }
                }
            );
        };
        featured_image();
        // Handle file deletion for messages
        var felan_message_file_delete = function () {
            $("body").on("click", ".cv-icon-delete", function (e) {
                e.preventDefault();
                var $this = $(this),
                    icon_delete = $this,
                    attachment_id = $this.data("attachment-id");

                if (!attachment_id) {
                    console.error('No attachment ID found for deletion');
                    return;
                }

                icon_delete.html('<i class="fal fa-spinner fa-spin large"></i>');

                $.ajax({
                    type: "post",
                    url: ajax_url,
                    dataType: "json",
                    data: {
                        action: "felan_thumbnail_remove_ajax",
                        attachment_id: attachment_id,
                        type: "message_file",
                        removeNonce: file_upload_nonce,
                    },
                    beforeSend: function () {
                        icon_delete.html('<i class="fal fa-spinner fa-spin large"></i>');
                    },
                    success: function (response) {
                        if (response.success) {
                            // Clear the file view and reset form
                            $("#felan_drop_file").attr("data-attachment-id", "");
                            $(".file_url").val("");
                            $("#felan_mess_file_view").html("");
                            // Reset button icon
                            $("#felan_select_file i").removeClass("far fa-check-circle large").addClass("far fa-file-upload");
                        } else {
                            showFileUploadError(response.message || "Failed to delete file");
                        }
                        icon_delete.html('<i class="far fa-trash-alt large"></i>');
                    },
                    error: function (xhr, status, error) {
                        console.error('Delete file error:', error);
                        showFileUploadError("Failed to delete file");
                        icon_delete.html('<i class="far fa-trash-alt large"></i>');
                    },
                });
            });
        };
        felan_message_file_delete();
    });
})(jQuery);
