(function ($) {
    "use strict";
    var ajax_url = felan_mess_image_vars.ajax_url,
        mess_image_title = felan_mess_image_vars.mess_image_title,
        mess_image_type = felan_mess_image_vars.mess_image_type,
        mess_image_file_size = felan_mess_image_vars.mess_image_file_size,
        mess_image_max_size = felan_mess_image_vars.mess_image_max_size || '1000kb',
        mess_image_id = felan_mess_image_vars.mess_image_id,
        mess_image_upload_nonce = felan_mess_image_vars.mess_image_upload_nonce;

	function showUploadError(message) {
		var errorElement = $(".felan-message-error");
		if (errorElement.length) {
			errorElement.html(message).show();
			// Auto hide after 5 seconds
			setTimeout(function() {
				errorElement.fadeOut();
			}, 5000);
		}
	}

	function hideUploadError() {
		var errorElement = $(".felan-message-error");
		if (errorElement.length) {
			errorElement.hide();
		}
	}

	function initSingleUploader($button, mess_image_id) {
		// Prevent multiple re-initializations.
		if ($button.data("plupload-initialized")) {
			// For AJAX loaded content, we need to re-initialize
			$button.removeData("plupload-initialized");
		}

		var uploader_mess_image = new plupload.Uploader({
			browse_button: $button.attr('id'),
			file_data_name: "felan_mess_image_upload_file_" + mess_image_id,
			drop_element: "felan_mess_image_view_" + mess_image_id,
			container: "felan_mess_image_container_" + mess_image_id,
			url:
			ajax_url +
			"?action=felan_mess_image_upload_ajax&nonce=" +
			mess_image_upload_nonce +
			"&mess_image_id=" +
			mess_image_id,
			filters: {
				mime_types: [
					{
						title: mess_image_title,
						extensions: mess_image_type,
					},
				],
				max_file_size: mess_image_max_size,
				prevent_duplicates: true,
			},
		});

		uploader_mess_image.init();
		$button.data("plupload-initialized", true);

		uploader_mess_image.bind("UploadProgress", function (up, file) {
			var $selectBtn = $("#felan_select_mess_image_" + mess_image_id);
			var $selectIcon = $selectBtn.find("i");
			if ($selectIcon.length) {
				$selectIcon.removeClass("far fa-images fal fa-spinner fa-spin large").addClass("fal fa-spinner fa-spin large");
			}
		});

		uploader_mess_image.bind("FilesAdded", function (up, files) {
			hideUploadError();
			up.refresh();
			uploader_mess_image.start();
		});

		uploader_mess_image.bind("Error", function (up, err) {
			var messages = felan_mess_image_vars.messages || {
				upload_failed: 'Upload failed',
				file_size_error: 'File too large (max'
			};

			// Handle file size errors specifically
			if (err.message.indexOf("File size") !== -1) {
				showUploadError(messages.file_size_error + " " + mess_image_max_size + ")");
				return;
			}

			// Handle other upload errors
			showUploadError(messages.upload_failed + ": " + err.message);
		});

		var $image_id = $("#mess_image_id_" + mess_image_id).val();
		var $image_url = $("#mess_image_url_" + mess_image_id).val();
		if ($image_id && $image_url) {
			var $html =
				'<figure class="media-thumb media-thumb-wrap">' +
				'<img src="' +
				$image_url +
				'">' +
				'<div class="media-item-actions">' +
				'<a class="icon icon-mess_image-delete_' +
				mess_image_id +
				'" data-attachment-id="' +
				$image_id +
				'" href="#" ><i class="far fa-trash-alt large"></i></a>' +
				'<span style="display: none;" class="icon icon-loader"><i class="fal fa-spinner fa-spin large"></i></span>' +
				"</div>" +
				"</figure>";
			$("#felan_mess_image_view_" + mess_image_id).html($html);
			$("#felan_add_mess_image_" + mess_image_id).hide();
		}

		uploader_mess_image.bind(
			"FileUploaded",
			function (up, file, ajax_response) {
				var response = $.parseJSON(ajax_response.response);
				if (response.success) {
					hideUploadError();
					$("#mess_image_url_" + mess_image_id).val(
						response.full_image
					);
					$("#mess_image_id_" + mess_image_id).val(
						response.attachment_id
					);

					// Update button icon to success state
					var $selectBtn = $("#felan_select_mess_image_" + mess_image_id);
					var $selectIcon = $selectBtn.find("i");
					if ($selectIcon.length) {
						$selectIcon.removeClass("far fa-images fal fa-spinner fa-spin large").addClass("far fa-check-circle large");
					}

					var $html =
						'<figure class="media-thumb media-thumb-wrap">' +
						'<img src="' +
						response.full_image +
						'">' +
						'<div class="media-item-actions">' +
						'<a class="icon icon-mess_image-delete_' +
						mess_image_id +
						'" data-attachment-id="' +
						response.attachment_id +
						'" href="#" ><i class="far fa-trash-alt large"></i></a>' +
						'<span style="display: none;" class="icon icon-loader"><i class="fal fa-spinner fa-spin large"></i></span>' +
						"</div>" +
						"</figure>";
					$("#felan_mess_image_view_" + mess_image_id).html($html);
					felan_thumbnai_delete();
				} else {
					// Show server-side error message
					showUploadError(response.reason || "Image upload failed");
					// Reset button icon on error
					var $selectIcon = $("#felan_select_mess_image_" + mess_image_id + " i");
					if ($selectIcon.length) {
						$selectIcon.removeClass("fal fa-spinner fa-spin large").addClass("far fa-images");
					}
				}
			}
		);

		var felan_thumbnai_delete = function ($type) {
			$("body").on(
				"click",
				".icon-mess_image-delete_" + mess_image_id,
				function (e) {
					e.preventDefault();
					var $this = $(this),
						icon_delete = $this,
						mess_image = $this
							.closest("#felan_mess_image_view_" + mess_image_id)
							.find(".media-thumb-wrap"),
						attachment_id = $this.data("attachment-id"),
						$drop = $("#felan_drop_mess_image_" + mess_image_id);

					if (!attachment_id) {
						console.error('No attachment ID found for image deletion');
						return;
					}

					icon_delete.html('<i class="fal fa-spinner fa-spin large"></i>');

					$.ajax({
						type: "post",
						url: ajax_url,
						dataType: "json",
						data: {
							action: "felan_mess_image_remove_ajax",
							attachment_id: attachment_id,
							type: $type,
							removeNonce: mess_image_upload_nonce,
						},
						success: function (response) {
							if (response.success) {
								mess_image.remove();
								$("#mess_image_url-error_" + mess_image_id).show();
								$("#felan_add_mess_image_" + mess_image_id).show();
								$drop.css("display", "block");
								$("input#mess_image_url_" + mess_image_id).val("");
								$("input#mess_image_id_" + mess_image_id).val("");

								// Reset button icon
								var $selectIcon = $("#felan_select_mess_image_" + mess_image_id + " i");
								if ($selectIcon.length) {
									$selectIcon.removeClass("far fa-check-circle large").addClass("far fa-images");
								}
							} else {
								showUploadError(response.message || "Failed to delete image");
							}
							icon_delete.html('<i class="far fa-trash-alt large"></i>');
						},
						error: function (xhr, status, error) {
							console.error('Delete image error:', error);
							showUploadError("Failed to delete image");
							icon_delete.html('<i class="far fa-trash-alt large"></i>');
						},
					});
				}
			);
		};

		felan_thumbnai_delete();
	}

	function initUploaderForId(mess_image_id) {
		const $button = $("#felan_select_mess_image_" + mess_image_id);

		if ($button.length === 0) {
			return;
		}

		if ($button.length > 1) {
			// Handle edge case: multiple buttons with same ID
			$button.each(function() {
				if (!$(this).data("plupload-initialized")) {
					initSingleUploader($(this), mess_image_id);
				}
			});
			return;
		}

		initSingleUploader($button, mess_image_id);
	}

	function initUploader() {
		// Try to find buttons directly instead of relying on wrapper data attributes
		var imageButtons = $('button[id^="felan_select_mess_image_"]');

		if (imageButtons.length > 0) {
			imageButtons.each(function() {
				var button = $(this);
				var buttonId = button.attr('id');
				var mess_image_id = buttonId.replace('felan_select_mess_image_', '');

				// Skip if already initialized
				if (button.data("plupload-initialized")) {
					return;
				}

				initUploaderForId(mess_image_id);
			});
			return;
		}

		// Fallback to original method using data attributes
		var mess_image = $(".felan-fields-mess_image");

		// If no elements found, try again after a short delay (for AJAX content)
		if (mess_image.length === 0) {
			setTimeout(function() {
				initUploader();
			}, 100);
			return;
		}

		$.each(mess_image, function () {
			const $wrapper = $(this);
			let mess_image_id = $wrapper.data("mess-image-id") || $wrapper.attr('data-mess-image-id') || $wrapper.attr('data-messimageid');

			// Fallback to global variable if data attribute not found
			if (!mess_image_id && typeof felan_mess_image_vars !== 'undefined' && felan_mess_image_vars.mess_image_id) {
				mess_image_id = felan_mess_image_vars.mess_image_id;
			}

			if (!mess_image_id) {
				return;
			}

			initUploaderForId(mess_image_id);
		});
	}
    jQuery(document).ready(function () {
		setTimeout(function() {
			initUploader();
		}, 500);
    });

	document.addEventListener('felan:initUploader', function () {
		initUploader();
	});
})(jQuery);
