(function ($) {
  "use strict";
  var ajax_url = felan_thumbnail_vars.ajax_url,
    thumbnail_title = felan_thumbnail_vars.thumbnail_title,
    thumbnail_type = felan_thumbnail_vars.thumbnail_type,
    thumbnail_file_size = felan_thumbnail_vars.thumbnail_file_size,
    thumbnail_text = felan_thumbnail_vars.thumbnail_text,
    thumbnail_url = felan_thumbnail_vars.thumbnail_url,
    thumbnail_upload_nonce = felan_thumbnail_vars.thumbnail_upload_nonce;

  jQuery(document).ready(function () {
    var felan_thumbnail = function () {
      var uploader_thumbnail = new plupload.Uploader({
        browse_button: "felan_select_thumbnail",
        file_data_name: "felan_thumbnail_upload_file",
        drop_element: "felan_thumbnail_view",
        container: "felan_thumbnail_container",
        url: thumbnail_url,
        filters: {
          mime_types: [
            {
              title: thumbnail_title,
              extensions: thumbnail_type,
            },
          ],
          max_file_size: thumbnail_file_size,
          prevent_duplicates: true,
        },
      });
      uploader_thumbnail.init();

      uploader_thumbnail.bind("UploadProgress", function (up, file) {
        var $selectBtn = $("#felan_select_thumbnail");
        var $selectIcon = $selectBtn.find("i");
        if ($selectIcon.length) {
          $selectIcon.removeClass().addClass("fal fa-spinner fa-spin large");
        }
      });

      uploader_thumbnail.bind("FilesAdded", function (up, files) {
        up.refresh();
        uploader_thumbnail.start();
      });
      uploader_thumbnail.bind("Error", function (up, err) {
        document.getElementById("felan_thumbnail_errors").innerHTML +=
          "Error #" + err.code + ": " + err.message + "<br/>";
      });

      var $image_id = $("#felan_thumbnail_view").data("image-id");
      var $image_url = $("#felan_thumbnail_view").data("image-url");
      if ($image_id && $image_url) {
        var $html =
          '<figure class="media-thumb media-thumb-wrap">' +
          '<img src="' +
          $image_url +
          '">' +
          '<div class="media-item-actions">' +
          '<a class="icon icon-thumbnail-delete" data-attachment-id="' +
          $image_id +
          '" href="#" ><i class="far fa-trash-alt large"></i></a>' +
          '<span style="display: none;" class="icon icon-loader"><i class="fal fa-spinner fa-spin large"></i></span>' +
          "</div>" +
          "</figure>";
        $("#felan_thumbnail_view").html($html);
        $("#felan_add_thumbnail").hide();
      }
      uploader_thumbnail.bind(
        "FileUploaded",
        function (up, file, ajax_response) {
          var response = $.parseJSON(ajax_response.response);
          if (response.success) {
            $("input.thumbnail_url").val(response.full_image);
            $("input.thumbnail_id").val(response.attachment_id);

            // Hide drop area
            document.getElementById("felan_drop_thumbnail").style.display = "none";

            var $html =
              '<figure class="media-thumb media-thumb-wrap">' +
              '<img src="' +
              response.full_image +
              '">' +
              '<div class="media-item-actions">' +
              '<a class="icon icon-thumbnail-delete" data-attachment-id="' +
              response.attachment_id +
              '" href="#" ><i class="far fa-trash-alt large"></i></a>' +
              '<span style="display: none;" class="icon icon-loader"><i class="fal fa-spinner fa-spin large"></i></span>' +
              "</div>" +
              "</figure>";
            $("#felan_thumbnail_view").html($html);
            felan_thumbnai_delete();
            $("#felan_add_thumbnail .la-upload").hide();
            $("#thumbnail_url-error").hide();
            if ($(".form-dashboard").hasClass("freelancer-profile-form")) {
              $("#freelancer-profile-form").find(".point-mark").change();
            }
          } else {
            // Reset button on error - thumbnail.js uses soft delete, so we need to reset UI
            $("#felan_drop_thumbnail").show();
            $("#felan_add_thumbnail .la-upload").show();
          }
        }
      );
    };
    felan_thumbnail();

    var felan_thumbnai_delete = function ($type) {
      $("body").on("click", ".icon-thumbnail-delete", function (e) {
        e.preventDefault();
        e.stopPropagation();
        var $this = $(this),
          thumbnail = $this
            .closest("#felan_thumbnail_view")
            .find(".media-thumb-wrap"),
          attachment_id = $this.data("attachment-id"),
          $drop = $("#felan_drop_thumbnail");

        // Soft delete - only hide UI and mark for deletion
        thumbnail.remove();
        thumbnail.hide();

        $("#thumbnail_url-error").show();
        $("#felan_add_thumbnail").show();
        $drop.css("display", "block");
        $("#felan_add_thumbnail .la-upload").show();
        $("#felan_select_thumbnail").html(thumbnail_text);

        // Clear thumbnail values
        $("input.thumbnail_url").val("");
        $("input.thumbnail_id").val("");

        // Add hidden input to mark attachment for deletion on submit
        if (attachment_id && !$("input[name='felan_delete_thumbnail_id']").length) {
          $("#felan_thumbnail_container").append(
            '<input type="hidden" name="felan_delete_thumbnail_id" value="' + attachment_id + '">'
          );
        }

        if ($(".form-dashboard").hasClass("freelancer-profile-form")) {
          $("#freelancer-profile-form").find(".point-mark").change();
        }
      });
    };
    felan_thumbnai_delete();
  });
})(jQuery);
