var MESSAGES = MESSAGES || {};
(function ($) {
  "use strict";
  var ajax_url = felan_template_vars.ajax_url,
    form_popup = $("#form-apply-project");

  MESSAGES = {
    // Convert time to hours for comparison
    convertToHours: function (value, unit) {
      var multipliers = {
        'hour': 1,
        'day': 24,
        'week': 24 * 7,
        'month': 24 * 30,
        'year': 24 * 365
      };
      return parseFloat(value) * (multipliers[unit] || 1);
    },

    // Extract unit from time string (e.g., "100 hours" -> "hour", "5 days" -> "day")
    extractUnit: function (timeString) {
      var str = timeString.toString().toLowerCase();
      if (str.includes('year')) return 'year';
      if (str.includes('month')) return 'month';
      if (str.includes('week')) return 'week';
      if (str.includes('day')) return 'day';
      if (str.includes('hour')) return 'hour';
      return 'hour'; // default to hour
    },

    validateForm: function () {
      var isValid = true;

      // Clear all previous errors
      form_popup.find('.error-message').hide().text('');
      form_popup.find('.form-group').removeClass('has-error');
      form_popup.find('.felan-message-error').removeClass('true').text('');

      // Validate working rate
      var proposal_price = form_popup.find('input[name="proposal_price"]').val();
      if (!proposal_price || parseFloat(proposal_price) <= 0) {
        form_popup.find('#proposal_price').closest('.form-group').addClass('has-error')
          .find('.error-message').text(felan_proposal_vars.i18n.error_working_rate).show();
        isValid = false;
      }

      // Validate estimated time
      var proposal_time = form_popup.find('input[name="proposal_time"]').val();
      var proposal_time_visible = form_popup.find('#proposal_time').closest('.form-group').is(':visible');

      if (proposal_time_visible && (!proposal_time || parseFloat(proposal_time) <= 0)) {
        form_popup.find('#proposal_time').closest('.form-group').addClass('has-error')
          .find('.error-message').text(felan_proposal_vars.i18n.error_estimated_time).show();
        isValid = false;
      }

      // Validate estimated time against project maximum time
      var project_maximum_time = $('input#project_maximum_time').val();
      var proposal_rate = form_popup.find('select[name="proposal_rate"]').val() || 'hour';
      var proposal_fixed_time = form_popup.find('input[name="proposal_fixed_time"]').val();
      var proposal_fixed_time_visible = form_popup.find('#proposal_fixed_time').closest('.form-group').is(':visible');

      // Determine which time field to validate (hourly or fixed)
      var timeToValidate = proposal_time_visible ? proposal_time : (proposal_fixed_time_visible ? proposal_fixed_time : null);
      var timeFieldId = proposal_time_visible ? '#proposal_time' : '#proposal_fixed_time';

      // Only validate if we have valid time, project max time, and time is greater than 0
      if (timeToValidate && project_maximum_time && !isNaN(parseFloat(timeToValidate)) && parseFloat(timeToValidate) > 0) {
        // Extract numeric value and unit from project max time (e.g., "100 hours" -> value: 100, unit: "hour")
        var maxTimeMatch = project_maximum_time.toString().match(/^(\d+\.?\d*)/);

        if (maxTimeMatch) {
          var maxTimeValue = parseFloat(maxTimeMatch[1]);
          var maxTimeUnit = MESSAGES.extractUnit(project_maximum_time);

          // Validate that we got valid numbers
          if (!isNaN(maxTimeValue) && maxTimeValue > 0) {
            // Convert both times to hours for comparison
            var proposalTimeInHours = MESSAGES.convertToHours(timeToValidate, proposal_rate);
            var maxTimeInHours = MESSAGES.convertToHours(maxTimeValue, maxTimeUnit);

            // Only compare if conversions resulted in valid numbers
            if (!isNaN(proposalTimeInHours) && !isNaN(maxTimeInHours) && proposalTimeInHours > maxTimeInHours) {
              form_popup.find(timeFieldId).closest('.form-group').addClass('has-error')
                .find('.error-message').text(felan_proposal_vars.i18n.error_exceeds_max_time + ' ' + project_maximum_time).show();
              isValid = false;
            }
          }
        }
      }

      // Validate cover letter
      var content_message = form_popup.find('textarea[name="content_message"]').val();
      if (!content_message || content_message.trim().length < 10) {
        form_popup.find('#content_message').closest('.form-group').addClass('has-error')
          .find('.error-message').text(felan_proposal_vars.i18n.error_cover_letter).show();
        isValid = false;
      }

      // Check if this is a fixed project or hourly project
      var isFixedProject = proposal_fixed_time_visible;

      if (isFixedProject) {
        // For fixed projects: validate proposal_price directly against budget range
        var projectBudgetText = form_popup.find('.info-budget .number').text();
        if (projectBudgetText && proposal_price && parseFloat(proposal_price) > 0) {
          var budgetMatch = projectBudgetText.match(/\$?([\d,]+)\s*-\s*\$?([\d,]+)/);
          if (budgetMatch) {
            var minBudget = parseFloat(budgetMatch[1].replace(/,/g, ''));
            var maxBudget = parseFloat(budgetMatch[2].replace(/,/g, ''));

            if (parseFloat(proposal_price) < minBudget || parseFloat(proposal_price) > maxBudget) {
              form_popup.find('#proposal_price').closest('.form-group').addClass('has-error')
                .find('.error-message').text('Please enter the price within the project range: ' + projectBudgetText).show();
              isValid = false;
            }
          }
        }
      } else {
        // For hourly projects: validate base budget (rate × time) against budget range
        var price = parseFloat(proposal_price);
        var time = parseFloat(proposal_time);

        // Only validate if both values are valid numbers
        if (!isNaN(price) && !isNaN(time) && price > 0 && time > 0) {
          var calculatedBaseBudget = price * time;
          calculatedBaseBudget = Math.round(calculatedBaseBudget * 100) / 100; // Round to 2 decimals

          var projectBudgetText = form_popup.find('.info-budget .number').text();

          if (projectBudgetText && calculatedBaseBudget > 0) {
            // Extract min/max from text like "$400-$6,000" or "400-6,000"
            var budgetMatch = projectBudgetText.match(/\$?([\d,]+)\s*-\s*\$?([\d,]+)/);

            if (budgetMatch) {
              var minBudget = parseFloat(budgetMatch[1].replace(/,/g, ''));
              var maxBudget = parseFloat(budgetMatch[2].replace(/,/g, ''));

              // Validate that budget values are valid numbers
              if (!isNaN(minBudget) && !isNaN(maxBudget) && minBudget > 0 && maxBudget > 0) {
                if (calculatedBaseBudget < minBudget || calculatedBaseBudget > maxBudget) {
                  // Mark both fields as error since budget = rate × time
                  form_popup.find('#proposal_price').closest('.form-group').addClass('has-error');
                  form_popup.find('#proposal_time').closest('.form-group').addClass('has-error');

                  // Show general error message
                  var errorMsg = felan_proposal_vars && felan_proposal_vars.i18n && felan_proposal_vars.i18n.error_budget_range
                    ? felan_proposal_vars.i18n.error_budget_range
                    : 'Your base budget (rate × time) must be within the project budget range:';

                  form_popup.find('.felan-message-error')
                    .text(errorMsg + ' ' + projectBudgetText)
                    .addClass('true')
                    .show();

                  isValid = false;
                }
              }
            }
          }
        }
      }

      // Scroll to first error
      if (!isValid) {
        var firstError = form_popup.find('.has-error').first();
        if (firstError.length) {
          firstError[0].scrollIntoView({ behavior: 'smooth', block: 'center' });
        } else {
          // If no field error but general error, scroll to error message
          var errorMsg = form_popup.find('.felan-message-error:visible');
          if (errorMsg.length) {
            errorMsg[0].scrollIntoView({ behavior: 'smooth', block: 'center' });
          }
        }
      }

      return isValid;
    },

    init: function () {
      $("body").off("click", "#btn-send-proposal").on("click", "#btn-send-proposal", function (e) {
        e.preventDefault();

        // Validate form before submission
        if (!MESSAGES.validateForm()) {
          return false;
        }

        var $this = $(this),
          proposal_price = form_popup
            .find('input[name="proposal_price"]')
            .val(),

          proposal_price_fee = form_popup.find("li.fee .number").text(),
          proposal_base_budget = form_popup.find("li.base-budget .number").text(),
          proposal_total_price = form_popup.find("li.total .number").text(),
          proposal_estimated_hours = form_popup.find("li.estimated-hours .number").text(),
          proposal_time = form_popup.find('input[name="proposal_time"]').val(),
          proposal_fixed_time = form_popup.find('input[name="proposal_fixed_time"]').val(),
          proposal_rate = form_popup.find('select[name="proposal_rate"]').val(),
          content_message = form_popup
            .find('textarea[name="content_message"]')
            .val(),
          proposal_maximum_time = $("input#project_maximum_time").val(),
          creator_message = $("input#project_author_id").val(),
          proposal_id = $("input#proposal_id").val(),
          recipient_message = $("input#project_post_current").val();

        $.ajax({
          type: "POST",
          url: ajax_url,
          dataType: "json",
          data: {
            action: "felan_send_proposal_project",
            nonce: felan_proposal_vars.nonce,
            proposal_price: proposal_price,
            proposal_price_fee: proposal_price_fee,
            proposal_base_budget: proposal_base_budget,
            proposal_total_price: proposal_total_price,
            proposal_estimated_hours: proposal_estimated_hours,
            proposal_time: proposal_time,
            proposal_fixed_time: proposal_fixed_time,
            proposal_rate: proposal_rate,
            proposal_maximum_time: proposal_maximum_time,
            content_message: content_message,
            proposal_id: proposal_id,
            creator_message: creator_message,
            recipient_message: recipient_message,
          },
          beforeSend: function () {
            $this.find(".btn-loading").fadeIn();
          },
          success: function (data) {
            if (data.success == true) {
              form_popup.find(".felan-message-error").removeClass("true").hide();
              if ($('#form-apply-project .project-popup').hasClass('update-proposal')) {
                $('#form-apply-project .project-popup.update-proposal').html(data.update_proposal);
              } else {
                $('#form-apply-project .project-popup').html(data.thank_proposals);
              }
              $('body').on("click", ".bg-overlay, .btn-close", function (e) {
                e.preventDefault();
                location.reload();
              });
            } else {
              // Show error message from server
              form_popup.find(".felan-message-error")
                .text(data.message)
                .addClass("true")
                .show();

              // Scroll to error message
              var errorMsg = form_popup.find('.felan-message-error:visible');
              if (errorMsg.length) {
                errorMsg[0].scrollIntoView({ behavior: 'smooth', block: 'center' });
              }
            }
            $this.find(".btn-loading").fadeOut();
          },
          error: function (xhr, status, error) {
            form_popup.find(".felan-message-error")
              .text('An error occurred. Please try again.')
              .addClass("true")
              .show();
            $this.find(".btn-loading").fadeOut();
          }
        });
      });
    },
  };

  $(document).ready(function () {
    MESSAGES.init();
  });
})(jQuery);
