(function ($) {
    "use strict";

    var ajax_url = felan_submit_vars.ajax_url,
        project_dashboard = felan_submit_vars.project_dashboard,
        submit_form = $("#submit_project_form"),
        project_title_error = submit_form.data("titleerror"),
        project_des_error = submit_form.data("deserror"),
        project_career_error = submit_form.data("careererror"),
        project_language_error = submit_form.data("languageerror"),
        project_cat_error = submit_form.data("caterror"),
        custom_field_project = felan_submit_vars.custom_field_project;

    $(document).ready(function () {
        // Show error notification at top of form
        function showErrorNotification(message) {
            // Remove existing notifications
            $('.felan-error-notification, .felan-success-notification').remove();

            // Create notification element
            var $notification = $('<div class="felan-error-notification">' +
                '<i class="far fa-exclamation-circle"></i>' +
                '<span>' + message + '</span>' +
                '<i class="far fa-times close-notification"></i>' +
                '</div>');

            // Insert at top of form
            submit_form.prepend($notification);

            // Auto hide after 5 seconds
            setTimeout(function () {
                $notification.fadeOut(300, function () {
                    $(this).remove();
                });
            }, 5000);

            // Close on click
            $notification.find('.close-notification').on('click', function () {
                $notification.fadeOut(300, function () {
                    $(this).remove();
                });
            });
        }

        // Show success notification at top of form
        function showSuccessNotification(message) {
            // Remove existing notifications
            $('.felan-error-notification, .felan-success-notification').remove();

            // Create notification element
            var $notification = $('<div class="felan-success-notification">' +
                '<i class="far fa-check-circle"></i>' +
                '<span>' + message + '</span>' +
                '</div>');

            // Insert at top of form
            submit_form.prepend($notification);

            // Scroll to top to show notification
            $("html, body").animate({ scrollTop: 0 }, 300);
        }

        //Budget
        function toggleFields(selectedValue) {
            var isFixed = selectedValue === 'fixed';
            var isHourly = selectedValue === 'hourly';

            $('#project_maximum_hours').closest('.form-group').toggle(isHourly);
            $('#project_value_rate').closest('.form-group').toggle(isFixed);
            $('#projects_rate').toggle(isFixed);
        }

        $('#select-budget-show').change(function () {
            toggleFields($(this).val());
        });
        toggleFields($('#select-budget-show').val());

        //More Section
        var $rowActive = submit_form.find(
            ".felan-addons-warpper > .row:first-child"
        );
        $rowActive.find(".group-title i").removeClass("delete-group");

        submit_form.on("click", "i.delete-group", function () {
            var groupToRemove = $(this).closest(".group-title").closest(".row");
            var groupSiblings = groupToRemove.siblings(".row");
            var template = groupToRemove.siblings("template");

            groupToRemove.remove();

            $.each(groupSiblings, function renumberGroups(index) {
                $(this)
                    .find(".group-title h6 span")
                    .text(index + 1);
            });

            template.data("size", groupSiblings.size());
        });

        submit_form.find(".btn-more.project-fields").on("click", function () {
            var template = $(this).siblings("template");
            var html = $(template.html().trim());
            var row = $(this).closest(".felan-addons-warpper").find(".row");
            var innerContainer = $(this)
                .closest(".felan-addons-warpper")
                .find(".felan-addons-inner");
            var index = parseInt(row.length) + 1;

            html.find(".group-title h6 span").text(index);
            innerContainer.append(html);
            template.data("size", index);
        });

        submit_form.on("click", ".group-title", function () {
            if (!$(this).hasClass("up")) {
                $(this).addClass("up");
            } else {
                $(this).removeClass("up");
            }
        });

        //Package
        submit_form.find(".btn-more.package-fields").on("click", function () {
            var template = $(this).siblings("template");
            var html = $(template.html().trim());
            var innerContainer = $(this).closest(".table-responsive").find("tbody");
            const quantity = parseInt(
                submit_form.find('select[name="project_quantity"]').val()
            );

            if (quantity == 1) {
                html.find(".field-standard").hide();
                html.find(".field-premium").hide();
            } else if (quantity == 2) {
                html.find(".field-premium").hide();
            }

            innerContainer.append(html);
        });

        submit_form.on("click", ".table-package i.delete-group", function () {
            $(this).closest("tr").remove();
        });

        //Pricing Quantity
        const selectQuantity = submit_form.find('select[name="project_quantity"]');
        const selectQuantityVal = submit_form
            .find('select[name="project_quantity"]')
            .val();

        function totalQuantity(quantity) {
            if (quantity == 1) {
                submit_form.find(".field-standard").hide();
                submit_form.find(".field-premium").hide();
            }
            if (quantity == 2) {
                submit_form.find(".field-standard").show();
                submit_form.find(".field-premium").hide();
            }

            if (quantity == 3) {
                submit_form.find(".field-standard").show();
                submit_form.find(".field-premium").show();
            }
        }

        selectQuantity.change(function () {
            const quantity = parseInt($(this).val());
            totalQuantity(quantity);
        });
        totalQuantity(selectQuantityVal);

        //Custom Number Revisions
        const revisions = submit_form.find("tr.number-revisions .felan-select2");

        function handleRevisionSelection(selectedSelect, selectedOption) {
            if (selectedOption == "custom") {
                selectedSelect
                    .closest(".filed-revisions")
                    .find('input[type="number"]')
                    .show();
            } else {
                selectedSelect
                    .closest(".filed-revisions")
                    .find('input[type="number"]')
                    .hide();
            }
        }

        revisions.on("change", function () {
            handleRevisionSelection($(this), $(this).val());
        });

        submit_form.find(".number-revisions .filed-revisions").each(function () {
            const revisions = $(this).find(".felan-select2");
            const selectedOption = revisions.val();

            handleRevisionSelection(revisions, selectedOption);
        });

        //Min Max
        var timeout;
        $('#project_budget_minimum, #project_budget_maximum').on('input', function () {
            clearTimeout(timeout);
            timeout = setTimeout(function () {
                var minPrice = parseFloat($('#project_budget_minimum').val());
                var maxPrice = parseFloat($('#project_budget_maximum').val());

                if (minPrice >= maxPrice && !isNaN(minPrice) && !isNaN(maxPrice)) {
                    alert('Minimum Price cannot be greater than Maximum Price.');
                    $('#project_budget_minimum').val(maxPrice - 1);
                }
            }, 1000);
        });

        // Custom method for TinyMCE validation
        $.validator.addMethod("tinymceRequired", function (value, element) {
            if (tinymce.get(element.id)) {
                var content = tinymce.get(element.id).getContent({ format: 'text' });
                return content.trim().length >= 3;
            }
            return false;
        }, felan_submit_vars.i18n.desc_min_length);

        //Submit
        submit_form.validate({
            ignore: ':hidden:not(.felan-select2)', // Validate Select2 hidden fields
            onkeyup: false, // Disable validation on keyup
            onclick: false, // Disable validation on click
            onfocusout: false, // Disable validation on blur/focusout
            rules: {
                project_title: {
                    required: true,
                    minlength: 3
                },
                project_categories: {
                    required: true,
                },
                project_des: {
                    tinymceRequired: true,
                },
                project_career: {
                    required: true,
                },
                project_language: {
                    required: true,
                },
                project_video_url: {
                    url: true
                },
                project_budget_minimum: {
                    number: true,
                    min: 0
                },
                project_budget_maximum: {
                    number: true,
                    min: 0
                },
                company_email: {
                    email: true
                },
                company_title: {
                    minlength: 3
                }
            },
            messages: {
                project_title: {
                    required: project_title_error,
                    minlength: felan_submit_vars.i18n.title_min_length
                },
                project_des: project_des_error,
                project_career: project_career_error,
                project_language: project_language_error,
                project_categories: project_cat_error,
                project_video_url: felan_submit_vars.i18n.video_url_invalid,
                project_budget_minimum: {
                    number: felan_submit_vars.i18n.budget_positive,
                    min: felan_submit_vars.i18n.budget_positive
                },
                project_budget_maximum: {
                    number: felan_submit_vars.i18n.budget_positive,
                    min: felan_submit_vars.i18n.budget_positive
                },
                company_email: felan_submit_vars.i18n.email_invalid,
                company_title: felan_submit_vars.i18n.company_name_min_length
            },
            submitHandler: function (form) {
                // Prevent default form submission
                // Final validation before submit (sync with backend)
                var isValid = true;
                var firstErrorField = null;
                var errors = {};

                // Clear previous errors
                submit_form.find('.error').remove();
                submit_form.find('.error-field').removeClass('error-field');

                // Validate title (min 3 chars)
                var title = submit_form.find('input[name="project_title"]').val();
                if (!title || title.trim() === '') {
                    errors.project_title = project_title_error;
                } else if (title.trim().length < 3) {
                    errors.project_title = felan_submit_vars.i18n.title_min_length;
                }

                // Validate categories
                var categories = submit_form.find('select[name="project_categories"]').val();
                if (!categories || categories.length === 0) {
                    errors.project_categories = project_cat_error;
                }

                // Validate description (min 3 chars)
                if (tinymce.get("project_des")) {
                    var content = tinymce.get("project_des").getContent({ format: 'text' });
                    if (!content || content.trim() === '') {
                        errors.project_des = project_des_error;
                    } else if (content.trim().length < 3) {
                        errors.project_des = felan_submit_vars.i18n.desc_min_length;
                    }
                }

                // Validate career
                var career = submit_form.find('select[name="project_career"]').val();
                if (!career || career === '') {
                    errors.project_career = project_career_error;
                }

                // Validate language
                var language = submit_form.find('select[name="project_language"]').val();
                if (!language || language.length === 0) {
                    errors.project_language = project_language_error;
                }

                // Validate budget (both or none)
                var budgetMin = submit_form.find('input[name="project_budget_minimum"]').val();
                var budgetMax = submit_form.find('input[name="project_budget_maximum"]').val();

                // If one is provided, both should be provided
                if ((budgetMin && budgetMin.trim() !== '') || (budgetMax && budgetMax.trim() !== '')) {
                    if (!budgetMin || budgetMin.trim() === '') {
                        errors.project_budget_minimum = felan_submit_vars.i18n.budget_min_required;
                    }

                    if (!budgetMax || budgetMax.trim() === '') {
                        errors.project_budget_maximum = felan_submit_vars.i18n.budget_max_required;
                    }

                    // If both provided, validate values
                    if (budgetMin && budgetMax) {
                        var minVal = parseFloat(budgetMin);
                        var maxVal = parseFloat(budgetMax);

                        if (isNaN(minVal) || minVal < 0) {
                            errors.project_budget_minimum = felan_submit_vars.i18n.budget_positive;
                        }

                        if (isNaN(maxVal) || maxVal < 0) {
                            errors.project_budget_maximum = felan_submit_vars.i18n.budget_positive;
                        }

                        if (!isNaN(minVal) && !isNaN(maxVal) && minVal >= maxVal) {
                            errors.project_budget_minimum = felan_submit_vars.i18n.budget_min_less_max;
                        }
                    }
                }

                // Validate video URL
                var videoUrl = submit_form.find('input[name="project_video_url"]').val();
                if (videoUrl && videoUrl.trim() !== '') {
                    if (!videoUrl.match(/^https?:\/\/.+/)) {
                        errors.project_video_url = felan_submit_vars.i18n.video_url_invalid;
                    }
                }

                // Validate company email
                var companyEmail = submit_form.find('input[name="company_email"]').val();
                if (companyEmail && companyEmail.trim() !== '') {
                    var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                    if (!emailRegex.test(companyEmail)) {
                        errors.company_email = felan_submit_vars.i18n.email_invalid;
                    }
                }

                // Validate company title if creating new company
                var selectCompany = submit_form.find('select[name="project_select_company"]').val();
                var companyTitle = submit_form.find('input[name="company_title"]').val();
                if (selectCompany === 'new_company') {
                    if (!companyTitle || companyTitle.trim() === '') {
                        errors.company_title = felan_submit_vars.i18n.company_name_required;
                    } else if (companyTitle.trim().length < 3) {
                        errors.company_title = felan_submit_vars.i18n.company_name_min_length;
                    }
                }

                // Display errors
                if (Object.keys(errors).length > 0) {
                    isValid = false;

                    $.each(errors, function (fieldName, errorMsg) {
                        var $field = submit_form.find('[name="' + fieldName + '"]');

                        if ($field.length > 0) {
                            $field.addClass('error-field').show(); // Ensure field stays visible
                            var $errorLabel = $('<label class="error">' + errorMsg + '</label>');

                            if ($field.hasClass('felan-select2')) {
                                $errorLabel.insertAfter($field.next('.select2-container'));
                            } else if (fieldName === 'project_des') {
                                $errorLabel.insertAfter('#wp-project_des-wrap');
                            } else {
                                $errorLabel.insertAfter($field);
                            }

                            if (!firstErrorField) {
                                firstErrorField = $field;
                            }
                        }
                    });

                    // Switch to tab containing first error
                    if (firstErrorField) {
                        var $errorTab = firstErrorField.closest('.tab-info');
                        if ($errorTab.length > 0) {
                            var tabId = $errorTab.attr('id');
                            $('.project-submit-tab .tab-item a[href="#' + tabId + '"]').trigger('click');

                            setTimeout(function () {
                                $("html, body").animate({
                                    scrollTop: firstErrorField.offset().top - 150
                                }, 500);
                            }, 100);
                        }
                    }
                    return false;
                }

                ajax_load();
            },
            errorPlacement: function (error, element) {
                // Handle Select2 error placement
                if (element.hasClass('felan-select2')) {
                    error.insertAfter(element.next('.select2-container'));
                } else if (element.attr('id') === 'project_des') {
                    // Handle TinyMCE error placement
                    error.insertAfter('#wp-project_des-wrap');
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function (element, errorClass, validClass) {
                // Add error class but ensure field stays visible
                $(element).addClass('error-field').show();
            },
            unhighlight: function (element, errorClass, validClass) {
                // Remove error class but keep field visible
                $(element).removeClass('error-field').show();
            },
            invalidHandler: function () {
                if ($(".error:visible").length > 0) {
                    $("html, body").animate(
                        {
                            scrollTop: $(".error:visible").length > 0 ? $(".error:visible").first().offset().top - 100 : 0,
                        },
                        500
                    );
                }
            },
        });

        // Clear error on change (but don't validate)
        submit_form.find('.felan-select2').on('change', function () {
            // Only clear error, don't validate
            $(this).removeClass('error-field');
            $(this).next('.select2-container').next('label.error').remove();
        });

        // Clear error on TinyMCE change
        if (tinymce.get("project_des")) {
            tinymce.get("project_des").on('change keyup', function () {
                // Only clear error, don't validate
                $('#project_des').removeClass('error-field');
                $('#wp-project_des-wrap').next('label.error').remove();
            });
        }

        // Clear error on input change (but don't validate)
        submit_form.find('input[type="text"], input[type="email"], input[type="number"], textarea').on('input', function () {
            // Only clear error, don't validate
            $(this).removeClass('error-field');
            $(this).next('label.error').remove();
        });

        function ajax_load() {
            var project_form = submit_form.find('input[name="project_form"]').val(),
                project_id = submit_form.find('input[name="project_id"]').val(),
                project_title = submit_form.find('input[name="project_title"]').val(),
                project_categories = submit_form
                    .find('select[name="project_categories"]')
                    .val(),
                project_skills = submit_form
                    .find('select[name="project_skills"]')
                    .val(),
                project_des = tinymce.get("project_des").getContent(),
                project_language = submit_form
                    .find('select[name="project_language"]')
                    .val(),
                project_career = submit_form
                    .find('select[name="project_career"]')
                    .val(),
                project_location = submit_form
                    .find('select[name="project_location"]')
                    .val(),
                project_map_address = submit_form
                    .find('input[name="felan_map_address"]')
                    .val(),
                project_map_location = submit_form
                    .find('input[name="felan_map_location"]')
                    .val(),
                project_latitude = submit_form
                    .find('input[name="felan_latitude"]')
                    .val(),
                project_longtitude = submit_form
                    .find('input[name="felan_longtitude"]')
                    .val(),
                project_thumbnail_url = submit_form
                    .find('input[name="project_thumbnail_url"]')
                    .val(),
                project_thumbnail_id = submit_form
                    .find('input[name="project_thumbnail_id"]')
                    .val(),
                felan_gallery_ids = submit_form
                    .find('input[name="felan_gallery_ids[]"]')
                    .map(function () {
                        return $(this).val();
                    })
                    .get(),
                project_video_url = submit_form
                    .find('input[name="project_video_url"]')
                    .val(),
                project_budget_show = submit_form
                    .find('select[name="project_budget_show"]')
                    .val(),
                project_budget_minimum = submit_form
                    .find('input[name="project_budget_minimum"]')
                    .val(),
                project_budget_maximum = submit_form
                    .find('input[name="project_budget_maximum"]')
                    .val(),
                project_value_rate = submit_form
                    .find('input[name="project_value_rate"]')
                    .val(),
                project_budget_rate = submit_form
                    .find('select[name="project_budget_rate"]')
                    .val(),
                project_maximum_hours = submit_form
                    .find('input[name="project_maximum_hours"]')
                    .val(),
                project_select_company = submit_form
                    .find('select[name="project_select_company"]')
                    .val(),
                project_faq_title = submit_form
                    .find('input[name="project_faq_title[]"]')
                    .map(function () {
                        return $(this).val();
                    })
                    .get(),
                project_faq_description = submit_form
                    .find('textarea[name="project_faq_description[]"]')
                    .map(function () {
                        return $(this).val();
                    })
                    .get(),
                company_title = submit_form.find('input[name="company_title"]').val(),
                company_email = submit_form.find('input[name="company_email"]').val(),
                company_avatar_url = submit_form.find('input[name="company_avatar_url"]').val(),
                company_avatar_id = submit_form.find('input[name="company_avatar_id"]').val();

            var additional = {};
            $("#project-submit-additional").each(function () {
                $.each(custom_field_project, function (index, value) {
                    var val = $(".form-control[name=" + value.id + "]").val();
                    if (value.type == "radio") {
                        val = $("input[name=" + value.id + "]:checked").val();
                    }
                    if (value.type == "checkbox_list") {
                        var arr_checkbox = [];
                        $('input[name="' + value.id + '[]"]:checked').each(function () {
                            arr_checkbox.push($(this).val());
                        });
                        val = arr_checkbox;
                    }
                    if (value.type == "image") {
                        val = $("input#custom_image_id_" + value.id).val();
                    }
                    if (value.type == "file") {
                        val = $("#cv_attachment_id_" + value.id).val();
                    }
                    additional[value.id] = val;
                });
            });

            // Collect delete markers
            var felan_delete_thumbnail_id = $("input[name='felan_delete_thumbnail_id']").val() || 0;
            var felan_delete_gallery_ids = [];
            $("input[name='felan_delete_gallery_ids[]']").each(function() {
                var val = $(this).val();
                if (val) {
                    felan_delete_gallery_ids.push(val);
                }
            });
            var felan_delete_avatar_id = $("input[name='felan_delete_avatar_id']").val() || 0;

            // Collect delete markers for custom images
            var deleteCustomImages = {};
            $("input[name^='felan_delete_custom_image_']").each(function() {
                var fieldId = $(this).attr('name').replace('felan_delete_custom_image_', '');
                var val = $(this).val();
                if (fieldId && val) {
                    deleteCustomImages[fieldId] = val;
                }
            });

            // Collect delete markers for custom files
            var deleteCustomFiles = {};
            $("input[name^='felan_delete_file_']").each(function() {
                var fieldId = $(this).attr('name').replace('felan_delete_file_', '');
                var val = $(this).val();
                if (fieldId && val) {
                    deleteCustomFiles[fieldId] = val;
                }
            });

            $.ajax({
                type: "POST",
                dataType: "json",
                url: ajax_url,
                data: {
                    action: "project_submit_ajax",
                    felan_submit_project_nonce_field: $('input[name="felan_submit_project_nonce_field"]').val(),
                    project_form: project_form,
                    project_id: project_id,
                    project_title: project_title,
                    project_categories: project_categories,
                    project_skills: project_skills,
                    project_des: project_des,
                    project_language: project_language,
                    project_career: project_career,

                    project_location: project_location,
                    project_map_address: project_map_address,
                    project_map_location: project_map_location,
                    project_latitude: project_latitude,
                    project_longtitude: project_longtitude,

                    project_thumbnail_url: project_thumbnail_url,
                    project_thumbnail_id: project_thumbnail_id,
                    felan_gallery_ids: felan_gallery_ids,
                    felan_delete_thumbnail_id: felan_delete_thumbnail_id,
                    felan_delete_gallery_ids: felan_delete_gallery_ids,
                    felan_delete_avatar_id: felan_delete_avatar_id,
                    project_video_url: project_video_url,

                    project_budget_show: project_budget_show,
                    project_budget_minimum: project_budget_minimum,
                    project_budget_maximum: project_budget_maximum,
                    project_value_rate: project_value_rate,
                    project_budget_rate: project_budget_rate,
                    project_maximum_hours: project_maximum_hours,

                    project_select_company: project_select_company,

                    project_faq_title: project_faq_title,
                    project_faq_description: project_faq_description,

                    custom_field_project: additional,
                    felan_delete_custom_images: deleteCustomImages,
                    felan_delete_custom_files: deleteCustomFiles,
                    company_title: company_title,
                    company_email: company_email,
                    company_avatar_url: company_avatar_url,
                    company_avatar_id: company_avatar_id,
                },
                beforeSend: function () {
                    $(".btn-submit-project .btn-loading").fadeIn();
                },
                success: function (data) {
                    $(".btn-submit-project .btn-loading").fadeOut();
                    if (data.success === true) {
                        // Show success notification
                        if (data.data && data.data.message) {
                            showSuccessNotification(data.data.message);
                        }

                        // Redirect after short delay
                        setTimeout(function () {
                            window.location.href = project_dashboard;
                        }, 1500);
                    } else {
                        // Clear previous errors
                        submit_form.find('.error').remove();
                        submit_form.find('.error-field').removeClass('error-field');

                        // Handle server validation errors
                        if (data.data && data.data.fields) {
                            var fields = data.data.fields;
                            var firstErrorField = null;

                            // Display error for each field
                            $.each(fields, function (fieldName, errorMsg) {
                                var $field = submit_form.find('[name="' + fieldName + '"]');

                                if ($field.length > 0) {
                                    $field.addClass('error-field');
                                    var $errorLabel = $('<label class="error">' + errorMsg + '</label>');

                                    // Handle different field types
                                    if ($field.hasClass('felan-select2')) {
                                        $errorLabel.insertAfter($field.next('.select2-container'));
                                    } else if (fieldName === 'project_des') {
                                        $errorLabel.insertAfter('#wp-project_des-wrap');
                                    } else {
                                        $errorLabel.insertAfter($field);
                                    }

                                    // Track first error field for scrolling
                                    if (!firstErrorField) {
                                        firstErrorField = $field;
                                    }
                                }
                            });

                            // Switch to tab and scroll to first error field
                            if (firstErrorField) {
                                var $errorTab = firstErrorField.closest('.tab-info');
                                if ($errorTab.length > 0) {
                                    var tabId = $errorTab.attr('id');
                                    // Activate the tab
                                    $('.project-submit-tab .tab-item a[href="#' + tabId + '"]').trigger('click');

                                    // Wait for tab animation then scroll
                                    setTimeout(function () {
                                        $("html, body").animate({
                                            scrollTop: firstErrorField.offset().top - 150
                                        }, 500);
                                    }, 100);
                                }
                            }
                        } else {
                            // Fallback for simple error message - show as notification at top
                            var errorMessage = data.data || 'An error occurred. Please try again.';
                            showErrorNotification(errorMessage);
                            $("html, body").animate({ scrollTop: 0 }, 500);
                        }
                    }
                },
                error: function (xhr, status, error) {
                    $(".btn-submit-project .btn-loading").fadeOut();

                    // Clear previous errors
                    submit_form.find('.error').remove();
                    submit_form.find('.error-field').removeClass('error-field');

                    var errorMessage = 'Security check failed or network error. Please refresh and try again.';

                    if (xhr.responseJSON && xhr.responseJSON.data) {
                        // Handle structured error response
                        if (xhr.responseJSON.data.fields) {
                            var fields = xhr.responseJSON.data.fields;
                            var firstErrorField = null;

                            $.each(fields, function (fieldName, errorMsg) {
                                var $field = submit_form.find('[name="' + fieldName + '"]');

                                if ($field.length > 0) {
                                    $field.addClass('error-field');
                                    var $errorLabel = $('<label class="error">' + errorMsg + '</label>');

                                    if ($field.hasClass('felan-select2')) {
                                        $errorLabel.insertAfter($field.next('.select2-container'));
                                    } else if (fieldName === 'project_des') {
                                        $errorLabel.insertAfter('#wp-project_des-wrap');
                                    } else {
                                        $errorLabel.insertAfter($field);
                                    }

                                    if (!firstErrorField) {
                                        firstErrorField = $field;
                                    }
                                }
                            });

                            // Switch to tab and scroll to first error
                            if (firstErrorField) {
                                var $errorTab = firstErrorField.closest('.tab-info');
                                if ($errorTab.length > 0) {
                                    var tabId = $errorTab.attr('id');
                                    $('.project-submit-tab .tab-item a[href="#' + tabId + '"]').trigger('click');

                                    setTimeout(function () {
                                        $("html, body").animate({
                                            scrollTop: firstErrorField.offset().top - 150
                                        }, 500);
                                    }, 100);
                                }
                            }

                            errorMessage = xhr.responseJSON.data.message || errorMessage;
                        } else {
                            errorMessage = xhr.responseJSON.data;
                        }
                    }

                    // Show error notification
                    showErrorNotification(errorMessage);
                },
            });
        }

        $(".ai-helper").on("click", function (e) {
            e.preventDefault();
            var _this = $(this),
                popup_name = _this.attr("data-popup");
            $("#" + popup_name).addClass("open");
        });

        if ($(window).width() > 767) {
            $(".generate-content").each(function () {
                var left = $(this).find(".left"),
                    right = $(this).find(".right"),
                    left_height = left.outerHeight();

                right.css("height", left_height);
            });
        }

        $(".ai-generate").on("submit", function (e) {
            e.preventDefault();

            var _this = $(this),
                wrap = $(this).closest(".ai-popup"),
                wrap_inner = wrap.find(".inner-popup"),
                keywords = _this.find('textarea[name="ai_prompt"]').val(),
                tone = _this.find('select[name="ai_tone"] option:selected').text(),
                language = _this
                    .find('select[name="ai_language"] option:selected')
                    .text();

            $.ajax({
                url: ajax_url,
                type: "POST",
                data: {
                    action: "auto_description_generate",
                    keywords: keywords,
                    tone: tone,
                    language: language,
                },
                beforeSend: function () {
                    _this.find(".btn-loading").fadeIn();
                    wrap.find(".suggestion").text("");
                    _this.find(".field-notice").removeClass("error");
                    _this.find(".field-notice p").text("");
                    wrap.find(".generate-content").removeClass("has-suggestion");
                },
                success: function (response) {
                    var response = $.parseJSON(response);
                    _this.find(".btn-loading").fadeOut();
                    if (response.success) {
                        _this
                            .find(".field-submit button .text")
                            .text(felan_submit_vars.regenerate);
                        wrap.find(".generate-content").addClass("has-suggestion");
                        wrap.find(".suggestion").html(response.message);
                        if ($(window).width() < 768) {
                            $(".ai-popup .inner-popup").animate(
                                {
                                    scrollTop:
                                        wrap.find(".suggestion").offset().top -
                                        wrap_inner.offset().top -
                                        40,
                                },
                                500
                            );
                        }
                        $(".keep-generate").on("click", function (e) {
                            e.preventDefault();
                            tinymce.get("project_des").setContent(response.message);
                            wrap.find(".generate-content").removeClass("has-suggestion");
                            $(".ai-generate")[0].reset();
                            _this.closest(".popup").removeClass("open");
                            _this
                                .find(".field-submit button .text")
                                .text(felan_submit_vars.generate);
                        });
                    } else {
                        _this.find(".field-notice p").text(response.message);
                        _this.find(".field-notice").addClass("error");
                    }
                },
            });
        });

    });
})(jQuery);
